//! Qore namespace
namespace Qore {
//! YAML namespace
namespace YAML {
/** @defgroup yaml_functions YAML Functions
//@{
 */

//! Returns version information about libyaml being used by the yaml module
/** @par Code Flags:
    @ref CONSTANT, @ref DEPRECATED

@return a hash with keys as in the following table:
    - \c version: the version string for the library, ex: \c "0.1.3"
    - \c major: the integer major version for the library, ex: \c 0
    - \c minor: the integer minor version for the library, ex: \c 1
    - \c patch: the integer patch version for the library, ex: \c 3

    @deprecated use get_yaml_info(); camel-case function names were deprecated in yaml 0.5
*/
hash getYAMLInfo();

//! Returns version information about libyaml being used by the yaml module
/** @return a hash with keys as in the following table:
    - \c version: the version string for the library, ex: \c "0.1.3"
    - \c major: the integer major version for the library, ex: \c 0
    - \c minor: the integer minor version for the library, ex: \c 1
    - \c patch: the integer patch version for the library, ex: \c 3

   @par Code Flags:
    @ref CONSTANT

     @par Example:
    @code
hash hash = get_yaml_info();
    @endcode

    @since yaml 0.5 as a replacement for deprecated camel-case getYAMLInfo()
*/
hash get_yaml_info();

//! Creates a YAML string from Qore data
/** For information on Qore to YAML serialization, see @ref qore_to_yaml_type_mappings

   @par Code Flags:
    @ref RET_VALUE_ONLY, @ref DEPRECATED

     @param data Qore data to convert; cannot contain any objects or a \c YAML-EMITTER-ERROR exception will be raised
    @param flags binary OR'ed @ref yaml_emitter_option_constants
    @param width default line width for output, -1 = no line length limit
    @param indent the number of spaces to use for indentation when outputting block format or multiple lines; note that libyaml seems to be ignoring this parameter for now, so it may not have any effect

    @return the YAML string corresponding to the input

    @throw YAML-EMITTER-ERROR object found; YAML library error

    @deprecated use make_yaml(); camel-case function names were deprecated in yaml 0.5
 */
string makeYAML(auto data, int flags = Qore::YAML::None, softint width = -1, softint indent = 2);

//! Creates a YAML string from Qore data
/** For information on Qore to YAML serialization, see @ref qore_to_yaml_type_mappings

   @par Code Flags:
    @ref RET_VALUE_ONLY

     @param data Qore data to convert; cannot contain any objects or a \c YAML-EMITTER-ERROR exception will be raised
    @param flags binary OR'ed @ref yaml_emitter_option_constants
    @param width default line width for output, -1 = no line length limit
    @param indent the number of spaces to use for indentation when outputting block format or multiple lines; note that libyaml seems to be ignoring this parameter for now, so it may not have any effect

    @return the YAML string corresponding to the input

    @par Example:
    @code
string str = make_yaml(data, YAML::Canonical);
    @endcode

    @throw YAML-EMITTER-ERROR object found; YAML library error

    @see parse_yaml()

    @since yaml 0.5 as a replacement for deprecated camel-case makeYAML()
 */
string make_yaml(auto data, int flags = Qore::YAML::None, softint width = -1, softint indent = 2);

//! Parses a YAML string and returns the corresponding Qore value or data structure
/** For information on YAML to Qore deserialization, see @ref qore_to_yaml_type_mappings

   @par Code Flags:
    @ref RET_VALUE_ONLY, @ref DEPRECATED

     @param yaml The YAML string to deserialize

    @return Qore data as deserialized from the YAML string

    @throw YAML-PARSER-ERROR error parsing YAML string

    @deprecated use parse_yaml(); camel-case function names were deprecated in yaml 0.5
 */
auto parseYAML(string yaml);

//! Parses a YAML string and returns the corresponding Qore value or data structure
/** For information on YAML to Qore deserialization, see @ref qore_to_yaml_type_mappings

   @par Code Flags:
    @ref RET_VALUE_ONLY

     @param yaml The YAML string to deserialize

    @return Qore data as deserialized from the YAML string

    @par Example:
    @code
auto data = parse_yaml(yaml_string);
    @endcode

    @throw YAML-PARSER-ERROR error parsing YAML string

    @since yaml 0.5 as a replacement for deprecated camel-case parseYAML()

    @see make_yaml()
 */
auto parse_yaml(string yaml);

//@}
}
}
//! Qore namespace
namespace Qore {
//! YAML namespace
namespace YAML {
/** @defgroup yaml_emitter_option_constants YAML Emitter Option Constants
//@{
 */

//! emitter constant: emit seq and map with block style
    const BlockStyle = QYE_BLOCK_STYLE;
//! emitter constant: Emit canonical YAML
    const Canonical = QYE_CANONICAL;
//! emitter constant: emit SQL null \c "!!sqlnull"
    const EmitSqlNull = QYE_EMIT_SQLNULL;
//! emitter constant: escape unicode characters
    const EscapeUnicode = QYE_ESCAPE_UNICODE;
//! emitter constant: emit an explicit document end sequence
    const ExplicitEndDoc = QYE_EXPLICIT_END_DOC;
//! emitter constant: emit an explicit document start sequence
    const ExplicitStartDoc = QYE_EXPLICIT_START_DOC;
//! emitter constant: No option (= default output)
    const None = QYE_NONE;
//! emitter constant: emit YAML 1.1 (not necessary to use as this is the default and currently the only YAML version supported by libyaml)
    const Yaml1_1 = QYE_VER_1_1;
/** @} */
}
}
