/* -*- mode: c++; indent-tabs-mode: nil -*- */
/*
    ql_yaml.qpp

    yaml Qore module

    Copyright (C) 2010 - 2019 Qore Technologies, s.r.o.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "yaml-module.h"

static QoreStringNode* q_make_yaml(QoreValue data, int64 flags, int64 width, int64 indent, ExceptionSink* xsink) {
    QoreYamlStringWriteHandler str;
    {
        QoreYamlEmitter emitter(str, flags, width, indent, xsink);
        if (*xsink)
            return nullptr;

        if (emitter.emit(data))
            return nullptr;
    }

    return str.take();
}

static QoreHashNode* q_get_yaml_info() {
    QoreHashNode *h = new QoreHashNode(autoTypeInfo);

    h->setKeyValue("version", new QoreStringNode(yaml_get_version_string()), 0);

    int major, minor, patch;
    yaml_get_version(&major, &minor, &patch);

    h->setKeyValue("major", major, 0);
    h->setKeyValue("minor", minor, 0);
    h->setKeyValue("patch", patch, 0);

    return h;
}
# 90 "ql_yaml.qpp"
# 95 "ql_yaml.qpp"
# 120 "ql_yaml.qpp"
# 138 "ql_yaml.qpp"
# 161 "ql_yaml.qpp"
# 177 "ql_yaml.qpp"
# 195 "ql_yaml.qpp"
// hash getYAMLInfo() {}
static QoreValue f_getYAMLInfo(const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 204 "ql_yaml.qpp"
    return q_get_yaml_info();
}

// hash get_yaml_info() {}
static QoreValue f_get_yaml_info(const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 191 "ql_yaml.qpp"
    return q_get_yaml_info();
}

// string makeYAML(auto data, int flags = Qore::YAML::None, softint width = -1, softint indent = 2) {}
static QoreValue f_makeYAML_VAVivivi(const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    QoreValue data = get_param_value(args, 0);
    int64 flags = HARD_QORE_VALUE_INT(args, 1);
    int64 width = HARD_QORE_VALUE_INT(args, 2);
    int64 indent = HARD_QORE_VALUE_INT(args, 3);
# 134 "ql_yaml.qpp"
    return q_make_yaml(data, flags, width, indent, xsink);
}

// string make_yaml(auto data, int flags = Qore::YAML::None, softint width = -1, softint indent = 2) {}
static QoreValue f_make_yaml_VAVivivi(const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    QoreValue data = get_param_value(args, 0);
    int64 flags = HARD_QORE_VALUE_INT(args, 1);
    int64 width = HARD_QORE_VALUE_INT(args, 2);
    int64 indent = HARD_QORE_VALUE_INT(args, 3);
# 116 "ql_yaml.qpp"
    return q_make_yaml(data, flags, width, indent, xsink);
}

// auto parseYAML(string yaml) {}
static QoreValue f_parseYAML_Vs(const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* yaml = HARD_QORE_VALUE_STRING(args, 0);
# 172 "ql_yaml.qpp"
    QoreYamlParser parser(*yaml, xsink);
    return parser.parse();
}

// auto parse_yaml(string yaml) {}
static QoreValue f_parse_yaml_Vs(const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* yaml = HARD_QORE_VALUE_STRING(args, 0);
# 156 "ql_yaml.qpp"
    QoreYamlParser parser(*yaml, xsink);
    return parser.parse();
}


DLLLOCAL void init_yaml_functions(QoreNamespace& ns) {
    // hash getYAMLInfo() {}
    ns.addBuiltinVariant("getYAMLInfo", (q_func_n_t)f_getYAMLInfo, QCF_CONSTANT|QCF_DEPRECATED, QDOM_DEFAULT, hashTypeInfo);
    // hash get_yaml_info() {}
    ns.addBuiltinVariant("get_yaml_info", (q_func_n_t)f_get_yaml_info, QCF_CONSTANT, QDOM_DEFAULT, hashTypeInfo);
    // string makeYAML(auto data, int flags = Qore::YAML::None, softint width = -1, softint indent = 2) {}
    ns.addBuiltinVariant("makeYAML", (q_func_n_t)f_makeYAML_VAVivivi, QCF_RET_VALUE_ONLY|QCF_DEPRECATED, QDOM_DEFAULT, stringTypeInfo, 4, autoTypeInfo, QORE_PARAM_NO_ARG, "data", bigIntTypeInfo, QoreSimpleValue().assign((int64)0), "flags", softBigIntTypeInfo, QoreSimpleValue().assign((int64)-1), "width", softBigIntTypeInfo, QoreSimpleValue().assign((int64)2), "indent");
    // string make_yaml(auto data, int flags = Qore::YAML::None, softint width = -1, softint indent = 2) {}
    ns.addBuiltinVariant("make_yaml", (q_func_n_t)f_make_yaml_VAVivivi, QCF_RET_VALUE_ONLY, QDOM_DEFAULT, stringTypeInfo, 4, autoTypeInfo, QORE_PARAM_NO_ARG, "data", bigIntTypeInfo, QoreSimpleValue().assign((int64)0), "flags", softBigIntTypeInfo, QoreSimpleValue().assign((int64)-1), "width", softBigIntTypeInfo, QoreSimpleValue().assign((int64)2), "indent");
    // auto parseYAML(string yaml) {}
    ns.addBuiltinVariant("parseYAML", (q_func_n_t)f_parseYAML_Vs, QCF_RET_VALUE_ONLY|QCF_DEPRECATED, QDOM_DEFAULT, autoTypeInfo, 1, stringTypeInfo, QORE_PARAM_NO_ARG, "yaml");
    // auto parse_yaml(string yaml) {}
    ns.addBuiltinVariant("parse_yaml", (q_func_n_t)f_parse_yaml_Vs, QCF_RET_VALUE_ONLY, QDOM_DEFAULT, autoTypeInfo, 1, stringTypeInfo, QORE_PARAM_NO_ARG, "yaml");

}

DLLLOCAL void init_yaml_constants(QoreNamespace& ns) {
# 56 "ql_yaml.qpp"
# 63 "ql_yaml.qpp"
# 66 "ql_yaml.qpp"
# 69 "ql_yaml.qpp"
# 72 "ql_yaml.qpp"
# 75 "ql_yaml.qpp"
# 78 "ql_yaml.qpp"
//const Yaml1_0 = QYE_VER_1_0;
# 83 "ql_yaml.qpp"
//const Yaml1_2 = QYE_VER_1_2;
//YNS.addConstant("Yaml1_2", QYE_VER_1_2);
    ns.addConstant("BlockStyle", ((int64)QYE_BLOCK_STYLE));
    ns.addConstant("Canonical", ((int64)QYE_CANONICAL));
    ns.addConstant("EmitSqlNull", ((int64)QYE_EMIT_SQLNULL));
    ns.addConstant("EscapeUnicode", ((int64)QYE_ESCAPE_UNICODE));
    ns.addConstant("ExplicitEndDoc", ((int64)QYE_EXPLICIT_END_DOC));
    ns.addConstant("ExplicitStartDoc", ((int64)QYE_EXPLICIT_START_DOC));
    ns.addConstant("None", ((int64)QYE_NONE));
    ns.addConstant("Yaml1_1", ((int64)QYE_VER_1_1));
# 90 "ql_yaml.qpp"
# 95 "ql_yaml.qpp"
# 120 "ql_yaml.qpp"
# 138 "ql_yaml.qpp"
# 161 "ql_yaml.qpp"
# 177 "ql_yaml.qpp"
# 195 "ql_yaml.qpp"

}
