//! Qore namespace
namespace Qore {
//! Xml namespace
namespace Xml {
//! The XmlDoc class provides access to a parsed XML document by wrapping a \c C \c xmlDocPtr from <a href="http://xmlsoft.org">libxml2</a>
/** Currently this class provides read-only access to XML documents; it is possible that this restriction will be removed in future versions of the xml module.
 */
class XmlDoc {

public:
//! creates a new XmlDoc object from the hash value passed
/** @param data the must have only one top-level key, as the XML string that will be used for the XmlDoc object will be created directly from the hash
    @param opts optional formatting and other serialization settings; see @ref xml_generation_opts for more information

    @par Example:
    @code XmlDoc xd(hash); @endcode

    @throw XMLDOC-CONSTRUCTOR-ERROR error parsing XML string
    @throw MAKE-XML-ERROR An error occurred serializing the %Qore data to an XML string
    @throw MAKE-XML-OPTS-INVALID the opts hash passed is not valid; see @ref xml_generation_opts for more information
 */
 constructor(hash data, __7_ hash opts);

public:
//! a new XmlDoc object from the XML string passed
/** @param xml the XML string to use as a basis for the XmlDoc object

    @par Example:
    @code XmlDoc xd(xml); @endcode

    @throw XMLDOC-CONSTRUCTOR-ERROR error parsing XML string
 */
 constructor(string xml);

public:
//! Returns a copy of the current object
/** @return a copy of the current object

    @par Example:
    @code XmlDoc xdcopy = xd.copy(); @endcode
*/
 copy();

public:
//! Evaluates an <a href="http://www.w3.org/TR/xpath">XPath</a> expression and returns a list of matching XmlNode objects.
/** @par Code Flags:
    @ref RET_VALUE_ONLY

    @param xpath the <a href="http://www.w3.org/TR/xpath">XPath</a> expression to evaluate against the XmlDoc object

    @return a list of XmlNode object matching the <a href="http://www.w3.org/TR/xpath">XPath</a> expression passed as an argument

    @throw XPATH-CONSTRUCTOR-ERROR cannot create XPath context from the XmlDoc object (ex: syntax error in xpath string)
    @throw XPATH-ERROR an error occured evaluating the XPath expression

    @par Example:
    @code list list = xd.evalXPath("//list[2]"); @endcode
 */
list evalXPath(string xpath);

public:
//! Returns an XmlNode object representing the root element of the document, if any exists, otherwise returns \c NOTHING
/** @return an XmlNode object representing the root element of the document, if any exists, otherwise returns \c NOTHING

   @par Code Flags:
    @ref CONSTANT

     @par Example:
    @code *XmlNode xn = xd.getRootElement(); @endcode
 */
__7_ XmlNode getRootElement();

public:
//! Returns the XML version of the contained XML document
/** @return the XML version of the contained XML document (normally \c "1.0")

   @par Code Flags:
    @ref CONSTANT

     @par Example:
    @code string xmlver = xd.getVersion(); @endcode
 */
string getVersion();

public:
//! Returns a hash corresponding to the data contained in the XML document with out-of-order keys preserved by appending a suffix to hash keys
/** @par Code Flags:
    @ref RET_VALUE_ONLY

    @par Example:
    @code hash h = xd.toQore(); @endcode

    Returns a hash structure correponding to the XML data contained by the XmlDoc object.

    @param pflags XML parsing flags; see @ref xml_parsing_constants for more information; note that this method assumes @ref XPF_PRESERVE_ORDER for backwards-compatibility

    @return a hash corresponding to the data contained in the XML document with out-of-order keys preserved by appending a suffix to hash keys

    @throw PARSE-XML-EXCEPTION error parsing XML string

    @see
    - parse_xml()
    - XmlDoc::toQoreData()
 */
hash toQore(int pflags = XPF_PRESERVE_ORDER);

public:
//! Returns a Qore hash corresponding to the data contained in the XML document; out-of-order keys are not preserved but are instead collapsed to the same Qore list
/** @par Code Flags:
    @ref RET_VALUE_ONLY

    @par Example:
    @code hash h = xd.toQoreData(); @endcode

    @param pflags XML parsing flags; see @ref xml_parsing_constants for more information;

    @return a Qore hash corresponding to the data contained in the XML document; out-of-order keys are not preserved but are instead collapsed to the same Qore list

    @throw PARSE-XML-EXCEPTION error parsing XML string

    @see
    - parse_xml()
    - XmlDoc::toQore()
 */
hash toQoreData(__7_ int pflags);

public:
//! Returns the XML string for the XmlDoc object
/** @return the XML string for the XmlDoc object
    @throw XML-DOC-TOSTRING-ERROR libxml2 reported an error while attempting to export the XmlDoc object's contents as an XML string

   @par Code Flags:
    @ref RET_VALUE_ONLY

     @par Example:
    @code string xml = xd.toString(); @endcode

    @throw XML-DOC-TOSTRING-ERROR an error occurred converting the XmlDoc object to an XML string
*/
string toString();

public:
//! Validates the XML document against a DTD; if any errors occur, exceptions are thrown
/** @par Example:
    @code{.py}
    xd.validateDtd(dtd);
    @endcode

    @param dtd the DTD to use to validate the XmlDoc object

    @throw DTD-SYNTAX-ERROR invalid DTD string
    @throw DTD-VALIDATION-ERROR the DTD did not pass validation
 */
nothing validateDtd(string dtd);

public:
//! Validates the XML document against a RelaxNG schema; if any errors occur, exceptions are thrown
/** The availability of this function depends on the presence of libxml2's \c xmlTextReaderRelaxNGSetSchema() function when this module was compiled; for maximum portability check the constant @ref optionconstants "HAVE_PARSEXMLWITHRELAXNG" before running this method.
    @param relaxng the RelaxNG schema to use to validate the XmlDoc object

    @throw MISSING-FEATURE-ERROR this exception is thrown when the function is not available; for maximum portability, check the constant @ref optionconstants "HAVE_PARSEXMLWITHRELAXNG" before calling this function
    @throw RELAXNG-SYNTAX-ERROR invalid RelaxNG string
    @throw RELAXNG-INTERNAL-ERROR libxml2 returned an internal error code while validating the document against the RelaxNG schema
    @throw RELAXNG-ERROR The document failed RelaxNG validation

    @par Example:
    @code xd.validateRelaxNG(relaxng); @endcode
 */
nothing validateRelaxNG(string relaxng);

public:
//! Validates the XML document against an XSD schema; if any errors occur, exceptions are thrown
/** The availability of this function depends on the presence of libxml2's \c xmlTextReaderSetSchema() function when this module was compiled; for maximum portability check the constant @ref optionconstants HAVE_PARSEXMLWITHSCHEMA before running this function

    @param xsd the XSD schema to use to validate the XmlDoc object

    @throw MISSING-FEATURE-ERROR this exception is thrown when the function is not available; for maximum portability, check the constant @ref optionconstants "HAVE_PARSEXMLWITHSCHEMA" before calling this function
    @throw XSD-SYNTAX-ERROR the XSD schema string could not be parsed
    @throw XSD-INTERNAL-ERROR libxml2 returned an internal error code while validating the document against the XSD schema
    @throw XSD-ERROR The document failed XSD validation

    @par Example:
    @code xd.validateSchema(xsd); @endcode
 */
nothing validateSchema(string xsd);
};
}
}
