/* -*- mode: c++; indent-tabs-mode: nil -*- */
/** @file SaxIterator.qpp defines the SaxIterator class */
/*
    QC_SaxIterator.qpp

    Qore Programming Language

    Copyright (C) 2003 - 2022 Qore Technologies, s.r.o.

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#include "qore-xml-module.h"

#include "QC_SaxIterator.h"
/* Qore class Qore::Xml::SaxIterator */

qore_classid_t CID_SAXITERATOR;
QoreClass* QC_SAXITERATOR;

// SaxIterator::constructor(string xml, string element_name, *hash opts) {}
static void SaxIterator_constructor_VsVsNh(QoreObject* self, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
    const QoreStringNode* xml = HARD_QORE_VALUE_STRING(args, 0);
    const QoreStringNode* element_name = HARD_QORE_VALUE_STRING(args, 1);
    const QoreHashNode* opts = get_param_value(args, 2).get<const QoreHashNode>();
# 53 "QC_SaxIterator.qpp"
ReferenceHolder<QoreSaxIterator> holder(new QoreSaxIterator(xml->stringRefSelf(), element_name->c_str(), opts, xsink), xsink);
    if (*xsink)
        return;
    self->setPrivate(CID_SAXITERATOR, holder.release());
}

// SaxIterator::copy() {}
static void SaxIterator_copy(QoreObject* self, QoreObject* old, QoreSaxIterator* i, ExceptionSink* xsink) {
# 66 "QC_SaxIterator.qpp"
ReferenceHolder<QoreSaxIterator> holder(new QoreSaxIterator(*i, xsink), xsink);
   if (*xsink)
      return;

   self->setPrivate(CID_SAXITERATOR, holder.release());
}

// auto SaxIterator::getValue(){}
static QoreValue SaxIterator_getValue(QoreObject* self, QoreSaxIterator* i, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 108 "QC_SaxIterator.qpp"
    if (i->check(xsink))
      return QoreValue();
   return i->getReferencedValue(xsink);
}

// bool SaxIterator::next(){}
static QoreValue SaxIterator_next(QoreObject* self, QoreSaxIterator* i, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 89 "QC_SaxIterator.qpp"
    if (i->check(xsink))
      return false;
   return i->next(xsink);
}

// nothing SaxIterator::reset(){}
static QoreValue SaxIterator_reset(QoreObject* self, QoreSaxIterator* i, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 137 "QC_SaxIterator.qpp"
    if (i->check(xsink))
       return QoreValue();
   i->reset(xsink);
    return QoreValue();
}

// bool SaxIterator::valid(){}
static QoreValue SaxIterator_valid(QoreObject* self, QoreSaxIterator* i, const QoreListNode* args, q_rt_flags_t rtflags, ExceptionSink* xsink) {
# 123 "QC_SaxIterator.qpp"
    return i->valid();
}

DLLLOCAL void preinitSaxIteratorClass() {
    QC_SAXITERATOR = new QoreClass("SaxIterator", "::Qore::Xml::SaxIterator", QDOM_DEFAULT);
    CID_SAXITERATOR = QC_SAXITERATOR->getID();
    QC_SAXITERATOR->setSystem();
}

DLLLOCAL QoreClass* initSaxIteratorClass(QoreNamespace& ns) {
    if (!QC_SAXITERATOR)
        preinitSaxIteratorClass();

    // set parent class
    assert(QC_ABSTRACTITERATOR);
    QC_SAXITERATOR->addBuiltinVirtualBaseClass(QC_ABSTRACTITERATOR);

    // SaxIterator::constructor(string xml, string element_name, *hash opts) {}
    QC_SAXITERATOR->addConstructor(SaxIterator_constructor_VsVsNh, Public, QCF_NO_FLAGS, QDOM_DEFAULT, 3, stringTypeInfo, QORE_PARAM_NO_ARG, "xml", stringTypeInfo, QORE_PARAM_NO_ARG, "element_name", hashOrNothingTypeInfo, QORE_PARAM_NO_ARG, "opts");

    // SaxIterator::copy() {}
    QC_SAXITERATOR->setCopy((q_copy_t)SaxIterator_copy);

    // auto SaxIterator::getValue(){}
    QC_SAXITERATOR->addMethod("getValue", (q_method_n_t)SaxIterator_getValue, Public, QCF_RET_VALUE_ONLY, QDOM_DEFAULT, autoTypeInfo);

    // bool SaxIterator::next(){}
    QC_SAXITERATOR->addMethod("next", (q_method_n_t)SaxIterator_next, Public, QCF_NO_FLAGS, QDOM_DEFAULT, boolTypeInfo);

    // nothing SaxIterator::reset(){}
    QC_SAXITERATOR->addMethod("reset", (q_method_n_t)SaxIterator_reset, Public, QCF_NO_FLAGS, QDOM_DEFAULT, nothingTypeInfo);

    // bool SaxIterator::valid(){}
    QC_SAXITERATOR->addMethod("valid", (q_method_n_t)SaxIterator_valid, Public, QCF_CONSTANT, QDOM_DEFAULT, boolTypeInfo);

    return QC_SAXITERATOR;
}
