// -*- mode: c++; indent-tabs-mode: nil -*-
//! Qore SoapDataProvider module definition

/*  SoapDataProvider.qm Copyright 2019 - 2020 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*/

// minimum required Qore version
// assume local scope for variables, do not use "$" signs
// require type definitions everywhere
// strict argument handling
// enable all warnings


}

/** @mainpage SoapDataProvider Module

    @tableofcontents

    @section soapdataproviderintro Introduction to the SoapDataProvider Module

    The %SoapDataProvider module provides a @ref dataproviderintro "data provider" API for SOAP messaging.  The
    @ref SoapDataProvider::SoapDataProvider "SoapDataProvider" class allows for introspecting a SOAP schema, while the
    @ref SoapDataProvider::SoapRequestDataProvider "SoapRequestDataProvider" class
    supports the @ref dataproviderintro "data provider" request-reply API for communication with SOAP servers.

    SOAP schemas can be introspected with the following format:
    - requests: <tt><i>operation</i>/request</tt>
      - ex: <tt><b>getInfo/request</b></tt>
      - results in a
        @ref SoapDataProvider::SoapRequestDataProvider "SoapRequestDataProvider" object where a request can be sent
        to the server
    - responses: <tt><i>operation</i>/response</tt>
      - ex: <tt><b>getInfo/response</b></tt>
      - results in a
        @ref SoapDataProvider::SoapResponseDataProvider "SoapResponseDataProvider" object where the response
        definition can be introspected

    The following classes are provided by this module:
    - @ref SoapDataProvider::SoapDataProvider "SoapDataProvider"
    - @ref SoapDataProvider::SoapDataProviderBase "SoapDataProviderBase"
    - @ref SoapDataProvider::SoapDataProviderFactory "SoapDataProviderFactory"
    - @ref SoapDataProvider::SoapOperationDataProvider "SoapOperationDataProvider"
    - @ref SoapDataProvider::SoapRequestDataProvider "SoapRequestDataProvider"
    - @ref SoapDataProvider::SoapResponseDataProvider "SoapResponseDataProvider"

    @section soapdataprovider_relnotes Release Notes

    @subsection soapdataprovider_v1_0 SoapDataProvider v1.0
    - initial release of the module
*/

//! contains all public definitions in the SoapDataProvider module
namespace SoapDataProvider {
};
