// -*- mode: c++; indent-tabs-mode: nil -*-
//! Qore SoapDataProvider module definition

/** SoapDataProvider.qc Copyright 2019 - 2020 Qore Technologies, s.r.o.

    Permission is hereby granted, free of charge, to any person obtaining a
    copy of this software and associated documentation files (the "Software"),
    to deal in the Software without restriction, including without limitation
    the rights to use, copy, modify, merge, publish, distribute, sublicense,
    and/or sell copies of the Software, and to permit persons to whom the
    Software is furnished to do so, subject to the following conditions:

    The above copyright notice and this permission notice shall be included in
    all copies or substantial portions of the Software.

    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
    IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
    FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
    AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
    LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
    FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
    DEALINGS IN THE SOFTWARE.
*/

// minimum required Qore version
// assume local scope for variables, do not use "$" signs
// require type definitions everywhere
// strict argument handling
// enable all warnings

//! contains all public definitions in the SoapDataProvider module
namespace SoapDataProvider {
//! The Soap data provider class
class SoapDataProvider : public AbstractDataProvider {

public:
        //! The SOAP schema
        WebService webservice;

        //! The client object for API calls
        __7_ SoapClient soapclient;

        //! Provider info
        const ProviderInfo = ...;


        //! Constructor options
        const ConstructorOptions = ...;


protected:
        //! hash of valid paths
        hash<auto> path_tree;

public:

    //! Creates the object from the arguments
    constructor(WebService webservice, __7_ SoapClient soapclient);


    //! Creates the object from constructor options
    constructor(__7_ hash<auto> options);


    //! Returns the data provider name
    string getName();


    //! Checks the SOAP client
protected:
     checkSoapClient(SoapClient soap);
public:


    //! Returns a list of child data provider names, if any
/** @return a list of child data provider names, if any
    */
protected:
     __7_ list<string> getChildProviderNamesImpl();
public:


    //! Returns the given child provider or @ref nothing if the given child is unknown
/** @return the given child provider or @ref nothing if the given child is unknown

        @see getChildProviderEx()
    */
protected:
     __7_ AbstractDataProvider getChildProviderImpl(string name);
public:


    //! Returns data provider static info
protected:
     hash<DataProviderInfo> getStaticInfoImpl();
public:

};
};
