#!/usr/bin/env qore

%new-style
%require-types
%enable-all-warnings
%strict-args

%module-cmd(jni) import org.qore.jni.compiler.QoreJavaCompiler
%module-cmd(jni) import org.qore.jni.compiler.CompilerOutput

# compile and execute QoreDynamicTest16.java
QoreJavaCompiler compiler();
hash<auto> sources = {
    "org.qore.test.QoreDynamicTest16": File::readTextFile(get_script_dir() +
        "/../test/QoreDynamicTest16.java"),
};
hash<auto> cv = compiler.compile(sources);
#printf("%N\n", cv);
compiler::CompilerOutput newClassData = cv{"org.qore.test.QoreDynamicTest16"};
binary fdata = newClassData.file.openInputStream().readAllBytes();
assertEq(True, fdata.size() > 0);

Program p(PO_NEW_STYLE);
p.setScriptPath(get_script_path());
p.issueModuleCmd("jni", "define-class org/qore/test/QoreDynamicTest16 " + fdata.toBase64());
p.issueModuleCmd("jni", "define-class org/qore/test/TestClass "
    + cv{"org.qore.test.TestClass"}.file.openInputStream().readAllBytes().toBase64());

p.parse("
class X inherits QoreDynamicTest16 {
    nothing messageArrived(string topic, auto other) {
        printf('topic: %y\n', topic);
    }
}

sub test() {
    X x();
    TestClass c();
    c.get(x);
}", "test");

assertEq(NOTHING, p.callFunction("test"));

sub assertEq(auto l, auto r) {
    if (l !== r) {
        throw "ERR", sprintf("%y !== %y", l, r);
    }
}