/*
 * Decompiled with CFR 0.152.
 */
package org.qore.lang.test;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.qore.jni.QoreObject;
import org.qore.lang.AbstractDatasource;
import org.qore.lang.AbstractSQLStatement;
import org.qore.lang.DatasourcePool;
import org.qore.lang.LogCallback;
import org.qore.lang.bulksqlutil.BulkInsertOperation;
import org.qore.lang.bulksqlutil.BulkRowCallback;
import org.qore.lang.bulksqlutil.BulkUpsertOperation;
import org.qore.lang.dataprovider.AbstractDataProvider;
import org.qore.lang.dataprovider.AbstractDataProviderRecordIterator;
import org.qore.lang.qunit.AbstractTestResult;
import org.qore.lang.qunit.Test;
import org.qore.lang.qunit.TestCode;
import org.qore.lang.qunit.TestResultExceptionDetail;
import org.qore.lang.qunit.TestResultExceptionRegexp;
import org.qore.lang.qunit.TestResultExceptionSubstring;
import org.qore.lang.qunit.TestResultExceptionType;
import org.qore.lang.qunit.TestResultFailure;
import org.qore.lang.qunit.TestResultSuccess;
import org.qore.lang.qunit.TestResultValue;
import org.qore.lang.sqlutil.AbstractTable;
import org.qore.lang.sqlutil.Table;

public class QoreJavaLangApiTest {
    public static DatasourcePool getPool(QoreObject qoreObject) {
        return new DatasourcePool(qoreObject);
    }

    public static Table createTable(QoreObject qoreObject) throws Throwable {
        DatasourcePool datasourcePool = new DatasourcePool(qoreObject);
        Table table = new Table((AbstractDatasource)datasourcePool, "test_table_1");
        HashMap<String, Object> hashMap = new HashMap<String, Object>(){
            {
                this.put("qore_type", "integer");
            }
        };
        table.addColumn("id", (Map)hashMap, false);
        hashMap = new HashMap<String, Object>(){
            {
                this.put("qore_type", "string");
                this.put("size", 50);
            }
        };
        table.addColumn("string", (Map)hashMap, false);
        hashMap = new HashMap<String, Object>(){
            {
                this.put("qore_type", "date");
            }
        };
        table.addColumn("modified", (Map)hashMap, false);
        table.addPrimaryKey("pk_test_table_1", new String[]{"id"});
        try {
            table.create();
            table.commit();
        }
        catch (Throwable throwable) {
            table.rollback();
            throw throwable;
        }
        return table;
    }

    public static boolean dropTable(Table table) throws Throwable {
        table.drop();
        table.commit();
        return true;
    }

    public static boolean testTable(Table table) throws Throwable {
        AbstractDatasource abstractDatasource = table.getDatasource();
        try {
            ZoneId zoneId = ZoneId.of(ZonedDateTime.now().getOffset().toString());
            ZonedDateTime zonedDateTime = ZonedDateTime.now(zoneId);
            AbstractSQLStatement abstractSQLStatement = abstractDatasource.getSQLStatement();
            abstractSQLStatement.prepare("insert into test_table_1 (id, string, modified) values(%v, %v, %v)", new Object[0]);
            abstractSQLStatement.bind(new Object[]{1, "hello", zonedDateTime});
            abstractSQLStatement.exec(new Object[0]);
            abstractSQLStatement.commit();
            if (table.rowCount() != 1) {
                throw new Throwable("rowcount");
            }
            final HashMap<String, Object> hashMap = new HashMap<String, Object>(){
                {
                    this.put("id", 1);
                }
            };
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>(){
                {
                    this.put("where", hashMap);
                }
            };
            HashMap hashMap3 = table.selectRow((Map)hashMap2);
            if ((Long)hashMap3.get("id") != 1L) {
                throw new Throwable("id");
            }
            if (!hashMap3.get("string").equals("hello")) {
                System.out.println("STR: " + hashMap3.get("string").toString() + " != hello");
                throw new Throwable("string");
            }
            if (!hashMap3.get("modified").equals(zonedDateTime)) {
                throw new Throwable("modified");
            }
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            table.rollback();
            throw throwable;
        }
        finally {
            table.commit();
        }
    }

    public static Object[] testBulkInsert(Table table) throws Throwable {
        Object[] objectArray2 = new Object[3];
        ZoneId zoneId = ZoneId.of(ZonedDateTime.now().getOffset().toString());
        final ZonedDateTime zonedDateTime = ZonedDateTime.now(zoneId);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(){
            {
                this.put("id", 2);
                this.put("string", "str");
                this.put("modified", zonedDateTime);
            }
        };
        ArrayList arrayList = new ArrayList();
        BulkRowCallback bulkRowCallback = map -> arrayList.add(map);
        ArrayList arrayList2 = new ArrayList();
        final LogCallback logCallback = (string, objectArray) -> arrayList2.add(String.format(string, objectArray));
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>(){
            {
                this.put("info_log", logCallback);
            }
        };
        BulkInsertOperation bulkInsertOperation = new BulkInsertOperation((AbstractTable)table, (Map)hashMap2);
        bulkInsertOperation.setRowCode(bulkRowCallback);
        try {
            bulkInsertOperation.queueData((Map)hashMap);
            bulkInsertOperation.flush();
            bulkInsertOperation.commit();
        }
        catch (Throwable throwable) {
            table.rollback();
            throw throwable;
        }
        final HashMap<String, Object> hashMap3 = new HashMap<String, Object>(){
            {
                this.put("id", 2);
            }
        };
        HashMap<String, Object> hashMap4 = new HashMap<String, Object>(){
            {
                this.put("where", hashMap3);
            }
        };
        objectArray2[0] = table.selectRow((Map)hashMap4);
        objectArray2[1] = arrayList;
        objectArray2[2] = arrayList2;
        return objectArray2;
    }

    public static Map<String, Object> testBulkUpsert(Table table) throws Throwable {
        ZoneId zoneId = ZoneId.of(ZonedDateTime.now().getOffset().toString());
        final ZonedDateTime zonedDateTime = ZonedDateTime.now(zoneId);
        HashMap<String, Object> hashMap = new HashMap<String, Object>(){
            {
                this.put("id", 2);
                this.put("string", "new-str");
                this.put("modified", zonedDateTime);
            }
        };
        ArrayList arrayList = new ArrayList();
        BulkRowCallback bulkRowCallback = map -> arrayList.add(map);
        BulkUpsertOperation bulkUpsertOperation = new BulkUpsertOperation((AbstractTable)table);
        try {
            bulkUpsertOperation.queueData((Map)hashMap);
            bulkUpsertOperation.flush();
            bulkUpsertOperation.commit();
        }
        catch (Throwable throwable) {
            table.rollback();
            throw throwable;
        }
        final HashMap<String, Object> hashMap2 = new HashMap<String, Object>(){
            {
                this.put("id", 2);
            }
        };
        HashMap<String, Object> hashMap3 = new HashMap<String, Object>(){
            {
                this.put("where", hashMap2);
            }
        };
        return table.selectRow((Map)hashMap3);
    }

    public static void testDataProvider(QoreObject qoreObject) throws Throwable {
        AbstractDataProvider abstractDataProvider = new AbstractDataProvider(qoreObject);
        Test test = new Test("JniTest", "1.0");
        AbstractDataProviderRecordIterator abstractDataProviderRecordIterator = abstractDataProvider.searchRecords(Collections.emptyMap());
        test.assertFalse((Object)abstractDataProviderRecordIterator.next());
    }

    public static void doTests() throws Throwable {
        Test test = new Test("JniTest", "1.0");
        TestCode testCode = () -> {
            test.assertTrue((Object)true);
            test.assertFalse((Object)false);
            test.assertEq((Object)1, (Object)1);
            test.assertEqSoft((Object)1, (Object)"1");
            test.assertNeq((Object)1, (Object)2);
            test.assertNeqSoft((Object)1, (Object)"2");
            test.assertGt((Object)1, (Object)2);
            test.assertGtSoft((Object)1, (Object)"2");
            test.assertGe((Object)1, (Object)2);
            test.assertGeSoft((Object)1, (Object)"2");
            test.assertLt((Object)2, (Object)1);
            test.assertLtSoft((Object)2, (Object)"1");
            test.assertLe((Object)2, (Object)1);
            test.assertLeSoft((Object)2, (Object)"1");
            test.testAssertion("my-test", () -> true);
            test.testAssertion("my-test", () -> true, (AbstractTestResult)new TestResultSuccess());
            test.testAssertion("my-test", () -> false, (AbstractTestResult)new TestResultFailure());
            test.testAssertion("my-test", () -> 2, (AbstractTestResult)new TestResultValue((Object)2));
            Object[] objectArray2 = new Object[]{1};
            test.testAssertion("my-test", objectArray -> objectArray[0], objectArray2, (AbstractTestResult)new TestResultValue((Object)1));
            test.assertThrows("JNI-ERROR", "Error", () -> {
                throw new Throwable("Error");
            });
            test.testAssertion("my-test", () -> {
                throw new Throwable("Error");
            }, (AbstractTestResult)new TestResultExceptionType("JNI-ERROR"));
            test.testAssertion("my-test", () -> {
                throw new Throwable("Error");
            }, (AbstractTestResult)new TestResultExceptionDetail("JNI-ERROR", "java.lang.Throwable: Error"));
            test.testAssertion("my-test", () -> {
                throw new Throwable("Error");
            }, (AbstractTestResult)new TestResultExceptionRegexp("JNI-ERROR", "Error"));
            test.testAssertion("my-test", () -> {
                throw new Throwable("Error");
            }, (AbstractTestResult)new TestResultExceptionSubstring("JNI-ERROR", "Error"));
        };
        test.addTestCase("my test", testCode);
        test.main();
    }
}

