/******************************************************************************
    Copyright (C) 2006, 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

  Garmin and MapSource are registered trademarks or trademarks of Garmin Ltd.
  or one of its subsidiaries.

-------------------------------------------------------------------------------

  gmapsupp.h:

  Header file for gmapsupp.cpp.

  Elements related to the creation of GMAPSUPP.IMG, the data file that combines
  the maps uploaded to a Garmin GPS.

  Does not create a GMAPBMAP.IMG base file.

  The documentation at
     http://sourceforge.net/projects/garmin-img
  provides some partial information on normal IMG files, although not on the
  unique features of GMAPSUPP.IMG.

  At this time, (12/29/07), the main known problem is that *two* copies of all
  data to upload are kept in memory.  Don't try a big upload if you have little
  memory on your machine.

  It is unclear to me how out-of-memory conditions are checked.  I am assuming
  Qt will properly terminate the program when an out-of-memory condition
  occurs.

  Also note that file sizes above 4GB are disabled at this time since lvd
  is unsure about which Qt indices are allowed to be 64 bit.  It is mostly
  written to allow bigger file sizes, though, and presumably can be adopted
  easily if the need arises.

  The driver includes user interaction through QMessageBox that is removable.
  However, this will require the user to wait until a big unacceptable
  map set is completed and has possibly crashed the program due to
  excessive memory allocations.

******************************************************************************/
#ifndef GMAPSUPP_H
#define GMAPSUPP_H

#include <QStringList>

#include <IDevice.h>

// QMAPSUPP.IMG mapfile definition
struct gms_map_def_t
{
    quint32 id;                  // file name number
    QString filename;            // disk file path of the IMG file
    QString mapname;             // map family name, e.g. US Road & Rec - Continental US
    QString tilename;            // e.g. Leon County
    QString mapKey;              // map key
    QString tileKey;             // tile key
    quint32 disabled;            // whether the file is disabled
    QString intname;             // internal name, from the FAT names of the parts
};

// the function that actually creates GMAPSUPP.IMG
extern void mkGMapSupp(
// input: selected IMG map tiles
QList<gms_map_def_t>& files,
// input: map sets involved
const QSet<QString>& maps,
// input: keys for the map sets
const QSet<QString>& keys,
// input: GMAPSUPP.IMG file size limit
quint64 size_limit,
// input: GMAPSUPP.IMG map tile limit
quint32 maps_limit,
// input: whether to disallow duplicate internal tile IDs
quint32 no_duplicates,
// output: GMAPSUPP.IMG as a byte string
QByteArray& result,
// output: size of the GMAPSUPP.IMG file
quint64& file_size,
// output: number of tiles in the file
quint32& subfile_cnt,
// output: skipped tiles (invalid or GPS limits exceeded)
quint32& skipped_cnt,
// output: invalid tiles (having duplicated internal IDs)
quint32& invalid_cnt
);
#endif                           //GMAPSUPP_H
