/**********************************************************************************************
    Copyright (C) 2007 Oliver Eichler oliver.eichler@gmx.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111 USA

**********************************************************************************************/
#ifndef CDLGWPTICON_H
#define CDLGWPTICON_H

#include <QDialog>
#include <QVector>

class QLabel;
class QVBoxLayout;
class QGridLayout;
class QPixmap;

class CDlgWptIcon : public QDialog
{
    Q_OBJECT
        public:
        CDlgWptIcon(quint16& id, QWidget * parent);
        virtual ~CDlgWptIcon();

    protected:
        void mousePressEvent(QMouseEvent * event);
        void setupSampleIcons(QGridLayout * layout, int * groupIDs, int len);

        quint16& id;
        QVBoxLayout * layout;
        QLabel      * lblSymbol;
        QGridLayout * layoutSymbols;
        QLabel      * lblFavIcon;
        QGridLayout * layoutFavIcon;
        QLabel      * lblCustomIcon;
        QGridLayout * layoutCustomIcon;

        QVector<QLabel*> items;
};
#endif                           //CDLGWPTICON_H
