/***************************************************************************
    qgswcsdataitems.h
    ---------------------
    begin                : 2 July, 2012
    copyright            : (C) 2012 by Radim Blazek
    email                : radim dot blazek at gmail.com
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef QGSWCSDATAITEMS_H
#define QGSWCSDATAITEMS_H

#include "qgsdatacollectionitem.h"
#include "qgslayeritem.h"
#include "qgsdatasourceuri.h"
#include "qgswcscapabilities.h"
#include "qgsdataitemprovider.h"
#include "qgsconnectionsitem.h"

class QgsWCSConnectionItem : public QgsDataCollectionItem
{
    Q_OBJECT
  public:
    QgsWCSConnectionItem( QgsDataItem *parent, QString name, QString path, QString uri );

    QVector<QgsDataItem *> createChildren() override;
    bool equal( const QgsDataItem *other ) override;

    QgsWcsCapabilities mWcsCapabilities;
    QVector<QgsWcsCoverageSummary> mLayerProperties;

  private:
    QString mUri;
};

// WCS Layers may be nested, so that they may be both QgsDataCollectionItem and QgsLayerItem
// We have to use QgsDataCollectionItem and support layer methods if necessary
class QgsWCSLayerItem : public QgsLayerItem
{
    Q_OBJECT
  public:
    QgsWCSLayerItem( QgsDataItem *parent, QString name, QString path,
                     const QgsWcsCapabilitiesProperty &capabilitiesProperty,
                     const QgsDataSourceUri &dataSourceUri, const QgsWcsCoverageSummary &coverageSummary );

    QString createUri();

    QgsWcsCapabilitiesProperty mCapabilities;
    QgsDataSourceUri mDataSourceUri;
    QgsWcsCoverageSummary mCoverageSummary;
};

class QgsWCSRootItem : public QgsConnectionsRootItem
{
    Q_OBJECT
  public:
    QgsWCSRootItem( QgsDataItem *parent, QString name, QString path );

    QVector<QgsDataItem *> createChildren() override;

    QVariant sortKey() const override { return 9; }

#ifdef HAVE_GUI
    QWidget *paramWidget() override;
#endif

  public slots:
#ifdef HAVE_GUI
    void onConnectionsChanged();
#endif
};

//! Provider for WCS root data item
class QgsWcsDataItemProvider : public QgsDataItemProvider
{
  public:
    QString name() override;
    QString dataProviderKey() const override;
    Qgis::DataItemProviderCapabilities capabilities() const override;
    QgsDataItem *createDataItem( const QString &pathIn, QgsDataItem *parentItem ) override;
};

#endif // QGSWCSDATAITEMS_H
