/***************************************************************************
                             qgsogrexpressioncompiler.h
                             --------------------------
    begin                : November 2015
    copyright            : (C) 2015 Nyall Dawson
    email                : nyall dot dawson at gmail dot com
 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSOGREXPRESSIONCOMPILER_H
#define QGSOGREXPRESSIONCOMPILER_H

#include "qgsogrfeatureiterator.h"
#include "qgssqlexpressioncompiler.h"

class QgsExpressionNode;
class QgsExpression;

class QgsOgrExpressionCompiler : public QgsSqlExpressionCompiler
{
  public:

    explicit QgsOgrExpressionCompiler( QgsOgrFeatureSource *source );

    virtual Result compile( const QgsExpression *exp ) override;

  protected:

    virtual Result compileNode( const QgsExpressionNode *node, QString &str ) override;
    virtual QString quotedIdentifier( const QString &identifier ) override;
    virtual QString quotedValue( const QVariant &value, bool &ok ) override;
    virtual QString castToReal( const QString &value ) const override;
    virtual QString castToInt( const QString &value ) const override;

  private:

    QgsOgrFeatureSource *mSource = nullptr;
};

#endif // QGSOGREXPRESSIONCOMPILER_H
