# -*- coding: utf-8 -*-

"""
***************************************************************************
    mkuidefaults.py
    ---------------------
    Date                 : June 2013
    Copyright            : (C) 2013 by Juergen E. Fischer
    Email                : jef at norbit dot de
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Juergen E. Fischer'
__date__ = 'June 2013'
__copyright__ = '(C) 2013, Juergen E. Fischer'
# This will get replaced with a git SHA1 when you do a git archive
__revision__ = '297138f14f92e55d2aa85557b380f48097a88a63'

from qgis.PyQt.QtCore import QCoreApplication, QSettings


def chunks(l, n):
    for i in range(0, len(l), n):
        yield l[i:i + n]


QCoreApplication.setOrganizationName("QGIS")
QCoreApplication.setOrganizationDomain("qgis.org")
QCoreApplication.setApplicationName("QGIS3")

s = QSettings()

ba = bytes(s.value("/UI/geometry"))

f = open("src/app/ui_defaults.h", "w")

f.write("#ifndef UI_DEFAULTS_H\n#define UI_DEFAULTS_H\n\nstatic const unsigned char defaultUIgeometry[] =\n{\n")

for chunk in chunks(ba, 16):
    f.write("  %s,\n" % ", ".join(map(lambda x: "0x%02x" % x, chunk)))

f.write("};\n\nstatic const unsigned char defaultUIstate[] =\n{\n")

ba = bytes(s.value("/UI/state"))

for chunk in chunks(ba, 16):
    f.write("  %s,\n" % ", ".join(map(lambda x: "0x%02x" % x, chunk)))

try:
    ba = bytes(s.value("/Composer/geometry"))

    f.write("};\n\nstatic const unsigned char defaultComposerUIgeometry[] =\n{\n")

    for chunk in chunks(ba, 16):
        f.write("  %s,\n" % ", ".join(map(lambda x: "0x%02x" % x, chunk)))
except TypeError as ex:
    pass

try:
    ba = bytes(s.value("/ComposerUI/state"))
    f.write("};\n\nstatic const unsigned char defaultComposerUIstate[] =\n{\n")

    for chunk in chunks(ba, 16):
        f.write("  %s,\n" % ", ".join(map(lambda x: "0x%02x" % x, chunk)))
except TypeError as ex:
    pass

f.write("};\n\n#endif // UI_DEFAULTS_H\n")

f.close()
