# -*- coding: utf-8 -*-

"""
***************************************************************************
    v_net_components.py
    ---------------------
    Date                 : December 2015
    Copyright            : (C) 2015 by Médéric Ribreux
    Email                : medspx at medspx dot fr
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Médéric Ribreux'
__date__ = 'December 2015'
__copyright__ = '(C) 2015, Médéric Ribreux'

# This will get replaced with a git SHA1 when you do a git archive

__revision__ = '1c1de3a88bed861da53b859bf80062fd2aab3659'

from .v_net import variableOutput


def processCommand(alg, parameters):
    # remove the output for point
    outLine = alg.getOutputFromName(u'output')
    outPoint = alg.getOutputFromName(u'output_point')
    alg.exportedLayers[outPoint.value] = outLine.name + alg.uniqueSuffix
    alg.removeOutputFromName(u'output_point')

    alg.processCommand()

    # Re-add output for point
    alg.addOutput(outPoint)


def processOutputs(alg):
    outputParameter = {u"output": [u"line", 1],
                       u"output_point": [u"point", 2]}
    variableOutput(alg, outputParameter)
