from collections.abc import Iterator
from typing import Any, Literal, overload
from typing_extensions import TypeAlias

from .resource import Collection, Model

_ImageList: TypeAlias = list[Image]  # To resolve conflicts with a method called "list"

class Image(Model):
    @property
    def labels(self) -> dict[str, Any]: ...
    @property
    def short_id(self) -> str: ...
    @property
    def tags(self) -> list[str]: ...
    def history(self) -> list[Any]: ...
    def remove(self, force: bool = False, noprune: bool = False) -> dict[str, Any]: ...
    def save(self, chunk_size: int = 2097152, named: bool = False) -> Iterator[Any]: ...
    def tag(self, repository: str, tag: str | None = None, **kwargs) -> bool: ...

class RegistryData(Model):
    image_name: str
    def __init__(self, image_name: str, *args, **kwargs) -> None: ...
    @property
    def id(self) -> str: ...
    @property
    def short_id(self) -> str: ...
    def pull(self, platform: str | None = None) -> Image: ...
    def has_platform(self, platform): ...
    def reload(self) -> None: ...

class ImageCollection(Collection[Image]):
    model: type[Image]
    def build(self, **kwargs) -> tuple[Image, Iterator[Any]]: ...
    def get(self, name: str) -> Image: ...
    def get_registry_data(self, name, auth_config: dict[str, Any] | None = None) -> RegistryData: ...
    def list(self, name: str | None = None, all: bool = False, filters: dict[str, Any] | None = None) -> _ImageList: ...
    def load(self, data: bytes) -> _ImageList: ...
    @overload
    def pull(self, repository: str, tag: str | None = None, all_tags: Literal[False] = False, **kwargs) -> Image: ...
    @overload
    def pull(self, repository: str, tag: str | None = None, *, all_tags: Literal[True], **kwargs) -> _ImageList: ...
    @overload
    def pull(self, repository: str, tag: str | None, all_tags: Literal[True], **kwargs) -> _ImageList: ...
    def push(self, repository: str, tag: str | None = None, **kwargs): ...
    def remove(self, *args, **kwargs) -> None: ...
    def search(self, *args, **kwargs): ...
    def prune(self, filters: dict[str, Any] | None = None): ...
    def prune_builds(self, *args, **kwargs): ...

def normalize_platform(platform, engine_info): ...
