from collections.abc import Iterator
from typing import Any, ClassVar, Protocol

from jsonschema._format import FormatChecker
from jsonschema._types import TypeChecker
from jsonschema.exceptions import ValidationError
from jsonschema.validators import RefResolver

class Validator(Protocol):
    META_SCHEMA: ClassVar[dict[Any, Any]]
    VALIDATORS: ClassVar[dict[Any, Any]]
    TYPE_CHECKER: ClassVar[TypeChecker]
    FORMAT_CHECKER: ClassVar[FormatChecker]
    schema: dict[Any, Any] | bool
    def __init__(
        self, schema: dict[Any, Any] | bool, resolver: RefResolver | None = ..., format_checker: FormatChecker | None = ...
    ) -> None: ...
    @classmethod
    def check_schema(cls, schema: dict[Any, Any]) -> None: ...
    def is_type(self, instance: Any, type: str) -> bool: ...
    def is_valid(self, instance: dict[Any, Any]) -> bool: ...
    def iter_errors(self, instance: dict[Any, Any]) -> Iterator[ValidationError]: ...
    def validate(self, instance: dict[Any, Any]) -> None: ...
    def evolve(self, **kwargs) -> Validator: ...
