#
# noe.py
#
# Copyright (C) 2005  Dr. Stephane Gagne
# the full copyright notice is found in the LICENSE file in this directory
#
# This program is free software; 
# you can redistribute it and/or modify it under the terms of the 
# GNU General Public License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, Inc., 
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# Contact:  nmr@rsvs.ulaval.ca
#
# --------------------------------------------------------------------
# author:  Leigh Willard
# lab:     Stephane Gagne, Laval Universite 
# date:    jan 2004
# --------------------------------------------------------------------
#
#
# PURPOSE: this is the main routine to call PyMOL.
#
#
#------------------------------------------------------------------------
# REVISION HISTORY:
#
# 2.05 - re-structured the program into modules.
#       re-wrote the torsions program.
#       added a "save" button to the output.
#
#
# 3.0  - added noe restraints to the Verify function.
#      - major re-writing.
# 3.1  - bug fix for loading
#      - first ebuild
#      - temporarily disable the load group function.
# .31  - renamed the version from 3.1 to 0.31
# .32  - added superimposition
# .33  - loading one big pdb file
# .34  - fast superimposition
# .35  - best range rewritten in C
# .37  - fix bug in averaging, also add averaging command "closest"
# .37c  - re-fix bug calling transpose_selection
# .37d  - create a color cutoff on the GUI, and slightly change the
#         way that violations are displayed
# .37e - added an install script.  no actual changes to the program.
# .37f - small bug fix to input routine in Crmsd.c.
#
#------------------------------------------------------------------------


from pymol import cmd
from Tkinter import *
import Pmw, sys, os

from loadnmr import *
from verify import *
from superimp import *


#------------------------------------------------------------------------------
# set up our NMR class.  first open a root window, then
# put up the menus.  Each menu item will call another class.
#
class Pynmr:
    """  
    pynmr 
    an NMR module for pymol
    """



# Pynmr -> showHelp ------------------------------------------------
    def showHelp(self, topic):

#       if it already exists, delete the window.
        try: helpwin.destroy()
        except UnboundLocalError: pass
        except AttributeError: pass
        except TclError: pass

#       open up new window with help page in it.
        helpwin = Tk()
        helpwin.title("PyNMR Help")
        helpwin.geometry("+800+25")

        fr1 = Frame(helpwin)
        fr1.pack(expand="yes", fill="both")

#       scrollbar
        helpsb = Scrollbar(fr1)
        textarea = Text(fr1, height=30,width=60)
        textarea.focus_set()
        helpsb.pack(side=RIGHT,fill=Y)
        textarea.pack(side=LEFT, expand="yes", fill="both")
        helpsb.configure(command=textarea.yview)
        textarea.configure(yscrollcommand=helpsb.set)


        fname = "%s%s" % (self.myfixed["helpdir"], topic)
        fp = open(fname, "r")
        try:
            helplines = fp.readlines()
        except: helpwin.destroy(); return
        fp.close()

        for line in helplines:
            textarea.insert(END, line)
        Button(helpwin, text="Close", command=helpwin.destroy).pack(pady=10)

# END Pynmr -> showHelp --------------------------------------------



# Pynmr-> NMR_menus -------------------------------------------------
    def NMR_menus(self, root):


        def call_load(type):
            self.nmrframe.destroy()
            self.nmrframe = Frame(root)
            self.nmrframe.pack()
            loadPdb(self.nmrframe, type)

        def call_superimpose():
            self.nmrframe.destroy()
            self.nmrframe = Frame(root)
            self.nmrframe.pack()
            start_superImpose(root, self.nmrframe)

        def call_checkrst():
            self.nmrframe.destroy()
            self.nmrframe = Frame(root)
            self.nmrframe.pack()
            checkRst(root, self.nmrframe)


        # main menubar
        menubar = Pmw.MenuBar(root, hull_relief='raised', hull_borderwidth=1)
        menubar.pack(fill=X, side = "top")

        # FILE menu
        menubar.addmenu('File', 'Load files or exit')
        menubar.addmenuitem('File', 'command', 'Load PDB files',
            command=lambda arg=1: call_load(arg),
            label="Load PDB Files")
        menubar.addmenuitem('File', 'separator')
        menubar.addmenuitem('File', 'command', 'Quit PyNMR',
            command = root.destroy,
            label = "Quit PyNMR")

        # VERIFY menu
        menubar.addmenu('Special', 'NMR Functions')
        menubar.addmenuitem('Special', 'command', 'Superimpose',
            command=call_superimpose,
            label = "Superimpose")
        menubar.addmenuitem('Special', 'command', 'Restraints',
            command=call_checkrst,
            label = "Restraints")

        # HELP menu
        menubar.addmenu('Help', 'User manuals to verify', side = 'right')
        menubar.addmenuitem('Help', 'command', 'About this application',
            command=lambda arg="about": self.showHelp(arg),
            label = "About...")
        menubar.addmenuitem('Help', 'separator')
        menubar.addmenuitem('Help', 'command', 'About Load Multiple',
            command=lambda arg="loadmult": self.showHelp(arg),
            label = "Load PDB Files")
        menubar.addmenuitem('Help', 'command', 'About Check Restraints',
            command=lambda arg="chkrestr": self.showHelp(arg),
            label = "Check Restraints")
        menubar.addmenuitem('Help', 'command', 'About Superimpose',
            command=lambda arg="superimpose": self.showHelp(arg),
            label = "Superimpose")
        menubar.addmenuitem('Help', 'command', 'About Using Scripts',
            command=lambda arg="scripts": self.showHelp(arg),
            label = "Using Scripts")


# END Pynmr-> NMR_menus  ------------------------------------------------


# Pynmr -> introScreen  ----------------------------------------------
    def introScreen(self, parent):

        self.nmrframe = Frame(parent)
        self.nmrframe.pack(side=BOTTOM)

        Label(self.nmrframe, text="""
version 0.37f of
The pymol NMR toolkit.

Brought to you by the Stephane Gagne Lab 
(programmer Leigh Willard second from the left,
and Dr. Gagne fourth from the right)
""").pack()
        gif1 = PhotoImage(file="%slab2003_sm.GIF"%(self.myfixed['imagedir']), 
		master=parent)
        gif2 = PhotoImage(file="%slogoCrefsip.GIF"%(self.myfixed['imagedir']),
		master=parent)
        splabel1 = Label(self.nmrframe, image=gif1)
        splabel2 = Label(self.nmrframe, image=gif2)
        splabel1.image = gif1
        splabel2.image = gif2
        splabel1.pack()
        Label(self.nmrframe, text="""
        and by the""").pack()
        splabel2.pack()
# END Pynmr -> introScreen  ----------------------------------------------



# Pynmr -> __init__ --------------------------------------------------------
    def __init__(self):
        
    #   find out where pymol is installed
        pynmrdir = sys.modules['pmg_tk.startup.pynmr'].__path__[0]
        if not os.path.exists(pynmrdir):
            print "*** PYNMR ERROR:  I cannot find the installation directory."
            print "*** internal error.  "
            print "*** please report this error to nmr@rsvs.ulaval.ca, "
            print "*** along with the output from the command: "
            print "  print sys.modules['pymol'].__path__ "
            print "  typed into the PyMOL window. "

        self.myfixed = {
            "helpdir": pynmrdir+"/help/",
            "imagedir": pynmrdir+"/images/"}

        root = Tk()
        root.title("pynmr - PyMOL NMR module")
        root.geometry("+1000+25")
        self.introScreen(root)
        self.NMR_menus(root)
#       added the mainloop to get the mac version to work.
#        root.mainloop()
# END Pynmr -> __init__ --------------------------------------------------------

