#
# nmr_cmd.py
#
# Copyright (C) 2005  Dr. Stephane Gagne
# the full copyright notice is found in the LICENSE file in this directory
#
# This program is free software; 
# you can redistribute it and/or modify it under the terms of the 
# GNU General Public License as published by the Free Software Foundation; 
# either version 2 of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, 
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. 
# See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License 
# along with this program; if not, write to the Free Software Foundation, Inc., 
# 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
#
# Contact:  nmr@rsvs.ulaval.ca
# 
# --------------------------------------------------------------------
# author:  Leigh Willard
# lab:     Stephane Gagne, Laval Universite
# date:    jan 2004
# --------------------------------------------------------------------
#
# COMMANDS:
#
# startpynmr
#      opens up the pynmr gui
#
#
# superimpose(ref, atoms, range, bbdef, pairfit=0, progressflag=0):
#      superimpose, writing rmsds to the screen
#      ex.  superimpose('aria_1', 'C N CA', 'all', 'C N CA', pairfit=0)
#
#
# C_do_best_range(ref, atoms, bbdef, string_of_objects, range, workingdir, stop_rmsd)
#       find the best range to superimpose on.
#       ex. do_best_range('aria_1', 'C N CA', 'C N CA', 'aria_1 aria_2 aria_3', "all", "/home/leigh/Proj/py/data1", 1.0)
#
#
# show_bbonly():
#      turns on backbone-only viewing
#
#
# load_file(list_file)   
#      loads all files which are listed in the given file.
#      ex.  load_file(file.nam) will load all files which are listed in file.nam
#
#
# load_models(bigfile) 
#      load in the file bigfile, which contains multiple structures
#
#
# load_root(rootname, first, last)
#      loads a bunch of pdb files with the same rootname,
#      in the range first-last.
#      ex.  load_root("mypdb", 1, 25)
#
#

import pynmr

from superimp import \
    superimpose,    \
    C_do_best_range

from loadnmr import \
    show_bbonly,    \
    load_file,      \
    load_models,    \
    load_root

def startpynmr():
    """ start up the pynmr gui """
    mynmr = pynmr.Pynmr()
    

