import os.path
import string

# initialize it if not already set
try:
    test = workingdir
except:
    workingdir =  os.path.abspath(".")


#..........................................................................
# an object resprenting a pdb file
class PdbData:

    def __init__(self):
        self.myPDB = dict()

    def readall(self, myverify):
        for pdbfile in myverify.maingui.objs:
            self.myPDB[pdbfile] = self.PdbFile()
            self.myPDB[pdbfile].readLines(pdbfile)

    # data from one PDB file
    class PdbFile:
        def __init__(self):
            self.serial = 0
            self.items = []
            self.hash_res = dict()
            # proton only hash table
            self.hash_resP = dict()

        #............................
        # one line in a pdb file
        class PdbItem:
            def __init__(self):
                self.atom_num = 0
                self.atom = ""
                self.res_num = 0
                self.res = ""
                self.coord = [0,0,0]
                self.serial = 0

        # read one pdb file
        def readLines(self, fname):

            try: pdbfile = open(fname, "r")
            except: 
                print "** ERROR: cannot read pdb file"
                return

            try:
                pdblines = pdbfile.readlines()
            except:
                print "** ERROR: cannot open pdb file", fname
                return

            pdbfile.close()
            self.processLines(pdblines)

        def processLines(self, pdblines):
            for pdbline in pdblines:
                if pdbline[0] == 'A':
                    pdbline = string.split(pdbline)
#                    pdbline = string.split(string.strip(pdbline))
                    line = self.PdbItem()
                    line.atom_num = pdbline[1]
                    line.atom = pdbline[2]
                    line.res = pdbline[3]

                    # check for chain indicator
                    if pdbline[4].isalpha():
                        adjust = 1
                    else: adjust = 0

                    line.res_num = pdbline[4+adjust]

                    line.coord = [float(pdbline[5+adjust]),
                    float(pdbline[6+adjust]), float(pdbline[7+adjust])]
                    line.serial = self.serial
                    self.items.append(line)
                    self.serial += 1

                    # build hash table of residue numbers -> line numbers
                    try:  self.hash_res[line.res_num].append(line.serial)
                    except KeyError:
                        self.hash_res[line.res_num] = [line.serial]

                    # hash containing just protons 
                    if ( (line.atom[0] == 'H') or 
                        ((line.atom[0][0].isdigit()) and (line.atom[1] == 'H')) ) :

                        try:  self.hash_resP[line.res_num].append(line.serial)
                        except KeyError:
                            self.hash_resP[line.res_num] = [line.serial]


        # this function returns indexes of matching pdb lines
        def find_line(self, rst_atom, rst_res, hashtable):

            idxs = list()

            # hashtable is either pdb.hash_res or pdb.hash_resH
            try: mytable = hashtable[rst_res]
            except:  return idxs

            for line in mytable:

                # exact match.  good enough.
                if (self.items[line].atom == rst_atom):
#                    idxs.append(self.items[line].coord)
                    idxs.append(line)
                    return idxs

                # check for * in restraint file
                if (rst_atom[-1] == '*'):
                    if self.items[line].atom.count(rst_atom[:-1]):
                        idxs.append(line)

            return idxs



pdb = PdbData()
