id = "54990ee22a0e95937ec218f008f20ba3b9fdbda8"
date = "2015-06-01 17:09:52 +0000"
branch = "master"
tag = "pylal-0.7.2-v1"
if tag == "None":
    tag = None
author = "Kipp Cannon <kipp.cannon@ligo.org>"
builder = "Kipp Cannon <kipp.cannon@ligo.org>"
committer = "Kipp Cannon <kipp.cannon@ligo.org>"
status = "CLEAN: All modifications committed"
version = id
verbose_msg = """Branch: master
Tag: pylal-0.7.2-v1
Id: 54990ee22a0e95937ec218f008f20ba3b9fdbda8

Builder: Kipp Cannon <kipp.cannon@ligo.org>
Build date: 2015-06-01 17:10:24 +0000
Repository status: CLEAN: All modifications committed"""

import warnings

class VersionMismatchError(ValueError):
    pass

def check_match(foreign_id, onmismatch="raise"):
    """
    If foreign_id != id, perform an action specified by the onmismatch
    kwarg. This can be useful for validating input files.

    onmismatch actions:
      "raise": raise a VersionMismatchError, stating both versions involved
      "warn": emit a warning, stating both versions involved
    """
    if onmismatch not in ("raise", "warn"):
        raise ValueError, onmismatch + " is an unrecognized value of onmismatch"
    if foreign_id == "54990ee22a0e95937ec218f008f20ba3b9fdbda8":
        return
    msg = "Program id (54990ee22a0e95937ec218f008f20ba3b9fdbda8) does not match given id (%s)." % foreign_id
    if onmismatch == "raise":
        raise VersionMismatchError, msg

    # in the backtrace, show calling code
    warnings.warn(msg, UserWarning)

