from functools import wraps
from copy import deepcopy, copy
import sql
import threading

def cached_property(func):
    '''
    This decorator can be used to have a certain property lookup cached.
    
    The method it decorates will be called once, after that the value will be
    taken from the cache.
    '''
    #We need to use wraps to have correct information about the function (it's name)
    @wraps(func)
    def _closure(self):
        if not "cache" in self.__dict__: self.cache = {}
        key = func.__name__
        if not key in self.cache: self.cache[key] = func(self)
        return self.cache[key]
    return property(_closure)

query_cache = {}
def cached_query(*args):
    
    #Change stuff
    if sql.getDbType() == "mysql":
        query = args[0].replace("?", "%s")
        argsL = []
        for arg in args: argsL.append(str(arg))
        args = argsL
    else:
        query = args[0]
        args = args[1:]
    
    key = tuple(query) + tuple(args)
    if not key in query_cache:
        c = sql.getConnection().cursor()
        c.execute(query, *args)
        results = []
        for row in c:
            results.append(row)
        query_cache[key] = results
    return query_cache[key]
