#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
try:
    import pygtk
    pygtk.require("2.0")
except ImportError:
    pass
import gtk
from gtk import glade
import os.path
import launch

class window(gtk.glade.XML, object):
    def __init__(self, gladeFile, signalsDict = None, gladeBaseDir = os.path.join(launch.basePath, "gui")):
        self.signalsDict = signalsDict
        #Set and load the glade file
        self.gladeFile = os.path.join(gladeBaseDir, gladeFile + ".glade")
        glade.XML.__init__(self, self.gladeFile)
        if self.signalsDict != None:
            self.signal_autoconnect(self.signalsDict)
        self.widgets = {}
        
    def __getattr__(self, attr):
        try:
            widget = self.widgets[attr]
            return widget
        except KeyError:
            widget = self.get_widget(attr)
            if widget != None:
                self.widgets[attr] = widget
                return widget
            else:
                raise AttributeError(attr)
    
    def main(self):
        gtk.gdk.threads_enter()
        gtk.main()
        gtk.gdk.threads_leave()
        
    def setTooltips(self, **tips):
        for widget, text in tips.iteritems():
            getattr(self, widget).set_tooltip_text(text)
