#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
import gtk
from gui import pixbufLoader
from gui.shipBrowserWindow import shipBrowserWindow
from gui.inputWindow import inputWindow
from model import item, fitting
from copy import deepcopy
from gui.errorWindow import errorWindow
import fittingPane

dependencies = (fittingPane,)

def init(self):
    #CmbSetup widget
    #Pixbuf, name, fit
    store = gtk.TreeStore(gtk.gdk.Pixbuf, str, object, object, str, str)
    self.cmbSetup.set_model(store)
    self.cmbSetup.connect("notify::popup-shown", self.setupPopup)
    self.cmbSetup.connect("changed", self.setupChanged)
    self.btnRenameSetup.connect("clicked", self.renameSetup)
    self.btnCopySetup.connect("clicked", self.copySetup)
    self.btnRemoveSetup.connect("clicked", self.removeSetup)
    self.btnNewSetup.connect("clicked", self.newSetup)
    self.connect("fitting-changed", self.handleFittingChangedSetup)
    self.setupBoxShown = False
    self.oldSelection = None
    nameRenderer = gtk.CellRendererText()
    pixbufRenderer = gtk.CellRendererPixbuf()
    shipRenderer = gtk.CellRendererText()
#        shipRenderer.set_fixed_size(150, -1)
#        shipRenderer.set_property('xalign', 1.0)
    groupRenderer = gtk.CellRendererText()
#        groupRenderer.set_fixed_size(150, -1)
#        groupRenderer.set_property('xalign', 1.0)

    self.cmbSetup.pack_start(pixbufRenderer, False)
    self.cmbSetup.pack_start(groupRenderer, False)
    self.cmbSetup.pack_start(shipRenderer, False)
    self.cmbSetup.pack_start(nameRenderer, True)

    self.cmbSetup.add_attribute(pixbufRenderer, 'pixbuf', 0)
    self.cmbSetup.add_attribute(nameRenderer, 'text', 1)
    self.cmbSetup.add_attribute(shipRenderer, 'text', 4)
    self.cmbSetup.add_attribute(groupRenderer, 'text', 5)

    store.set_sort_column_id(1, gtk.SORT_ASCENDING)
    groupPixbuf = pixbufLoader.getPixbuf("ships")
    for group, ships in self.fits.iteritems():
        groupIter = store.append(None, (groupPixbuf, group.name, group, None, None, None))
        for ship, fits in ships.iteritems():
            if ship:
                shipPixbuf = pixbufLoader.getPixbuf(ship.race)
                shipIter = store.append(groupIter, (shipPixbuf, ship.name, ship, None, None, None))
                for fitName, fit in fits.iteritems():
                    store.append(shipIter, (None, fitName, fit, None, None, None))
                
    #Set tooltips
    self.setTooltips(**{"btnNewSetup" : "New",
                      "btnRenameSetup" : "Rename",
                      "btnCopySetup" : "Duplicate",
                      "btnRemoveSetup" : "Remove",
                      "btnImportSetup" : "Import",
                      "btnExportSetup" : "Export"})
    
    #Call our handler to disable the buttons
    self.handleFittingChangedSetup()

def handleFittingChangedSetup(self, *stuff):
    fit = self.getActiveFit()
    if fit == None:
        self.btnRenameSetup.set_sensitive(False)
        self.btnRemoveSetup.set_sensitive(False)
        self.btnCopySetup.set_sensitive(False)
        self.btnExportSetup.set_sensitive(False)
    else:
        self.btnRenameSetup.set_sensitive(True)
        self.btnRemoveSetup.set_sensitive(True)
        self.btnCopySetup.set_sensitive(True)
        self.btnExportSetup.set_sensitive(True)
        
def setupChanged(self, *stuff):
    store = self.cmbSetup.get_model()
    if store == None: return
    iter = self.cmbSetup.get_active_iter()
    if iter == None: return
    fit = store.get_value(iter, 2)
    if fit == None or not isinstance(fit, fitting.fitting):
        if self.oldSelection:
            self.cmbSetup.set_active_iter(self.oldSelection)
        else:
            self.cmbSetup.set_active(-1)
        return
    if self.oldSelection: self.setupDeprettify(self.oldSelection)
    self.oldSelection = iter
    self.setupPrettify(iter)
    self.setupBoxShown = False
    #Clear selection
    self.tvwModules.get_selection().unselect_all()
    self.emit("fitting-changed")

def setupPrettify(self, iter):
    store = self.cmbSetup.get_model()
    fit = store.get_value(iter, 2)
    pixbuf = pixbufLoader.getPixbuf(fit.ship.race)
    store.set(iter, 0, pixbuf, 4, " -  " + fit.ship.name + "  - ", 5, fit.ship.group.name)
    self.cmbSetup.set_size_request(-1, -1)
    
def setupDeprettify(self, iter):
    store = self.cmbSetup.get_model()
    ##Make sure to keep the same width when deprettifying
    rect = self.cmbSetup.get_allocation()
    self.cmbSetup.set_size_request(rect.width, -1)
    store.set(iter, 0, None, 4, None, 5, None)
    
def setupPopup(self, *stuff):
    store = self.cmbSetup.get_model()        
    if store == None: return
    iter = self.cmbSetup.get_active_iter()
    if iter == None:
        if self.oldSelection: self.cmbSetup.set_active_iter(self.oldSelection)
        return
    self.oldSelection = iter
    fit = store.get_value(iter, 2)
    if fit == None: return
    #Unprettify the active setup
    if self.setupBoxShown == False:
        self.setupDeprettify(iter)
        self.setupBoxShown = True
    else:
        self.setupPrettify(iter)
        self.setupBoxShown = False
    return False
    
def getShipTypeIter(self, group, type):
    store = self.cmbSetup.get_model()
    iter = store.get_iter_root()
    while iter != None:
        grp = store.get_value(iter, 2)
        if grp == group:
            typeIter = store.iter_children(iter)
            while typeIter != None:
                currType = store.get_value(typeIter, 2)
                if currType == type:
                    return "type", typeIter
                typeIter = store.iter_next(typeIter)
                
            return "group", iter
            
        iter = store.iter_next(iter)
    return None, None

def newSetup(self, source):
    shipBrowser = shipBrowserWindow(self)

#Gets called by the ship browser window when it's done
def newShip(self, name, ship):
    ship = item.getItem(ID = ship.ID)
    fit = fitting.fitting(ship)
    self.newFit(name, fit)
    
def newFit(self, name, fit, background = False):
    #Deprettify old fit first
    store = self.cmbSetup.get_model()
    iter = self.cmbSetup.get_active_iter()
    if iter != None: self.setupDeprettify(iter)
    ship = fit.ship
    iterType, rootIter = self.getShipTypeIter(ship.group, ship)
    if rootIter == None:
        self.fits[ship.group] = {}
        img = pixbufLoader.getPixbuf("ships")
        iterType = "group"
        rootIter = store.append(None, (img, ship.group.name, ship.group, None, None, None))
    if iterType == "group":
        self.fits[ship.group][ship] = {}
        img = pixbufLoader.getPixbuf(fit.ship.race)
        rootIter = store.append(rootIter, (img, fit.ship.name, fit.ship, None, None, None))

    self.fits[ship.group][ship][name] = fit
    iter = store.append(rootIter, (None, name, fit, None, None, None))
    if not background:
        self.cmbSetup.set_active_iter(iter)
    
def renameSetup(self, source):
    if self.getActiveFit() != None:
        renameSetup = inputWindow(self, "New name: ", self.rename)
        iter = self.cmbSetup.get_active_iter()
        store = self.cmbSetup.get_model()
        renameSetup.entryInput.set_text("".join(store.get(iter, 1)))
        renameSetup.entryInput.select_region(0,-1)
        
def rename(self, newSetupName):
    fit = self.getActiveFit()
    if newSetupName == None or newSetupName == "" : return False
    iter = self.cmbSetup.get_active_iter()
    store = self.cmbSetup.get_model()
    oldName, fit = store.get(iter, 1, 2)
    if oldName == newSetupName: return True
    if newSetupName in self.fits[fit.ship.group][fit.ship]:
        errorWindow(self, "A setup with this name already exists.")
        return False
    del self.fits[fit.ship.group][fit.ship][oldName]
    self.fits[fit.ship.group][fit.ship][newSetupName] = fit
    store.set(iter, 1, newSetupName)
    return True

def copySetup(self, source):
    if self.getActiveFit() != None:
        renameSetup = inputWindow(self, "Name: ", self.copy)

def copy(self, newSetupName):
    fit = self.getActiveFit()
    if newSetupName == None or newSetupName == "" :
        return False
    
    if newSetupName in self.fits[fit.ship.group][fit.ship]:
        errorWindow(self, "A setup with this name already exists.")
        return False
    
    fit = deepcopy(fit)
    self.fits[fit.ship.group][fit.ship][newSetupName] = fit
    iter = self.cmbSetup.get_active_iter()
    self.setupDeprettify(iter)
    type, iter = self.getShipTypeIter(fit.ship.group, fit.ship)
    iter = self.cmbSetup.get_model().append(iter, (None, newSetupName, fit, None, None, None))
    self.cmbSetup.set_active_iter(iter)
    return True

def removeSetup(self, source):
    store = self.cmbSetup.get_model()
    iter = self.cmbSetup.get_active_iter()
    if iter == None: return
    name, fit = store.get(iter, 1, 2)
    if fit == None: return
    next = store.iter_next(iter)
    path = store.get_path(iter)
    parent = store.iter_parent(iter)
    self.oldSelection = None
    store.remove(iter)
    del self.fits[fit.ship.group][fit.ship][name]
    ##See if we can select any other fits of the same ship
    if next:
        self.cmbSetup.set_active_iter(next)
    else:
        if path[-1] != 0:
            newPath = path[0:-1] + (path[-1] -1,)
            iter = store.get_iter(newPath)
            self.cmbSetup.set_active_iter(iter)
        else:
            #There's no more fits for this ship, let's delete it
            del self.fits[fit.ship.group][fit.ship]
            newParent = store.iter_parent(parent)
            store.remove(parent)
            if len(self.fits[fit.ship.group]) == 0:
                #Also delete the group, as it has no more ships
                del self.fits[fit.ship.group]
                store.remove(newParent)
    
    self.emit("fitting-changed")
