#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
import gtk
from model import item, fitting, character
from gui import pixbufLoader
from gui.itemStatsWindow import itemStatsWindow

def init(self):
    self.connect("fitting-changed", self.handleFittingChangedGang)
    self.tvwGang.connect("button-press-event", self.tvwGangClicked)
        
    #Active, icon, fitName, charName, fit, char, position
    store = gtk.ListStore(bool, gtk.gdk.Pixbuf, str, str, object, int)
    store.set_sort_column_id(5, gtk.SORT_ASCENDING)
    self.tvwGang.set_model(store)
    
    activeRenderer = gtk.CellRendererToggle()
    iconRenderer = gtk.CellRendererPixbuf()
    nameRenderer = gtk.CellRendererText()
    characterRenderer = gtk.CellRendererText()
    
    self.gangStateCol = gtk.TreeViewColumn()
    colItem = gtk.TreeViewColumn("Item")
    colChar = gtk.TreeViewColumn("Character")
    
    self.gangStateCol.pack_start(activeRenderer, False)
    colItem.pack_start(iconRenderer, False)
    colItem.pack_start(nameRenderer, True)
    colChar.pack_start(characterRenderer, False)
    
    self.gangStateCol.add_attribute(activeRenderer, 'active', 0)
    colItem.add_attribute(iconRenderer, 'pixbuf', 1)
    colItem.add_attribute(nameRenderer, 'text', 2)
    colChar.add_attribute(characterRenderer, 'text', 3)
    activeRenderer.set_property("activatable", True)
    
    self.tvwGang.append_column(self.gangStateCol)
    self.tvwGang.append_column(colItem)
    self.tvwGang.append_column(colChar)
    
    #Generate menus we need
    self.gangMenu = self.generateMenu({})
    shipPixbuf = pixbufLoader.getPixbuf("ships")
    self.gangAddFitLabel = gtk.Label("Add Setup")
    box = self.generateHBox(gtk.image_new_from_pixbuf(shipPixbuf),
                            self.gangAddFitLabel)
    self.gangAddFitEntry = self.generateMenuItem(box, None)
    self.gangCharacterSelectLabel = gtk.Label("Change Character")
    self.gangCharacterSelectEntry = self.generateMenuItem(self.gangCharacterSelectLabel, None)
    self.gangStatsLabel = gtk.Label("Ship Stats")
    self.gangStatsEntry = self.generateMenuItem(self.gangStatsLabel, self.gangItemStats)
    self.gangMenu.append(self.gangAddFitEntry)

def handleFittingChangedGang(self, *stuff):
    fit = self.getActiveFit()
    if fit == None: self.tvwGang.get_model().clear()
    else: self.updateGangBrowser()

def getSelectedGangItem(self):
    store, selected_rows = self.tvwGang.get_selection().get_selected_rows()
    if not selected_rows: return
    iter = store.get_iter(selected_rows[0])
    gangItem =  store.get_value(iter, 4).ship
    return gangItem

def gangItemStats(self, *stuff):
    itemStatsWindow(self.getSelectedGangItem(), self.getActiveFit(), None)

def updateGangBrowser(self):
    fit = self.getActiveFit()
    if fit == None: return
    store, selected_rows = self.tvwGang.get_selection().get_selected_rows()
    #If store is not set we got called early, let's gtfo
    if store == None: return
    store.clear()
    ship = pixbufLoader.getPixbuf("ships")
    for i in range(len(fit.gang)):
        stuff, char, enabled = fit.gang[i]
        for name, otherFit in self.fits[stuff.ship.group][stuff.ship].iteritems():
            if otherFit == stuff: fitName = name
        store.append((enabled, ship, "%s - %s" % (stuff.ship.name, fitName), char.name, stuff, i))
    
    #We're done, set the selection back to where it was
    if selected_rows: self.tvwGang.get_selection().select_path(selected_rows[0])

def tvwGangClicked(self, widget, event):
    fit = self.getActiveFit()
    if fit == None: return
    widget.do_button_press_event(widget, event)
    stuff = widget.get_path_at_pos(int(event.x), int(event.y))
    #when double/triple-click events arrive, browser is still refilling so
    #in order to not deselect items (stuff will be none during refilling)
    #we add button press check. Prevents deselecting stuff
    #on double-clicking enable/disable gang setup tick
    if stuff == None and event.type == gtk.gdk.BUTTON_PRESS:
        widget.get_selection().unselect_all()
    store, selected_rows = widget.get_selection().get_selected_rows()
    if event.button == 1:
        col = widget.get_path_at_pos(int(event.x), int(event.y))
        if col: col = col[1]
        else: return
        if event.type == gtk.gdk.BUTTON_PRESS:
            if col == self.gangStateCol:
                if selected_rows:
                    i = store.get_value(store.get_iter(selected_rows[0]), 5)
                    gangEntry = fit.gang[i]
                    fit.gang[i] = (gangEntry[0], gangEntry[1], not gangEntry[2])
                    self.emit("fitting-changed")
        elif event.type == gtk.gdk._2BUTTON_PRESS and col != self.gangStateCol:
            if selected_rows:
                i = store.get_value(store.get_iter(selected_rows[0]), 5)
                del fit.gang[i]
                self.emit("fitting-changed")
    elif event.button == 3:
            for it in self.gangMenu: self.gangMenu.remove(it)

            if selected_rows:
                i = store.get_value(store.get_iter(selected_rows[0]), 5)
                gangItemCatName = self.getItemCategoryName(fit.gang[i][0].ship) or "Ship"

                self.gangMenu.append(self.gangCharacterSelectEntry)
                menu = self.generateCharacterMenu(self.gangFitSwitchChar)
                self.gangCharacterSelectEntry.set_submenu(menu)
                self.gangStatsLabel.set_text(gangItemCatName + " Stats")
                self.gangMenu.append(self.gangStatsEntry)
                self.gangMenu.append(gtk.SeparatorMenuItem())
            self.gangMenu.append(self.gangAddFitEntry)
            menu = self.generateFitMenu(self.addGangFit)
            self.gangAddFitEntry.set_submenu(menu)

            self.gangMenu.show_all()
            self.gangMenu.popup(None, None, None, event.button, event.time)

def addGangFit(self, widget, fit):
    activeFit = self.getActiveFit()
    if activeFit == None: return
    activeFit.gang.append((fit, self.characters["All 5"], None))
    self.emit("fitting-changed")
    
def gangFitSwitchChar(self, widget, char):
    fit = self.getActiveFit()
    store, selected_rows = self.tvwGang.get_selection().get_selected_rows()
    if not selected_rows: return
    i = store.get_value(store.get_iter(selected_rows[0]), 5)
    gangEntry = fit.gang[i]
    fit.gang[i] = (gangEntry[0], char, gangEntry[2])
    self.emit("fitting-changed")
