#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
from gui.window import window
from gui.pluggable import pluggable
class inputWindow(window):
    def __init__(self, master, msg, callback):
        self.master = master
        self.callback = callback
        signalsDict = {'exitRequest' : self.exit,
                       'confirm' : self.confirm,
                       'delete' : self.exit}
        window.__init__(self, "inputWindow", signalsDict)
        self.initPluggable()
        self.lblInputHeader.set_text(msg)
        self.initAllSections()
        self.window.show()
        
    def exit(self, *stuff):
        self.window.destroy()
        return False
        
    def confirm(self, widget):
        input = self.entryInput.get_text()
        if input != None and input != "":
            if self.callback(self.entryInput.get_text()):
                self.window.destroy()
            
inputWindow = pluggable(inputWindow)