#Copyright 2009 Diego Duclos
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
from gui.window import window
from gui.pluggable import pluggable
class errorWindow(window):
    def __init__(self, master, msg):
        self.master = master
        signalsDict = {'exitRequest' : self.exit,
                       'delete' : self.exit}
        window.__init__(self, "errorWindow", signalsDict)
        self.initPluggable()
        self.lblError.set_text(msg)
        self.initAllSections()
        self.window.show()
        
    def exit(self, *stuff):
        self.window.destroy()
        return False

errorWindow = pluggable(errorWindow)