# (C) Copyright 2017, 2020 by Rocky Bernstein
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""
CPython 2.6 bytecode opcodes

This is a like Python 2.6's opcode.py with some classification
of stack usage.
"""

from xdis.opcodes.base import (
    store_op,
    finalize_opcodes,
    format_extended_arg,
    init_opdata,
    update_pj2,
)
import xdis.opcodes.opcode_25 as opcode_25

version = 2.6

l = locals()
init_opdata(l, opcode_25, version)

# Below are opcode changes since Python 2.5
store_op(l, "STORE_MAP", 54, 3, 1)

# FIXME remove (fix uncompyle6)
update_pj2(globals(), l)

opcode_arg_fmt = {
    "EXTENDED_ARG": format_extended_arg,
}

finalize_opcodes(l)
