"""
This is a set of tests that take a while to run.  They are separated out
into a separate file so that they can easily be skipped.
"""

import os

from vo.table import parse
from vo import table

ROOT_DIR = os.path.dirname(table.__file__)

def test_slow_python_parser():
    votable = parse(os.path.join(ROOT_DIR, "tests", "regression.xml"),
                    pedantic=False,
                    _debug_python_based_parser=True)
    votable = parse("wfpc2_all.xml.gz", pedantic=False,
                    _debug_python_based_parser=True)


def test_large_gzipped_file():
    table = parse("wfpc2_all.xml.gz", pedantic=False)

if __name__ == '__main__':
    test_large_gzipped_file()
