"""
A set of basic benchmarks over a really large file.
"""

import sys
try:
    from cStringIO import StringIO
except ImportError:
    from io import StringIO
import gzip
import os
import time
import warnings

from vo.table import parse
from vo import table

ROOT_DIR = os.path.dirname(table.__file__)

TIMES = 1

def test_slow_python_parser():
    votable = parse("wfpc2_all.xml", pedantic=False,
                    _debug_python_based_parser=True)


def test_fast_parser():
    global glob_table
    glob_table = parse("wfpc2_all.xml", pedantic=False)

def test_write_out():
    glob_table.to_xml("output.xml")

def test_write_out_memory():
    glob_table.to_xml(StringIO())

def test_write_out_slow():
    glob_table.to_xml("output.xml", _debug_python_based_parser=True)

def test_baseline_xml_parser():
    from vo.xmlutil import fast_iterparse
    fd = open("wfpc2_all.xml", "r")
    for start, data, tag, pos in fast_iterparse(fd):
        pass
    fd.close()

def test_baseline_python_xml_parser():
    from vo.xmlutil import slow_iterparse
    fd = open("wfpc2_all.xml", "r")
    for start, data, tag, pos in slow_iterparse(fd):
        pass
    fd.close()

def test_fast_not_pedantic():
    table = parse("wfpc2_all_pedantic.xml", pedantic=False)

def test_fast_pedantic():
    table = parse("wfpc2_all_pedantic.xml", pedantic=True)

if __name__ == '__main__':
    warnings.simplefilter('ignore')

    if not os.path.exists("wfpc2_all.xml"):
        sys.stdout.write("Decompressing data...\n")
        sys.stdout.flush()
        os.system("gunzip wfpc2_all.xml.gz")

    if not os.path.exists("wfpc2_all_pedantic.xml"):
        sys.stdout.write("Rewriting pedantically perfect version...\n")
        sys.stdout.flush()
        table = parse("wfpc2_all.xml", pedantic=False)
        table.to_xml("wfpc2_all_pedantic.xml")

    for func in (
        test_fast_parser,
        test_write_out,
        test_write_out_memory,
        test_write_out_slow,
        test_baseline_xml_parser,
        test_slow_python_parser,
        test_baseline_python_xml_parser,
        test_fast_not_pedantic,
        test_fast_pedantic,
        ):
        sys.stdout.write("%s...\r" % func.__name__)
        sys.stdout.flush()
        t = time.time()
        for i in range(TIMES):
            func()
        t = (time.time() - t) / float(TIMES)
        sys.stdout.write("%s [%.03f s]\n" % (func.__name__, t))


