#!/usr/bin/env python

CONTACT = "Michael Droettboom"
EMAIL = "support@stsci.edu"
VERSION = "0.8"

from distutils.core import setup, Extension
import sys

defines = [("HAVE_EXPAT_CONFIG_H", 1)]
if sys.byteorder == 'big':
    defines.append(('BYTEORDER', '4321'))
else:
    defines.append(('BYTEORDER', '1234'))
if sys.platform != 'win32':
    defines.append(('HAVE_UNISTD_H', None))

iterparse_ext = Extension(
    "vo.iterparser",
    ["src/iterparse.c",
     "src/expat/xmlparse.c",
     "src/expat/xmlrole.c",
     "src/expat/xmltok.c",
     "src/expat/xmltok_impl.c"
     ],
    define_macros=defines,
    include_dirs=["src", "src/expat"])

pkg = ['vo', 'vo.tests', 'vo.validator']

setupargs = {
      'version'      : VERSION,
      'description'  : "Python based tools to parse/write VOTABLE files",
      'author'       : CONTACT,
      'author_email' : EMAIL,
      'url'          : "http://astropy.scipy.org/astropy/astrolib/",
      'platforms'    : ["unix", "windows"],
      'data_files'   : [
        ("vo/data", ["lib/data/ucd1p-words.txt", 'lib/data/*.xsd', 'lib/data/*.dtd']),
        ("vo/tests", ["lib/tests/*.xml", "lib/tests/*.gz"] ),
        ("vo/tests/data", [
                "lib/tests/data/*.json",
                "lib/tests/data/*.fits",
                "lib/tests/data/*.xml"])
        ],
      'ext_modules'  : [iterparse_ext]
      }
