! -*-f90-*-
!
! :Author: Pauli Virtanen <pauli@ltl.tkk.fi>
! :Organization: Low Temperatory Laboratory, Helsinki University of Technology
! :Date: 2005-2006
!

!
! XXX: this is work-in-progress, and currently unfinished code.
!

MODULE SP_SOLVE3
  USE PARAMS
  USE SP_EQUATIONS
  use lazy_alloc
  
  PUBLIC SOLVE, INIT_SOLVER, GET_VARS

  PRIVATE

  INTEGER :: NRWTOP, NRWBOT, NOVRLP
  INTEGER :: NRWBLK, NCLBLK, NBLOKS
  INTEGER :: N, NX

  double precision, DIMENSION(:,:), POINTER :: TOPBLK, BOTBLK
  double precision, DIMENSION(:,:,:), POINTER :: ARRAY

  INTEGER, DIMENSION(:), POINTER :: PIVOT

  double precision, DIMENSION(:), POINTER :: Z1, Z2, Z3
  double precision, DIMENSION(:), POINTER :: XX

CONTAINS

  SUBROUTINE INIT_SOLVER(NREC)
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: NREC

    NX = WIRE_coefs(1)%N
    !NX = 2

    NRWTOP = MSTAR - NREC
    NRWBOT = NREC

    NOVRLP = MSTAR

    NRWBLK = MSTAR
    NCLBLK = 2*MSTAR

    NBLOKS = NX - 1

    N = NBLOKS * NRWBLK + NOVRLP

    call lazy_alloc_r3(ARRAY, NRWBLK, NCLBLK, NBLOKS)
    call lazy_alloc_r2(TOPBLK, NRWTOP, NOVRLP)
    call lazy_alloc_r2(BOTBLK, NRWBOT, NOVRLP)
    call lazy_alloc_i1(PIVOT, N)
    call lazy_alloc_r1(Z1, N)
    call lazy_alloc_r1(Z2, N)
    call lazy_alloc_r1(Z3, N)
    call lazy_alloc_r1(XX, NX)

    XX = WIRE_coefs(1)%X

    ! Boundary condition positions
    call lazy_alloc_r1(ZETA, MSTAR)
    ZETA = 1d0
    ZETA(1:(MSTAR - NREC)) = 0d0
  END SUBROUTINE INIT_SOLVER

  SUBROUTINE SOLVE(CONVERGED)
    implicit none

    Z1 = 
    
  END SUBROUTINE SOLVE

  SUBROUTINE NEWTON_STEP(Z0, DZ, CONVERGED)
    USE TWPBVPC_MOD
    IMPLICIT NONE
    double precision, dimension(N), intent(in) :: Z0
    double precision, dimension(N), intent(out) :: DZ
    LOGICAL, INTENT(OUT) :: CONVERGED

    INTEGER :: K, M, IFLAG, JOB
    double precision :: h, x

    double precision, DIMENSION(MSTAR) :: Z
    double precision, DIMENSION(NCOMP) :: F

    !!! Construct the Jacobian in the COLROW form
    DZ = 0
    ARRAY = 0
    Z = 0

    ! left bc
    Z = Z0(1:MSTAR)
    DO K = 1, NRWTOP
       CALL GSUB(K, Z, DZ(K))
       CALL DGSUB(K, Z, TOPBLK(K, :))
    END DO
    DZ(1:NRWTOP) = -DZ(1:NRWTOP)

    ! right bc
    Z = Z0(N-MSTAR+1:N)
    DO K = 1, NRWBOT
       CALL GSUB(NRWTOP + K, Z, DZ(N - NRWBOT + K))
       CALL DGSUB(NRWTOP + K, Z, BOTBLK(K, :))
    END DO
    DZ((N-NRWBOT):N) = -DZ((N-NRWBOT):N)

    ! equations
    DO K = 1, NBLOKS
       x = .5*(XX(K+1) + XX(K))
       h = XX(K+1) - XX(K)

       Z = .5*(Z0(K*MSTAR+1:(K+1)*MSTAR) + Z0((K-1)*MSTAR+1:(K-1+1)*MSTAR))

       CALL DFSUB(x, Z, ARRAY(1:NCOMP, 1:MSTAR, K))
       CALL FSUB(x, Z, F)

       ARRAY(1:NCOMP, 1:MSTAR, K) = .5*h*ARRAY(1:NCOMP, 1:MSTAR, K)
       ARRAY(1:NCOMP, (MSTAR+1):(2*MSTAR), K) = ARRAY(1:NCOMP, 1:MSTAR, K)

       DO M = 1, NCOMP
          ! Second derivative
          ARRAY(M, 2*(M-1) + 2, K) = ARRAY(M, 2*(M-1) + 2, K) + 1
          ARRAY(M, 2*(M-1) + 2 + MSTAR, K) = ARRAY(M, 2*(M-1) + 2 + MSTAR, K) - 1

          ! Rhs for second derivative
          DZ(NRWTOP + (K-1)*MSTAR + 2*(M-1) + 2) = -F(M)*h
          
          ! First derivative
          ARRAY(M+NCOMP, 2*(M-1) + 1, K)         =  1
          ARRAY(M+NCOMP, 2*(M-1) + 1 + MSTAR, K) = -1

          ARRAY(M+NCOMP, 2*(M-1) + 2, K)         = .5*h
          ARRAY(M+NCOMP, 2*(M-1) + 2 + MSTAR, K) = .5*h
       END DO
    END DO

    ! Solve the equations
    JOB = 0
    CALL COLROW (N,TOPBLK,NRWTOP,NOVRLP,ARRAY,NRWBLK,NCLBLK, &
         NBLOKS,BOTBLK,NRWBOT,PIVOT,DZ,IFLAG,JOB)
    
    IF (IFLAG .NE. 0) THEN
       WRITE(0,*) '%% Failed to solve: ', IFLAG
       CONVERGED = .FALSE.
    ELSE
       CONVERGED = .TRUE.
    END IF
  END SUBROUTINE NEWTON_STEP

  SUBROUTINE DUMPMAT(M, N, A)
    IMPLICIT NONE
    INTEGER, INTENT(IN) :: M, N
    double precision, INTENT(IN), DIMENSION(*) :: A
    INTEGER :: I, J
    WRITE(*,*) '|---'
    DO I = 1, M
       DO J = 1, N
          WRITE(*,'(1X,G7.1,1X)',ADVANCE='NO') A(I + M*(J-1))
       END DO
       WRITE(*,'(1X)')
    END DO
  END SUBROUTINE DUMPMAT

  SUBROUTINE get_vars(X, a, da, b, db)
    USE INTERPOLATE
    IMPLICIT NONE
    double precision, DIMENSION(:), INTENT(in) :: X
    double complex, DIMENSION(:,:), INTENT(out) :: a, da, b, db
    INTEGER :: ix, wire
    TYPE(Interpolation), SAVE :: u_interp
    
    double precision, DIMENSION(MSTAR) :: z
    
    CALL interpolation_new(u_interp, MSTAR, NX, XX, &
         RESHAPE(B, (/ MSTAR, NX /)))

    DO ix = 1, SIZE(X)
       z = interpolation_get(u_interp, X(ix))
       DO wire = 1, nwire
          CALL get_vars_from_Z(X(ix), z, wire, &
                               a(ix,wire), da(ix,wire), &
                               b(ix,wire), db(ix,wire))
       END DO
    END DO
  END SUBROUTINE get_vars
END MODULE SP_SOLVE3
