#!/usr/bin/env python

# Copyright (c) Twisted Matrix Laboratories.
# See LICENSE for details.


from twisted.spread import pb
from twisted.internet import reactor


class MyError(pb.Error):
    """This is an Expected Exception. Something bad happened."""

    pass


class MyError2(Exception):
    """This is an Unexpected Exception. Something really bad happened."""

    pass


class One(pb.Root):
    def remote_broken(self):
        msg = "fall down go boom"
        print("raising a MyError exception with data '%s'" % msg)
        raise MyError(msg)

    def remote_broken2(self):
        msg = "hadda owie"
        print("raising a MyError2 exception with data '%s'" % msg)
        raise MyError2(msg)


def main():
    reactor.listenTCP(8800, pb.PBServerFactory(One()))
    reactor.run()


if __name__ == "__main__":
    main()
