# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.voice.v1.voice_permission import VoicePermissionList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of Voice

        :returns: V1 version of Voice
        :rtype: twilio.rest.voice.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._voice_permissions = None

    @property
    def voice_permissions(self):
        """
        :rtype: twilio.rest.voice.v1.voice_permission.VoicePermissionList
        """
        if self._voice_permissions is None:
            self._voice_permissions = VoicePermissionList(self)
        return self._voice_permissions

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Voice.V1>'
