# coding=utf-8
"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.domain import Domain
from twilio.rest.wireless.v1 import V1


class Wireless(Domain):

    def __init__(self, twilio):
        """
        Initialize the Wireless Domain

        :returns: Domain for Wireless
        :rtype: twilio.rest.wireless.Wireless
        """
        super(Wireless, self).__init__(twilio)

        self.base_url = 'https://wireless.twilio.com'

        # Versions
        self._v1 = None

    @property
    def v1(self):
        """
        :returns: Version v1 of wireless
        :rtype: twilio.rest.wireless.v1.V1
        """
        if self._v1 is None:
            self._v1 = V1(self)
        return self._v1

    @property
    def commands(self):
        """
        :rtype: twilio.rest.wireless.v1.command.CommandList
        """
        return self.v1.commands

    @property
    def rate_plans(self):
        """
        :rtype: twilio.rest.wireless.v1.rate_plan.RatePlanList
        """
        return self.v1.rate_plans

    @property
    def sims(self):
        """
        :rtype: twilio.rest.wireless.v1.sim.SimList
        """
        return self.v1.sims

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Wireless>'
