"""	TimeFormat Test cases for strftime
	--------------------------------------------------------------------
	Copyright (c) 2004 Colin Stewart (http://www.owlfish.com/)
	All rights reserved.
	
	Redistribution and use in source and binary forms, with or without
	modification, are permitted provided that the following conditions
	are met:
	1. Redistributions of source code must retain the above copyright
	   notice, this list of conditions and the following disclaimer.
	2. Redistributions in binary form must reproduce the above copyright
	   notice, this list of conditions and the following disclaimer in the
	   documentation and/or other materials provided with the distribution.
	3. The name of the author may not be used to endorse or promote products
	   derived from this software without specific prior written permission.
	
	THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
	IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
	OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
	IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
	INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
	NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
	DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
	THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
	(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
	THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
"""

import unittest, time
import timeformat


class strftimeTests (unittest.TestCase):
	def setUp (self):
		pass
		
	def tearDown (self):
		pass
		
	def testSupportedStrftime (self):
		# Use a time and date early in the month, year, and day
		atime = (2004, 5, 9, 9, 52, 46, 6, 130, 1)
		
		supportedFormats = []
		supportedFormats.extend (timeformat.STRFMAP.keys())
		# %z is broken in time.strftime(), so remove this from the test list.
		supportedFormats.remove ('%z')
		
		for frmt in supportedFormats:
			timestrf = time.strftime (frmt, atime)
			ourstrf = timeformat.strftime (frmt, atime)
			self.failUnless (timestrf == ourstrf, "time.strftime resulted in [%s] but timeformat.strftime resulted in [%s] for format code %s" % (timestrf, ourstrf, frmt))
		
		# Now re-run with a time and date late in the month, year, and day
		atime = (2004, 11, 23, 23, 55, 10, 1, 328, 0)
		for frmt in supportedFormats:
			timestrf = time.strftime (frmt, atime)
			ourstrf = timeformat.strftime (frmt, atime)
			self.failUnless (timestrf == ourstrf, "time.strftime resulted in [%s] but timeformat.strftime resulted in [%s] for format code %s" % (timestrf, ourstrf, frmt))
		
if __name__ == '__main__':
	unittest.main()