#!/bin/bash
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Moves the bazel generated files needed for packaging the wheel to the source
# tree.

function _is_windows() {
  [[ "$(uname -s | tr 'A-Z' 'a-z')" =~ (cygwin|mingw32|mingw64|msys)_nt* ]]
}

function tfx_bsl::move_generated_files() {
  if _is_windows; then
    TFX_BSL_EXTENSION="tfx_bsl/cc/tfx_bsl_extension.pyd"
    cp -f "${BUILD_WORKSPACE_DIRECTORY}/bazel-out/x64_windows-opt/bin/${TFX_BSL_EXTENSION}" \
      "${BUILD_WORKSPACE_DIRECTORY}/${TFX_BSL_EXTENSION}"
    cp -f "${BUILD_WORKSPACE_DIRECTORY}"/bazel-out/x64_windows-opt/bin/tfx_bsl/public/proto/*.py \
      "${BUILD_WORKSPACE_DIRECTORY}"/tfx_bsl/public/proto
  else
    # If run by "bazel run", $(pwd) is the .runfiles dir that contains all the
    # data dependencies.
    RUNFILES_DIR=$(pwd)
    TFX_BSL_EXTENSION="tfx_bsl/cc/tfx_bsl_extension.so"
    cp -f "${RUNFILES_DIR}/${TFX_BSL_EXTENSION}" \
      "${BUILD_WORKSPACE_DIRECTORY}/${TFX_BSL_EXTENSION}"
    cp -f "${RUNFILES_DIR}"/tfx_bsl/public/proto/*.py \
      "${BUILD_WORKSPACE_DIRECTORY}/tfx_bsl/public/proto/"
  fi

  chmod +w "${BUILD_WORKSPACE_DIRECTORY}/${TFX_BSL_EXTENSION}"
}

tfx_bsl::move_generated_files
