This folder contains various examples ranging from simple `Hello World` language
to a full language for Psychological experiments (`pyFlies`).

To run these examples clone this repository (or download archive and unpack).
Each folder contains README file which describes language and gives instruction
how to check/visualize meta-models and models.

Example language are:
  - `hello_world` - a very simple language used for [the hello world
    tutorial](http://textx.github.io/textX/tutorials/hello_world/).
  - `robot` - A simple DSL for moving robot on an imaginary grid. This example
    shows how to do model interpretation. Used for [the robot
    tutorial](http://textx.github.io/textX/tutorials/robot/).
  - `drawing` - A simple DSL for drawing. It uses interpretation Similarly to
    the robot DSL.
  - `Entity` - A simple DSL for modeling data. This example shows how to
    generate source code from the model. Used for [the Entity
    tutorial](http://textx.github.io/textX/tutorials/entity/).
  - `expression` - Two simple expression languages with variable assignment and
    expression evaluation. `calc.py` - four basic arithmetic operations.
    `bool.py` - three basic boolean operations.
  - `workflow` - A simple DSL for workflow descriptions.
  - `json` - An example of using textX for parsing data-interchange formats.
  - `StateMachine` - State machine language and example from
    [Fowler's](http://www.martinfowler.com/aboutMe.html) [DSL
    book](http://www.martinfowler.com/books/dsl.html). An example of source code
    generator - generating `dot` file, and an example of state machine
    interpreter.
  - `pyFlies` - An example of real DSL for the description of cognitive
    reaction-time experiments. See [the pyFlies project](http://igordejanovic.net/pyFlies/).
  - `IBM_Rhapsody` - An example of loading of a model made using IBM Rational
    Rhapsody.

