/* Copyright 2020 The TensorFlow Authors. All Rights Reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
==============================================================================*/
#ifndef TENSORFLOW_CORE_DATA_SERVICE_TEST_UTIL_H_
#define TENSORFLOW_CORE_DATA_SERVICE_TEST_UTIL_H_

#include <string>
#include <vector>

#include "tensorflow/core/framework/graph.pb.h"
#include "tensorflow/core/framework/tensor.h"
#include "tensorflow/core/platform/statusor.h"

namespace tensorflow {
namespace data {
namespace test_util {

struct GraphDefTestCase {
  // Name for the test case.
  std::string name;
  // A dataset graph.
  GraphDef graph_def;
  // The expected output from iterating over the dataset represented by the
  // graph.
  std::vector<std::vector<Tensor>> output;
};

// Returns test data representing
// tf.data.Dataset.range(range).map(lambda x: x*x). Useful for testing dataset
// graph execution.
StatusOr<GraphDefTestCase> map_test_case(int64 range);

}  // namespace test_util
}  // namespace data
}  // namespace tensorflow

#endif  // TENSORFLOW_CORE_DATA_SERVICE_TEST_UTIL_H_
