<!-- mdformat off(b/169948621#comment2) -->

# TensorFlow Lite Micro ESP-IDF Project

This folder has been autogenerated by TensorFlow, and contains source, header,
and project files needed to build a single TensorFlow Lite Micro target using
Espressif's [ESP-IDF](https://docs.espressif.com/projects/esp-idf/en/latest/).

## Usage

### Install the ESP IDF

Follow the instructions of the
[ESP-IDF get started guide](https://docs.espressif.com/projects/esp-idf/en/latest/get-started/index.html)
to setup the toolchain and the ESP-IDF itself.

The next steps assume that the
[IDF environment variables are set](https://docs.espressif.com/projects/esp-idf/en/latest/get-started/index.html#step-4-set-up-the-environment-variables) :
* The `IDF_PATH` environment variable is set. * `idf.py` and Xtensa-esp32 tools
(e.g., `xtensa-esp32-elf-gcc`) are in `$PATH`. * `esp32-camera` should be
downloaded in `components/` dir of example as explained in `Build the
example`(below)

## Build the example

As the `person_detection` example requires an external component `esp32-camera`
for functioning hence we will have to manually clone it in `components/`
directory of the example with following commands.

```
 git clone https://github.com/espressif/esp32-camera.git components/esp32-camera
 cd components/esp32-camera/
 git checkout eacd640b8d379883bff1251a1005ebf3cf1ed95c
 cd ../../
```

To build this, run:

```
idf.py build
```

### Load and run the example

To flash (replace `/dev/ttyUSB0` with the device serial port):
```
idf.py --port /dev/ttyUSB0 flash
```

Monitor the serial output:
```
idf.py --port /dev/ttyUSB0 monitor
```

Use `Ctrl+]` to exit.

The previous two commands can be combined:
```
idf.py --port /dev/ttyUSB0 flash monitor
```

## Project Generation

See
[tensorflow/lite/micro](https://github.com/tensorflow/tensorflow/tree/master/tensorflow/lite/micro)
for details on how projects like this can be generated from the main source
tree.

## License

TensorFlow's code is covered by the Apache2 License included in the repository,
and third party dependencies are covered by their respective licenses, in the
third_party folder of this package.
