# Lint as: python3
# Copyright 2020 The TensorFlow Probability Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
r"""Ground truth values for `stochastic_volatility_sp500`.

Automatically generated using the command:

```
python -m inference_gym.tools.get_ground_truth \
  --target=stochastic_volatility_sp500 \
  --stan_samples=20000
```
"""

import numpy as np

IDENTITY_LOG_VOLATILITY_MEAN = np.array([
    5.6641595902,
    5.7246810971999995,
    5.6197484214,
    5.5389854031,
    5.50537504465,
    5.5143565334,
    5.569428290300001,
    5.4649456045,
    5.3892889498,
    5.353038615499999,
    5.367586840949999,
    5.36570012115,
    5.414163025,
    5.512669367799999,
    5.4291483597,
    5.38805640165,
    5.364428340250001,
    5.3347497091000005,
    5.20906008525,
    5.1126181458,
    5.0201660701,
    4.976407536749999,
    4.9543923273,
    4.9697202246500005,
    5.03547999275,
    4.9499138864,
    4.8990625221,
    4.882480846750001,
    4.9133747407,
    4.982760880300001,
    5.0923932145499995,
    5.231207630150001,
    5.114580008400001,
    5.0330751177,
    4.991582503399999,
    5.00057467455,
    5.0003544427,
    5.049861814350001,
    5.0148426196,
    5.02166854245,
    5.0677858353000005,
    5.0707531901500005,
    5.1218248123,
    5.1949511821500005,
    5.2344545059,
    5.2439257478500005,
    5.304512665,
    5.1669827544,
    5.05579869515,
    4.9287252548,
    4.778758739,
    4.6581772748,
    4.5768218097,
    4.531721929,
    4.4526757537999995,
    4.4215141664,
    4.43176914235,
    4.49056534515,
    4.597919950949999,
    4.602978717900001,
    4.6505010848,
    4.727065056499999,
    4.80053409895,
    4.683909429750001,
    4.589010324999999,
    4.530666032400001,
    4.5133795793,
    4.532818992499999,
    4.590812845099999,
    4.6411496326999995,
    4.4629481386,
    4.3316591655,
    4.24442465295,
    4.1739155517,
    4.1516453596,
    4.1653316943,
    4.176362194450001,
    4.2129522165,
    4.2970826142,
    4.385154503600001,
    4.259128424350001,
    4.07797738275,
    3.9438321090499997,
    3.8538067945,
    3.80749537245,
    3.8095657255999997,
    3.83808733225,
    3.915663721650001,
    4.039275717400001,
    4.2109954106,
    4.3709910313,
    4.5716436555,
    4.5381459073,
    4.54277282045,
    4.5907125528,
    4.623522056599999,
    4.6931814321,
    4.7949521978,
    4.840883380399999,
    4.9356702975,
    4.918232659200001,
    4.950357008399999,
    4.913638206450001,
    4.9249898871,
    4.983138674950001,
    4.96987758265,
    4.8984051534,
    4.837391307,
    4.8237234309,
    4.831169730049998,
    4.62319186675,
    4.34874447265,
    4.119479685949999,
    3.9334932222999996,
    3.7968081989000004,
    3.6893539682,
    3.6075568139999996,
    3.5052356672499996,
    3.4492972114499993,
    3.4409067626,
    3.3866033303500003,
    3.28917064075,
    3.23893494915,
    3.2232155042499997,
    3.1505554185999993,
    3.095775299175,
    3.0663884154200005,
    3.08509963151,
    3.151251270975,
    3.262851838944999,
    3.4070880368000003,
    3.5967543616999995,
    3.5593402804499994,
    3.5612976254000004,
    3.5612874203,
    3.58906758495,
    3.6490980497,
    3.7469824429500003,
    3.87297176935,
    3.9137964544,
    3.99262383535,
    4.0423272771,
    4.13887424265,
    4.11195904945,
    4.1294310228,
    4.190450481800001,
    4.2604798946999995,
    4.380310645,
    4.5329874942499995,
    4.7324321949,
    4.706597325750001,
    4.69021396285,
    4.507897574199999,
    4.3630590809,
    4.263317690999999,
    4.2053204943499995,
    4.14770327645,
    4.119234520300001,
    4.120156753550001,
    4.1685747023,
    4.227307657900001,
    4.330009400650001,
    4.46151027915,
    4.6040912372500005,
    4.79031684055,
    5.024704926749999,
    5.01897165605,
    5.0336373003,
    5.09765778935,
    5.15488740855,
    5.24692034245,
    5.2524036033999995,
    5.30792364985,
    5.283994486799999,
    5.2786202076999995,
    5.283105265350001,
    5.3049486627,
    5.3752296922,
    5.326436319799999,
    5.3098024477,
    5.32279940225,
    5.3226880161,
    5.195797870650002,
    5.04110497785,
    4.9283452384499995,
    4.7296827138,
    4.56652160295,
    4.447284542299999,
    4.291425493,
    4.17557108165,
    4.0920862300500005,
    3.9870285187,
    3.8616949517500005,
    3.7725123727499996,
    3.6855989127999997,
    3.6458790795200002,
    3.6541087776,
    3.7033558401500004,
    3.78890966325,
    3.8734209026000004,
    3.9820042418,
    4.008198084649999,
    4.083575839850001,
    4.2072195079500005,
    4.3630661658,
    4.40251823285,
    4.460019228049999,
    4.38476143375,
    4.3324381552,
    4.3217146684999985,
    4.26644672365,
    4.212940215550001,
    4.19423869575,
    4.220527657749999,
    4.286656903,
    4.378399674500001,
    4.4472575631,
    4.4539000257,
    4.49789838715,
    4.57413441035,
    4.64025456235,
    4.62027320465,
    4.631811668599999,
    4.61815416835,
    4.608099693000001,
    4.64741430785,
    4.67034491175,
    4.7396650104499995,
    4.796955629400001,
    4.775566476,
    4.802003278,
    4.873218411849999,
    4.98489898155,
    5.138317170500001,
    5.284301715349999,
    5.207387027499999,
    5.178954501800001,
    5.1424739003,
    5.085793081649999,
    5.077760410649999,
    5.10507669535,
    5.1564502679,
    5.143579934200001,
    5.1823757357,
    5.19717487585,
    5.095224400800001,
    5.043416282400001,
    5.037864626949999,
    5.069275869749999,
    5.0547742077999995,
    5.0602031387499995,
    5.10897690935,
    5.1221001539,
    5.1460882717,
    5.13850254045,
    5.147771016249999,
    5.156743475499999,
    5.108762915850001,
    5.108752628149999,
    5.15890996375,
    5.20249782335,
    5.2637939261,
    5.1944051578499995,
    5.16087691415,
    5.1735281281,
    5.2059505455499995,
    5.2746838463,
    5.356448186899999,
    5.374921791450001,
    5.443242919599999,
    5.4875847350499996,
    5.58339339205,
    5.714077876749999,
    5.887834379899999,
    5.989180742599999,
    6.13933539835,
    6.3299846661000005,
    6.569096721800001,
    6.770285569350001,
    7.022085430349999,
    7.14561639555,
    7.322702277200001,
    7.320439209500002,
    7.2727181788,
    7.174560269099999,
    7.018426022999999,
    6.9142855923,
    6.8290249122,
    6.785661212299999,
    6.794840751,
    6.674932051250001,
    6.583700947999999,
    6.5446048239499985,
    6.443515231549999,
    6.3748792412,
    6.3221542441,
    6.2931369001499995,
    6.2052541181,
    6.1691657464,
    6.180637733749999,
    6.216804732399999,
    6.1947831082,
    6.2138066808999985,
    6.1656925093,
    6.14787695815,
    6.0546681337,
    6.006488319850001,
    5.9959469856,
    6.004891262099999,
    6.009149259199999,
    6.05931306,
    6.1398831105500005,
    6.271094607949999,
    6.3175228613,
    6.271670093149999,
    6.27391240635,
    6.257483735300001,
    6.2776645863499985,
    6.28380064715,
    6.333820445150001,
    6.3476022515,
    6.30817229285,
    6.2631772573,
    6.2294300536,
    6.2023387968,
    6.2146992791499995,
    6.1116581559,
    6.0590114188,
    6.0424895508,
    6.07558372005,
    6.1062248684,
    6.112293716350001,
    6.099119573049999,
    6.1038799972,
    6.15715781895,
    6.203048935250001,
    6.274387384599999,
    6.32600350715,
    6.4151656437,
    6.3982150007000005,
    6.4333235766,
    6.42564143415,
    6.354084931499999,
    6.30012226665,
    6.2458231923500005,
    6.23450241735,
    6.26891876175,
    6.3356854938,
    6.23136521795,
    6.169416161349999,
    6.093130910900001,
    6.047764722549999,
    6.049661123849999,
    6.03909291975,
    6.017923305400001,
    6.0470692452999995,
    6.054180490949999,
    6.1073097224,
    6.1215945966,
    6.1854348110999995,
    6.1769721330000005,
    6.21946471855,
    6.03114579865,
    5.8938286692999995,
    5.806479127049999,
    5.745526957600001,
    5.73573012985,
    5.7762634120000005,
    5.7368252703,
    5.6759768984,
    5.5928284556,
    5.533111923199999,
    5.4754355892,
    5.465281818549999,
    5.5038099226499995,
    5.54110344845,
    5.364545487799999,
    5.237489785999999,
    5.13425150255,
    5.0444399650000005,
    5.003203611799999,
    4.909785729949999,
    4.7989907084,
    4.72068026105,
    4.5182123363,
    4.3649281276,
    4.2545636568,
    4.180068596150001,
    4.150615643899999,
    4.06747041845,
    4.0321728476,
    4.041319544449999,
    4.04710703835,
    4.086927011999999,
    4.001233331050001,
    3.9302000268999997,
    3.9079777023999993,
    3.9342460724999997,
    4.00318277555,
    4.00418191265,
    3.9811944808999997,
    3.9977569244,
    4.04638864955,
    4.1411339303000005,
    4.17875717045,
    4.2649083445,
    4.13263718355,
    4.0474965234999996,
    4.00845458135,
    4.0131396158,
    4.0645485073,
    4.06660442325,
    4.04986689125,
    4.0768016853499995,
    4.09068840015,
    3.9707123593999993,
    3.8935716849000004,
    3.8643826457,
    3.8485526744000005,
    3.8494883422499995,
    3.89593598565,
    3.9892190569499997,
    4.1150237117,
    4.2393942364,
    4.36632369075,
    4.521569081449999,
    4.703661062,
    4.69993372635,
    4.710172425650001,
    4.691734788949999,
    4.713955499100001,
    4.78515321135,
    4.640744408650001,
    4.542865679549999,
    4.459555755049999,
    4.42460768665,
    4.42340658265,
    4.452848522700001,
    4.52429453515,
    4.57166065875,
    4.6612290979,
    4.6170036952,
    4.60971089595,
    4.61592037505,
    4.66753497095,
    4.7572305055,
    4.8499762211,
    4.974177945950001,
    5.0577677542,
    5.19092952835,
    5.288528116050001,
    5.272974349850001,
    5.282101651,
    5.2500594705,
    5.1737486089499996,
    5.1463719353499995,
    5.03439904485,
    4.957493517850001,
    4.897588711,
    4.88674925245,
    4.85989541945,
    4.87534856135,
    4.8021049688,
    4.7445054545500005,
    4.73334628605,
    4.75193213,
    4.794163457199999,
    4.8776210622,
    4.95389103685,
    4.8680254313499995,
    4.8325112696999994,
    4.8267133003,
    4.8250828022,
    4.8704394234,
    4.9529306821,
    4.98548544285,
    5.04031529155,
    5.1293086494,
    5.126871898899999,
    5.138254111100001,
    5.0684436786000004,
    5.048527002050001,
    5.07847766415,
    5.15723387605,
    5.2828284745,
    5.4028271971,
    5.474091230699999,
    5.59369486395,
    5.539511170199999,
    5.53536287015,
    5.5734392957,
    5.4874616484,
    5.451860308250001,
    5.444303807900001,
    5.411724217,
    5.37627609045,
    5.3659227914,
    5.3578086782500005,
    5.35497775085,
    5.40219968845,
    5.46029380295,
    5.5670201484,
    5.5211875591999995,
    5.510280753849999,
    5.440102785500001,
    5.413426021799999,
    5.4060773740000005,
    5.4468037306,
    5.2887996485499995,
    5.179338254199999,
    5.1018329988,
    5.05548767995,
    4.99138340395,
    4.973992320800001,
    4.9510272715,
    4.9772535907,
    5.032035669699999,
    4.9720378761,
    4.955623704050001,
    4.95420604015,
    4.974927199350001,
    5.041996412900001,
    5.080520008750001,
    5.1116645212,
    5.1350990693,
    5.20828488605,
    5.19526330005,
    5.0404576156,
    4.9349868237,
    4.86098106275,
    4.827796567299999,
    4.78928104515,
    4.5106525906499995,
    4.278181422099999,
    4.0623745113,
    3.895039378199999,
    3.77618120104,
    3.6984500758500003,
    3.6589979794499996,
    3.6662345471999997,
    3.7203249833000003,
    3.7020962523499996,
    3.7271020734,
    3.7997760071999997,
    3.8782405596000005,
    4.00474472065,
    4.0258002821,
    4.026968891649999,
    4.074285067449999,
    4.165467205400001,
    4.307107642749999,
    4.38988750185,
    4.4930904417,
    4.64299420625,
    4.84019502155,
    4.752403104450001,
    4.7021880491,
    4.654750600850001,
    4.6496682716499995,
    4.691003284800001,
    4.523521033550001,
    4.3886668121,
    4.2828340884,
    4.2193808749,
    4.2044849029,
    4.23697488445,
    4.316449320649999,
    4.433222450700001,
    4.427125956399999,
    4.415464086649999,
    4.3373693778,
    4.269291640900001,
    4.2429813651999995,
    4.2654509894,
    4.32066988965,
    4.354309216199999,
    4.435425389550001,
    4.543367481800001,
    4.562265054399999,
    4.57533954415,
    4.6375867745,
    4.73483184805,
    4.8245286863,
    4.875279860100001,
    4.9643787904,
    5.095461492749999,
    5.06678989135,
    5.088746421200001,
    5.0026591842000006,
    4.95574275775,
    4.954923989799999,
    5.00263446295,
    5.09927877625,
    5.172362414149999,
    5.231514652949999,
    5.338891655049999,
    5.4681092264,
    5.3732837937,
    5.248044195,
    5.1722940603,
    5.14617502185,
    5.1572614755499995,
    5.091378260800001,
    5.07223991945,
    5.092371680449999,
    4.930165194300001,
    4.8180189412,
    4.7527248781,
    4.59248114995,
    4.4733396593000005,
    4.361600009799999,
    4.22141269495,
    4.107832253699999,
    4.04108974245,
    3.9660009403,
    3.92704846945,
    3.9351323026500005,
    3.9731004868,
    4.047087418650001,
    4.1700803644499995,
    4.27671197055,
    4.4324970472,
    4.571210989550001,
    4.734249005450001,
    4.821662389549999,
    4.85010064545,
    4.8677697297,
    4.914499874599999,
    4.9257502524,
    4.9789535142000005,
    5.060501579049999,
    5.1903471701,
    5.287118663849999,
    5.2901101974,
    5.0024898569000005,
    4.760184386249999,
    4.547628218350001,
    4.366924620249999,
    4.213363395750001,
    4.099902023299999,
    3.9325624444500002,
    3.8135959125500003,
    3.7356715558499998,
    3.7052827764500003,
    3.7229058426500004,
    3.7080080713999997,
    3.71530990025,
    3.7232401465000002,
    3.77477684325,
    3.8743901705,
    3.9567130439,
    4.072857795300001,
    4.193163426450001,
    4.323888181999999,
    4.48827097415,
    4.575557881149999,
    4.52550930855,
    4.392751692200001,
    4.3098374814,
    4.2657065839,
    4.22126971945,
    4.22280748225,
    4.27202736865,
    4.3693275928999995,
    4.516169366249999,
    4.7082018184,
    4.895507132500001,
    4.9714663706,
    5.05650885145,
    5.13744025365,
    5.01186240815,
    4.910395148199999,
    4.7233044169500005,
    4.58399163915,
    4.48954763205,
    4.4184375046,
    4.26630271285,
    4.16175876725,
    4.102988812,
    4.0571917471,
    4.04087976245,
    4.05271788925,
    4.11088608645,
    4.159064588850001,
    4.2446673404999995,
    4.3071879306000005,
    4.40408239785,
    4.4858116074000005,
    4.49832757885,
    4.4948117648000006,
    4.5170028813,
    4.5102383790500005,
    4.55030210655,
    4.62200419355,
    4.70807882735,
    4.81702244245,
    4.8393146076499995,
    4.897535722100001,
    4.9814624665,
    5.08439838645,
    5.2285974779,
    5.32136185295,
    5.458410393899999,
    5.63979328765,
    5.6047054444999995,
    5.53048419405,
    5.38761566105,
    5.26285967715,
    5.14034194715,
    5.05398921105,
    4.93024417735,
    4.85635639395,
    4.8179702435500005,
    4.82352329705,
    4.82618875645,
    4.874192583699999,
    4.8681810128,
    4.8257982467,
    4.7170048254,
    4.6553420729,
    4.6108186074,
    4.59601759655,
    4.60301743875,
    4.636212856749999,
    4.719056396800001,
    4.72700770275,
    4.7545897016500005,
    4.79122963195,
    4.754721141350001,
    4.7652019945,
    4.823731465200001,
    4.83350888485,
    4.87935716345,
    4.9736267795,
    5.081594613150001,
    5.183698700949999,
    5.32738993695,
    5.360129838200001,
    5.422403866300001,
    5.5120577933,
    5.5302178199,
    5.56299342075,
    5.559905060449999,
    5.6073016637,
    5.64328238275,
    5.68875707845,
    5.685607310950001,
    5.7116343797,
    5.764614495150001,
    5.84339913565,
    5.8835941736,
    5.71598616315,
    5.59822014205,
    5.446721486749999,
    5.297929298750001,
    5.139794010449999,
    5.0042110071499994,
    4.895253309999999,
    4.808725226400001,
    4.7712143425,
    4.78377491765,
    4.728762232699999,
    4.693046175799999,
    4.64497280045,
    4.6462145833,
    4.44790134645,
    4.28753786015,
    4.173626800400001,
    4.0654820503,
    3.9900804737500004,
    3.90003109485,
    3.8535598018500004,
    3.84677271315,
    3.8694602812500003,
    3.8758881911000005,
    3.91605092235,
    4.004779385350001,
    4.087476703550001,
    4.219886818649999,
    4.399737776499999,
    4.347474867200001,
    4.34205754475,
    4.378618803399999,
    4.38490846735,
    4.40212398245,
    4.446243535,
    4.5077255311,
    4.6139537954500005,
    4.76126063355,
    4.91458720205,
    4.868728602,
    4.855041773200001,
    4.84224681925,
    4.86681365985,
    4.89513965815,
    4.8982909208,
    4.936442429899999,
    5.002550952399999,
    4.8484645449,
    4.7380143083999995,
    4.67410845805,
    4.6395871476499995,
    4.6357198345,
    4.59392070035,
    4.600795654200001,
    4.65819863635,
    4.6320507799,
    4.58250714205,
    4.5712859479,
    4.58394271125,
    4.6381670218,
    4.698503195749999,
    4.788442069149999,
    4.7426666724,
    4.73865046615,
    4.697074882099999,
    4.664019692649999,
    4.665921056299999,
    4.700892165049999,
    4.77169069215,
    4.864876967549999,
    4.9550084856,
    5.02940431055,
    5.152373054750001,
    5.242492497599999,
    5.347483219549999,
    5.441908033300001,
    5.4780316206,
    5.564216136249999,
    5.440912591149999,
    5.345019660749999,
    5.289421014250001,
    5.2384623351,
    5.085997581500001,
    4.9430842064,
    4.8054097374,
    4.7167869371,
    4.634000926400001,
    4.55402157955,
    4.508478263199999,
    4.4819861875,
    4.5032323369,
    4.520695383550001,
    4.5306326557,
    4.555427377700001,
    4.6190880764,
    4.71459206195,
    4.84310188345,
    5.001492901450001,
    4.99589028785,
    4.8518407367,
    4.7569018395,
    4.699407130999999,
    4.599204553849999,
    4.5120023767,
    4.4461586642,
    4.3914899072999996,
    4.37356791,
    4.36629220225,
    4.273275674200001,
    4.1764185576,
    4.1197957362,
    4.112176713499999,
    4.140099787,
    4.211387345,
    4.30440404805,
    4.4128452539500005,
    4.5637284158,
    4.72082937495,
    4.742996192150001,
    4.811755803399999,
    4.9114156933999995,
    4.87760581485,
    4.870446289749999,
    4.91274445465,
    4.9605549582999995,
    5.04215866445,
    4.8802759187,
    4.766573289999999,
    4.6724297786,
    4.5858970671,
    4.53507893175,
    4.495525932850001,
    4.50281335865,
    4.558978687250001,
    4.6397490581,
    4.609024046250001,
    4.62634730125,
    4.6751999101,
    4.716481341300001,
    4.8072122975500005,
    4.9472121671,
    5.13170972855,
    5.17763379655,
    5.16196171905,
    5.1716590035,
    5.22801261705,
    5.31426733745,
    5.446438185700001,
    5.62911364795,
    5.8038566389,
    5.77884047085,
    5.7893494881,
    5.833976962350001,
    5.86999461885,
    5.899060784599999,
    5.9560864994500005,
    5.822626570099999,
    5.7142519191000005,
    5.6528283,
    5.556545794650001,
    5.398684813499999,
    5.291320901400001,
    5.129616178849999,
    5.0177728125500005,
    4.920089787649999,
    4.844408891599999,
    4.81770498415,
    4.7636301074,
    4.70742592605,
    4.690601106400001,
    4.66391525605,
    4.68020864075,
    4.74646256515,
    4.827223294,
    4.9490118148999995,
    5.037909838300001,
    4.908078207050001,
    4.827505878000001,
    4.792788186449999,
    4.8094294947,
    4.874828051300001,
    4.94311902355,
    5.0613158265,
    5.048000639850001,
    5.0718307754500005,
    5.0450124370000005,
    5.0113284494,
    4.969879042400001,
    4.9360291794,
    4.93435347635,
    4.9437220745,
    4.9799239151500005,
    4.990885077350001,
    5.044734550149999,
    5.125429824699999,
    5.1914323933,
    5.257664106049999,
    5.368320345999999,
    5.526739002050001,
    5.604406098300001,
    5.64427586225,
    5.7280761804,
    5.7955881844,
    5.653066099049999,
    5.4977682048,
    5.347161386,
    5.21222241135,
    5.021595676150001,
    4.87992704955,
    4.7705180153999995,
    4.6881199628,
    4.641160220000001,
    4.6412226825000005,
    4.54961342355,
    4.49182757655,
    4.44006684875,
    4.4203757054,
    4.44817549005,
    4.51848349555,
    4.634060699150001,
    4.6272528268,
    4.6169186853,
    4.6499476493000005,
    4.731258592049999,
    4.71342902385,
    4.74513594395,
    4.7803897080499995,
    4.70766507905,
    4.6648232941,
    4.6495380117,
    4.593266237800001,
    4.469180822949999,
    4.38610475435,
    4.315255815149999,
    4.2079134190500005,
    4.14165812115,
    4.0431152712000005,
    3.9860983147,
    3.97655504452,
    4.01249015695,
    4.0892803592,
    4.082076531249999,
    4.05941490635,
    4.08497595605,
    4.1572164657999995,
    4.2274943269,
    4.17310957555,
    4.144053531999999,
    4.1630013658000005,
    4.219159511300001,
    4.15957541835,
    4.145192756799999,
    4.174832954249999,
    4.251730843400001,
    4.233723197999999,
    4.2013345028,
    4.209524158100001,
    4.2591209144999995,
    4.3566367099,
    4.39202343705,
    4.47634150035,
    4.546136430650001,
    4.62062218915,
    4.62550338465,
    4.641570937950001,
    4.66245189055,
    4.731231311050001,
    4.8099991085,
    4.928944308149999,
    5.0749056261,
    5.0695321390000005,
    4.98474754385,
    4.938281238949999,
    4.90836242275,
    4.92457478345,
    4.990390846599999,
    5.065310147050001,
    5.189432350700001,
    5.333482253500001,
    5.528105574349999,
    5.4242869852,
    5.3622968955,
    5.306437155599999,
    5.1954940258,
    5.133896185150002,
    5.080638882600001,
    4.921899183149999,
    4.804960483299999,
    4.7302862682,
    4.6307050711,
    4.5484312218000005,
    4.5141921415,
    4.37551065395,
    4.22718184715,
    4.1132370296,
    4.02353334485,
    3.9599685382000005,
    3.85925232865,
    3.8053413691999998,
    3.79816953355,
    3.8165962131499995,
    3.8390639551999994,
    3.90529403555,
    4.01316531135,
    4.15313786375,
    4.2661665952,
    4.3892435324,
    4.4267274333,
    4.4848394398,
    4.59205741485,
    4.656572815549999,
    4.76626011535,
    4.83068431155,
    4.94257364005,
    5.071337015849999,
    5.24906476105,
    5.392615556699999,
    5.5490888019,
    5.70824421695,
    5.72012819075,
    5.73540731515,
    5.7961893446,
    5.900406365149999,
    5.945029255250001,
    6.0408151115,
    6.128789532800001,
    6.26643798445,
    6.3586926223499995,
    6.3988593995,
    6.3351786155,
    6.2733666555,
    6.1557127533000005,
    6.0882551632499995,
    6.039554899800001,
    6.041776255250001,
    6.02469608355,
    6.02330357935,
    5.8952673068,
    5.785000613900001,
    5.636569832049999,
    5.503606153900001,
    5.419168147900001,
    5.2587907305999995,
    5.145115165,
    5.038137391699999,
    4.7973731105,
    4.6056701836,
    4.4402179335500005,
    4.2458194873,
    4.059770311750001,
    3.9237503405499994,
    3.7989317321000002,
    3.7216821017500004,
    3.6855455608199996,
    3.696430300225,
    3.7553914995999995,
    3.8624065397000003,
    3.9014157570499997,
    3.97235296395,
    4.07964685615,
    4.13787274595,
    4.2205480809500004,
    4.343371868450001,
    4.49565451405,
    4.6743711878,
    4.78638240305,
    4.87527437645,
    4.9929193533500005,
    5.1566896296,
    5.368516532299999,
    5.5637221524,
    5.81003432225,
    5.9118001089500005,
    6.05416199415,
    6.1005590327,
    6.1765294654,
    6.269293938600001,
    6.253200242850001,
    6.052989728200001,
    5.8945961444,
    5.779335896649999,
    5.7128868841,
    5.698867706300001,
    5.7277918659000004,
    5.806258596999999,
    5.91612452005,
    6.000238726199999,
    6.136330365949999,
    6.146586415650001,
    6.1665386114,
    6.178935523900002,
    6.099678308550001,
    6.029985868549999,
    5.97134531685,
    5.95883475365,
    5.9744085962,
    5.98714749645,
    5.955021091699999,
    5.974000838100001,
    6.0330363809000005,
    6.0202699446,
    6.038386893650001,
    6.1054407932000005,
    6.1250946531,
    6.10045807365,
    6.085375545,
    6.0307912381,
    5.943518269249999,
    5.7918992444,
    5.67545958455,
    5.5320195746000005,
    5.4258707807999995,
    5.348109324899999,
    5.2007570029500005,
    5.104611537449999,
    4.9311061418,
    4.7820988366999995,
    4.6796826785,
    4.626100452799999,
    4.61665597255,
    4.57111523615,
    4.573450155550001,
    4.609048602900001,
    4.6903042421,
    4.8130864603,
    4.9616787597,
    5.10142892375,
    5.25271814825,
    5.42424520475,
    5.64590746065,
    5.736363406000001,
    5.86771734645,
    5.85018328905,
    5.8806896073,
    5.8663389131,
    5.87443692525,
    5.8198748966,
    5.806691065849999,
    5.745001619799998,
    5.71377906485,
    5.671830998999999,
    5.6775708765,
    5.69710874485,
    5.586454740750001,
    5.5203250188999995,
    5.501355018750001,
    5.3983703165,
    5.2533506931,
    5.1345209680499995,
    5.05201104075,
    4.95796893445,
    4.903499532100001,
    4.8894565094,
    4.8933201212999995,
    4.902495215549999,
    4.9143073417,
    4.973102265950001,
    5.0426996308,
    5.16074232815,
    5.1352807606,
    5.04871448685,
    5.0066344165,
    4.9774824436500005,
    4.9912298582,
    5.0489055579499995,
    5.1222544541,
    5.2370640406,
    5.37964185775,
    5.4475458879500005,
    5.449678744350001,
    5.49641624815,
    5.442840874,
    5.41547805685,
    5.4260235328999995,
    5.30637382165,
    5.1991455230999994,
    5.1285922588999995,
    5.107103959,
    4.9719636528999995,
    4.88778760565,
    4.83794632905,
    4.8357304905,
    4.880697678050001,
    4.967639420849999,
    5.0921405664499995,
    5.091125216250001,
    5.02305313825,
    5.0014372252,
    4.95207627825,
    4.9475863779,
    4.988967186150001,
    5.07563896185,
    5.0843036958,
    5.1383947904000005,
    5.1741630036499995,
    5.260278401400001,
    5.227138410699999,
    5.2419515393000005,
    5.2352984622,
    5.246265262300001,
    5.269475669699999,
    5.3397636072,
    5.3524757554,
    5.3763104062,
    5.4124562030500005,
    5.498369093199999,
    5.572120580199999,
    5.68594464795,
    5.8505502278999995,
    5.7529700237,
    5.70241604815,
    5.667533023799999,
    5.6828792587,
    5.7345898415,
    5.81246754975,
    5.73420933155,
    5.704506491200001,
    5.615603502699999,
    5.47696242085,
    5.371088779299999,
    5.314188120399999,
    5.23457596265,
    5.2033695342,
    5.222653977999999,
    5.26265228095,
    5.342191302350001,
    5.42761804175,
    5.430704747599999,
    5.4456735248,
    5.3608791373499995,
    5.270876865,
    5.23123658035,
    5.23263155185,
    5.270420485850001,
    5.3490934866,
    5.468578369399999,
    5.5682279308,
    5.7083103261,
    5.7733451037000005,
    5.8122621399500005,
    5.90202798405,
    6.03915173645,
    6.221502279699999,
    6.442724710749999,
    6.712837619999999,
    7.012955245550001,
    7.266407844700001,
    7.410164385950002,
    7.40801417965,
    7.434371079900001,
    7.3470015121,
    7.236557337049999,
    7.179495612950001,
    7.1618178084999995,
    7.047404408449999,
    6.92979728305,
    6.8651817536,
    6.797439399199999,
    6.6420974375499995,
    6.4797782216,
    6.3627852953,
    6.29105461675,
    6.2627471432999995,
    6.220878140200001,
    6.1997697539,
    6.22605302715,
    6.1820635598,
    6.1813351796,
    6.15900063725,
    6.18470681875,
    6.257471358049999,
    6.3817494766000005,
    6.3210322952,
    6.31137422975,
    6.22993376005,
    6.1992157556,
    6.13853307025,
    5.98433255395,
    5.8708356032,
    5.77279342025,
    5.67512487635,
    5.627987823850001,
    5.6323350897,
    5.643053951899999,
    5.684065852099999,
    5.615544402200001,
    5.5833234137,
    5.603273005349999,
    5.669875962250002,
    5.756787010200001,
    5.707141243700001,
    5.62055514965,
    5.5792226018,
    5.580768806299999,
    5.5140647823,
    5.497956308449999,
    5.503909227049999,
    5.428755938,
    5.399011722400001,
    5.3997435631999995,
    5.449416663100001,
    5.5491073409,
    5.59773894995,
    5.69595811855,
    5.83484750305,
    5.880613077,
    5.891207767100001,
    5.82141872215,
    5.800828709299999,
    5.6546500772999995,
    5.5571129663,
    5.498925549250001,
    5.48867292605,
    5.5287377894,
    5.618807489350001,
    5.7593078286,
    5.932010615699999,
    6.08618664165,
    6.2188548493,
    6.2988177371,
    6.258547790450001,
    6.2445866768,
    6.2603862581500005,
    6.297506468300001,
    6.38510955905,
    6.36862431965,
    6.39740966725,
    6.4371113057,
    6.455689593049999,
    6.43690087665,
    6.347862656199999,
    6.28972309915,
    6.25091312095,
    6.198546455000001,
    6.196032794300001,
    6.24132054735,
    6.2876734262,
    6.36031288335,
    6.4440748484,
    6.487779128700001,
    6.582371820900001,
    6.6715334450000014,
    6.6518754311,
    6.648908510650001,
    6.6990653938,
    6.787789457450001,
    6.776920690350001,
    6.75911208965,
    6.6779803308,
    6.64938747165,
    6.635111995849999,
    6.6672159259,
    6.6538809913999994,
    6.62396671015,
    6.5973613147,
    6.58733129855,
    6.6228633742,
    6.55292512355,
    6.535266345950001,
    6.457523011399999,
    6.425024817700001,
    6.44445001185,
    6.398560624699999,
    6.335062689749999,
    6.322987020800001,
    6.3621375343499995,
    6.3997393344,
    6.375846590799999,
    6.31898959075,
    6.22121745255,
    6.1637710187999994,
    6.158186268400001,
    6.1186763437,
    6.052817510100001,
    6.030540455050001,
    5.999009138500001,
    6.01673465015,
    6.046730329900001,
    5.8621584038000005,
    5.71971663145,
    5.621081062499999,
    5.566403579200001,
    5.563087665500001,
    5.4928726696,
    5.4531275789999984,
    5.4636108424,
    5.286415877900001,
    5.157605729649999,
    5.071720695550001,
    4.9966095406,
    4.9096280199,
    4.8435544,
    4.8262198065,
    4.85608717795,
    4.848383545700001,
    4.889357421200001,
    4.98065633815,
    5.0070673892499995,
    5.0573464593000015,
    5.14900933405,
    5.2411230208,
    5.3671829933,
    5.4226601417,
    5.42512153925,
    5.3204970532,
    5.259744026649999,
    5.237618412750001,
    5.1600033246,
    5.0052518429,
    4.9007657691999995,
    4.841958537599999,
    4.7592327395,
    4.70934922765,
    4.70989420085,
    4.6873518113,
    4.7140865189,
    4.779889737100001,
    4.8890817075,
    5.0457667771,
    5.1067367893,
    5.17429039065,
    5.21828554095,
    5.204243658250001,
    5.18842734455,
    5.2218499530499995,
    5.2959385693000005,
    5.420206885450001,
    5.4429717747,
    5.413883906250001,
    5.43479474685,
    5.425364731799999,
    5.37519158485,
    5.27113240365,
    5.2173463042499995,
    5.1913983181,
    5.17545730435,
    5.2004578312000005,
    5.049493268,
    4.88135714055,
    4.762162711349999,
    4.659688217699999,
    4.6016214971,
    4.5921747611,
    4.6150715984,
    4.6605253351,
    4.70325028405,
    4.795202553,
    4.917286960450001,
    5.0795942061499995,
    5.1499834732,
    5.165918989149999,
    5.2253427972,
    5.328709743450001,
    5.47299974515,
    5.651591889700001,
    5.8563730962000005,
    6.10858968875,
    6.4104490399,
    6.697828554200001,
    6.651073340249999,
    6.5578634004000005,
    6.424345310350001,
    6.2417105596499995,
    6.030116624500001,
    5.867906457450001,
    5.720181564299999,
    5.603804395749999,
    5.536391018900001,
    5.3072483889000015,
    5.11596879765,
    4.906742779450001,
    4.74744723815,
    4.58206738805,
    4.4624758119,
    4.37814160355,
    4.331922229849999,
    4.280081093600001,
    4.21773248085,
    4.1341885931,
    4.0500264539,
    4.01411729815,
    4.014432949999999,
    4.05628675815,
    4.13888952495,
    4.2589233577500005,
    4.25994712875,
    4.2814330357,
    4.351608354150001,
    4.244085365750001,
    4.1798598457,
    4.1647447809500004,
    4.15426765915,
    4.112643688100001,
    4.11363931095,
    4.136825824250001,
    4.0610540547500005,
    4.024549318299999,
    4.018290678750001,
    4.04573272685,
    4.11668835735,
    4.225699724849999,
    4.256707266049999,
    4.32549494375,
    4.4299159967,
    4.506500580949999,
    4.61562821175,
    4.75334218935,
    4.94105084535,
    5.14827313745,
    5.395976577,
    5.69335409365,
    6.0358557322,
    6.05248425,
    6.005301052249999,
    5.863700004700001,
    5.771846603150001,
    5.65667179115,
    5.576426721100001,
    5.547505329649999,
    5.5692052296500005,
    5.53125020165,
    5.5060236937500004,
    5.491397484050001,
    5.440237927149999,
    5.39838169245,
    5.37788221255,
    5.2940158206,
    5.1857163266,
    5.10781538655,
    5.034315470099999,
    4.9849018555999995,
    4.984131163799999,
    5.0107820213,
    5.0550642558,
    4.88081144935,
    4.75488683885,
    4.6512012613,
    4.5974013864,
    4.56194190575,
    4.484692629,
    4.446466045299999,
    4.44755605065,
    4.49780559305,
    4.5403364484,
    4.580985012250001,
    4.65946019045,
    4.759364351450001,
    4.88234136685,
    5.0539181506499995,
    5.19242318985,
    5.3152800749,
    5.4619554286,
    5.65392968615,
    5.50730887475,
    5.4004621889,
    5.2124652576,
    5.071922797900001,
    4.97652867155,
    4.93131724835,
    4.837856974,
    4.784478771799999,
    4.740048519299999,
    4.7267743001,
    4.641912826899999,
    4.5990312321,
    4.6045853793500005,
    4.6236244123,
    4.60531097665,
    4.63347481855,
    4.687957897199999,
    4.751838413650001,
    4.866010307749999,
    4.967476195000001,
    5.1016689639,
    5.0190792773999995,
    4.98012083465,
    4.93238002945,
    4.92968113405,
    4.8963656882499995,
    4.759891645000001,
    4.64143716115,
    4.5602281204,
    4.521258334600001,
    4.495801534149999,
    4.493793879900001,
    4.5246799727,
    4.6025413324999995,
    4.71891919615,
    4.69188256255,
    4.7138202383,
    4.72288325225,
    4.61865525165,
    4.482742529649999,
    4.3917609895,
    4.3139224069,
    4.22513350805,
    4.18500494855,
    4.164788027549999,
    4.164148615,
    4.202303718,
    4.239854455,
    4.317296675250001,
    4.3830346232999995,
    4.46441822255,
    4.56420492255,
    4.5983505011,
    4.5129160359,
    4.47332900225,
    4.4788085878,
    4.397657404449999,
    4.3607960579,
    4.371920368950001,
    4.4330136299000005,
    4.37644866835,
    4.3464083937,
    4.36470290295,
    4.4319677921,
    4.4452638355,
    4.4703811277500005,
    4.461317408099999,
    4.456015065700001,
    4.4208725355,
    4.42930426235,
    4.4806958874000005,
    4.46368421115,
    4.4892086782,
    4.5643110583499995,
    4.683443379199999,
    4.8509882605,
    5.0471154028,
    4.94746154445,
    4.8117476115,
    4.725242919699999,
    4.6510635344,
    4.593821736750001,
    4.56368200705,
    4.5813701589999996,
    4.621111753949999,
    4.70977821255,
    4.80806397055,
    4.791386795100001,
    4.813391645599999,
    4.878776627050001,
    4.98082721375,
    4.792695822250001,
    4.647346746249999,
    4.546482221699999,
    4.489815102500001,
    4.4755837651,
    4.3428531993,
    4.257002590499999,
    4.1894700576,
    4.1371132476,
    4.11270109705,
    4.137605859350001,
    4.150235346450001,
    4.199114331650001,
    4.2897089123,
    4.429191638449999,
    4.605581115950001,
    4.7790795205,
    4.87176761415,
    4.8584780282499995,
    4.87013985855,
    4.92148331335,
    4.908436957999999,
    4.9199481776,
    4.738539395549999,
    4.51590921235,
    4.34022999995,
    4.2130908934499995,
    4.109949049600001,
    4.04393520985,
    4.0214075404,
    4.03241511075,
    4.0921028683,
    4.118975802,
    4.1933839309500005,
    4.30760055605,
    4.46849573565,
    4.6542172518,
    4.879329124850001,
    5.105333952850001,
    5.379443268299999,
    5.218322291000001,
    5.0893492068,
    4.93189677485,
    4.7699055011,
    4.651623428100001,
    4.56802945715,
    4.4747566494,
    4.4301085676,
    4.426708121999999,
    4.4690562909,
    4.364287168950001,
    4.259233844750001,
    4.19262776765,
    4.1238868285,
    4.0951256348500005,
    4.1152544772,
    4.1774980711000005,
    4.27845642415,
    4.345751292,
    4.45477302185,
    4.5864554319,
    4.7672144415,
    4.81687868275,
    4.7835924536,
    4.79721510015,
    4.8593375211000005,
    4.9671488457,
    5.125067966999999,
    5.19496105425,
    5.18767679545,
    5.085406022100001,
    5.02997676305,
    5.016882139550001,
    5.050617598850001,
    4.9390459118,
    4.791906224500001,
    4.6939391747,
    4.64177074,
    4.4847653277,
    4.36779674175,
    4.2184018088999995,
    4.1175785207,
    4.06492739135,
    3.909926047,
    3.8017208355500003,
    3.7378858739000003,
    3.70559015265,
    3.6611334141,
    3.6642643333999994,
    3.6994210610500007,
    3.7577463903500004,
    3.8548433998,
    3.9648881924999997,
    4.12255127055,
    4.291658019800001,
    4.4984324803,
    4.7472988672,
    5.02321354725,
    5.34772066765,
    5.3780967605,
    5.4569810084000006,
    5.45490629475,
    5.50192838345,
    5.598968176550001,
    5.44261261415,
    5.3302118569,
    5.26703870635,
    5.097549733799999,
    4.9488010232,
    4.8355390555,
    4.76786480185,
    4.74908508395,
    4.77934797805,
    4.806142878999999,
    4.800632424350001,
    4.83688699985,
    4.75698406595,
    4.702731928300001,
    4.69812051325,
    4.7332473213,
    4.4968634417499995,
    4.2730907381500005,
    4.097614337400001,
    3.9575040675999995,
    3.85033178305,
    3.7806157546500003,
    3.7536339843,
    3.7755059851000006,
    3.7501484301,
    3.77258603255,
    3.7892447238499996,
    3.8547510698500007,
    3.8612250245499995,
    3.9099545690499995,
    3.925834644699999,
    3.9016690185000003,
    3.9009662436,
    3.9433321628,
    3.8364067171499996,
    3.7630729258499995,
    3.6990420095999994,
    3.6457006151,
    3.61839803115,
    3.5984903202,
    3.62249899815,
    3.6740141533499995,
    3.7726067830500005,
    3.917601200200001,
    4.1109068746499995,
    4.2135677181,
    4.2657035255,
    4.3571519367,
    4.38278991545,
    4.453665255700001,
    4.32206293565,
    4.17905721385,
    4.0821764664,
    4.02252340515,
    4.0131269856,
    3.9965440978500006,
    4.0210300351,
    4.092689849,
    4.2039842824499996,
    4.2684716969,
    4.374811283650001,
    4.5279006916,
    4.703060833050001,
    4.813763302099999,
    4.79129020245,
    4.79216012845,
    4.839905207349999,
    4.822281777000001,
    4.8505467729,
    4.920189880000001,
    5.038478189,
    4.9867902917,
    4.984435973199999,
    4.8688972736,
    4.7868853786,
    4.748966296799999,
    4.7037666621000005,
    4.7079021621,
    4.73635234375,
    4.7197392531,
    4.72266206475,
    4.769692835300001,
    4.86352300025,
    4.948999542050001,
    4.8766782183499995,
    4.7763575858500005,
    4.681424992049999,
    4.6324752582999995,
    4.6198162734,
    4.655531363950001,
    4.7335009074,
    4.85951018295,
    5.0278403884500005,
    5.16566252565,
    5.20930171855,
    5.21943779205,
    5.249044018899999,
    5.22840699975,
    5.253924594350001,
    5.326837445150001,
    5.44699125665,
    5.5337975860499995,
    5.5991384150000005,
    5.69219592325,
    5.7131229457999995,
    5.780326532999999,
    5.874779950299999,
    5.94195208805,
    6.0555648736,
    6.2204633782,
    6.4366727599,
    6.606525738900001,
    6.79795344975,
    6.977646516450001,
    7.20949277175,
    7.494752922599998,
    7.72139047275,
    7.6928737536,
    7.66777931305,
    7.691395922300001,
    7.513758879050002,
    7.346242446,
    7.18633244185,
    7.077444707550001,
    6.96319165215,
    6.8463319282,
    6.781100433200001,
    6.74998545815,
    6.7551234811,
    6.8120574237,
    6.808857950399999,
    6.797269190749999,
    6.75622544845,
    6.7047405701,
    6.6115181523499995,
    6.557192730599999,
    6.4882213959,
    6.4676193834500015,
    6.498079197199999,
    6.56958719055,
    6.5186235943,
    6.517618606499999,
    6.53950720075,
    6.5900633290499995,
    6.69162329215,
    6.8445136289500015,
    6.9538021085000015,
    7.1151655891,
    7.327803206550001,
    7.4215290859,
    7.465108932,
    7.413026811549999,
    7.3411132758,
    7.320699639550002,
    7.307180743100001,
    7.214876250900001,
    7.1337423202500005,
    7.0675807582,
    7.039045196649999,
    6.89475726295,
    6.799354387399999,
    6.64158383715,
    6.51886566195,
    6.41168599055,
    6.349776284299999,
    6.295853255300001,
    6.211917315399999,
    6.17944311805,
    6.1666703641,
    6.1389911798500005,
    6.1618615153,
    6.079904769499999,
    6.04714527355,
    5.97012164975,
    5.943237531149999,
    5.891544421100001,
    5.88640278225,
    5.869659585550001,
    5.8968603185,
    5.8104338460000005,
    5.762586828200001,
    5.7652776094,
    5.70816210775,
    5.589992197349999,
    5.5205906652,
    5.50081963455,
    5.4424424864,
    5.408963236,
    5.422838056,
    5.47003607125,
    5.479670287699999,
    5.518789427550001,
    5.5933135427,
    5.71032552625,
    5.8686359141499995,
    5.9170864551,
    5.8540254271,
    5.78152336865,
    5.622278435299999,
    5.4865309061,
    5.40232118735,
    5.23534747695,
    5.11784154975,
    5.02758732555,
    4.9855970875999995,
    4.9857911908500006,
    4.978653345500001,
    5.0056900572,
    5.0776858152,
    5.184380988849999,
    5.2941359341,
    5.4505838355,
    5.5747318555,
    5.7464225026,
    5.707992399949999,
    5.71571388525,
    5.6676194704,
    5.62084880215,
    5.623861307,
    5.667368508999999,
    5.722365875749999,
    5.73478985605,
    5.70764822915,
    5.6300217003999995,
    5.58696479465,
    5.50684348045,
    5.3511296601,
    5.24534680415,
    5.186630236,
    5.142021385950001,
    5.13827626125,
    5.13695056615,
    5.18078576965,
    5.2693136568000005,
    5.3624197223,
    5.34316562055,
    5.352190771649999,
    5.311882238299999,
    5.242500926,
    5.173986290349999,
    5.1507728793,
    5.122182181000001,
    5.092192771199999,
    5.081708191,
    5.1019670436,
    5.1718766146499995,
    5.2833618967,
    5.3202244821,
    5.366430470199999,
    5.38706923615,
    5.332142101599999,
    5.2040543581500005,
    5.103246803999999,
    5.040084856349999,
    5.015437432400001,
    5.04045409465,
    5.1037321565,
    5.1198625887,
    5.03602000725,
    5.0020627303000005,
    4.926136744599999,
    4.822280308000001,
    4.7686313775,
    4.749553111799999,
    4.74004799385,
    4.715949896349999,
    4.715294103450001,
    4.75248469365,
    4.7899702497500005,
    4.87750898805,
    4.9244135702,
    5.0205322459,
    5.0604829874,
    5.073143767100001,
    5.132940390899999,
    5.081608660700001,
    5.079620329949999,
    5.08363247565,
    5.129449144900001,
    5.187219371099999,
    5.2774606388,
    5.41800169225,
    5.583139328650001,
    5.79865880285,
    6.064298936550001,
    6.29969600215,
    6.55746464315,
    6.866491626999999,
    7.227230100349999,
    7.28527312375,
    7.2714201801,
    7.255011458650001,
    7.280233036749999,
    7.22832582095,
    7.230182074299999,
    7.2147547276,
    7.2511084162,
    7.33467083675,
    7.463405450399999,
    7.415946631600001,
    7.34333407835,
    7.24268714415,
    7.181674484000001,
    7.1029113849,
    7.03939645505,
    6.9893591327,
    6.9753336703,
    7.002424147249999,
    7.0672442028,
    7.02747154865,
    7.036472669150001,
    7.064271338199999,
    6.9966932708,
    6.98063878015,
    6.992354808350001,
    7.015803492400001,
    7.091499749549999,
    7.1179839497,
    7.08596905055,
    7.1051026985000005,
    7.160456477600002,
    7.198641420250001,
    7.2875638803000005,
    7.286632822,
    7.3372484195,
    7.4244205647,
    7.5361621975,
    7.458726381599999,
    7.4335631274499985,
    7.326757200400001,
    7.2741024996,
    7.2741573741,
    7.3201146796000005,
    7.41932361505,
    7.4812566012,
    7.501591379700001,
    7.576244244799999,
    7.65709782785,
    7.7497323287,
    7.832931158950001,
    7.874870394299999,
    7.6942772011,
    7.556758317900001,
    7.472703822749999,
    7.429568935699999,
    7.4386742006,
    7.373486693500001,
    7.1218809917,
    6.91086832965,
    6.721013070150001,
    6.5762311727,
    6.473308449500001,
    6.422130266350001,
    6.40312683715,
    6.36663480835,
    6.37925667685,
    6.408753433399999,
    6.3840622066999995,
    6.2703083734,
    6.206049114700001,
    6.1930426268500005,
    6.1768223765000005,
    6.1569268483499995,
    6.186109968899999,
    6.08213837235,
    5.966092131049999,
    5.90120038645,
    5.8396707686000005,
    5.8057890269,
    5.81442138455,
    5.757200496599999,
    5.7507457296,
    5.79462795555,
    5.693312434200001,
    5.6308121641,
    5.60699422055,
    5.4603165973,
    5.3615325144,
    5.30935368895,
    5.2741360751999995,
    5.20373334215,
    5.1813446587500005,
    5.20650872955,
    5.279731343099999,
    5.38110875725,
    5.442788610949999,
    5.5221261557500005,
    5.6488401329,
    5.7545472883,
    5.815247124950001,
    5.9201239039,
    5.8462422819499995,
    5.8142811566,
    5.7759187134,
    5.78623503625,
    5.8171889102500005,
    5.8831899000500005,
    6.000006805350001,
    6.156505167200001,
    6.2603733474,
    6.10498136555,
    5.999436875100001,
    5.893545105349999,
    5.80866941385,
    5.7606410200500004,
    5.706566863099999,
    5.5138720658,
    5.37204849655,
    5.272216954449999,
    5.214843289150001,
    5.157516359200001,
    5.14922920685,
    5.0795515481499995,
    5.0299110572500005,
    5.029539461649999,
    4.9536902745499996,
    4.924531008050001,
    4.946166125100001,
    4.9941578866,
    5.0864558171,
    5.227506554850001,
    5.2291372418,
    5.2646461175,
    5.349512989800001,
    5.4388550137,
    5.5760170032,
    5.763827993400001,
    5.9090546311,
    6.097919977699999,
    6.244095836900001,
    6.420770321100001,
    6.4338398326,
    6.49576845095,
    6.6021944579500005,
    6.7545173886,
    6.64691019335,
    6.556849558950001,
    6.49989551165,
    6.444051290999999,
    6.4119575502,
    6.3940471919,
    6.3772226481,
    6.40384581415,
    6.36888103025,
    6.3853944269500005,
    6.39635986485,
    6.421195934999998,
    6.495812475000001,
    6.504279163850001,
    6.558856496649999,
    6.40636231525,
    6.2610662639,
    6.1372308181,
    5.9629576358000005,
    5.8158317603,
    5.7202934803000005,
    5.66752382845,
    5.6400473473999995,
    5.6574778756,
    5.72419523365,
    5.70507630495,
    5.7252881011,
    5.66456008445,
    5.6491033463,
    5.6789534467,
    5.601917607450001,
    5.571496873200001,
    5.568688075849999,
    5.560778225050001,
    5.5012014681000005,
    5.4793571852500005,
    5.39273032535,
    5.34671076205,
    5.288016466149999,
    5.2770570933,
    5.2691080489,
    5.30106509705,
    5.33357809525,
    5.4164182577,
    5.518716200449999,
    5.5768578911999995,
    5.663750456200001,
    5.72730016,
    5.830639899,
    5.921815301450001,
    6.036310332000001,
    6.1643778386,
    6.289082604999999,
    6.4617716358,
    6.67916870795,
    6.870410005900001,
    7.06899583155,
    7.2974032279,
    7.2946006806499994,
    7.2961854546,
    7.3500792109000015,
    7.357127944349999,
    7.402946647850001,
    7.456390906299999,
    7.504220509449999,
    7.381007372499999,
    7.309720969350002,
    7.23101707095,
    7.157786847599999,
    7.112814473999999,
    7.095768154549999,
    7.132324849600001,
    6.9647228387,
    6.8008829663,
    6.6831616215,
    6.59508682375,
    6.46026217135,
    6.376596627349999,
    6.30301861335,
    6.184852515049999,
    5.9568762465,
    5.7803346285,
    5.6544262152,
    5.5799058489,
    5.45986056165,
    5.375139556600001,
    5.337993401,
    5.321693698150001,
    5.34025505515,
    5.409836752500001,
    5.52987730735,
    5.64438649175,
    5.809627107300001,
    5.91033385365,
    6.0150206796,
    6.16306591785,
    6.328513568400001,
    6.525696176950001,
    6.6639451429,
    6.65642683425,
    6.667604913550001,
    6.6155653703,
    6.602079321,
    6.48021772805,
    6.355948717599999,
    6.2502639267,
    6.092080765899999,
    5.982271548649999,
    5.80547090125,
    5.67299981975,
    5.57996966255,
    5.50396577025,
    5.38912446295,
    5.29010580815,
    5.223819236450001,
    5.19997311575,
    5.18422015155,
    5.1361969906,
    5.135308761099999,
    5.15612069405,
    5.195413825799999,
    5.03666917555,
    4.8863097532,
    4.776655802700001,
    4.717010405,
    4.67505342065,
    4.65526527735,
    4.658471473650001,
    4.702436963549999,
    4.794897081899999,
    4.93582809025,
    4.9108742089,
    4.935992389299999,
    5.008220012000001,
    5.07061929065,
    5.171210776150001,
    5.310491390799999,
    5.358672628350001,
    5.447382010549999,
    5.550677642199999,
    5.666406973900001,
    5.6847313012,
    5.66792638505,
    5.634738516900001,
    5.648516574149999,
    5.56424151235,
    5.505114384,
    5.49270733325,
    5.5156595810999995,
    5.436004930899999,
    5.405687669299999,
    5.3062793477,
    5.2560247163,
    5.25538805245,
    5.250858502350001,
    5.22786426045,
    5.25428185635,
    5.330103053399999,
    5.387544547199999,
    5.494872975350001,
    5.565353813550001,
    5.6699385369,
    5.6932637314,
    5.662265120950001,
    5.6601312859,
    5.689458007200001,
    5.72640142225,
    5.733365191900001,
    5.7716526832,
    5.775471324550001,
    5.8240467476,
    5.920093915100002,
    5.9572679636000005,
    6.024168094049999,
    6.128768535850001,
    6.285563241099999,
    6.4947353709,
    6.67345673965,
    6.712217949649999,
    6.735705439749999,
    6.80958221125,
    6.930672628249999,
    6.917001277599999,
    6.92850621165,
    6.867706048449999,
    6.781547718699999,
    6.7404971117,
    6.7276839056,
    6.7270854638,
    6.7763311743,
    6.848945269999999,
    6.97121689975,
    7.144190298699999,
    7.364252581450001,
    7.62901979065,
    7.9417616015000005,
    8.281291121050002,
    8.49823623645,
    8.6600416212,
    8.875084588750001,
    8.99823439375,
    9.1711396709,
    9.294231927899999,
    9.43450180835,
    9.560468764549999,
    9.69792054465,
    9.88190327015,
    9.9790503523,
    10.0850616359,
    10.20345928835,
    10.240869481349998,
    10.23421326665,
    10.0775066971,
    9.93100134665,
    9.7952441508,
    9.71554524515,
    9.654381891549999,
    9.6319349859,
    9.50664735625,
    9.434799367199998,
    9.31349459555,
    9.2081815491,
    9.11754730965,
    9.07056362935,
    8.994266583449999,
    8.9514829077,
    8.95275478965,
    8.79248478415,
    8.6865870306,
    8.55971967085,
    8.47079631845,
    8.42673351225,
    8.35027758795,
    8.2751544711,
    8.2513377987,
    8.20127065265,
    8.16364989725,
    8.058482802600002,
    7.9387744626,
    7.873223141950001,
    7.83025427545,
    7.8029013027000005,
    7.82301230715,
    7.77015185875,
    7.7525415753499995,
    7.6259942846,
    7.5491485084,
    7.5067614335499995,
    7.5040019625999985,
    7.522418662849999,
    7.5250860394,
    7.5797711649,
    7.582553925249999,
    7.5660493444,
    7.573025208300001,
    7.630248084650001,
    7.5271995003,
    7.4468394361499985,
    7.34563194055,
    7.275562919899999,
    7.2559730113,
    7.237804101650001,
    7.194234446449999,
    7.200801224399998,
    7.252931048700002,
    7.3530801087,
    7.4855993608,
    7.615277729649999,
    7.794695340499999,
    7.877869870350001,
    7.98468365965,
    8.1318343901,
    8.3283842948,
    8.119017568550001,
    7.938513855699999,
    7.80119528405,
    7.640498903999999,
    7.529144270950001,
    7.470218596599999,
    7.4542589053000015,
    7.478082581800001,
    7.55098503135,
]).reshape((2516,))

IDENTITY_LOG_VOLATILITY_MEAN_STANDARD_ERROR = np.array([
    0.0009686587671226155,
    0.00088001310523198,
    0.000898760199225109,
    0.0009226059327782523,
    0.0009244342961492821,
    0.0009231266352836516,
    0.0008921487398779833,
    0.0009106828265404698,
    0.0009351941724413935,
    0.0009324460471424583,
    0.0009203608196664113,
    0.0009237711017315495,
    0.0009029938852785524,
    0.0008638782545864068,
    0.0008888756831121416,
    0.000884930257781663,
    0.0008780741516536896,
    0.0008642959782666718,
    0.0008833786417346573,
    0.0009065112859574868,
    0.000931632384821632,
    0.0009318697303014106,
    0.0009311072535594757,
    0.0009105935090837878,
    0.000878222529076661,
    0.0009159637201511443,
    0.000945249559377127,
    0.0009588699705048771,
    0.0009508344124945868,
    0.00092903708769344,
    0.0008953936637566368,
    0.0008631870971908099,
    0.0008819660487199109,
    0.000920773117681863,
    0.0009189882976247721,
    0.000904862232431852,
    0.0008966791322067541,
    0.0008847630336658815,
    0.0008968369760250461,
    0.0008958012622753322,
    0.0008724254806007062,
    0.0008894525295466735,
    0.0008782554261140397,
    0.0008667003996695022,
    0.0008604907908824323,
    0.0008632883679800309,
    0.0008471377343389835,
    0.0008721515427749506,
    0.000870020900359833,
    0.000877211651796528,
    0.000905098403877288,
    0.0009293858513799543,
    0.0009297505486967777,
    0.0009352638739221269,
    0.0009669156811986959,
    0.0009873363171756873,
    0.000982488937568734,
    0.0009494081969197452,
    0.0009075110396314572,
    0.0009183195080566722,
    0.0009138413948310973,
    0.0008968222142702593,
    0.0008619678208357726,
    0.0008828480709288665,
    0.000903711115318289,
    0.0009187690461335742,
    0.0009177081676822002,
    0.0008931361555422155,
    0.000859888077148157,
    0.0008437334740690072,
    0.0008831894653026555,
    0.0009085811339715787,
    0.0009278825752906079,
    0.0009450331511051368,
    0.0009478004380863078,
    0.0009294141435850977,
    0.0009309569930303871,
    0.0009296331230606104,
    0.0008938395290359279,
    0.0008756594217696357,
    0.0008954878511858479,
    0.000961016236788264,
    0.0010139562922568985,
    0.0010358674638009015,
    0.0010585528436651845,
    0.0010568078533374802,
    0.0010659534985332617,
    0.0010491980568350203,
    0.0010162472703195368,
    0.0009493193357756713,
    0.0009123864040924921,
    0.0008790088791480579,
    0.0009011194316619504,
    0.0009110762454584643,
    0.0008974843405757739,
    0.0008983549105248578,
    0.0008896029533937383,
    0.0008702822092710229,
    0.0008649211466221181,
    0.0008453747206744,
    0.0008578810222008337,
    0.0008516004242612689,
    0.0008557863623787299,
    0.000858654394633629,
    0.0008387734952571493,
    0.0008405116173156388,
    0.0008630099787325425,
    0.0008693555712491667,
    0.0008584970033768913,
    0.0008353835424388865,
    0.000861429451714949,
    0.0008958201575826139,
    0.0009274911638798861,
    0.000962915585063406,
    0.0009687998795032567,
    0.0009628529326498139,
    0.0009650700615142995,
    0.000983398437307418,
    0.0009708575819202791,
    0.0009462127558917007,
    0.0009558559838426814,
    0.0009819583779265826,
    0.0009745433566488065,
    0.0009553110216036734,
    0.0009819668138847585,
    0.001008607518589405,
    0.0010338123234708535,
    0.0010341994392361704,
    0.0010114046534040813,
    0.0009814282300944794,
    0.0009392023068413517,
    0.0008809400322337097,
    0.0009085719709010382,
    0.0009155956413401072,
    0.0009320340107161694,
    0.0009445221132607381,
    0.000936226403865195,
    0.0009132454120178139,
    0.0008880819387713945,
    0.000895739326332699,
    0.0008845138242617411,
    0.0008884900706731457,
    0.0008688142796594352,
    0.0008999059901563029,
    0.0009174341665922623,
    0.0009090715989857799,
    0.0009115679532040246,
    0.0008941505092065476,
    0.0008685350842088265,
    0.0008423154337104672,
    0.0008578323418488132,
    0.0008466438246708907,
    0.000888302226507465,
    0.0009174455774874449,
    0.0009411732786469589,
    0.0009444105471619626,
    0.0009771807820899007,
    0.0009962317459020738,
    0.0010106186635123026,
    0.0009955784563414293,
    0.0009983995959234285,
    0.0009752346974966549,
    0.0009457016181703706,
    0.000939877133476628,
    0.0009203969039593839,
    0.0008705017569574889,
    0.0008866262287485801,
    0.0008979611965129189,
    0.0008816385668238832,
    0.000876010168653715,
    0.0008508263754732052,
    0.0008626570076125955,
    0.0008512799773017056,
    0.0008584582241203802,
    0.0008584007815697768,
    0.0008596704501047027,
    0.0008655950279193126,
    0.0008392097924066582,
    0.0008578309506961397,
    0.0008524536969383154,
    0.0008466953598465365,
    0.0008339656390180276,
    0.0008548966699486136,
    0.0008699457226839627,
    0.0008525097783236465,
    0.0008911636627571956,
    0.0009131572990003435,
    0.0009220454879159876,
    0.0009502985472933952,
    0.0009615226155341611,
    0.0009640224621694183,
    0.0009633104875523104,
    0.0009985751773719182,
    0.0010306232847940345,
    0.001069901132566722,
    0.001073089637021166,
    0.0010550620759318082,
    0.0010267532755551677,
    0.0009833308521935028,
    0.0009634787920048224,
    0.0009242164470094884,
    0.0009324916950367924,
    0.0009368154610796196,
    0.0009083818966726586,
    0.000875343536107379,
    0.0008729470509863802,
    0.0008601989758864768,
    0.000869671065382991,
    0.0008914276602348419,
    0.0008882742600992952,
    0.0008989075900599611,
    0.0009331936352645166,
    0.0009448533484983329,
    0.0009609546761778124,
    0.0009373754604317053,
    0.0008918658568052007,
    0.0008810909106279985,
    0.0008986406364235638,
    0.0009069209616226645,
    0.000899956784418746,
    0.0008784256609567893,
    0.000883440304529016,
    0.0009015366501628294,
    0.0008999148147382864,
    0.0009154527009539507,
    0.0009034339003128256,
    0.0009063536395389405,
    0.0008892329942861505,
    0.0008860058703599879,
    0.0009086252146653787,
    0.0009083332748059913,
    0.0009022744743187132,
    0.0008915267744077938,
    0.0008657188113052488,
    0.0008412873260895806,
    0.0008644842629484129,
    0.0008704572091230333,
    0.0008857111775079137,
    0.0008956848892596779,
    0.0008984627389479083,
    0.0008853011617024584,
    0.0008757098849183227,
    0.0008916339959251645,
    0.0008757519509188653,
    0.0008742421327248582,
    0.0009086601364937847,
    0.0009306198705344129,
    0.0009165291935508567,
    0.0008893779092536855,
    0.0008905091464937212,
    0.0008908143395369675,
    0.0008833744544219236,
    0.0008788025289767313,
    0.000867124138612066,
    0.0008800530030482136,
    0.0008823063891987731,
    0.0008766367809724157,
    0.0009174694871810351,
    0.0009370479601383565,
    0.0009084951185572341,
    0.0008925884110886097,
    0.0008690981366906059,
    0.0009160757619892246,
    0.0009377315759733626,
    0.0009347672063073158,
    0.0009450473096048434,
    0.000928995115244929,
    0.0009095406699243205,
    0.0009334681036270604,
    0.0009267617734679438,
    0.0009483103370283029,
    0.0009456745902173375,
    0.0009281869686722199,
    0.0008999174280898613,
    0.0009237743376005801,
    0.0009239561354453161,
    0.0008916227319906077,
    0.0008587500071902839,
    0.0008471487350709937,
    0.0008177919018646314,
    0.0008208178211187938,
    0.0007977630961254459,
    0.0008046347215695266,
    0.0008123701900454571,
    0.0008197274488172931,
    0.0008317488219205754,
    0.0008481710558825059,
    0.0008703347186796935,
    0.0008679392137571071,
    0.0008399558096639245,
    0.0008776545380006142,
    0.0008937857197317012,
    0.0008935696158934175,
    0.0009095741458367112,
    0.0009113151720691466,
    0.0008996215823344511,
    0.0008958976417908977,
    0.0009224544692566531,
    0.0009257064018518386,
    0.0009223280616026561,
    0.0008912775379046171,
    0.0008965550887769693,
    0.0008843984398216336,
    0.0008840574956477573,
    0.0008829188963094781,
    0.0009073324983289617,
    0.0009167621096013116,
    0.0009174814076961012,
    0.0009036595691412625,
    0.0009177493863134071,
    0.0009091425612879616,
    0.0008913155342779608,
    0.0008623165323077232,
    0.0008561085519425642,
    0.0008726765988230384,
    0.0008703950797052474,
    0.0008733923867402366,
    0.0008654308968278838,
    0.0008829982995737376,
    0.0008636723986552322,
    0.0008584135142464624,
    0.0008661826216894022,
    0.000875827978722939,
    0.000887128728650444,
    0.0008878502820801413,
    0.000874460393751008,
    0.000912902093845076,
    0.0009319109892936901,
    0.000944557785418268,
    0.0009098552679584855,
    0.0009024624891330367,
    0.0009028021032114833,
    0.0009159216101517152,
    0.0009229737597390015,
    0.0009035314135792555,
    0.0008867321415265481,
    0.0008722262105899753,
    0.0008648989394079531,
    0.00084278585112084,
    0.0008557500128025441,
    0.0008496841193497223,
    0.0008535113365296182,
    0.0008664911851631085,
    0.000869290690856449,
    0.0009078986899854723,
    0.000903007880008722,
    0.0008824754473011172,
    0.0008466467775590313,
    0.000871009587843798,
    0.0008842771932502135,
    0.0009043323596722247,
    0.0009046682034753661,
    0.0008899131311338997,
    0.0008955100330497089,
    0.0009015083977197045,
    0.0008943892945265522,
    0.0008946289200069473,
    0.0008793958438769577,
    0.0008821764812786466,
    0.000861152438869145,
    0.0008704622403624707,
    0.0008405075362713698,
    0.0008667693064217173,
    0.000901365545727507,
    0.0009085288105272077,
    0.0009127558622211206,
    0.0008960913740304727,
    0.0008552161398688008,
    0.0008614482184690851,
    0.0008701044180478386,
    0.0008830195529527058,
    0.0008755857426095028,
    0.0008870056582283088,
    0.0008757866868400889,
    0.0008603361272887592,
    0.0008315312748294809,
    0.0008567029806402463,
    0.000868225404914292,
    0.0008730023330122296,
    0.0008774150951852762,
    0.0008645095868152212,
    0.0008687252465442183,
    0.000880476121900723,
    0.0008689948519614675,
    0.0009202356930202515,
    0.0009514168486454343,
    0.0009612209305768624,
    0.0009587719592259554,
    0.0009432353070066095,
    0.0009612262493342315,
    0.0009566111507889222,
    0.0009407972589275701,
    0.0009352227173304632,
    0.0009092492121826378,
    0.0009338186486221662,
    0.0009656463735435646,
    0.0009647857347971656,
    0.0009454759886421914,
    0.000912602973463526,
    0.0009089284313019357,
    0.0009167139719361454,
    0.0009272840005039754,
    0.0009024904307663595,
    0.0008752320710130253,
    0.000877017303161291,
    0.0008454669443665972,
    0.0008843285735847883,
    0.0009095965989755649,
    0.000915202234739606,
    0.0009204778090555678,
    0.0008875842231710543,
    0.0008939419537617882,
    0.0009068681233687462,
    0.0008984497002196187,
    0.0008948708585778869,
    0.0009267187033650375,
    0.0009561028113355518,
    0.0009602466200707271,
    0.0009596079788724938,
    0.000980733385161769,
    0.0009787860607300893,
    0.000949994699714365,
    0.0009234043015790065,
    0.0009100836823322341,
    0.0009024881372146398,
    0.0008714988140085026,
    0.000846660205852523,
    0.000873172939384551,
    0.0008673691795350244,
    0.0008611383217188152,
    0.0008630963070986817,
    0.0008397605343759876,
    0.000876756311240867,
    0.000899869112252155,
    0.0009150120569292067,
    0.0009224750519914979,
    0.0009257026210823558,
    0.0009288373020286864,
    0.0008997545719320105,
    0.0008948216563620169,
    0.0008721085953666489,
    0.0009141563503288571,
    0.0009236533064393847,
    0.0009376574804757864,
    0.0009268845693231136,
    0.0009125664527856673,
    0.0008996372874093975,
    0.0008692204465732572,
    0.0008836205791692182,
    0.000860702185310733,
    0.0008495175071158431,
    0.0008609007193947011,
    0.0008620295666854944,
    0.0008652057252079945,
    0.0008777842137008717,
    0.0008615434228854478,
    0.0008845861162271573,
    0.0008924841574634028,
    0.0008987967213775703,
    0.0008860094912263424,
    0.0008971525051512738,
    0.0008802281016130888,
    0.0009093475110913542,
    0.0009340217135082762,
    0.000939505168842015,
    0.0009388110403468434,
    0.0009217822831141357,
    0.0008962392088767855,
    0.0008796062988852062,
    0.0009116390372556467,
    0.0009236196295606896,
    0.0009233245599460888,
    0.000926978041942176,
    0.0009082878146088421,
    0.000887484565526029,
    0.0008949885997106156,
    0.00089640189697486,
    0.0008770455802296229,
    0.0008826864970354164,
    0.0008757862294706166,
    0.0009109198902487919,
    0.0009350372673819483,
    0.0009346221826906228,
    0.0009227499704480252,
    0.0008816800778531404,
    0.0008612242216662781,
    0.0008738295092142963,
    0.0008560761209366745,
    0.0008697883835667629,
    0.000873621197858853,
    0.0008534864857625184,
    0.0008802112666440254,
    0.0008762234419635138,
    0.0008680788394875644,
    0.000871419254765733,
    0.0008783754378882811,
    0.0008770863955174543,
    0.0008902293261664233,
    0.0009054689631450626,
    0.0008897228004230706,
    0.0008802463359103589,
    0.0008478100744692273,
    0.0008608866035704379,
    0.000863079834792904,
    0.0008887994151395245,
    0.000885986472319587,
    0.0008770192920194375,
    0.0008519034441173905,
    0.0008873765342747484,
    0.0008998756289956334,
    0.0009055603509826412,
    0.0008991489246159744,
    0.0009241813018729669,
    0.0009092096958992193,
    0.0009348793625915487,
    0.0009179578084604941,
    0.0008887553696264321,
    0.0009150160828561253,
    0.0009125183098527554,
    0.0009057400957649701,
    0.0009025344471000784,
    0.0008693132470875514,
    0.0008626208040866863,
    0.0008598136008288638,
    0.0008579578567208034,
    0.0008342313119759539,
    0.0008328247708243168,
    0.0008580475925257248,
    0.0008613152049132139,
    0.0008586618822070396,
    0.0008496598870869987,
    0.0008279635906053034,
    0.0008892758562164538,
    0.0009422575671638461,
    0.0010183301445428276,
    0.0010547535172954483,
    0.001076102836397291,
    0.0010851923937720057,
    0.0010880670910716806,
    0.001054751688766077,
    0.0010054864956505298,
    0.0010233503106981245,
    0.001023995409658706,
    0.0009965930816776365,
    0.0009791826681643356,
    0.0009274168346390937,
    0.0009474738424541068,
    0.0009661563386358803,
    0.0009563409668910825,
    0.000939851099723252,
    0.0008890061522733957,
    0.0008998471621234469,
    0.0008935941169035585,
    0.0008615477413817036,
    0.000822569603953605,
    0.000853233807810177,
    0.0008714587824546639,
    0.0008822615228534246,
    0.0008591830739477105,
    0.0008467550911597608,
    0.0008950909578773132,
    0.0009329459944571936,
    0.0009599863412752268,
    0.0009689538294165957,
    0.0009775865457478854,
    0.0009684078694804138,
    0.0009233744737350063,
    0.0008894281185521896,
    0.0008997102038779136,
    0.0009001404360215234,
    0.0009146127534768446,
    0.000935752103262681,
    0.0009484923117990169,
    0.0009410758329528261,
    0.0009204641013411952,
    0.0009304028456316031,
    0.0009095139572388603,
    0.0008834899891145618,
    0.000906023622301329,
    0.0009169316954880558,
    0.0009008601571457391,
    0.0008815530591321852,
    0.0008698374281079715,
    0.0008805905928943047,
    0.0008749674198616638,
    0.0008516401697798788,
    0.0008618082016193523,
    0.0008541982799696411,
    0.0008732033126501418,
    0.0009062574202135059,
    0.0009105773074524904,
    0.0009072859704829485,
    0.0008723564982898161,
    0.0008687584009350632,
    0.0008849983775347889,
    0.000864988562999474,
    0.0008364046462005314,
    0.0008445750452634475,
    0.0008694082228231147,
    0.00087916985706847,
    0.0008695718423888549,
    0.0008500747850566175,
    0.0008750667827515616,
    0.0008633823859825358,
    0.0008444737136282707,
    0.0008800634279580973,
    0.0008935708852764872,
    0.0008838746063664376,
    0.0009037132776652579,
    0.0009155473310452753,
    0.0009307442306190414,
    0.0009602514527385829,
    0.0009922229380848072,
    0.0009870184927174004,
    0.0010169162002610004,
    0.0010361334317013796,
    0.0010331839362456513,
    0.001030602791606759,
    0.0010156890676018748,
    0.0009779672104642816,
    0.0009594843621897553,
    0.000914113223762316,
    0.0008957903549559576,
    0.0008693746250582817,
    0.0008609272347091262,
    0.000855783456451727,
    0.0008579789506257908,
    0.0008434897399248194,
    0.0008641343864115461,
    0.0008691743674280253,
    0.0008562258112488871,
    0.0008331044336832111,
    0.0008255143812149616,
    0.0008148439123424355,
    0.0008398170900934124,
    0.0008634233325419126,
    0.0008948323188298876,
    0.0009200387564199156,
    0.0009481102640854024,
    0.0009517269846312219,
    0.0010102327630108988,
    0.0010313537348873992,
    0.0010517213031780279,
    0.0010401585920483667,
    0.0009909638987108788,
    0.0009930106145076255,
    0.000987764795475644,
    0.0009941116570093868,
    0.0010038199268960892,
    0.0009672916472029772,
    0.0009503209078021776,
    0.0009210376735411982,
    0.0009031771968903106,
    0.0008942264791556406,
    0.000865892448071421,
    0.0008584874740397542,
    0.0008574608468565108,
    0.000897994130949726,
    0.0009271611857736752,
    0.0009375231894545906,
    0.0009596961112317825,
    0.0009796036394240629,
    0.0009726394539268148,
    0.0009576745009468476,
    0.000909195657688337,
    0.0008628517274412062,
    0.0008354028053448959,
    0.0008456348054842834,
    0.0008459821596207201,
    0.000828601273859371,
    0.000840026474584708,
    0.000843014955758212,
    0.000878147942187919,
    0.0008970196166427251,
    0.0009041757309602536,
    0.0008958024748661802,
    0.0009380122961438036,
    0.0009629165487865883,
    0.0009703156018819045,
    0.0009819440186816888,
    0.0009868654254426327,
    0.0009815208355906306,
    0.0009585641309878666,
    0.0009613585914261336,
    0.0009427835977534493,
    0.0009365011908390231,
    0.0009216639254384588,
    0.0009172479927694977,
    0.0009214066500023786,
    0.0009176125694936393,
    0.0009144051719679974,
    0.0009339176568895041,
    0.0009287527834503555,
    0.0009183112912565953,
    0.0008987085909712676,
    0.0008742074904474875,
    0.0008897947604587327,
    0.0008871347065159067,
    0.0008761653998895916,
    0.0008668938169671135,
    0.0008546128654178972,
    0.00086192827450994,
    0.0008528536410572961,
    0.0008193277323232374,
    0.0008270438776045722,
    0.0008366901186622454,
    0.0008561693716121841,
    0.0008643666932901189,
    0.0008857152032925949,
    0.0008852719560521427,
    0.0009234802702818252,
    0.0009333340322380864,
    0.0009445062419215041,
    0.0009273034390070022,
    0.0009195231995370156,
    0.0009033673021282416,
    0.0009123955449192639,
    0.0009122512660237736,
    0.0009398420332851033,
    0.0009416070396720722,
    0.0009441336131203174,
    0.0009496967752632468,
    0.0009440625624942144,
    0.0009362649087962296,
    0.0009058429820873524,
    0.0009067031041983852,
    0.000914550233229605,
    0.00091162095985944,
    0.0009339441455581394,
    0.0009301965256985027,
    0.0009135326021324019,
    0.0009250871609204906,
    0.0009314020025814234,
    0.0009155549012969858,
    0.0008965826961013475,
    0.0008864573249651296,
    0.0008649072439375723,
    0.0008698747145617692,
    0.0008692131524332796,
    0.0008526440814978523,
    0.0008692896856546939,
    0.0008541868875311476,
    0.0008733149799024449,
    0.0008637469321314289,
    0.000855291586693822,
    0.0008411613683252323,
    0.0008506697476249105,
    0.0008523356834003496,
    0.0008555773527270175,
    0.0008366716604293377,
    0.0008288363740930007,
    0.0008489304745398115,
    0.0008398589236845715,
    0.0008579409597531529,
    0.0008733869678131372,
    0.0008867433736515796,
    0.0009047501891191283,
    0.0009266234191724778,
    0.0009369144834855274,
    0.0009226032373397259,
    0.0008885453271078475,
    0.0008909099292508403,
    0.0008987434573130319,
    0.0008953497417095531,
    0.0008675594248081025,
    0.0009040540065515863,
    0.0009364437731507091,
    0.000948788231172458,
    0.000954620285307247,
    0.0009613552985562746,
    0.0010001468481295318,
    0.0010017355936889143,
    0.0009922091914006301,
    0.0009826821037462422,
    0.0009920321763529348,
    0.0009985768478458766,
    0.0009673869268695047,
    0.0009579667181601707,
    0.0009227640087131476,
    0.0008856779550977741,
    0.0009184781085962619,
    0.0009207406708300096,
    0.0009063111953193481,
    0.0009138449150476684,
    0.0009290842183369301,
    0.0009225897649635423,
    0.0009187135537979753,
    0.000897974548865277,
    0.0008697876975206476,
    0.0008517657915043793,
    0.0008670740743949375,
    0.0008749065302971934,
    0.0008822711024543644,
    0.0008721017073483399,
    0.0008613519057317176,
    0.0008741506365457538,
    0.0008601859937051805,
    0.0008461801468125263,
    0.0008701214872490487,
    0.0009005980909985083,
    0.0009063614715870452,
    0.000916066975813309,
    0.0009005751299291078,
    0.000923517438559671,
    0.0009131704971545523,
    0.00088869902128227,
    0.0009012488551288371,
    0.0009290221623588183,
    0.0009281170447324957,
    0.0009251647704558167,
    0.000913816172828683,
    0.0009008454745162071,
    0.0008732084919456168,
    0.0008990307146202704,
    0.0008906534207719948,
    0.0009040896229616035,
    0.000920035019250989,
    0.0009246562695633091,
    0.000926713911704262,
    0.0009081887153687961,
    0.0008927372164351851,
    0.000866936111591936,
    0.0008756200906068613,
    0.0008587592152138009,
    0.000857863317601405,
    0.0008417437118882321,
    0.0008281831373514667,
    0.0008430241192344854,
    0.0008247048035759524,
    0.0008428240331311825,
    0.0008580283160316349,
    0.0008576790471139889,
    0.0008403244101802298,
    0.000859959347036764,
    0.0008876387788167788,
    0.0009123775339883983,
    0.0009062602701306525,
    0.0009262554523698073,
    0.0009465559383586151,
    0.0009460804282125213,
    0.0009460370736101079,
    0.0009324082680358789,
    0.0009275549185022695,
    0.0009248045715243316,
    0.0009310019634752124,
    0.0009167519461689623,
    0.0008986976618078057,
    0.0008741361494402186,
    0.0008445034436715441,
    0.0008506489637410345,
    0.0008694427111541176,
    0.0008876549189069042,
    0.0008709296973519036,
    0.000890732380047533,
    0.0009045764230909645,
    0.0009133945184491833,
    0.000922083649864776,
    0.000905283517962396,
    0.0008876995285439423,
    0.0009289532717137965,
    0.0009628879519422701,
    0.0009930458564065031,
    0.0009999689457593347,
    0.0009823387745922197,
    0.0009662347086590187,
    0.0009392042116567764,
    0.0009362710072978297,
    0.0008971481445483646,
    0.0008586427118833681,
    0.0008721505577075249,
    0.0008611988677360179,
    0.0008484703891102647,
    0.0008709398358140131,
    0.0008774468020503293,
    0.0008724659128813633,
    0.0008635004000439269,
    0.0008380279695294459,
    0.0008656269910417055,
    0.0008836706990309757,
    0.0008994420564379601,
    0.0009268725277865353,
    0.0009467272136403897,
    0.0009674458742338484,
    0.0009722706580555607,
    0.000969213735605626,
    0.0009263787802103219,
    0.0009586514687002803,
    0.0009693279644050448,
    0.0009596779949382436,
    0.0009847095340374439,
    0.0009780238409139836,
    0.0009330836574788008,
    0.0008863542574729426,
    0.0008917481355449821,
    0.0009068048404599828,
    0.0009210214569916296,
    0.000926115785184205,
    0.0009089696397180833,
    0.0008928146056910164,
    0.0008537021758134667,
    0.0008284641165983435,
    0.0008481872762617516,
    0.0008485719190763799,
    0.0008383674119239271,
    0.0008401176654848072,
    0.0008291027173346778,
    0.0008252859689384175,
    0.0008520195812196581,
    0.0008611477240552354,
    0.0008615670324995066,
    0.0008616293762681177,
    0.0008877892012417188,
    0.000883973703596467,
    0.0009173738448345507,
    0.0009255960952034729,
    0.0009460332387446206,
    0.0009519864565514381,
    0.0009463156530814399,
    0.0009550862085797988,
    0.0009680722783348408,
    0.0009726663621504817,
    0.0009859598960149836,
    0.0009705508726838418,
    0.0009368260659504007,
    0.0009125367172410024,
    0.0008683547481878009,
    0.0008585624606953974,
    0.0008888890535805102,
    0.0009198226126480179,
    0.0009338711300057889,
    0.0009303020738995557,
    0.0009197373901869924,
    0.0008988732298177198,
    0.0008764613358602823,
    0.0008814920778095092,
    0.0008735657494018761,
    0.000883288198717334,
    0.0008794333958726444,
    0.0008981576308332893,
    0.0009193813762822841,
    0.0009234354585755316,
    0.0009196101540810587,
    0.0009053045928372486,
    0.0009158891861291626,
    0.000903593098855074,
    0.000890377245508078,
    0.0008899666338985049,
    0.0008960822413897602,
    0.0008766188592846767,
    0.0008441969010982709,
    0.0008406633051218778,
    0.0008463544840549882,
    0.0008428578949304839,
    0.000824013222358944,
    0.0008494567945534316,
    0.000866437985801934,
    0.0008741773712780919,
    0.0008721758140016267,
    0.0009199951803338954,
    0.0009342484547151378,
    0.0009503010130522046,
    0.0009501282004652121,
    0.0009500457163475462,
    0.0009341472974668445,
    0.0009551244419850604,
    0.0009545657967085523,
    0.0009838087127013921,
    0.0009825199420397217,
    0.0009668175166599954,
    0.0009416400595240251,
    0.0008935570232096646,
    0.0009022504587502968,
    0.0009127275922457385,
    0.0008861461928952054,
    0.0008589741106226748,
    0.0008653071027935275,
    0.0008564996805946912,
    0.0008515473454971212,
    0.0008609316589082443,
    0.0008724221252576585,
    0.0008630948685455277,
    0.0008602314505868464,
    0.0008899633359313214,
    0.0008964076832992913,
    0.0008970435402387747,
    0.0009208210430652087,
    0.0009283814416495488,
    0.0009573803788598683,
    0.0009746295603023497,
    0.000968234752577171,
    0.0009468615403635139,
    0.0009064626282765029,
    0.0009130658344434932,
    0.0009282151334530116,
    0.0009258532657539289,
    0.0009019844266683805,
    0.000870163477017497,
    0.0008942547896176752,
    0.0009024179857806604,
    0.0009074437611990852,
    0.0008841847374412813,
    0.0009146487272839594,
    0.0009265965197311241,
    0.000916474466831791,
    0.0008844403559292137,
    0.0009040971989871997,
    0.000926589818698716,
    0.0009353455649334382,
    0.0009237054680993356,
    0.000900413998401818,
    0.0009208908124483695,
    0.0008909327844650311,
    0.0008764927480329094,
    0.0008715916483713383,
    0.0008830950281900958,
    0.0009124936694882657,
    0.0009179381844130435,
    0.0009105936490107057,
    0.0009041482772037506,
    0.0008912184588689302,
    0.0008570588077706585,
    0.0008582163726529848,
    0.0008859631583180155,
    0.000903440771307703,
    0.0009129614651296241,
    0.0009168808565554044,
    0.0009029074307232742,
    0.0009003997203830611,
    0.0008702094841092035,
    0.0008541897542744589,
    0.0008165436546278091,
    0.0008335692400862721,
    0.0008367888278958406,
    0.0008455373068847068,
    0.0008603879305885315,
    0.0008524301849190707,
    0.0008471337980455457,
    0.0008702770967823194,
    0.0008903791011013355,
    0.0008849410530758486,
    0.0009053628743929552,
    0.0009071179137507899,
    0.0008807582217971432,
    0.0008980019203005107,
    0.0009405438902460603,
    0.0009665950796859847,
    0.0009667082606637293,
    0.0009666035417379128,
    0.0010093556741952077,
    0.001019802620575203,
    0.001028769713439043,
    0.0010203385744606028,
    0.00101562408346535,
    0.0010031065258920464,
    0.0009663669435352326,
    0.0009307680021321781,
    0.0009226124228499973,
    0.0009108129473219048,
    0.0009225247556510308,
    0.0009234079037353536,
    0.000903095418731682,
    0.0009042204937283306,
    0.000885412140934436,
    0.0009077050760428685,
    0.0009073426914099434,
    0.0008996751618104225,
    0.0008702323224751982,
    0.0008719756544066747,
    0.0008600817370511296,
    0.0008432421101775783,
    0.0008538038560645483,
    0.0008829046390087418,
    0.0008687012605454313,
    0.0008643463998344634,
    0.000867054728188756,
    0.0008571069691595514,
    0.0008703306616037782,
    0.0008467744400211362,
    0.0008382671312367535,
    0.0008472134814447609,
    0.0008538708003168591,
    0.0008475628322019358,
    0.0008661818256078431,
    0.0008747747261181627,
    0.0008667205058145403,
    0.0008383483194701403,
    0.0008445980473296862,
    0.000833997533160172,
    0.0008569481771290112,
    0.0008519006270723286,
    0.0008687164947457634,
    0.0008746299945004352,
    0.0008557548935848435,
    0.0008860659496755449,
    0.0008751332361863106,
    0.0008720441127255654,
    0.0009173262780811195,
    0.0009430622607179018,
    0.0009505219257755003,
    0.000996886317305198,
    0.0010467614089203694,
    0.0010676481722237782,
    0.0011209996073404517,
    0.0011391698377277916,
    0.0011404686337770026,
    0.0011385421113594841,
    0.0010958416204480575,
    0.0010376220643493021,
    0.0010425060065421808,
    0.0010271003587849195,
    0.001000232808777731,
    0.0010085821649560467,
    0.0009982373129187134,
    0.0009791197253657717,
    0.0009616863353126665,
    0.000920228825523368,
    0.0009196961401149775,
    0.0009262677710054978,
    0.0009236407543946169,
    0.0009178352217880044,
    0.0008789806131998315,
    0.0008695845530073804,
    0.0008214377549080468,
    0.0008239622483886939,
    0.0008201088376255171,
    0.0008388989411953227,
    0.0008350746354592298,
    0.0008257127240220184,
    0.0008130790966487058,
    0.0008604720587328433,
    0.0009121682300977533,
    0.0009635816519787439,
    0.0009773191355759653,
    0.0009738353525263583,
    0.0009749053769250716,
    0.0009393085628348846,
    0.0009068480417473623,
    0.0008975012046719173,
    0.0008608254252383841,
    0.0008687380717159285,
    0.0008699575924889476,
    0.0008537194480559351,
    0.0008802877468382428,
    0.0008965751867182266,
    0.0008896658686151623,
    0.0008811322086980901,
    0.0008704820865956843,
    0.000861614795113497,
    0.0008812088246849528,
    0.0008860777714020032,
    0.0008605521377758616,
    0.0008612744261742128,
    0.000854706488466779,
    0.0008384675658118758,
    0.0008232235917734095,
    0.0008298385748884244,
    0.000834248330496016,
    0.0008427642691244292,
    0.0008403698237953345,
    0.0008597425059805253,
    0.000864383572512563,
    0.000895713869783977,
    0.0008960206956058423,
    0.0008948048543766845,
    0.0009267660642566782,
    0.0009190908142629699,
    0.000962258126233732,
    0.0010218786149699221,
    0.00104548370955969,
    0.0010500213710035885,
    0.0010307925384535092,
    0.001056609649069345,
    0.0010648021575761178,
    0.001078666729434208,
    0.0010408820369985528,
    0.001001212733195096,
    0.0009490479691986137,
    0.0009386362079173872,
    0.0009145231590112811,
    0.0008938827476616909,
    0.0008514653451411294,
    0.0008542635513935048,
    0.0008285405887901437,
    0.0008344883022496231,
    0.0008269540578861567,
    0.0008350352852176764,
    0.0008316002658257806,
    0.0008461355533533981,
    0.000840314685355264,
    0.0008601463395880716,
    0.0008613947288222963,
    0.0008734284880868462,
    0.000856277709809094,
    0.0008421997903623508,
    0.0008739742063398545,
    0.000884039988496491,
    0.0008654990543247494,
    0.0008796433254054355,
    0.0008990075390178104,
    0.0009171946759168982,
    0.00091869068007772,
    0.0009457162363913996,
    0.0009684114364452171,
    0.0009564707519803227,
    0.0009518599563135593,
    0.0009389283811963703,
    0.000944949029979607,
    0.0009251192020926466,
    0.0009182100032405155,
    0.0008775439815037693,
    0.0008795470356743921,
    0.0009054343932787443,
    0.0009213055606665518,
    0.0009393459215638427,
    0.000938079496485977,
    0.0009094623951411207,
    0.0009073198051261251,
    0.0008910329898248974,
    0.0008462975274595011,
    0.0008516513715152608,
    0.0008576613275138275,
    0.0008455724433523953,
    0.000871164581329484,
    0.0008686298873492073,
    0.000849297335497441,
    0.0008759306142532943,
    0.0008901013417585602,
    0.0008986935867289243,
    0.0008805187631175659,
    0.0009383354953784668,
    0.0009617188452431998,
    0.0009836985726000976,
    0.0009867059558596257,
    0.0009661999945016389,
    0.000931669865608327,
    0.0008721771397202607,
    0.0008725232553077752,
    0.0008919761924916554,
    0.0008988014766617127,
    0.0009296449092615935,
    0.0009243717674496611,
    0.0009194212937310023,
    0.0008867748213960975,
    0.0009047641648170215,
    0.0008917449956237029,
    0.0008884837504986382,
    0.0008703438775669659,
    0.0009015220509461687,
    0.0008935050617481985,
    0.0008988427006827287,
    0.0009088616131900934,
    0.0009120741298473012,
    0.0008891897006894631,
    0.0008995117252755048,
    0.0009132362600147043,
    0.000904726979939139,
    0.0008822522371652845,
    0.0008775487596266525,
    0.000867314672838945,
    0.0008338316764395985,
    0.0008562108086303519,
    0.0008619350488565702,
    0.0008810282149510101,
    0.000877316318131026,
    0.000859788852366448,
    0.0008415033749343205,
    0.0008681016673639233,
    0.0008601954296587274,
    0.0008606820530865234,
    0.0008805893636909168,
    0.0009171999679632466,
    0.0009225332101350557,
    0.0009583545900770638,
    0.0009608472182646249,
    0.0009515272801552383,
    0.0009478197223823531,
    0.0009126327034986018,
    0.000894882917526269,
    0.000905111054218756,
    0.0008973386342908808,
    0.000922103730898108,
    0.0009839831295670777,
    0.0010099949475103488,
    0.001014998650670156,
    0.0010100122244638852,
    0.000989253970278247,
    0.0009672534433295914,
    0.0009545906532324853,
    0.0009192980676857266,
    0.0009215917198478312,
    0.0009648531973739647,
    0.0009886369596620972,
    0.0009864794360263344,
    0.0009590973455241737,
    0.0009185793784323058,
    0.0008640826769216401,
    0.0008058209023013564,
    0.0007872934138168259,
    0.000789027891122709,
    0.0008015039744365175,
    0.0007945820924079481,
    0.000805978833600265,
    0.0008312604954710426,
    0.0008444023688353134,
    0.0008326013672857257,
    0.0008433176181461787,
    0.000867301878250238,
    0.0008599044027353152,
    0.0008579756473747956,
    0.0008788378700891506,
    0.0009271003854756492,
    0.0009447321705672355,
    0.0009484716710914674,
    0.0009293009711748792,
    0.0009239811201668866,
    0.0009270509759075049,
    0.0008961288024371745,
    0.0008982692061727504,
    0.0008957827461274248,
    0.0009042652144594436,
    0.000913668059421634,
    0.0008736356219831696,
    0.0008334725177057235,
    0.0008586161502733816,
    0.0008538697713465646,
    0.0008725462801760968,
    0.0008620282109023212,
    0.0008546881590962022,
    0.0008955428378648284,
    0.0009157327468425855,
    0.0009209415608515584,
    0.0009322854961953536,
    0.0009368245397356438,
    0.0009264264764564623,
    0.0009019745486178359,
    0.0008845344302899416,
    0.0009152561353337017,
    0.000928017819513749,
    0.0009265342113057621,
    0.000896811223489259,
    0.0008609300753233294,
    0.0008703139740743238,
    0.0008909333952693772,
    0.0008931038647329907,
    0.0008755196456781975,
    0.0009079547531324156,
    0.0009021758300096795,
    0.000884176972044243,
    0.0009131708215125899,
    0.0009204652581299006,
    0.0009181487864233295,
    0.0009169681794999261,
    0.0008916094198666325,
    0.0009060147780762951,
    0.0008877605646968106,
    0.0008527578313030434,
    0.000860262034802596,
    0.0008574164169906591,
    0.0008854905257133286,
    0.0008740141553087233,
    0.0009215712908293215,
    0.0009628964064867621,
    0.0009931678433587124,
    0.0010089177321734373,
    0.0010067655624894033,
    0.000984810647954051,
    0.0009399055748713864,
    0.0008929565684701464,
    0.0008660832523630812,
    0.0008633441956367379,
    0.0008439482791645211,
    0.0008584297902995257,
    0.0008684288576938972,
    0.0008826904155072045,
    0.0008718092047160508,
    0.0008496207423103459,
    0.0008530693020183515,
    0.0008462890990262147,
    0.0008409175465702045,
    0.0008435478266607815,
    0.0008479485070671543,
    0.0008838034785949155,
    0.0008891004664711522,
    0.0008939165381080883,
    0.0009152577853438631,
    0.0009362157105919576,
    0.000915200800305585,
    0.0008941751800114639,
    0.0008828446920236461,
    0.0008697449875519791,
    0.0008860408991962414,
    0.000866740198939913,
    0.0008463420078820377,
    0.0008705659885175416,
    0.0008830384305749939,
    0.0008630618325653034,
    0.0008375476628943944,
    0.0008368846474365658,
    0.0008297867887603513,
    0.0008528095010023953,
    0.0008728221502905636,
    0.0008795168810024737,
    0.0008665122080155882,
    0.0008609910848467189,
    0.0008708701355694643,
    0.0008834375726233096,
    0.0008763850930759829,
    0.0008550208622234652,
    0.0008689262422969546,
    0.0008699238248057398,
    0.0008826845066973201,
    0.0008805534669226904,
    0.0008510561920421307,
    0.0008654298076722071,
    0.000894575826485743,
    0.0008929916611539241,
    0.0008812920619235124,
    0.0008631436534252915,
    0.0008543968367673776,
    0.0008546269593275854,
    0.000868008928778572,
    0.000871942861058635,
    0.0008593417631430379,
    0.000860814937087351,
    0.0008820067303919104,
    0.0008783291451602666,
    0.0008852362082620285,
    0.0008629827951476324,
    0.0008422576903701957,
    0.000878278953104707,
    0.0009064897057928739,
    0.0009136259728151947,
    0.0008989867561969427,
    0.0008792672455148878,
    0.0008907049233177012,
    0.0008881691959384602,
    0.0008676020848784026,
    0.0009100158547883343,
    0.0009344395292985186,
    0.000930635396306951,
    0.0009284338225077854,
    0.0009565627549575367,
    0.0009729948757975465,
    0.0009655014021555668,
    0.0009412157295428607,
    0.0009448075127746933,
    0.000946301208466861,
    0.0009029950915493758,
    0.0009093148643461139,
    0.0009069653716651724,
    0.0008907040310665033,
    0.0008822233932694028,
    0.0008638900611195041,
    0.0008626408141424176,
    0.0008519071298958561,
    0.0008695307096095544,
    0.0008741992540956663,
    0.000866432099863934,
    0.0008651358708679177,
    0.0009044222243500434,
    0.0009224604673269064,
    0.0009203875100084899,
    0.0009531252822262522,
    0.000965035999518648,
    0.0009495943112948146,
    0.0009771723549253937,
    0.0009761120995238171,
    0.0009680267835782121,
    0.0009366839187022688,
    0.0008921137141686301,
    0.0008843585063598264,
    0.0008704863547964215,
    0.0008574698280611303,
    0.0008727264549461785,
    0.0008881759539009855,
    0.0008961591547952289,
    0.0008763022100037143,
    0.0008432615225154578,
    0.0008469917253127458,
    0.0008689163361522924,
    0.000853372227099461,
    0.0008525372574447216,
    0.000837196576070838,
    0.000860591713316158,
    0.0008768868027334038,
    0.0008805012885342518,
    0.0008852117725686408,
    0.0008577940524676932,
    0.0008875959118589128,
    0.000938210616140949,
    0.0009727382756240416,
    0.001017242593820871,
    0.001032730037441847,
    0.0010313501847608374,
    0.0010133936586380777,
    0.0010198128764537496,
    0.0010304831201009528,
    0.001006732595472133,
    0.0009805758113127358,
    0.0009336957106256106,
    0.0009296478786034529,
    0.000956575895426042,
    0.0009628418693596033,
    0.0009517237764282882,
    0.0009540897414963936,
    0.0009292205615563291,
    0.0008960697612944351,
    0.0008589094680310223,
    0.0008052942921076843,
    0.0007777125113285234,
    0.0007877209995703483,
    0.0007930998622560948,
    0.0008031906930697916,
    0.0008115058931353767,
    0.0008342794045480484,
    0.0008368427642265901,
    0.0008623490637546389,
    0.0008668150528279065,
    0.000850331099381361,
    0.0008872142434071307,
    0.0009040806417300116,
    0.0009432588541319497,
    0.0009452089690729118,
    0.0009709030191759606,
    0.0009828983409793468,
    0.0009763763242647569,
    0.0009604516903888907,
    0.000955964898088787,
    0.000965820558345761,
    0.0009744146439282701,
    0.0009966360988285328,
    0.000991495462134657,
    0.0009767567591122055,
    0.000958928367942783,
    0.0009231133116690924,
    0.0008754976469908522,
    0.0008785402248475965,
    0.0008779334669933138,
    0.0008612043211260011,
    0.0008959173890637251,
    0.0009175227176492478,
    0.0009019444238911074,
    0.0008935855749083083,
    0.0009199744261634626,
    0.0009284881280762074,
    0.0009105868195398309,
    0.0009396331235078043,
    0.0009660970628858131,
    0.0009823749027774952,
    0.0009938063944084272,
    0.0009850702983203985,
    0.0009568511379426035,
    0.0009704060509466611,
    0.0009861040095149173,
    0.0009461795880245815,
    0.00095757157236276,
    0.0009641751109165666,
    0.0009656400831697592,
    0.0009275627998329726,
    0.0009144364880486386,
    0.000885576868290515,
    0.0008375251821193942,
    0.0008046248903921038,
    0.000819086826227238,
    0.0008176444981734331,
    0.0008378326859581719,
    0.0008385611075082454,
    0.0008705912091846306,
    0.0008932604838999982,
    0.0009011341259452068,
    0.0008690319344033648,
    0.0008723950381050256,
    0.0008783227974897315,
    0.0008644620898567431,
    0.0008806432866157437,
    0.0008806748524057402,
    0.0008702585824133332,
    0.0008732080757041782,
    0.0008789328662957206,
    0.0008870027412789059,
    0.0009073239226825787,
    0.0009236816575107265,
    0.0009102612776818035,
    0.0009023811807342799,
    0.000874751670158472,
    0.0009169068874446237,
    0.0009434490278105378,
    0.0009648188542803709,
    0.0009515615484974497,
    0.0009483640067909477,
    0.000980130930887111,
    0.000995622080655159,
    0.0009864551545843469,
    0.000951922003826607,
    0.0009421769902407027,
    0.0009551540495649931,
    0.0009404611436300533,
    0.000922128197812281,
    0.0009057234375402512,
    0.0008675681399138113,
    0.0008614655503127744,
    0.0008564512845780503,
    0.0008435778003836533,
    0.0008068070647788657,
    0.0008318894736988014,
    0.0008252534798694832,
    0.0008621670544004228,
    0.0008747444510432497,
    0.0008954398105192433,
    0.0008831525281841159,
    0.0009056448350913792,
    0.0009063481880594637,
    0.0009113061469993749,
    0.0009115376488494939,
    0.0009313634441620602,
    0.0009436755332953773,
    0.0009241824869563169,
    0.0009111299503818981,
    0.000931972400278802,
    0.0009212759738018792,
    0.0009115351219695632,
    0.0009087659132924327,
    0.0008886039975913205,
    0.0008646204439466704,
    0.0008410719696351828,
    0.0008575955045723945,
    0.000861957029086268,
    0.0008783040613516459,
    0.0008717417488844912,
    0.0008577133034056338,
    0.0008912903801500473,
    0.0009166228276888499,
    0.0009227325528863532,
    0.0009178170174166811,
    0.000929288928087424,
    0.0009298124392079697,
    0.0009330472435017153,
    0.0009054792164957822,
    0.0008751743261339879,
    0.0008889849332984114,
    0.0008814063971588299,
    0.0008673974234757837,
    0.0008787282127112173,
    0.0009049556450916858,
    0.000907141830593843,
    0.0009173360318891754,
    0.0009433375468836778,
    0.0009524479366196343,
    0.0009477347199693622,
    0.0009480028223544946,
    0.0009394447625721438,
    0.0009288332251760521,
    0.0009087975766732139,
    0.0008947645306173025,
    0.0008821725180387383,
    0.0008496539603088104,
    0.0008473267266704873,
    0.0008817950771978886,
    0.000890288110795972,
    0.0008637484625168887,
    0.0009054233390043712,
    0.0009180617000057477,
    0.0009122610237416183,
    0.0008854771576407814,
    0.0009112046096940327,
    0.0009401291863875958,
    0.000932023043818019,
    0.0008969239841313537,
    0.0009040465536963459,
    0.0008941713637514015,
    0.0008966492195028856,
    0.0008872053184892525,
    0.0009058857573831713,
    0.0009111810545847764,
    0.0008938933199646864,
    0.0009215757125080588,
    0.0009474432314872648,
    0.0009421570997054815,
    0.0009188546753626526,
    0.0008825773034019649,
    0.0008381006821493968,
    0.0008488788736463384,
    0.0008852252682686014,
    0.0008854142654018687,
    0.00089045531254281,
    0.000909554735565631,
    0.0009314137223005678,
    0.0009115690023861873,
    0.0008968687497031224,
    0.0008705692365680246,
    0.000848244384380076,
    0.0008726655697410389,
    0.0008833407012830264,
    0.0008736989689137494,
    0.0008287649705752131,
    0.0008703861419199993,
    0.0008936321639099921,
    0.0009234550194947336,
    0.0009123617546996451,
    0.0008914849453283578,
    0.0009239350794062028,
    0.000950557586089509,
    0.0009625532431384644,
    0.0009754950681257541,
    0.0009835172397634965,
    0.0009791510169052061,
    0.0009971915664773539,
    0.0009824823556997737,
    0.0009680003894246625,
    0.0009318034728375341,
    0.0008756219678148324,
    0.000848714281793173,
    0.0008336083196613888,
    0.000842138226351057,
    0.0008513956856737799,
    0.0008394292361761377,
    0.0008396490607723593,
    0.0008214994507096611,
    0.0008630047094373889,
    0.0009111714577428493,
    0.0009547529520021416,
    0.0009852489788750919,
    0.0010316173908117118,
    0.0010497237248973735,
    0.0010620111403350956,
    0.0010437607054850394,
    0.001019666363728219,
    0.0010303119155834174,
    0.0010231459216546964,
    0.0009979868458204382,
    0.0009544821994683984,
    0.0009083254487700299,
    0.0008697489995014808,
    0.0008355742826685147,
    0.0008049896290393781,
    0.0008298683795393878,
    0.0008365262571898377,
    0.000854160679492644,
    0.0008839281092390233,
    0.0008938943703317172,
    0.0008995460688702607,
    0.0009412148016984943,
    0.0009502483849299446,
    0.0009405337194389999,
    0.0009188505400833505,
    0.0009435008814690974,
    0.0009752616900064369,
    0.0009868117971292873,
    0.0010153260190486188,
    0.0010341315876726763,
    0.0010241684886979573,
    0.0010036410888843309,
    0.0009656421374908235,
    0.0009646542904721763,
    0.0009511087238798728,
    0.0009225373195697512,
    0.0008853538437408139,
    0.0008731575553410104,
    0.0009032423534285299,
    0.0009227196208640126,
    0.0009109073486831127,
    0.0008894239643258704,
    0.0008637678569397364,
    0.0008356003564757575,
    0.0008402554711545318,
    0.0008704081069899016,
    0.0008718208425400613,
    0.0008777686201630656,
    0.0008460187583431879,
    0.0008553457526533985,
    0.0008802570610582037,
    0.0008958019807292823,
    0.0008795490551604426,
    0.0009120944475285247,
    0.0009146693090604428,
    0.0009487427282991682,
    0.000959573134980454,
    0.0009410351535835093,
    0.0010077172566273732,
    0.0010359472605671854,
    0.0010551114971754534,
    0.001052791181951924,
    0.0010784577352879825,
    0.0010897823571565598,
    0.001093372456260903,
    0.0010834084827312882,
    0.0010651428806488386,
    0.00105523686269013,
    0.0010113918623791498,
    0.0009927172119380263,
    0.0009475009425638067,
    0.0008951562725703508,
    0.000855288947663294,
    0.00081476811463566,
    0.0008275780116315503,
    0.0008068888003949696,
    0.0008243996721668765,
    0.0008353749025432686,
    0.0008078602009616537,
    0.0008294588108246029,
    0.0008519617940715404,
    0.0008310782636725254,
    0.0008648839508410712,
    0.0008884768414722514,
    0.0009352261636177571,
    0.0009439145651096573,
    0.000928952755032525,
    0.0008984729488261331,
    0.0008726079377271198,
    0.0008771032433978986,
    0.0008591160712261429,
    0.0008900766036545631,
    0.000896717728470886,
    0.0008879713534150466,
    0.0008478143703810468,
    0.0008854073855873102,
    0.0009201081302710746,
    0.0009444166348526684,
    0.0009610470717722079,
    0.0009804741395574934,
    0.0009859459382012793,
    0.0009772585768614184,
    0.0009507703933683407,
    0.0009526808970262744,
    0.0009366124524110814,
    0.0009256588750858688,
    0.0009034687550770066,
    0.0009066498797919744,
    0.0008946942510041598,
    0.0008806794129231223,
    0.0009013185211884596,
    0.0009008370989156468,
    0.0008772035464959533,
    0.0009038850446401336,
    0.0009078148459402572,
    0.0009193512969588338,
    0.0009353806730064002,
    0.0009411883126338505,
    0.0009590998449029019,
    0.0009629780669556442,
    0.0009609527489843294,
    0.0009454365598819834,
    0.0009135343363382467,
    0.0008764571361405516,
    0.0008664443793062195,
    0.000865560936847747,
    0.0008518077729596071,
    0.0008566156200587023,
    0.0008408532786985981,
    0.0008662501697040304,
    0.0008981478668286856,
    0.0009324835080821211,
    0.0009609742169534988,
    0.0009629273373551652,
    0.0009820937178936053,
    0.000980082361691939,
    0.0009652515281689129,
    0.000935739818412974,
    0.0009493693454833821,
    0.0009324194771967472,
    0.0009159720394090692,
    0.0008799392088287457,
    0.0008687211583940425,
    0.0008823701029208292,
    0.0008801674407476348,
    0.000856041023344652,
    0.0008789200035963851,
    0.0008902983835074208,
    0.0008751494929819025,
    0.0008540726857934861,
    0.0008724637267201037,
    0.0008640911820323488,
    0.0008841588514846309,
    0.0009121124507263596,
    0.0009028195185315123,
    0.0009174146933491576,
    0.0009032150836961783,
    0.0008853972676965168,
    0.0009032037029029565,
    0.0009165059774876509,
    0.0009088258705815523,
    0.0008932239613462591,
    0.0008723325642176728,
    0.0008865182060052916,
    0.0009086138630231243,
    0.000947192099211788,
    0.0009754010376269977,
    0.0010066573455368537,
    0.0010110045949721256,
    0.0009896511554192697,
    0.0009538289802712925,
    0.0009066074541716939,
    0.0008900323447716664,
    0.000894330329064633,
    0.0009122544615561441,
    0.0008993290527663861,
    0.0009380130796876707,
    0.0009431931776323146,
    0.0009413157452303501,
    0.0009078903313203462,
    0.0008998447661721034,
    0.0009058063488221817,
    0.0009017553123750188,
    0.0009293623439659087,
    0.0009292849687090562,
    0.0009291001227551961,
    0.000941008339690153,
    0.0009498791764490924,
    0.0009285014883856832,
    0.000887354079630838,
    0.0008791961710941609,
    0.0008509645982930576,
    0.0008565358551184126,
    0.0008379669433255602,
    0.0008057166917479166,
    0.0007818598947409755,
    0.0008102028667777584,
    0.000810256177105214,
    0.0007881280421965218,
    0.0008103382381478342,
    0.0008307269559439926,
    0.0008623529171133093,
    0.0008681808192366496,
    0.0008965298546080595,
    0.0009115586440548143,
    0.0009289442069934599,
    0.0009363144675105965,
    0.0009212181561653501,
    0.0008902089864697228,
    0.0008934644676172958,
    0.0008947925177972804,
    0.0008996954493969028,
    0.0008996378995681741,
    0.0009258421550326953,
    0.000931023936936447,
    0.0009501259488625444,
    0.0009751289223898428,
    0.0009498968377514292,
    0.0009077049117891105,
    0.0009449702579430415,
    0.0009451376913579419,
    0.0009598375291608618,
    0.0009625409113287123,
    0.0009402011504013027,
    0.0008936655075853609,
    0.0008870366434183342,
    0.0008609328177509661,
    0.0008307466042059802,
    0.0008200916660936518,
    0.0008176708858854513,
    0.000820531137061739,
    0.0008435636808681738,
    0.0008347327566505444,
    0.0008210490056782866,
    0.0008269094218750922,
    0.0008465966029932562,
    0.0008414292152657909,
    0.0008258834469656673,
    0.0008635448797416477,
    0.0008667988502535298,
    0.0008883260672474658,
    0.0009046976716438675,
    0.0009178292368965611,
    0.000903468348216559,
    0.0009048730920070819,
    0.0009209146973718273,
    0.0009129179775909951,
    0.0009045423355006504,
    0.0008978563384447991,
    0.0008768406239266675,
    0.0008871274333650195,
    0.0008710296675752726,
    0.0008920711078239492,
    0.0008855484234819255,
    0.0008913406057204066,
    0.0008835053988257949,
    0.0008783109598360862,
    0.000862321578548712,
    0.0008969101648927665,
    0.0009037894297755159,
    0.0008778492144145265,
    0.0008811382944324169,
    0.0009072467160234299,
    0.0009098236426760861,
    0.000886801213491167,
    0.0009148754496065896,
    0.0009219281337987677,
    0.0009050123455682127,
    0.0008861998844873793,
    0.0009105294983394644,
    0.0009035704290553222,
    0.0008927241725404548,
    0.0008606493274345671,
    0.0008266016525950197,
    0.0008263834961798867,
    0.0008371784632761378,
    0.0008346747107862233,
    0.00086759230095331,
    0.0008836867640465814,
    0.0008816096096845587,
    0.0009305373962112141,
    0.0009572167723725166,
    0.0009791833387811236,
    0.0009806604125925653,
    0.0009739544028769837,
    0.0009944277486272199,
    0.0009906224994996112,
    0.0009723875857828163,
    0.0009444305005308987,
    0.0009243070787176954,
    0.0008867927981302697,
    0.0008710844072626315,
    0.0008375066137242153,
    0.0008567659240043352,
    0.00084111773896056,
    0.000857313263039731,
    0.0008885224330442054,
    0.0008879937499212721,
    0.0008656524158621506,
    0.0008566377377824341,
    0.0008449727446744112,
    0.0008519734909791305,
    0.000872976280506613,
    0.0008637818734456863,
    0.0008588095233826846,
    0.0008999996493118691,
    0.000925083094727883,
    0.0009222349510845814,
    0.0009227549430835091,
    0.0009262461086970963,
    0.0009334244869747235,
    0.000929886477933999,
    0.0008987847224610177,
    0.0008788849940755795,
    0.0008947036273121677,
    0.0008877971425406405,
    0.0008907940147793499,
    0.0008966972319412804,
    0.0008945077228166751,
    0.0009013935235995578,
    0.0008967821061126872,
    0.0009067455177042164,
    0.0009137163300986818,
    0.0009036804240696192,
    0.000886698300198807,
    0.0008610382887961342,
    0.0008603138177997267,
    0.0008570250064812293,
    0.00084522034072825,
    0.000849268976729535,
    0.0008857428793875396,
    0.0008886055385624021,
    0.0009115170121920215,
    0.0009172862029874694,
    0.0008971041171607836,
    0.0008714421150804819,
    0.0008680134491763818,
    0.0008922791744068957,
    0.0008861527653537133,
    0.0008987732278795421,
    0.0009405634184139201,
    0.0009442336366164903,
    0.0009398392684836934,
    0.000927113653014811,
    0.0009486629989592004,
    0.0009690447337612325,
    0.0009458356128925068,
    0.0009527987243288569,
    0.0009284312214920415,
    0.0009424167397516705,
    0.0009105779271372365,
    0.0009154449741871747,
    0.0009220103326524699,
    0.0009162620068151478,
    0.0009598379461137262,
    0.0009626920190955493,
    0.0009853369285955866,
    0.0009948902902364905,
    0.0010058431611148127,
    0.001031263553536185,
    0.001019290005983557,
    0.001006594356587328,
    0.0009730033199207715,
    0.0009122288604748259,
    0.0008992615438911159,
    0.000872855949807378,
    0.000844889342331968,
    0.000802375545834637,
    0.0008116512207610619,
    0.0008227595596318135,
    0.0008364484116007007,
    0.0008160269606372008,
    0.0008508350513795955,
    0.0008513176357971953,
    0.0008749483695515019,
    0.0008680091004461868,
    0.0008506953793834647,
    0.0008204625917163047,
    0.0008471676338200092,
    0.0008574793446108784,
    0.0008760374466951834,
    0.0008695277833089664,
    0.0008817976099683233,
    0.0009028436341062604,
    0.0009122258485985998,
    0.0009161881052462326,
    0.0009016725902137935,
    0.000869515591540835,
    0.0008868253474344941,
    0.0008841388690399873,
    0.0008707807858670902,
    0.0009233641847520704,
    0.0009276007190792934,
    0.0009268381612981592,
    0.0009162478668333826,
    0.0008857706218547282,
    0.000874023002858168,
    0.0009093063327169835,
    0.0009087558704810095,
    0.000884971581566868,
    0.000893286558289993,
    0.0008629205083435567,
    0.0008914857872796011,
    0.0008928480034289951,
    0.000871800184816083,
    0.000835724063807954,
    0.0008604182016640034,
    0.0008459159330726375,
    0.0009004391028653206,
    0.0009304033290010507,
    0.000928118174616631,
    0.0009097958232354824,
    0.0008611744935071292,
    0.0008564904790755874,
    0.0008588438852977267,
    0.0008583677762342683,
    0.0008369561264688052,
    0.0008170944940814735,
    0.0008143269667348318,
    0.000803045079732592,
    0.0008401067316456377,
    0.0008735902154219493,
    0.0008787611949875233,
    0.0008662518433229359,
    0.0008330581202034077,
    0.0008239655914907019,
    0.0008739730960195517,
    0.000895643098838439,
    0.0009389191455286045,
    0.0009591062550915611,
    0.0009704296957429961,
    0.0009638261279347787,
    0.0009414694674901004,
    0.0009449622436861055,
    0.000928275064830277,
    0.0009072294818796071,
    0.0008835055965053202,
    0.0009201104404149,
    0.0009127108759098109,
    0.0008932751161495752,
    0.0008761393869605119,
    0.0008677966345114601,
    0.0008479935516184796,
    0.0008618781626401603,
    0.000881695435994114,
    0.0008792865993948486,
    0.0008804003166943181,
    0.0009015193446415273,
    0.0008740460645717467,
    0.0008923858029465079,
    0.0008863068349018881,
    0.0008637854553109465,
    0.000886134830031945,
    0.0008940234889471844,
    0.0008744053473510102,
    0.0009146892951659571,
    0.0009353222893366981,
    0.0009278989241542321,
    0.0009345090838955423,
    0.000964722013811479,
    0.000986784539759952,
    0.000988537204556195,
    0.0009592680666353669,
    0.0009251054257501324,
    0.0009241846469200296,
    0.0009227729313146794,
    0.0008900044409763392,
    0.0008723215722869915,
    0.0008777408167165274,
    0.0008394174803090458,
    0.0008598737617578011,
    0.0008682003019478072,
    0.0009008214364570422,
    0.0009048801868424482,
    0.0009035355834173549,
    0.0008957216210202212,
    0.0008650967920763565,
    0.0008322383125442552,
    0.0008205190514176049,
    0.0008394509525707803,
    0.0008533607177190882,
    0.0008594977760316369,
    0.0008687731617598605,
    0.0008638926389691045,
    0.0008551480696236097,
    0.0009037288201391359,
    0.000939511081229356,
    0.0009480991681075216,
    0.0009465097701714664,
    0.0009482274038722565,
    0.000931191292083167,
    0.0009542331932734263,
    0.0009648521466413403,
    0.0009576488885190927,
    0.0010015298915592354,
    0.0010176532169988146,
    0.0010100803173719063,
    0.001001536362995118,
    0.000989405786234067,
    0.0009238063884458513,
    0.0009464199345464542,
    0.0009590923950984956,
    0.0009450579562118773,
    0.0009539027589843162,
    0.000932660770651996,
    0.0008931297650030233,
    0.0008812439097877451,
    0.0008443492727468057,
    0.0008421981135729834,
    0.0008207353106883002,
    0.0008366494265900036,
    0.0008603302179453129,
    0.0008429084037421438,
    0.0008202835985680638,
    0.0008411432222151546,
    0.0008606818192499003,
    0.0008674602454993733,
    0.0008720533840653373,
    0.0008689413525440401,
    0.0008609858287691073,
    0.0008789785459058149,
    0.0008635224864881539,
    0.0008847099557773113,
    0.0008764671209037686,
    0.0008750133326413606,
    0.0008678227741498375,
    0.0008531150351109238,
    0.0008548132914510639,
    0.0008255891340501366,
    0.000841865876738906,
    0.0008528819281631109,
    0.0008657397452970023,
    0.0008973884316861493,
    0.0009284063197353504,
    0.0009434564172232621,
    0.000943077158668548,
    0.0009567697393695268,
    0.0009296857837166924,
    0.0008826698586775733,
    0.0008994704520277605,
    0.0008771647514886618,
    0.0009041875243203192,
    0.0009004019406855517,
    0.0008748069834283235,
    0.0009077318321469923,
    0.0008925306011826646,
    0.0008890062854129059,
    0.0008868567974032177,
    0.0009060989878746238,
    0.0008976364634757935,
    0.0009136949216641003,
    0.0009231205261710526,
    0.0009436928794721925,
    0.0009529731695472248,
    0.0009668289221371418,
    0.0009643668334268751,
    0.0009608537613112465,
    0.0009307674643340649,
    0.0009055779369216692,
    0.0009264888058028594,
    0.000924661485415145,
    0.0009254706502439554,
    0.000919158758272659,
    0.000922169509391623,
    0.0009216475390481836,
    0.0009107110000992345,
    0.0009230018871887661,
    0.0009013354457573904,
    0.000866006988029945,
    0.0008582839543502476,
    0.000839340374853076,
    0.0008233650835460638,
    0.0008433976944816245,
    0.0008528482504140107,
    0.0008322240229647603,
    0.0008528050305242434,
    0.0008354721996341779,
    0.0008248994865341789,
    0.000815013508191178,
    0.0008343326335276893,
    0.0008360292750207805,
    0.0008514543312779275,
    0.0008674727851146723,
    0.0008672593856372899,
    0.0008717453175340785,
    0.0008399991474915956,
    0.0008767714824946902,
    0.0008895454142947564,
    0.0008816724480926767,
    0.0008782966020729012,
    0.0008982781129976124,
    0.0008936575544494378,
    0.0008896871312636367,
    0.00089894799755242,
    0.0009469375876177588,
    0.0009850317440523763,
    0.0009997170413136751,
    0.000989868640713656,
    0.0010333364160141692,
    0.0010648547146347499,
    0.0010709038216416362,
    0.0010819917685532705,
    0.0010760863023603262,
    0.001038172487317328,
    0.0009941117077266397,
    0.0009666619064564018,
    0.0009129315598101978,
    0.0009151735378049464,
    0.0009156331573075888,
    0.000894993105904498,
    0.0008634803083362276,
    0.0008362291827286774,
    0.0008135622130697439,
    0.0008222141986333815,
    0.0008292054832671684,
    0.0008236961550414426,
    0.0008075363354506675,
    0.0008264574735111195,
    0.0008304763454825873,
    0.0008376918608162988,
    0.0008541520050114826,
    0.0008438146591575892,
    0.0008816896249642704,
    0.0008906320015175304,
    0.0008944515803297774,
    0.0008896461436191176,
    0.000914512618996371,
    0.0009365006729775318,
    0.0009265673455831929,
    0.0009134177030372472,
    0.0009096173211477748,
    0.0009301603060817241,
    0.0009223630871364098,
    0.0009120204701994067,
    0.0008747898102835362,
    0.0009077810156962302,
    0.0009506530848414622,
    0.0009675889149835708,
    0.0009814671842556365,
    0.0009885256528141524,
    0.0009980200742176646,
    0.0009855586610012675,
    0.000977840000551883,
    0.0009524075554672179,
    0.0009067947301130054,
    0.0009316885089709833,
    0.0009315485986109661,
    0.0009239713310914711,
    0.0009184723366924199,
    0.0008940893344052471,
    0.000865547991461162,
    0.000871433582532033,
    0.0008707389744780847,
    0.0008574184064988698,
    0.0008496944740464633,
    0.0008491060952347831,
    0.0008414482803331112,
    0.0008532416910206682,
    0.0008426369821702785,
    0.0008692092614059731,
    0.0008848892335399705,
    0.0008808984108706107,
    0.0008593703517239447,
    0.0008771240916019945,
    0.00088091374361643,
    0.0009206602768701808,
    0.0009286898699241848,
    0.000917108611674131,
    0.000920528627778441,
    0.0009374066926088521,
    0.0009369568606821706,
    0.0009168652692410675,
    0.0009204199087669233,
    0.0008933290626408873,
    0.0008988934933700477,
    0.0008637485030689816,
    0.0008633028935112975,
    0.0008880100103219925,
    0.0009030879726139625,
    0.000890696445104831,
    0.000881700549408717,
    0.0008945947102411131,
    0.0008915972324843184,
    0.0009139227191980012,
    0.0009142385190364221,
    0.0008982794330846228,
    0.0009152404967878637,
    0.0009233396637627942,
    0.0009161933204347158,
    0.000899241224126186,
    0.0008617244769289835,
    0.0008352547564298112,
    0.0008516488010676853,
    0.0008714334617138628,
    0.0008747270397469088,
    0.0008396025745620887,
    0.0008663905677509778,
    0.0008640968037979833,
    0.0008880108812316347,
    0.0009471629363721747,
    0.000985346954099361,
    0.0010282795710354529,
    0.0010832498539790447,
    0.0011057831786391499,
    0.0011309207321233763,
    0.0011293389483167473,
    0.001112467688431568,
    0.001064070810767589,
    0.0010035399291496027,
    0.0009383688475519662,
    0.0008780639938528308,
    0.0008613766990252198,
    0.000868875217353587,
    0.0008406633376759846,
    0.0008561884052739756,
    0.0008349586190009327,
    0.0008382334851061132,
    0.0008292326592912413,
    0.0008192477014765735,
    0.0008253878510400665,
    0.000799591492792473,
    0.0008035379447127101,
    0.0008034272667920467,
    0.0007866395589984249,
    0.0007961059411188471,
    0.0007797276426657844,
    0.0008045096850435521,
    0.0008357728371345603,
    0.000854066628935431,
    0.0008658766417290075,
    0.0008650839643039364,
    0.0008514241222974278,
    0.0008731929356151312,
    0.000868172508799956,
    0.0008955445717412128,
    0.0008974957906669436,
    0.0008937903037341551,
    0.0008801513069281539,
    0.0008892437906299609,
    0.0008775152280418035,
    0.0008516354897139018,
    0.0008841723305345753,
    0.0008856447222556948,
    0.000904804893781283,
    0.0009116394626845554,
    0.0008846222486870978,
    0.0008817223137548473,
    0.0008892794954861985,
    0.0008728465266432995,
    0.000868124890771929,
    0.0008638886217052104,
    0.0008842017027787355,
    0.0008990473999950192,
    0.0009084751030271326,
    0.0009032719898269577,
    0.0008993919504971926,
    0.0008740730547950146,
    0.0008876332680958448,
    0.0008773805063098709,
    0.0009146435123004641,
    0.0009180186808708939,
    0.0009168365641131974,
    0.0008998914239807298,
    0.0008916717804013489,
    0.0009033963526039554,
    0.0008694016638130024,
    0.0008732397538450391,
    0.0008965429719799572,
    0.0008862731164960744,
    0.000869065708172824,
    0.0008988522522931797,
    0.0009175841224004244,
    0.0009542572602637622,
    0.0009692804645389276,
    0.0009577266421921254,
    0.0009490208338426613,
    0.0009893030965264556,
    0.000992366591085598,
    0.000983172286098929,
    0.0009564364588796701,
    0.0009125500138431386,
    0.0008888072999886811,
    0.0008442982258514051,
    0.000847741046545544,
    0.0008374002594877409,
    0.0008239776615340859,
    0.0007885810607453463,
    0.0008298078010002136,
    0.0008784848146425112,
    0.0009179589764250821,
    0.0009827484791448348,
    0.0010315259640375515,
    0.0010522056689261166,
    0.001074292513349659,
    0.0010764718721676498,
    0.0010654759398619979,
]).reshape((2516,))

IDENTITY_LOG_VOLATILITY_STANDARD_DEVIATION = np.array([
    0.5797837804280623,
    0.5050888494213164,
    0.5184642759326066,
    0.528134519126659,
    0.5208354721450523,
    0.4993018718545256,
    0.459671007178323,
    0.4895416997277044,
    0.5069852618975519,
    0.5125458149513393,
    0.4986416054880956,
    0.498282323171835,
    0.4782071316433961,
    0.43467842085257463,
    0.46000971404456015,
    0.46299185735554904,
    0.45744546920622076,
    0.4513505789484011,
    0.48035706975845993,
    0.49680000251026823,
    0.5155905193029515,
    0.5159161518866702,
    0.514596375372147,
    0.5003857998335792,
    0.4652707683424925,
    0.498224129475669,
    0.5174633244598721,
    0.5272441692260635,
    0.519875618629426,
    0.5015374675829015,
    0.46920642684977043,
    0.42135147420842456,
    0.46579882132427103,
    0.4939270470265981,
    0.5056985662869213,
    0.49693170399657705,
    0.49545240064007745,
    0.4736098864760657,
    0.4932725236262855,
    0.49378708230232105,
    0.4796550774600553,
    0.4890481420614404,
    0.47793929164351,
    0.4558777186151026,
    0.4452433922462037,
    0.4433227460410813,
    0.4123285302817288,
    0.44287318505263845,
    0.45591278753516606,
    0.47213659430272764,
    0.5000641831457935,
    0.5182569027251422,
    0.5243578942091887,
    0.5207883736049362,
    0.5420244992270982,
    0.5467774334361765,
    0.5397390820808433,
    0.5184153710968264,
    0.47665686579999694,
    0.48495498269892645,
    0.47657900328263986,
    0.45285762861248796,
    0.4261455540058142,
    0.4652158447591065,
    0.49264495944828834,
    0.5065014133947203,
    0.5044651382849784,
    0.4885305488192174,
    0.4573119755887192,
    0.4253541858051997,
    0.47677645458895324,
    0.506816268328143,
    0.5196572490722547,
    0.5328418479569444,
    0.527727049516397,
    0.5140294480139049,
    0.5075963837823946,
    0.49428318333296,
    0.4595129418144522,
    0.4203620481323912,
    0.4554816889165575,
    0.5103898188605545,
    0.5484779716666439,
    0.5757895957467685,
    0.5871225712110397,
    0.5865818413673415,
    0.586959104102845,
    0.5748674311363506,
    0.5476466211693645,
    0.5050454376730675,
    0.4753369982253034,
    0.4275900569946055,
    0.46635502803624673,
    0.4848937448788445,
    0.48195919010345795,
    0.4911477326318282,
    0.4835081368410627,
    0.46150577313263896,
    0.46378495950955045,
    0.4414382226368212,
    0.46142919940200766,
    0.45418585103619424,
    0.47267524940311045,
    0.4702304348507898,
    0.4435269747302669,
    0.44094067747825516,
    0.4551159695826469,
    0.4593641579013233,
    0.4404561237166617,
    0.40544822394611824,
    0.4352037346920879,
    0.4878191041152067,
    0.5193984692404712,
    0.5361982172581224,
    0.5379300945321445,
    0.5334701299093252,
    0.5234599483753419,
    0.531205151007504,
    0.5217837655053577,
    0.4951181786059943,
    0.4943909394726533,
    0.5148769091404246,
    0.5164137934003844,
    0.5033465087975175,
    0.5272038426883559,
    0.5478093422536192,
    0.5636174815311401,
    0.5687086463048276,
    0.5558883947241586,
    0.528816071584667,
    0.4941112121888289,
    0.4391935893868995,
    0.47293579274714775,
    0.48769862051255386,
    0.5057796883654526,
    0.5145282533227794,
    0.5115973220254689,
    0.49514265518605205,
    0.4692294819146536,
    0.4792283638481942,
    0.4713926490711177,
    0.47662686589195047,
    0.4593319247268754,
    0.49389914831183457,
    0.508404993950149,
    0.5099863774675707,
    0.5105263611049721,
    0.4913926728802638,
    0.46137244380981324,
    0.40797055501689916,
    0.4231612034660494,
    0.4211201825524092,
    0.47407400094783253,
    0.5083536506976939,
    0.5287917031866488,
    0.5339110578845785,
    0.5489554716533783,
    0.5603055778210345,
    0.5673845215610482,
    0.5581633666141977,
    0.556589404626859,
    0.5425749043432696,
    0.5235428536115722,
    0.5073623242765644,
    0.47636706160724585,
    0.42325931186886656,
    0.4557828082576134,
    0.4732378784309291,
    0.4702619573634902,
    0.4680194073740044,
    0.44739194608118354,
    0.4608525696008101,
    0.4488763365676724,
    0.4658327387992819,
    0.47307185629931825,
    0.4740451669916014,
    0.46867733327590366,
    0.44103984494488735,
    0.4584512151611248,
    0.45692559072082517,
    0.439761814427113,
    0.42010958349094407,
    0.43523923243593765,
    0.45447735407029494,
    0.45245580885352865,
    0.48112529025597145,
    0.4948699964769746,
    0.49093326253923336,
    0.5081565225920356,
    0.5116936202888354,
    0.5026392207001693,
    0.5094459019646211,
    0.5331123901775822,
    0.5446733194538282,
    0.5670155863663866,
    0.5741913505075884,
    0.5678235783365114,
    0.5516144236574309,
    0.5256261239631254,
    0.5085668958085272,
    0.48534658418379617,
    0.5023273967354747,
    0.5003599890160418,
    0.47768664440717556,
    0.43906507583499305,
    0.44288620261794387,
    0.4295058991885844,
    0.460450161420691,
    0.4775371568536745,
    0.47583411827838284,
    0.49441143534938065,
    0.516906160989645,
    0.5276421381272819,
    0.5247474121636897,
    0.5083245354784827,
    0.48221916269920834,
    0.4671043737698851,
    0.4845129450560143,
    0.4818259081818832,
    0.46553032124355154,
    0.451321212548638,
    0.468794584752812,
    0.4720315176135944,
    0.4851971654347606,
    0.49926962887778725,
    0.4916103892055637,
    0.4972865285453308,
    0.4828897793386533,
    0.47425442322337563,
    0.5029783864769741,
    0.5146936028800375,
    0.5078664155336364,
    0.4892292466229537,
    0.4524033997280972,
    0.4158442255402897,
    0.45236358827070966,
    0.4612276027483556,
    0.4740127303997479,
    0.49573184870236664,
    0.49813222701440346,
    0.4864632696464791,
    0.4659843431317019,
    0.4737976534232541,
    0.4582541466777889,
    0.4502464388332931,
    0.48672213603462444,
    0.5019542339552976,
    0.4984204965588499,
    0.4812738108671013,
    0.4891457204281105,
    0.4904994843775305,
    0.47338947574603035,
    0.4727372761614476,
    0.46606339633736116,
    0.4737453632989004,
    0.47172562595230394,
    0.47090021248784064,
    0.49407149957321483,
    0.49841009479415926,
    0.48277413825012294,
    0.4719201810535386,
    0.4534011791006153,
    0.4890610378705974,
    0.5084256115394397,
    0.5115277158150081,
    0.5110360500052463,
    0.5001689050698084,
    0.48680145777871847,
    0.5066862676446278,
    0.508745831713652,
    0.5264567539143662,
    0.5268825701278128,
    0.5195867930975485,
    0.49586650401586285,
    0.5127706979599443,
    0.5131860847129162,
    0.499270581902379,
    0.4685914630125869,
    0.45741979253221887,
    0.4192536109747387,
    0.4234124820408497,
    0.3916476653038828,
    0.40345762202617835,
    0.41464406393512415,
    0.43496721653827397,
    0.4699793322038609,
    0.4825413862661554,
    0.4893285452429897,
    0.4803869565675546,
    0.45034024729060507,
    0.4740096032830724,
    0.48294734311134546,
    0.46920764809999993,
    0.4864696748185315,
    0.4903065209767189,
    0.4899038210010983,
    0.4816943645235396,
    0.5053592538644611,
    0.5068973992655773,
    0.49226487202233515,
    0.4687211575905338,
    0.4719853285832472,
    0.4572766425895445,
    0.468078709141341,
    0.46451688017738224,
    0.49552380058320733,
    0.509667147915333,
    0.5097991011506858,
    0.5058200747052051,
    0.5128227380828073,
    0.5039570942284624,
    0.48564010030387095,
    0.4463302936486834,
    0.43909643871717907,
    0.4647083896982053,
    0.4673167078153927,
    0.4778761784168572,
    0.472584353189363,
    0.4723937149052361,
    0.453075593375688,
    0.44698927450735837,
    0.45661743522889287,
    0.4698669273873538,
    0.47465399270951847,
    0.476611443138264,
    0.46075703936394596,
    0.4942704295388827,
    0.5075452433778872,
    0.5104219483146145,
    0.493432406181651,
    0.48141253858684,
    0.481232470719856,
    0.4925790123932239,
    0.4999050828507892,
    0.48848897669486774,
    0.4839942318201004,
    0.46824790724331977,
    0.46222779706453193,
    0.4396488319414761,
    0.453937695588857,
    0.4428095899447757,
    0.44406537101905075,
    0.4656909804641276,
    0.47696216249985823,
    0.49267815460110553,
    0.49153319647055815,
    0.47132613176829674,
    0.4362983981710079,
    0.46674897756786765,
    0.4776980193146431,
    0.49414915604890447,
    0.5002759058447084,
    0.48990401774956077,
    0.49024937453493,
    0.4963494712798501,
    0.485479652897254,
    0.4873999157286553,
    0.4682585888586379,
    0.4670154747783716,
    0.44336640500102725,
    0.4446314532052259,
    0.41629722543800274,
    0.46814443804580674,
    0.4990862389883497,
    0.5075651027664242,
    0.5128145704307026,
    0.49632028729226274,
    0.4611429078075944,
    0.4601119888066522,
    0.4673172759112142,
    0.48308409999295876,
    0.48677180391693586,
    0.4944565254667899,
    0.4853697358366219,
    0.45506754958450807,
    0.4200550852175244,
    0.4598125734367849,
    0.47526247349501327,
    0.48114060883245163,
    0.48395835520630237,
    0.46253423711209674,
    0.4648626672442119,
    0.4687733412688836,
    0.457099604238927,
    0.4983293996781118,
    0.5216301341703875,
    0.5307039944898141,
    0.5275433129096078,
    0.5089480860120957,
    0.5235664960618394,
    0.5203255575676665,
    0.5032088942619584,
    0.49179068449381413,
    0.4659693392496024,
    0.4932278275614352,
    0.5171501314007769,
    0.5212388658053682,
    0.5090135076817374,
    0.47967931884500536,
    0.48431444247257904,
    0.501539677278123,
    0.5025459783667565,
    0.4940381103040477,
    0.4645461401636327,
    0.4589762312769591,
    0.4285095554648157,
    0.47780164572842854,
    0.5038670456072181,
    0.5113575342044793,
    0.5047635675605421,
    0.4798680584702234,
    0.4767468014525257,
    0.4825733841003377,
    0.4670532496451846,
    0.4544312309558564,
    0.4964642852149811,
    0.5239381689350354,
    0.5317471608255999,
    0.5434259550769738,
    0.5561963717896515,
    0.5537783181421047,
    0.5383654567354779,
    0.5141895507727807,
    0.49780088664984445,
    0.48496012332485644,
    0.45948487494259743,
    0.41938144704968605,
    0.44143484248281606,
    0.44929363227712826,
    0.4635551253588456,
    0.4595439005228671,
    0.4278772856170397,
    0.47580156197447276,
    0.5016322031076056,
    0.5247142867780423,
    0.5308803156299747,
    0.52903477350734,
    0.5209594690696223,
    0.4960378578000689,
    0.4866667128259422,
    0.461306018900874,
    0.49103242632695016,
    0.5065234629978214,
    0.5187687994933078,
    0.517431581398178,
    0.5046508014061419,
    0.4935239678724658,
    0.47200453193934433,
    0.46769206129724744,
    0.44318868645752596,
    0.4240169152902844,
    0.44073990390780243,
    0.43868467560486446,
    0.4452704320593903,
    0.4630055324671062,
    0.4558879108201713,
    0.4831684943481167,
    0.4949222881744631,
    0.5035321025120552,
    0.4924830104444692,
    0.49275423141004626,
    0.47338633907912053,
    0.4951106415143386,
    0.513790699201214,
    0.5157251711136873,
    0.5105020474983699,
    0.4975495671294669,
    0.4695458755944243,
    0.4439270164925741,
    0.48166241179963587,
    0.4962763713738987,
    0.5012436529451312,
    0.51045780622641,
    0.49973692761885424,
    0.47879448329516217,
    0.48154246347472063,
    0.47523183770628225,
    0.45147636838539695,
    0.4643472595742483,
    0.46663847755886945,
    0.507106862492759,
    0.5274364234773494,
    0.53043501186112,
    0.5164729561828836,
    0.4870074401198027,
    0.46334963375962024,
    0.4570889028013344,
    0.4265032812651879,
    0.4569521999108345,
    0.46182111566427625,
    0.4428458003651814,
    0.47237340388089655,
    0.47920579462551693,
    0.47430759634234454,
    0.48161247201792357,
    0.490175640525473,
    0.49146699408434313,
    0.49599779484397305,
    0.5016795872244164,
    0.4876907442444323,
    0.4723182986057989,
    0.4348758240745033,
    0.45360028290055954,
    0.45289603437599446,
    0.47323135446358267,
    0.473179817192662,
    0.46462485719421337,
    0.43348012097357425,
    0.4751059301056661,
    0.4935442945886425,
    0.5022207084917581,
    0.5006833944845388,
    0.5128604160368001,
    0.5068650409940092,
    0.5110625609214399,
    0.49374943221582945,
    0.4672073397612855,
    0.49088403117111545,
    0.49722998529419915,
    0.501430719207287,
    0.4985179776378428,
    0.4772081491761081,
    0.4683742807509487,
    0.4636809510488217,
    0.4586000586739285,
    0.42709211341519804,
    0.42034296575080354,
    0.45771419409099157,
    0.47152341360046546,
    0.46755220211219506,
    0.44565713007290986,
    0.4200490197141484,
    0.47844248464350825,
    0.5171528241757819,
    0.5573489938767875,
    0.5814772797447317,
    0.5912944106092186,
    0.5927178575063148,
    0.5842766864442274,
    0.5619828849856093,
    0.5268666012826523,
    0.5397438155227133,
    0.5373773901013622,
    0.5193426769187788,
    0.5049447752329407,
    0.4708969440558147,
    0.48630145036619343,
    0.5124594607537627,
    0.520084998880266,
    0.5108737613352673,
    0.4839975960944246,
    0.48505808332547157,
    0.47858746058150353,
    0.45419317024817163,
    0.4042090513911506,
    0.44499308486183614,
    0.46079697801348507,
    0.4722893544799516,
    0.4657731098640682,
    0.433534068110748,
    0.481156533098288,
    0.5151705858634501,
    0.5408050601337513,
    0.5532159125349898,
    0.5492132689493022,
    0.5320774865762626,
    0.49952900872672235,
    0.4546228279494812,
    0.45889243198755175,
    0.4597626994841826,
    0.48860684788666353,
    0.5146717833130614,
    0.5270103374840069,
    0.521830643885375,
    0.5072263410569781,
    0.5099512615862973,
    0.4940700882050663,
    0.4681208138248104,
    0.48077633856012747,
    0.49848611534587606,
    0.49826700807336677,
    0.48093891975829994,
    0.4696691417843503,
    0.4758587189751908,
    0.4639943747481662,
    0.43090627838848883,
    0.45393514280685004,
    0.44984731194255795,
    0.4915286716383408,
    0.5170518896665337,
    0.5242464948182477,
    0.5153006083502918,
    0.4894521468348856,
    0.4785460768232085,
    0.4748429556803567,
    0.4497286986394789,
    0.4088365014697679,
    0.4412267091232451,
    0.47747866750986445,
    0.4918724933446936,
    0.4851782228982053,
    0.46279645271891984,
    0.47335382360699574,
    0.4615644007204257,
    0.4303870242634737,
    0.463214460412559,
    0.4721000247155132,
    0.458737814420089,
    0.4841784865664748,
    0.4936365668495384,
    0.5000704115866978,
    0.5240579753838024,
    0.5432695409959432,
    0.5472614226324862,
    0.5660054225936297,
    0.5766458026604325,
    0.576306048838706,
    0.5706298786163009,
    0.5590476389300383,
    0.530184533940907,
    0.5188910952710561,
    0.49077328052198615,
    0.47250303843924835,
    0.44444153890091387,
    0.4414313489080892,
    0.45564813360513823,
    0.4685746123810165,
    0.46907710082174764,
    0.4842082863726381,
    0.4825220322980801,
    0.4705061991079719,
    0.43437103307113495,
    0.4008657673221526,
    0.38268441208355586,
    0.4436683521424123,
    0.4819482441565448,
    0.5062021203247425,
    0.5184951986358184,
    0.5266832270787551,
    0.521737240606666,
    0.5517630470438176,
    0.5672450803124597,
    0.5704446931745497,
    0.5600269813884317,
    0.5352859141187056,
    0.5387468746567243,
    0.5378339551261362,
    0.5470982341173809,
    0.5418954535819935,
    0.5198513297180871,
    0.5140206649131281,
    0.4969539139442358,
    0.48232654232394506,
    0.4628545498400164,
    0.4271872548440608,
    0.4126743018820104,
    0.436154414799403,
    0.4879170752978689,
    0.5162735876361019,
    0.5312572561748355,
    0.5564154085016739,
    0.566715397282592,
    0.5657526927552176,
    0.5502102572870342,
    0.5208373570594493,
    0.4770242131786124,
    0.4360817084907283,
    0.43626533427969943,
    0.42063293393369816,
    0.3957085778232658,
    0.42844183454283746,
    0.43772358405494155,
    0.4770631600028906,
    0.4963660789072968,
    0.4961271793317312,
    0.4877590301536971,
    0.5223877786143706,
    0.5407804396207351,
    0.5416222036801057,
    0.5472643322433584,
    0.5469396959399461,
    0.5425736429382425,
    0.5223622261453736,
    0.5142405026983038,
    0.49449661177560406,
    0.4881452807800256,
    0.4685784991386777,
    0.45392706213233797,
    0.4644403202073926,
    0.4815292477803256,
    0.48622966424307135,
    0.5062996355506298,
    0.5084251695243935,
    0.5001357597595399,
    0.4906219645950848,
    0.4721427057443258,
    0.49288766665081774,
    0.49947909657939427,
    0.4976044068622878,
    0.4910730838014919,
    0.4685069980393754,
    0.4673118213459492,
    0.4461911763216726,
    0.3979287711083603,
    0.4108359487848284,
    0.4236045111280785,
    0.4551986852504769,
    0.47210170431697246,
    0.48944786780246563,
    0.49238373242984873,
    0.5162050455279592,
    0.5238149829986078,
    0.5211355686508692,
    0.5041850901275666,
    0.492523681719932,
    0.4631878089974835,
    0.45646897572870404,
    0.4602947482900638,
    0.4947797591019863,
    0.5069866232866603,
    0.5165936156984601,
    0.517580754582276,
    0.5142135209822407,
    0.5045928631431924,
    0.4752846702462117,
    0.4808976462537605,
    0.47793347738776387,
    0.47144412503968314,
    0.49853284151227967,
    0.5046328203547421,
    0.49363677760930447,
    0.5098011053083047,
    0.5159647969615893,
    0.501877843604547,
    0.48712340615076755,
    0.47667157737811533,
    0.4490956476190954,
    0.46467323709660013,
    0.4633840620853659,
    0.4482943970691194,
    0.459032810963652,
    0.46076981955145496,
    0.4765982300925084,
    0.4684243517590018,
    0.4655839413403336,
    0.45828435137488466,
    0.47021003466821937,
    0.4686721785556359,
    0.45417326869377084,
    0.4255530755467688,
    0.40144905688417565,
    0.4391631781487715,
    0.44697156267134774,
    0.4637813168412889,
    0.4777540965633505,
    0.4975819069218101,
    0.5129378686030542,
    0.5198058386207844,
    0.5243904079422053,
    0.5104374819960557,
    0.47804033849708183,
    0.47781089293799966,
    0.46759707775642567,
    0.463858519975791,
    0.4320641510885129,
    0.47663885440494813,
    0.5025920783654592,
    0.512244106361572,
    0.5245677548527796,
    0.527208181042367,
    0.5453970513644977,
    0.5495712331097835,
    0.5440319357881983,
    0.5347319570231421,
    0.5395044985550728,
    0.5363856387207975,
    0.5179970005768892,
    0.5096045399523592,
    0.48270986310324515,
    0.43346897467434686,
    0.47092654608801177,
    0.4859033333152076,
    0.4827903641804404,
    0.4954244304201221,
    0.5078734870292395,
    0.5102831212687987,
    0.5096932621951604,
    0.49347459090848156,
    0.4617703970071355,
    0.4248282653780424,
    0.4559800512702813,
    0.46830116621673074,
    0.4788978194229251,
    0.47229445087647076,
    0.4661047013461708,
    0.4692403528866527,
    0.4549163420306332,
    0.42421361997812185,
    0.4708319711966918,
    0.49927920826048827,
    0.5096479554656714,
    0.5078066034614083,
    0.4945045722217027,
    0.5068656531101714,
    0.4989115540300772,
    0.46908912186307583,
    0.4801982957037051,
    0.5005084206108789,
    0.505911174066833,
    0.5066525072524263,
    0.49072117544347343,
    0.4761919842679195,
    0.44778970557901854,
    0.47087140761402013,
    0.4739405507028359,
    0.49534626611166566,
    0.5146491846392685,
    0.5238097262550363,
    0.5239471569735039,
    0.5123851792712921,
    0.49731526557113287,
    0.4885939128320344,
    0.490571497531051,
    0.47030659821603554,
    0.46399466114563587,
    0.4494662104586281,
    0.43468343832282025,
    0.4362178741415702,
    0.4071987378107889,
    0.44171121953956655,
    0.45762460148218126,
    0.45292205340072156,
    0.4427370153396063,
    0.46835760815334904,
    0.4892122025003525,
    0.5102539404171706,
    0.5100249846002276,
    0.5164276838904518,
    0.5282426784544534,
    0.52983290042279,
    0.5318555435234631,
    0.5167734676356941,
    0.5111419657674892,
    0.5151186534708942,
    0.5194307179431289,
    0.5099330330395877,
    0.49179250707716343,
    0.4605525881919654,
    0.4118328795716512,
    0.41440580711749153,
    0.4550133166144758,
    0.4701936760500588,
    0.4680441847412082,
    0.4849101791090968,
    0.496520848647681,
    0.5000385898698803,
    0.500928696314802,
    0.4893389638344717,
    0.47508237294696276,
    0.5015436626741301,
    0.5334138999856173,
    0.5532222465412806,
    0.55684561849747,
    0.554538059699012,
    0.5390999816511514,
    0.5240676019564073,
    0.5103755893705678,
    0.4782476044598442,
    0.44640948336324654,
    0.4636899186638958,
    0.4595927826019458,
    0.4383265095221794,
    0.46485245118543395,
    0.47715485770841226,
    0.4660095051714386,
    0.4512110217879407,
    0.41483213107121264,
    0.4633142989091545,
    0.48634073349832097,
    0.5036309329536515,
    0.5201976882065015,
    0.5275288866570751,
    0.5390060850192636,
    0.5325306074840658,
    0.5110988354325301,
    0.48217141128074215,
    0.5105717957642046,
    0.5186889381893106,
    0.5151693617384615,
    0.5261496475620588,
    0.5182980279755371,
    0.4916688394507628,
    0.4461603941740943,
    0.4557839924057786,
    0.488385977642707,
    0.5111490357229409,
    0.5164222709374227,
    0.5135122014885203,
    0.49572296125094983,
    0.45745827147377127,
    0.4207814366145194,
    0.45131834524769243,
    0.4624674983082211,
    0.4550808746460544,
    0.4489978587513515,
    0.44143147911674196,
    0.41242255461467775,
    0.4449335146210044,
    0.4590770701738968,
    0.45104780315157206,
    0.45319824281370213,
    0.4772559448069923,
    0.4773300784543239,
    0.5049234198646845,
    0.5127525367314716,
    0.5188265866675118,
    0.5212665582979098,
    0.5075579197599185,
    0.5128578944970231,
    0.5239099053701155,
    0.5224428620854522,
    0.5343395620258391,
    0.5319552094632862,
    0.5121716200334696,
    0.49182612513715485,
    0.4537025064794399,
    0.42688412404686005,
    0.48036884964274423,
    0.5115021578581344,
    0.5263620880608241,
    0.5236928259985892,
    0.5024097594573427,
    0.4857919396740519,
    0.4476692491250872,
    0.46102951491327426,
    0.4528077002495866,
    0.4637936798750508,
    0.4752688320900959,
    0.4887631919185905,
    0.5037651377671173,
    0.5046907300366306,
    0.5068929243817818,
    0.5007283935954302,
    0.5112271980132413,
    0.5060422042955073,
    0.4943508768318171,
    0.49351590419569896,
    0.49647689626839336,
    0.4819486934384101,
    0.44655125431590825,
    0.4413457019030747,
    0.44567996509483665,
    0.42329379441453135,
    0.39552218308054904,
    0.423973463588126,
    0.44812920823058056,
    0.46272153605279476,
    0.47202196747777964,
    0.5051132974746738,
    0.5195990909280217,
    0.5247862849421703,
    0.5257609060403332,
    0.5173093351602667,
    0.4903153542847628,
    0.5100699433456549,
    0.5185196899959644,
    0.5337227567029508,
    0.5382896541787534,
    0.5282133812365257,
    0.50386891621137,
    0.46361763123914396,
    0.4755146230019964,
    0.4881765859337113,
    0.4826709671834619,
    0.4567795586434822,
    0.46747142886691107,
    0.4560877386707863,
    0.4389549822741916,
    0.45889845596913326,
    0.4629334859132432,
    0.4517502008003868,
    0.45211180421085295,
    0.4761185046499016,
    0.4813949980110085,
    0.4826170698857905,
    0.5015061518639181,
    0.5034749095349321,
    0.5280048370489053,
    0.5391224027220853,
    0.5362775730813883,
    0.5164001135489725,
    0.4811114939172585,
    0.4878187703003604,
    0.5030223095225962,
    0.4989308756577725,
    0.474332163440813,
    0.4514346791256387,
    0.47829767675102863,
    0.4927967981786904,
    0.48855068455780665,
    0.46469216077598474,
    0.4931775983432436,
    0.5040507736842765,
    0.4965851220137834,
    0.46922598207879657,
    0.4840952716056736,
    0.5064000994961225,
    0.5157059790603542,
    0.5089063399081777,
    0.4837667794676726,
    0.4907921181729562,
    0.4775746903658103,
    0.47026365633071415,
    0.46011986615470085,
    0.47756815891970117,
    0.48994986586583134,
    0.5027773190165215,
    0.4963981282771056,
    0.48847270652526087,
    0.46436463709665743,
    0.4263274422502086,
    0.44022506015510493,
    0.47990066835639017,
    0.5046104061671044,
    0.5266883214750345,
    0.5315433967764196,
    0.5194426306572428,
    0.511875256225019,
    0.4861458603420932,
    0.45571112922439827,
    0.398834795200124,
    0.4355097177637125,
    0.44466618487571435,
    0.4466183550100036,
    0.46592572751802097,
    0.4595120828084457,
    0.448181477495189,
    0.47662219735786504,
    0.48605663934860155,
    0.47839095098030204,
    0.48251163957819376,
    0.4818104137763939,
    0.45885057452139144,
    0.4778814435990606,
    0.502135635142232,
    0.5156976659254535,
    0.5211717096384685,
    0.5217507147195521,
    0.5491211728579801,
    0.5595192215063927,
    0.5550492968758267,
    0.5507506441263798,
    0.5546769843175519,
    0.5467182551151446,
    0.5268912547885217,
    0.49556094930808187,
    0.4822608342951222,
    0.46499798883588106,
    0.48277844317595553,
    0.49444822101743713,
    0.48413011864829913,
    0.49586069529444254,
    0.48794758385274617,
    0.5056260449793041,
    0.5042046479025953,
    0.4988082907875371,
    0.4736834901757835,
    0.4648871319987432,
    0.4498595713062964,
    0.4287642364814478,
    0.4560292456667946,
    0.4789072223228409,
    0.4844188737504605,
    0.4686424793479211,
    0.4809764715557649,
    0.4726801549514536,
    0.4689423703218427,
    0.43950843046573673,
    0.42420471905144497,
    0.41711184877932334,
    0.43513897788958056,
    0.44716411899330977,
    0.47675862822023146,
    0.4840641073010227,
    0.4856828446545586,
    0.46489502490753265,
    0.4532492898892163,
    0.4303384087356181,
    0.44712470780925084,
    0.4489450072701079,
    0.4652332745459734,
    0.47192782579258985,
    0.4559579484871673,
    0.4694667629206493,
    0.4605875476419091,
    0.4455803654607031,
    0.4827175976873443,
    0.49708383841487747,
    0.5049543409741202,
    0.5298670369211694,
    0.5612912220874445,
    0.5745432966174829,
    0.5965632315189084,
    0.60400853915674,
    0.6048502450300499,
    0.5926520062893398,
    0.5648472367267214,
    0.5256333470060214,
    0.5295626585353812,
    0.5247176778723259,
    0.5070410634807307,
    0.5197744371450421,
    0.5239891597851042,
    0.5168762349992859,
    0.5003778531598322,
    0.4751397450420579,
    0.48253698416948076,
    0.5016956094226579,
    0.5137063157251972,
    0.5062770207318834,
    0.48168604072914406,
    0.46733174473946215,
    0.4277125507531453,
    0.43829783015237134,
    0.42394967622383917,
    0.4383878560404197,
    0.430695757328202,
    0.40745546297880486,
    0.40921817722321857,
    0.4696198826281136,
    0.5130837757772247,
    0.5433924964480873,
    0.5595661394033671,
    0.5612611481641328,
    0.5505006842494646,
    0.5246000467330063,
    0.49121342449070465,
    0.4762918687946864,
    0.43727652181277454,
    0.4464196075512324,
    0.44280532891140095,
    0.43668249614752563,
    0.46379927041285596,
    0.4829675861759548,
    0.4972845907472373,
    0.49602022198727747,
    0.4860151900053552,
    0.4781648603634109,
    0.4944392211308184,
    0.48947985908358416,
    0.46779610487117856,
    0.47701071471303935,
    0.4733625864419809,
    0.4492967935862958,
    0.4410209589524972,
    0.44311304383321204,
    0.4346703072485344,
    0.4351505049635741,
    0.4388268112361101,
    0.461676684143863,
    0.4655074787369432,
    0.4816215722335747,
    0.4805565490149622,
    0.46895131900558146,
    0.48763626628021345,
    0.4829262906872871,
    0.5175217950368164,
    0.5457608216474417,
    0.5594392240086137,
    0.5609035662029446,
    0.5482301684107609,
    0.5692634688209895,
    0.5757411139681927,
    0.575801621508028,
    0.5639745042380041,
    0.5419593711550369,
    0.5158926756352278,
    0.5043290879660374,
    0.492562144890709,
    0.4733323205372715,
    0.4313191034740763,
    0.43794329621255973,
    0.41829229088332315,
    0.44388800016056623,
    0.44224506914215594,
    0.4511558231447273,
    0.4463842472789297,
    0.46173503136680055,
    0.45729820566012214,
    0.47154833999776613,
    0.4736837494608285,
    0.47916174898487973,
    0.46442800023466557,
    0.440686722527731,
    0.46724814940714304,
    0.4688860826648159,
    0.4480724169718773,
    0.46018159274509773,
    0.48669485274679386,
    0.5038447163974079,
    0.5081788988692931,
    0.5265738688998747,
    0.532661659196319,
    0.525117536576012,
    0.5155999476925592,
    0.5115922425536976,
    0.5136686995903147,
    0.49651983024286955,
    0.478241794200778,
    0.4392199047098801,
    0.4528305360624717,
    0.4902504513516018,
    0.5077942837187461,
    0.5253434209926297,
    0.5284838645329623,
    0.5175219746538318,
    0.5067905283438324,
    0.4814162112969066,
    0.4450822171260159,
    0.438389797507725,
    0.44801206262471505,
    0.43358572601835216,
    0.45288874019924014,
    0.4559065690591331,
    0.4367230351938785,
    0.4653216671237844,
    0.48538981486720545,
    0.49087048008379597,
    0.4749562390613601,
    0.5134017341500716,
    0.5332721308744245,
    0.5459511478062974,
    0.5432751830648043,
    0.5243422290117524,
    0.49377003242921946,
    0.4462814289882474,
    0.4498543607272746,
    0.47876462559455135,
    0.4851489216318773,
    0.5090885391710287,
    0.5152368886542253,
    0.5037928658572418,
    0.47580596156471067,
    0.4859446245110178,
    0.47571492925735165,
    0.47556512869618944,
    0.44981316297391893,
    0.473884052444714,
    0.47422752817207847,
    0.486065087779636,
    0.4916711824221641,
    0.49404585370642906,
    0.4767509142736511,
    0.48757325845481647,
    0.49580652670445824,
    0.5013288068686179,
    0.4877167688231611,
    0.4834171417878557,
    0.4613255105732331,
    0.41521258950116763,
    0.4592662809953536,
    0.47962317975787155,
    0.4933316310283595,
    0.48577303538369404,
    0.46519406011506303,
    0.43031676172311106,
    0.4506723021200072,
    0.4449496544293857,
    0.45831313994752476,
    0.48950367271330897,
    0.5083422846520579,
    0.5109981230202734,
    0.5336884880098253,
    0.5373473237639759,
    0.5242795744792857,
    0.5100886019293417,
    0.482586117570803,
    0.4530863571703446,
    0.4565962899359315,
    0.45014028422277275,
    0.48152562291365103,
    0.5196043270936221,
    0.5385567780772176,
    0.5464831278589447,
    0.5464389430639967,
    0.5331189698914389,
    0.5101755483838282,
    0.5037707284830211,
    0.48198439524774006,
    0.49784292395613433,
    0.5321171664104561,
    0.5488889569479638,
    0.5488816725080089,
    0.5370313152436778,
    0.5169634919493682,
    0.48216935068797173,
    0.4341832391354705,
    0.40067939636429256,
    0.3913923750548794,
    0.4140751699741048,
    0.4091904666212117,
    0.4324118048617288,
    0.4587255950074745,
    0.4602289951583397,
    0.44212719529064365,
    0.45653080150317027,
    0.47102134503808823,
    0.46095960869287567,
    0.4506139213389475,
    0.476202353708989,
    0.5065373830281042,
    0.521594985244025,
    0.5202827317316099,
    0.5072462815708974,
    0.5066965012849105,
    0.5015708114344429,
    0.48018531391686353,
    0.4955411706630291,
    0.49132303542933287,
    0.5040860296822023,
    0.4968807040859966,
    0.4732946745330743,
    0.42687053169527756,
    0.4473755277165929,
    0.4402532095704461,
    0.45641014474119085,
    0.44839967249743823,
    0.4462701480604185,
    0.47932632475022496,
    0.4939586790406817,
    0.5062168560907383,
    0.5255147262468689,
    0.5246516402990818,
    0.507215944380451,
    0.4938285205236991,
    0.4699084673372226,
    0.4936862981260621,
    0.5047766426793917,
    0.4990566560931577,
    0.4731824735039717,
    0.4369422544851484,
    0.45194535077797704,
    0.4787319986725446,
    0.48576072242335455,
    0.47245826789785134,
    0.49250925857160094,
    0.4904149435066791,
    0.48108773119353465,
    0.5104436479272008,
    0.5254897146612041,
    0.5315141306021582,
    0.5215877316158384,
    0.4928275394283255,
    0.4933564971529121,
    0.4742229955284814,
    0.4364997098968356,
    0.43083121695542986,
    0.4317580973916053,
    0.45612794370575027,
    0.45259697857501635,
    0.5046922826452735,
    0.5382871698779516,
    0.561982452462652,
    0.5728897720246778,
    0.570784112783687,
    0.5559189823504784,
    0.5216953640168368,
    0.4822556676231541,
    0.4548459699601346,
    0.4340404120860959,
    0.4273180405034429,
    0.4593515081747048,
    0.47559162420668644,
    0.48003746645340606,
    0.47703575969358364,
    0.4517521657847709,
    0.46725290011924087,
    0.4625120047977114,
    0.45162421090986954,
    0.4436303314037079,
    0.44627836259204934,
    0.4742170563268348,
    0.48884782883976674,
    0.4985687491056144,
    0.5204019284856469,
    0.5238146383007467,
    0.5081681817727438,
    0.5012414605219828,
    0.4872157231089641,
    0.47313805666523373,
    0.4776764270226678,
    0.4593667369399389,
    0.44211982209786127,
    0.4643419601558197,
    0.4778741511985974,
    0.467919323999725,
    0.4398350733811439,
    0.44553074291739625,
    0.4506582750317488,
    0.47697790925938177,
    0.48145175626621955,
    0.48372718445576995,
    0.46342306128476407,
    0.4636025443580185,
    0.4700473817401808,
    0.47368059149501746,
    0.47158770802235483,
    0.44967033456460326,
    0.4682604587402728,
    0.46206982347975034,
    0.48361167333166677,
    0.48696807956213267,
    0.46611813289695425,
    0.47370703128233005,
    0.4936934878855622,
    0.49109312735803484,
    0.46916297075207386,
    0.4470931806590993,
    0.4474067360017133,
    0.45619618188971867,
    0.48055613402618,
    0.4864162945394607,
    0.47096148476951527,
    0.47161641526584575,
    0.4834498005866954,
    0.47889796589787875,
    0.4783940951342364,
    0.45670952161298795,
    0.4263352109144705,
    0.47211079813917756,
    0.4983511929839201,
    0.5070626474430504,
    0.4999130917669479,
    0.47356895178816283,
    0.4792234393985593,
    0.4720256338892771,
    0.43831519647670214,
    0.4812817846862979,
    0.5012450942322206,
    0.5053545913500705,
    0.5086578094014864,
    0.5243044679793258,
    0.5369263397690168,
    0.5352866204384703,
    0.5167852987975224,
    0.5253002311460684,
    0.5174151762376986,
    0.49015804861579165,
    0.4973377998234989,
    0.4974211553337427,
    0.4793007278974454,
    0.4659913150645414,
    0.4349287641014826,
    0.4240916045694833,
    0.42410696666465464,
    0.45555169151362945,
    0.46234939272963854,
    0.4500821981043269,
    0.45502116975881757,
    0.4916118387690232,
    0.5093785393236275,
    0.5080728637936767,
    0.5268933041211572,
    0.5380554341582311,
    0.5315408697838104,
    0.5464267323055692,
    0.5440888569440661,
    0.5315049433499649,
    0.5068015157689392,
    0.4638628143870635,
    0.4625635493620295,
    0.4557351340424118,
    0.4556243858216953,
    0.4745388542703949,
    0.49510557644088493,
    0.495782388228566,
    0.48182239013100536,
    0.4434686902365774,
    0.44297531889052166,
    0.4597981419796744,
    0.4492557353206366,
    0.4444973148856401,
    0.4516569524095071,
    0.47767481754758556,
    0.4825111837435035,
    0.4767350438084025,
    0.46567686821943977,
    0.4350032778243656,
    0.46700091656374687,
    0.5077590719506653,
    0.5301610438965276,
    0.5533733189488426,
    0.5656973357012838,
    0.5619522171812682,
    0.552451564264112,
    0.5430736442750356,
    0.5456894111018081,
    0.5310766123718655,
    0.5097538614838658,
    0.47311949992464986,
    0.4816719036123782,
    0.5167480585247096,
    0.5368210951832199,
    0.5442230059369418,
    0.5386843332311257,
    0.5254685870500944,
    0.5086536978161034,
    0.4763955599572702,
    0.4227245141004884,
    0.36622375368460247,
    0.3894939022054832,
    0.4069524761428152,
    0.4207944952294901,
    0.44419397272836314,
    0.4736752193568098,
    0.4820279817881879,
    0.48333754365576437,
    0.47376399541298975,
    0.4419409696243205,
    0.4718838412917289,
    0.4857986701144412,
    0.5105481983105673,
    0.5181484327166664,
    0.5353782224116913,
    0.5381020413284722,
    0.5311133161737478,
    0.5123404566878795,
    0.5025797771892008,
    0.5017087382847035,
    0.5158105690853615,
    0.5384378594829282,
    0.5451508096562314,
    0.5404389758926922,
    0.5260201378320336,
    0.5002430880424851,
    0.458171543410946,
    0.4679176536614803,
    0.46479282381475173,
    0.435393856824928,
    0.4736761720796685,
    0.49134743083138754,
    0.4870961192147593,
    0.48273590627413576,
    0.49441509495307645,
    0.4891399855022517,
    0.4765757696895962,
    0.5086308343402175,
    0.5262003791877374,
    0.5362851460559158,
    0.5392162062780231,
    0.5255203707424265,
    0.5012402015159066,
    0.5195246865181609,
    0.5236218560273427,
    0.5173297972639752,
    0.5348936648860726,
    0.5424728359662291,
    0.5450261408190478,
    0.5321248094264615,
    0.5168900826716809,
    0.4910845269515384,
    0.44359598571416237,
    0.3754220297460588,
    0.3936880699569747,
    0.41292024475719724,
    0.45225883694444,
    0.4667407786857279,
    0.4920065504517396,
    0.5047095649402905,
    0.4992145778136588,
    0.47163276585571534,
    0.4723114899457852,
    0.469214028418555,
    0.4609863163989051,
    0.4657251648805546,
    0.4658049267869231,
    0.45376409111981963,
    0.4636724449484667,
    0.4846360875236204,
    0.4933066227530822,
    0.5047292675538834,
    0.5073136447590028,
    0.4905292058220662,
    0.46416031562626137,
    0.42820338021915455,
    0.4752229430270088,
    0.4991170698668056,
    0.5164622325659648,
    0.5162205731935943,
    0.5107678046887986,
    0.5339566837499099,
    0.5444894839349955,
    0.5433971852782739,
    0.5270366545626719,
    0.5250729802019867,
    0.5312844707911665,
    0.5258502400838513,
    0.5190403091764911,
    0.507897145294391,
    0.4761385851753831,
    0.46244925075192,
    0.4548039568051637,
    0.432248150627517,
    0.3810302301581862,
    0.42340352388514574,
    0.4390343298397088,
    0.481541195799099,
    0.5031862587430667,
    0.5074660990303081,
    0.4927363772547997,
    0.5038921938896085,
    0.5024879559550207,
    0.5005122970754329,
    0.4876178265780714,
    0.5123692734727225,
    0.5213066643118888,
    0.5135486285926524,
    0.5027404048552578,
    0.5180505479439989,
    0.5152020274900451,
    0.5085764712505513,
    0.5010541221139527,
    0.4743918840755623,
    0.45390725771936724,
    0.4154766475023918,
    0.44935576151829765,
    0.4561149356827924,
    0.46628853201696385,
    0.4526878863588256,
    0.4462478293077856,
    0.48208289706594964,
    0.509217438238782,
    0.5219526982174558,
    0.5237007876311679,
    0.5268587772768641,
    0.5264458789615057,
    0.5160663467675555,
    0.48808311135181554,
    0.4449331946572575,
    0.4586203314098376,
    0.44532098605737824,
    0.43210446857288404,
    0.45309487595083786,
    0.4851531589572156,
    0.497928796928998,
    0.5060010847099219,
    0.5280536656236047,
    0.5305440152090052,
    0.5307111896327494,
    0.5294545023454076,
    0.5176657643221025,
    0.511319613146897,
    0.49174163969662077,
    0.48167861594945627,
    0.4651294489129739,
    0.44001856926115723,
    0.43242334384706205,
    0.46761077964492614,
    0.4780943135082477,
    0.4680745179948949,
    0.49672517506060493,
    0.5077535807191568,
    0.49920510385455685,
    0.47007151341892195,
    0.49206893089408005,
    0.5065737025822852,
    0.49986473686930494,
    0.47439166431556173,
    0.47485266834598006,
    0.4680641369955625,
    0.4761954074073949,
    0.48123775431840893,
    0.5017080687991682,
    0.5057650320105362,
    0.4934311852810776,
    0.5188788988065517,
    0.5285698750262202,
    0.5219196056689824,
    0.49909588699293017,
    0.45687369151556617,
    0.39793171976600866,
    0.43249532679063896,
    0.47487860467174425,
    0.49366567090173535,
    0.5112962223047978,
    0.5248878185193728,
    0.5325553620822043,
    0.5238011745057809,
    0.5136787507869398,
    0.48673843830134295,
    0.45546899993698187,
    0.4733849002498857,
    0.47356619942173195,
    0.4508512652462938,
    0.40704898250380406,
    0.4597579113873337,
    0.4894395363026631,
    0.5014605843208534,
    0.49610784890060167,
    0.47209466123858423,
    0.5038226772447436,
    0.5178415891065719,
    0.5305665388636899,
    0.5430515814200761,
    0.5513121417725216,
    0.5431723056892178,
    0.5523894020547857,
    0.5528094307775968,
    0.540406271176386,
    0.5126341665256077,
    0.4740267890825919,
    0.4378919658159631,
    0.42570608101037594,
    0.4475988999120971,
    0.4510634024830124,
    0.4333914313524477,
    0.4322584748149364,
    0.41048871573505696,
    0.4502591116153479,
    0.5034813847480937,
    0.5374282633589091,
    0.5553931116742479,
    0.5744174310033489,
    0.5850087266768378,
    0.5848704332979767,
    0.5792297759558988,
    0.5614788746556069,
    0.574046414227371,
    0.5725372971369675,
    0.5616604419761271,
    0.5387498599170405,
    0.5115486529281694,
    0.4713424563336218,
    0.4320939938086523,
    0.36556529215257255,
    0.41598859853138004,
    0.43906422408155665,
    0.4682298022374969,
    0.49715593158502874,
    0.5085770709999455,
    0.5118348191889226,
    0.5232199416888986,
    0.5172302127112791,
    0.4989181648437103,
    0.46106590686948107,
    0.48688498629264554,
    0.5131584564516817,
    0.5261769087800502,
    0.5485310598641672,
    0.5615661844990674,
    0.5567424799419424,
    0.544416180325874,
    0.5190735394094006,
    0.5188950791367566,
    0.5059112839975101,
    0.4854818857676122,
    0.4418003089667476,
    0.44839624991706417,
    0.4845602931695406,
    0.4998443593452878,
    0.49854308460260777,
    0.47924936984915245,
    0.437652978805667,
    0.42397215152266343,
    0.43023217424181565,
    0.46247234438849316,
    0.47290380221697836,
    0.46409684768296505,
    0.4301285637754814,
    0.4469330601714258,
    0.4729289133654121,
    0.4746267146085388,
    0.45407656939594865,
    0.47797589727182704,
    0.48458346908775907,
    0.5067938530028531,
    0.5102664951766945,
    0.4929333893466527,
    0.5311814272061426,
    0.5519451907449695,
    0.558119841120493,
    0.5580438391986763,
    0.5778829912195104,
    0.5827720394170022,
    0.5818296913163811,
    0.5832318128164059,
    0.5756633840181762,
    0.5734985828125081,
    0.5581929635675403,
    0.5492179610881966,
    0.5316595554822029,
    0.49860793017386085,
    0.46008630822282415,
    0.39785452302125934,
    0.42641380677169954,
    0.4241572516134184,
    0.4454629870742156,
    0.4392926889955505,
    0.40284450309639286,
    0.4444023701074407,
    0.4622123360214564,
    0.45420427414902215,
    0.49113532084685263,
    0.5192848538114868,
    0.5392524115916585,
    0.5442556358878485,
    0.5302501212699777,
    0.5010032236983676,
    0.4789150470039825,
    0.4735029157753939,
    0.4471530467563488,
    0.4678114182997947,
    0.47092037142649323,
    0.4521903323971812,
    0.41243079744241207,
    0.4638800200677876,
    0.5082643625037113,
    0.5352475875887072,
    0.5510609289803243,
    0.5600660071798307,
    0.5604747185023174,
    0.547734735032639,
    0.5200850299368367,
    0.5247108236447462,
    0.5107126562383262,
    0.5049779621499602,
    0.4797848736580216,
    0.48278477301985534,
    0.4660921152208434,
    0.4618407231041789,
    0.4702992873596471,
    0.46953114304546617,
    0.44603308498932676,
    0.47998991174804856,
    0.4963582835729287,
    0.5107610021315321,
    0.5277687604676191,
    0.5370769747505773,
    0.5523603072527995,
    0.5552182766358194,
    0.5542970637656676,
    0.5399666832522251,
    0.5095753755652501,
    0.46072840381849983,
    0.44955600130620554,
    0.4561500502558096,
    0.43821386435798343,
    0.44173581669039724,
    0.41658948645053695,
    0.45810845278463275,
    0.5027389088964211,
    0.527458954658082,
    0.5407053109612978,
    0.5395163158330795,
    0.5526320990380806,
    0.5530059195826491,
    0.5384689395957809,
    0.5120586630203416,
    0.5171832144024979,
    0.5074760738458044,
    0.48033089525141176,
    0.44438637085512334,
    0.42898891432092706,
    0.45843726081124536,
    0.4724556919897277,
    0.4638969707452536,
    0.48531310506498554,
    0.4864586489368771,
    0.47092207739530767,
    0.43074925138044406,
    0.44977889356306405,
    0.4423429737952665,
    0.4790411302185368,
    0.49903743427875885,
    0.5015330590552194,
    0.5130933011023515,
    0.5053904192053535,
    0.48970308691120545,
    0.5004847054888084,
    0.5068435403880354,
    0.49319044635753484,
    0.4616017350251161,
    0.4321227803195642,
    0.4559234919062263,
    0.4916252673304002,
    0.5268192354576482,
    0.5466807216299866,
    0.5602087042193787,
    0.5583765874295025,
    0.5447458558204593,
    0.5173777381156509,
    0.473595249392852,
    0.44503571441315914,
    0.4521819342677003,
    0.4684083323951942,
    0.473611487546977,
    0.5028550356845523,
    0.5129265523566388,
    0.5065590258036414,
    0.4816733799779656,
    0.4771512846219433,
    0.48055493739994004,
    0.4732727433365508,
    0.4980171893948831,
    0.5063932853044879,
    0.5072246968987938,
    0.5273165270429387,
    0.5316753902958044,
    0.5203584351773175,
    0.49231441958907973,
    0.49093953492192083,
    0.48256894418316537,
    0.4804089370842696,
    0.45897909216166194,
    0.412987186569333,
    0.378536511201624,
    0.40794469680196455,
    0.4203555334280621,
    0.3994439676658262,
    0.43689542242857116,
    0.4645080692140594,
    0.48815496912435874,
    0.4924677279544721,
    0.5037655446824578,
    0.5235835686063937,
    0.526836631147153,
    0.5206806162010731,
    0.5042058338128091,
    0.46852892896802334,
    0.4602523557828313,
    0.454268971436393,
    0.45739544180220537,
    0.46281801930737265,
    0.48914518932061324,
    0.49761853389439265,
    0.5190654112309205,
    0.5234190348404635,
    0.5081268511104458,
    0.47843666865966367,
    0.5095497931153588,
    0.520844509030882,
    0.5316397475844206,
    0.5368975116712033,
    0.524567087468417,
    0.49389520343973814,
    0.49174133730287906,
    0.46973462181082287,
    0.42252934589883717,
    0.4142796019212692,
    0.4102801434039887,
    0.431703008882345,
    0.45541273115397346,
    0.4516856029407146,
    0.43838387688069724,
    0.4553513455025239,
    0.4600700355592612,
    0.45857362457373296,
    0.4383699779613896,
    0.4610461007648922,
    0.45917174931552757,
    0.48405546867565474,
    0.49603166192296466,
    0.5052426346981627,
    0.49840417194543807,
    0.4916088057237566,
    0.5049539039839321,
    0.4966841110396024,
    0.48353591768136095,
    0.4809190042889921,
    0.45513473016866135,
    0.47528348497743833,
    0.4706055503243268,
    0.4870965230089298,
    0.4821020373008212,
    0.4891024269151677,
    0.4785286276235687,
    0.47387523912131124,
    0.4508897794353377,
    0.47333336398151404,
    0.4782599872591651,
    0.45864782036050045,
    0.46300681442137703,
    0.4951979016640221,
    0.5067010630638163,
    0.4973413071807727,
    0.514564259903388,
    0.5258140628371752,
    0.5189785596927952,
    0.5017008898878714,
    0.5090576189337044,
    0.5069192423192802,
    0.4964853364670862,
    0.4690603921798158,
    0.4237355827131985,
    0.4107626297774914,
    0.42484257443585516,
    0.4294663532851484,
    0.462383144414183,
    0.48284184817675674,
    0.4797233384048356,
    0.5176758011397944,
    0.5384770482237138,
    0.5556997371864597,
    0.5574785156897711,
    0.5487125993479193,
    0.5550908043368901,
    0.5545290011141926,
    0.5396575988050198,
    0.5206368232873992,
    0.5061447863194112,
    0.47459608664332775,
    0.4580967110002089,
    0.417020853922548,
    0.4461209778026385,
    0.4475683361317411,
    0.4703924113867505,
    0.4906885722486557,
    0.48862594144236055,
    0.47233633276034226,
    0.4503587772496361,
    0.4413698713161021,
    0.44076648637055876,
    0.4551356406597343,
    0.4520337473969064,
    0.4587337827553277,
    0.4991006019261343,
    0.5206766157866847,
    0.5247681428375441,
    0.530427566712485,
    0.523619361150181,
    0.5237362936172518,
    0.5085819318801913,
    0.47725541704217145,
    0.4451114112968438,
    0.455844941243641,
    0.4473606753214893,
    0.45578976601146143,
    0.47384413927348057,
    0.49322948519833715,
    0.4917040030837378,
    0.4972370384457155,
    0.50910512750762,
    0.5155456094878504,
    0.5132831748886588,
    0.49236021532401253,
    0.4569377519787726,
    0.4532963956275077,
    0.43872311669805997,
    0.4293683516566257,
    0.44146873626547656,
    0.4775809808867003,
    0.5017939841204979,
    0.5144799511286968,
    0.5142072714809576,
    0.4951404469539211,
    0.46099262806714636,
    0.44573937872986963,
    0.4668410883636609,
    0.46396476236556133,
    0.47730791821217194,
    0.5044984694815837,
    0.511371970950983,
    0.5072036775349004,
    0.503729708368585,
    0.514896638282716,
    0.5176648526823426,
    0.5088025056447145,
    0.5074721394578686,
    0.48573266847791474,
    0.4861605062103397,
    0.4639716429414299,
    0.46514515205438756,
    0.47445245108157186,
    0.46311225169252007,
    0.49973776564642713,
    0.5181042523876861,
    0.5405802422204885,
    0.549682462447578,
    0.5634702635493141,
    0.5741639997286156,
    0.569506646008106,
    0.5646682710140242,
    0.5454835018856927,
    0.5099933875807643,
    0.4991303165943878,
    0.48149263045518725,
    0.4435342204485228,
    0.3802360806595635,
    0.40105106495605486,
    0.4290726387747054,
    0.44996418701703994,
    0.4469251939365918,
    0.4749345352598541,
    0.4779954255724295,
    0.4930774090771952,
    0.487497752433082,
    0.46203505128932604,
    0.4161460964923937,
    0.4290223981297746,
    0.4443935296210695,
    0.46752347253206555,
    0.47264555530789504,
    0.48712625994495296,
    0.4971328417357997,
    0.5073481502244432,
    0.5056460292938303,
    0.4906920026843832,
    0.46048918033629704,
    0.478521661494476,
    0.472699960467769,
    0.4590738600577498,
    0.48978190549467227,
    0.49551966240482936,
    0.4924837107476415,
    0.48956683174979176,
    0.4656357725536724,
    0.4640306410736044,
    0.488546554639311,
    0.49218639304437073,
    0.4806746283998834,
    0.4809550016705174,
    0.45959893485043246,
    0.47767561418374704,
    0.47340619152674124,
    0.4538641266700901,
    0.4196006597917152,
    0.45317538016842623,
    0.45785470224207697,
    0.49985229560504596,
    0.5217184159264063,
    0.5238566972707756,
    0.5126479760592049,
    0.4812497192622126,
    0.47106935198546845,
    0.4830116090398178,
    0.4721035191645355,
    0.4582417689540523,
    0.4388061610667928,
    0.41628232360277273,
    0.399335482076591,
    0.44927190868262246,
    0.47546337852247894,
    0.48111317052131397,
    0.4684125627897674,
    0.43166656916507284,
    0.4174120436482275,
    0.4672824696611332,
    0.499220225096811,
    0.5260530616272535,
    0.5406420498211678,
    0.5424485825506428,
    0.5306309120699721,
    0.5108168932753416,
    0.5071873492825182,
    0.4848148212967381,
    0.4571707982507756,
    0.4526741530101682,
    0.4845678020179215,
    0.4942667634511344,
    0.4819612707304854,
    0.47336431477192964,
    0.46877074466050556,
    0.4399407745141465,
    0.46112081204529376,
    0.4858862260676875,
    0.48898195532743216,
    0.4967667441382816,
    0.4929585413336105,
    0.47369258981493606,
    0.4861717063321672,
    0.47610115561597854,
    0.4435774270418674,
    0.46667356212260075,
    0.4705591171307285,
    0.4569272951724332,
    0.4943601011307244,
    0.5136752340901621,
    0.5144131442644306,
    0.5147648936265349,
    0.5398627646514464,
    0.5500770093217457,
    0.5454852732413027,
    0.525576218548756,
    0.49975142777416226,
    0.4976229085871351,
    0.4923144851216069,
    0.4674510251546914,
    0.4520236742811708,
    0.451630607930135,
    0.4267129618534419,
    0.46401431004034877,
    0.48250049428350755,
    0.5069079052346954,
    0.5117021492479672,
    0.5141361979799084,
    0.5045009513321487,
    0.47552726229584386,
    0.42799220566400153,
    0.3960485807916402,
    0.4407327976362693,
    0.4563071163463922,
    0.46952138271347116,
    0.4736280605992286,
    0.46012454795263347,
    0.4475015921168013,
    0.489622902142806,
    0.5115360376225307,
    0.5196329289988209,
    0.5115474437675975,
    0.5099438022220408,
    0.48880847150560813,
    0.5018546393859075,
    0.5105519710980752,
    0.4990869738907831,
    0.5302416367888068,
    0.5454238093040036,
    0.5413266294117649,
    0.5346331326518279,
    0.5141394220676835,
    0.47621933833151164,
    0.5070438241431443,
    0.5236190425243326,
    0.5232131001184595,
    0.5286965792588636,
    0.5164013751640715,
    0.48789132043157946,
    0.4830360239963921,
    0.4580708688843192,
    0.4499709408289346,
    0.42398574369327136,
    0.4533629854797825,
    0.45968631858128417,
    0.4433575643936445,
    0.4028130954040273,
    0.44166564398455843,
    0.46698853215289693,
    0.4756271234404922,
    0.4860374183741964,
    0.487532897742768,
    0.48703518281420016,
    0.48954688442014066,
    0.47462488346602577,
    0.48941513716597224,
    0.48136873231263344,
    0.48002900816366456,
    0.47345686745531346,
    0.4448602738171828,
    0.4383985804918965,
    0.4055726617198892,
    0.43738334339668195,
    0.45803929344475486,
    0.4682107414940333,
    0.5020068878753456,
    0.5287121996119656,
    0.5362379995458962,
    0.5349046955984291,
    0.529980132732615,
    0.5102564878316334,
    0.4723252672666227,
    0.47466970995424784,
    0.4592089790036796,
    0.4777824114423447,
    0.4763455100925908,
    0.4552842915922267,
    0.47837330921583393,
    0.48018199561803404,
    0.47067711440139953,
    0.46213313982017745,
    0.47487353958483014,
    0.47034886440218215,
    0.4930941373670528,
    0.49919655242510536,
    0.5168993112045172,
    0.5176293001460548,
    0.5256065689553339,
    0.5194032946644369,
    0.5230767307280482,
    0.5072574511264089,
    0.48887633741415104,
    0.49496220232830074,
    0.4898482287354928,
    0.5002018861663955,
    0.4945293462757613,
    0.5029166927643219,
    0.5031567175881875,
    0.5026364451199139,
    0.5090439701928643,
    0.49863724298208006,
    0.4710896611650058,
    0.45867526266509834,
    0.4397457162898045,
    0.40068998738464323,
    0.430803053604395,
    0.45218441978538826,
    0.4475186184301304,
    0.4581027496517443,
    0.44929771982431116,
    0.4352853593328467,
    0.41601974544230347,
    0.4511228218501856,
    0.45963915813008294,
    0.46827830127138287,
    0.4774706002882108,
    0.47555923671159384,
    0.4609223001663175,
    0.4196540270594948,
    0.44853979360525364,
    0.47316076104590976,
    0.47633748168773205,
    0.4679389385510434,
    0.48174244541976663,
    0.46888910177092946,
    0.453121794639852,
    0.45231997505752836,
    0.5004012999950875,
    0.5275456316326215,
    0.5355229044482526,
    0.5269035318183957,
    0.5509881463541763,
    0.5668916083420039,
    0.5708336665439185,
    0.5785602204798066,
    0.5785979218100538,
    0.5654000882643629,
    0.5356836450390621,
    0.5211882328276041,
    0.48715329681578234,
    0.4904206641052856,
    0.49403830560348067,
    0.48092590777139144,
    0.46049620856630524,
    0.4261990369364367,
    0.4061983445377195,
    0.4231788882266675,
    0.4216365204560012,
    0.43170810706451873,
    0.4205076695649318,
    0.43970300218213476,
    0.45149013599026055,
    0.45100106022311354,
    0.4713127028496539,
    0.4664721842074873,
    0.4928600880480949,
    0.5024605366646748,
    0.497292615512562,
    0.4890951584684954,
    0.5034949695494629,
    0.5144382103902523,
    0.5147977358620446,
    0.4999770278167657,
    0.4886961880101156,
    0.49548848879390156,
    0.4828150197655594,
    0.4625633784719224,
    0.43007720432673463,
    0.47100519205477853,
    0.5076469928009109,
    0.5286350755578967,
    0.5332270990955915,
    0.53845825126672,
    0.5422792912208901,
    0.544454993246529,
    0.5371109665142343,
    0.5110530740890298,
    0.4675586105050649,
    0.49831171473585745,
    0.5086560585918783,
    0.5000288103524781,
    0.501784833760776,
    0.4904824774636932,
    0.46207750757171207,
    0.4729941876344747,
    0.4664833881022844,
    0.4517013220065869,
    0.4281033430385158,
    0.43378973226122747,
    0.4452831555934395,
    0.4580951518603002,
    0.44607228695752454,
    0.47145785330301965,
    0.4847625131426356,
    0.4780759906125892,
    0.45580984193960683,
    0.47614726018402787,
    0.4724042856937043,
    0.5036816368907109,
    0.514579114907231,
    0.5062005214252839,
    0.5069726900931756,
    0.5230498353850592,
    0.5220517225046202,
    0.5030303992608794,
    0.4993910801450535,
    0.474409872670641,
    0.465668302390245,
    0.44338300004877607,
    0.4481294644936608,
    0.4723347860731947,
    0.48270101422435124,
    0.48237125770206174,
    0.4787017766680625,
    0.48815360467364977,
    0.48807691325327385,
    0.507015845226171,
    0.510115053551558,
    0.4936923780218968,
    0.5119021218385785,
    0.5199301492506758,
    0.5167614122537947,
    0.4960291511486017,
    0.4564892493959537,
    0.4270525185480277,
    0.4438942624064346,
    0.4632334560592333,
    0.45661092110356744,
    0.4261713123723814,
    0.44264511007020146,
    0.44369658961905856,
    0.4690019189504806,
    0.5064298065313065,
    0.5286289883329165,
    0.5462172913083543,
    0.572812333452098,
    0.5820086931653405,
    0.5977743077304137,
    0.6005843963415007,
    0.589779119338842,
    0.5676267786208331,
    0.5353018140142037,
    0.4905591255771162,
    0.43816090984500694,
    0.435375531840973,
    0.4485728511682785,
    0.4336756872870112,
    0.4506076871605015,
    0.4418642396025591,
    0.45171467288611256,
    0.4512072581799142,
    0.4549033460671018,
    0.45386715423992746,
    0.42930233953060115,
    0.4326066592425506,
    0.42730262051492807,
    0.4081495832194686,
    0.40297156913515436,
    0.39887741149674627,
    0.4342848610835734,
    0.4589589768163872,
    0.47924161300155915,
    0.4782823594361571,
    0.46977441677205184,
    0.4450111588818479,
    0.4627442560387781,
    0.45620837076960247,
    0.4711508311462437,
    0.4808772265322707,
    0.48402394559805534,
    0.4709293779878336,
    0.47443825410205803,
    0.4637884931732767,
    0.43277662560511443,
    0.4641042714265534,
    0.4700497851190061,
    0.48755149089503513,
    0.48978078398628044,
    0.4754095314972348,
    0.47915648606811506,
    0.4828666086180788,
    0.4661319687910626,
    0.46222519574833265,
    0.4515044125669653,
    0.4671150221305502,
    0.490961061973333,
    0.4934404354918909,
    0.4906412500811945,
    0.4840909628787619,
    0.4577925339650668,
    0.4634607172620794,
    0.45237059085294584,
    0.48777873779648184,
    0.5033963595340685,
    0.5052750370412371,
    0.49735044844655424,
    0.48393409087257383,
    0.48235464008536166,
    0.45908198130738853,
    0.45783744362059436,
    0.4640632125694589,
    0.45794384592156845,
    0.4277768052130435,
    0.4564168218700665,
    0.4706406487913963,
    0.4964853949882174,
    0.5126696478448836,
    0.508736096248424,
    0.5130260578678227,
    0.537446871544127,
    0.5449681623965097,
    0.5423737998955883,
    0.526697161876511,
    0.5037096814248888,
    0.48965460787312426,
    0.4528373973186063,
    0.4601679021129647,
    0.45483961992826805,
    0.4274692045648928,
    0.37218106762965786,
    0.4305243396306845,
    0.47021096275341306,
    0.49300781294852286,
    0.5314778049570155,
    0.5560520072601552,
    0.563974283569302,
    0.5647721045474531,
    0.5572578223056122,
    0.5373678935189673,
]).reshape((2516,))

IDENTITY_MEAN_LOG_VOLATILITY_MEAN = np.array([
    5.3446576965,
]).reshape(())

IDENTITY_MEAN_LOG_VOLATILITY_MEAN_STANDARD_ERROR = np.array([
    0.00039864915223491846,
]).reshape(())

IDENTITY_MEAN_LOG_VOLATILITY_STANDARD_DEVIATION = np.array([
    0.1840790889969047,
]).reshape(())

IDENTITY_PERSISTENCE_OF_VOLATILITY_MEAN = np.array([
    0.9643991159349999,
]).reshape(())

IDENTITY_PERSISTENCE_OF_VOLATILITY_MEAN_STANDARD_ERROR = np.array([
    2.8303304300600763e-05,
]).reshape(())

IDENTITY_PERSISTENCE_OF_VOLATILITY_STANDARD_DEVIATION = np.array([
    0.007805919031681402,
]).reshape(())

IDENTITY_WHITE_NOISE_SHOCK_SCALE_MEAN = np.array([
    0.310704774755,
]).reshape(())

IDENTITY_WHITE_NOISE_SHOCK_SCALE_MEAN_STANDARD_ERROR = np.array([
    0.00011251061649338455,
]).reshape(())

IDENTITY_WHITE_NOISE_SHOCK_SCALE_STANDARD_DEVIATION = np.array([
    0.028085236102570483,
]).reshape(())
