# Lint as: python2, python3
# Copyright 2020 The TensorFlow Probability Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
r"""Ground truth values for `radon_contextual_effects_minnesota`.

Automatically generated using the command:

```
python -m inference_gym.tools.get_ground_truth \
  --target=radon_contextual_effects_minnesota \
  --stan_samples=20000
```
"""

import numpy as np

IDENTITY_COUNTY_EFFECT_MEAN = np.array([
    1.3704574330049997,
    1.4293326126600001,
    1.387051684465,
    1.465267674995,
    1.3975043663349997,
    1.37603627028,
    1.5139071096400003,
    1.41928106849,
    1.3399944953749998,
    1.37467573236,
    1.4622858357,
    1.41151106104,
    1.4222172687799999,
    1.470370195005,
    1.3633706159000003,
    1.3650217175850001,
    1.304376628395,
    1.4149005631849998,
    1.35084569431,
    1.415954138715,
    1.4386622488399998,
    1.2018762093300002,
    1.357002145895,
    1.5064336261349998,
    1.5113800854,
    1.3875867442,
    1.3713110762150003,
    1.375325361905,
    1.4126984921149999,
    1.3928277631300001,
    1.457507359585,
    1.37659715725,
    1.471196566475,
    1.3862499153249999,
    1.355564720735,
    1.47634818382,
    1.2568197950949997,
    1.4938686854400003,
    1.4144767098700002,
    1.45994520881,
    1.44816726192,
    1.387077425685,
    1.386671059945,
    1.282690222035,
    1.2909634292749999,
    1.3608389845000002,
    1.3516197706350002,
    1.336691472295,
    1.4116720755649999,
    1.4241525464999998,
    1.4720664127299998,
    1.417885994345,
    1.343876836855,
    1.25597826411,
    1.4426557231749997,
    1.339458244695,
    1.2845449223099998,
    1.3961101031100003,
    1.38442969194,
    1.369894085335,
    1.40465302904,
    1.4322646460099997,
    1.37947276004,
    1.4717920918499998,
    1.3580605792500002,
    1.456066065915,
    1.468665722095,
    1.4334153507849998,
    1.3494718798749998,
    1.20707457483,
    1.369861499965,
    1.39068500142,
    1.3976011895950002,
    1.3085501668500001,
    1.416348746155,
    1.4136102098199999,
    1.447225589375,
    1.4255610943500001,
    1.2549513882149999,
    1.39058286224,
    1.48896546861,
    1.418044820695,
    1.331518051955,
    1.482028134755,
    1.3591791435749998,
]).reshape((85,))

IDENTITY_COUNTY_EFFECT_MEAN_STANDARD_ERROR = np.array([
    0.00043378877555807826,
    0.00038455155818166323,
    0.0004818854684003893,
    0.0007794499308176886,
    0.00045242776073851573,
    0.0004124270488362963,
    0.0009418311651318006,
    0.0005590387315337962,
    0.000448509023829179,
    0.00048508897123991884,
    0.000725156938748939,
    0.0004527901013173799,
    0.000488756374719811,
    0.0007241824027827133,
    0.0004753310168024939,
    0.00044095639766659616,
    0.0006785376449157354,
    0.0004864663115831901,
    0.0002854882115304121,
    0.0004944414881747714,
    0.0005617809079679903,
    0.0012778248448860553,
    0.0004721182068294251,
    0.0009682111875847014,
    0.000917058494175578,
    0.0002512675578729523,
    0.00043647910952524427,
    0.00047391690981862604,
    0.0004818578532328103,
    0.0003860035224382364,
    0.0006885480440874546,
    0.00040276196986838923,
    0.0007720521466705149,
    0.00048643323772644523,
    0.0005074510086074087,
    0.0008865758289351734,
    0.0009012137854679572,
    0.0009628431373922607,
    0.0004998673849295239,
    0.0007578299623783381,
    0.0006237988429737934,
    0.00044294816063474886,
    0.0004863678689942122,
    0.0007261101668621947,
    0.0006453042397207494,
    0.00040662576259784216,
    0.0004945131225959214,
    0.00047937700104992665,
    0.00042835775062854655,
    0.0005689619122227257,
    0.0008154631448570136,
    0.000490186858060219,
    0.0004931198773864684,
    0.0007091975729349492,
    0.0006112447726825634,
    0.0005342280977473613,
    0.0007563123855243394,
    0.0004521402832538271,
    0.00046794103609496766,
    0.0004212130707159165,
    0.00036257952793174473,
    0.0005631010422840254,
    0.0004526246852834399,
    0.0007227858069077868,
    0.0004492062076703649,
    0.0006915993143010365,
    0.0007124384306183623,
    0.0005303023288082047,
    0.0004428119695306855,
    0.0006376850081669849,
    0.000349012236960844,
    0.00037021390616609457,
    0.00045266920275107304,
    0.0006350784594305646,
    0.0005244030425548467,
    0.0004869982982381482,
    0.0006159562546927964,
    0.0005387739726589804,
    0.0009711800406651867,
    0.00030638839818231226,
    0.0009401842221337083,
    0.0005348873348745119,
    0.0004537743666111552,
    0.0007761920975178501,
    0.0004427274898622078,
]).reshape((85,))

IDENTITY_COUNTY_EFFECT_STANDARD_DEVIATION = np.array([
    0.14734132347449616,
    0.10126396381880924,
    0.15363472435684586,
    0.15010624030320954,
    0.14753894679256743,
    0.1482399409867741,
    0.13653174659200878,
    0.15025476312102287,
    0.13189865726676803,
    0.14411181936219725,
    0.14893408012135648,
    0.14554720749166017,
    0.1414171453975923,
    0.1321215495580536,
    0.149215632220668,
    0.15298288003242408,
    0.1570356930491398,
    0.13070034828502014,
    0.08091741918062538,
    0.1492753881864917,
    0.13527097334074134,
    0.1691973807928993,
    0.1549159787135075,
    0.14736758403858066,
    0.1355465319933819,
    0.06930156893388245,
    0.14207911840593107,
    0.14746004432015564,
    0.1507932236177715,
    0.12865640902097053,
    0.14739809950822852,
    0.14531308378731542,
    0.15349182434640585,
    0.15232555295958825,
    0.145836297450113,
    0.16346455324056403,
    0.1476664000184243,
    0.1614067949578853,
    0.14509156509226495,
    0.15305595240606845,
    0.1391474035911409,
    0.15696590510294645,
    0.13907207370502922,
    0.14646559566053322,
    0.13401436391769472,
    0.14294204367374108,
    0.15548149022679156,
    0.13497185750117885,
    0.1264572634195295,
    0.1588726884790733,
    0.1530013834703638,
    0.14925261011382807,
    0.15147616889633467,
    0.11991952194965996,
    0.14175964465140917,
    0.15454932264531554,
    0.14924315861887996,
    0.14651308871757598,
    0.14904530458494467,
    0.15235349548340454,
    0.1038448902751268,
    0.1463622969224604,
    0.14972643627917587,
    0.1342749938539407,
    0.15264713606394584,
    0.13904636432883974,
    0.13430586976559095,
    0.13777868993324957,
    0.14604062321112027,
    0.08457309784807807,
    0.10913163099315637,
    0.12941150269082682,
    0.15242160307707425,
    0.1512327808432346,
    0.15154225940123717,
    0.1474825067548986,
    0.14174406071250334,
    0.1473639256040764,
    0.16318040212713508,
    0.09141715616104276,
    0.16426884333754227,
    0.15834915413090245,
    0.12871999474884913,
    0.1320536518406819,
    0.15308636940647516,
]).reshape((85,))

IDENTITY_COUNTY_EFFECT_MEAN_MEAN = np.array([
    1.3926324686,
]).reshape(())

IDENTITY_COUNTY_EFFECT_MEAN_MEAN_STANDARD_ERROR = np.array([
    0.00037260654849879157,
]).reshape(())

IDENTITY_COUNTY_EFFECT_MEAN_STANDARD_DEVIATION = np.array([
    0.05089620565031372,
]).reshape(())

IDENTITY_COUNTY_EFFECT_SCALE_MEAN = np.array([
    0.14478838968500002,
]).reshape(())

IDENTITY_COUNTY_EFFECT_SCALE_MEAN_STANDARD_ERROR = np.array([
    0.0006879029769937458,
]).reshape(())

IDENTITY_COUNTY_EFFECT_SCALE_STANDARD_DEVIATION = np.array([
    0.04973664308706159,
]).reshape(())

IDENTITY_LOG_RADON_SCALE_MEAN = np.array([
    0.7599694699449999,
]).reshape(())

IDENTITY_LOG_RADON_SCALE_MEAN_STANDARD_ERROR = np.array([
    7.251513923332775e-05,
]).reshape(())

IDENTITY_LOG_RADON_SCALE_STANDARD_DEVIATION = np.array([
    0.018310779659695388,
]).reshape(())

IDENTITY_WEIGHT_MEAN = np.array([
    0.71445485752,
    -0.7141921106649999,
    0.39890424115780443,
]).reshape((3,))

IDENTITY_WEIGHT_MEAN_STANDARD_ERROR = np.array([
    0.0003418609449277563,
    0.0002188782450466194,
    0.0011736849237801805,
]).reshape((3,))

IDENTITY_WEIGHT_STANDARD_DEVIATION = np.array([
    0.09094040610561843,
    0.0734182847695389,
    0.20019045959378673,
]).reshape((3,))
