# Lint as: python3
# Copyright 2020 The TensorFlow Probability Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ============================================================================
# pylint: disable=line-too-long
r"""Synthetic dataset generated from the ItemResponseTheory model.

This was generated using the following snippet:

```python
import tensorflow.compat.v2 as tf
tf.enable_v2_behavior()

import tensorflow_probability as tfp
from inference_gym.internal import array_to_source
from inference_gym import using_tensorflow as gym
import numpy as np

rng = np.random.RandomState(seed=1)

student_ids = np.arange(400)
question_ids = np.arange(100)

student_ids, question_ids = np.meshgrid(student_ids, question_ids)
mask = rng.binomial(1, 0.75, size=student_ids.shape).astype(np.bool)

student_ids = student_ids[mask]
question_ids = question_ids[mask]
dummy_correct = np.ones_like(student_ids)

model = gym.targets.ItemResponseTheory(
    train_student_ids=student_ids,
    train_question_ids=question_ids,
    train_correct=dummy_correct)
dataset = model._sample_dataset(seed=2)

sources = []
sources.append(
    array_to_source.array_to_source(
        'STUDENT_IDS', dataset['train_student_ids']))
sources.append(
    array_to_source.array_to_source(
        'QUESTION_IDS', dataset['train_question_ids']))
sources.append(
    array_to_source.array_to_source(
        'CORRECT', dataset['train_correct']))

with open('/tmp/synthetic_item_response_theory.py', 'w') as f:
  f.write("\n\n".join(sources))
```

Note that the final `_sample_dataset` is not reproducible, hence the output is
checked in.

"""

import numpy as np

STUDENT_IDS = np.array([
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    11,
    12,
    14,
    15,
    16,
    17,
    18,
    19,
    22,
    23,
    26,
    27,
    28,
    30,
    31,
    33,
    34,
    35,
    36,
    38,
    41,
    42,
    44,
    45,
    47,
    48,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    67,
    69,
    71,
    72,
    74,
    75,
    77,
    79,
    81,
    83,
    84,
    86,
    88,
    89,
    90,
    92,
    93,
    94,
    95,
    97,
    98,
    99,
    100,
    101,
    103,
    105,
    106,
    108,
    110,
    111,
    113,
    114,
    118,
    119,
    120,
    121,
    122,
    123,
    125,
    126,
    128,
    129,
    130,
    132,
    133,
    135,
    137,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    152,
    153,
    154,
    155,
    156,
    157,
    160,
    161,
    162,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    172,
    173,
    174,
    175,
    176,
    177,
    178,
    179,
    180,
    181,
    183,
    184,
    186,
    187,
    188,
    190,
    191,
    192,
    196,
    197,
    198,
    201,
    203,
    204,
    205,
    206,
    207,
    210,
    212,
    213,
    214,
    215,
    216,
    219,
    220,
    221,
    222,
    224,
    226,
    230,
    231,
    233,
    234,
    235,
    236,
    237,
    238,
    240,
    242,
    243,
    245,
    246,
    247,
    248,
    250,
    252,
    254,
    256,
    257,
    258,
    259,
    263,
    265,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    275,
    276,
    277,
    278,
    282,
    283,
    284,
    286,
    288,
    289,
    290,
    292,
    293,
    294,
    295,
    296,
    297,
    299,
    302,
    303,
    304,
    305,
    306,
    307,
    308,
    309,
    312,
    313,
    314,
    315,
    316,
    317,
    318,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    332,
    333,
    335,
    336,
    339,
    344,
    345,
    346,
    347,
    349,
    351,
    352,
    353,
    354,
    355,
    357,
    360,
    361,
    363,
    365,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    375,
    377,
    378,
    379,
    380,
    381,
    383,
    384,
    385,
    387,
    388,
    389,
    390,
    392,
    393,
    394,
    396,
    397,
    398,
    399,
    2,
    3,
    4,
    6,
    7,
    8,
    9,
    10,
    11,
    13,
    15,
    17,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    28,
    29,
    30,
    31,
    32,
    33,
    35,
    37,
    39,
    40,
    41,
    42,
    43,
    48,
    49,
    50,
    51,
    54,
    55,
    57,
    58,
    59,
    60,
    62,
    63,
    65,
    67,
    68,
    69,
    71,
    72,
    73,
    75,
    76,
    78,
    79,
    80,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    92,
    93,
    94,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    121,
    124,
    125,
    126,
    127,
    128,
    129,
    131,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    147,
    149,
    150,
    151,
    153,
    154,
    155,
    156,
    157,
    159,
    160,
    161,
    163,
    164,
    165,
    166,
    168,
    169,
    170,
    173,
    174,
    175,
    176,
    177,
    178,
    179,
    181,
    182,
    183,
    185,
    187,
    188,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    202,
    203,
    204,
    206,
    207,
    208,
    210,
    212,
    213,
    214,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    223,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    233,
    235,
    237,
    238,
    239,
    240,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    253,
    255,
    256,
    257,
    259,
    260,
    261,
    262,
    263,
    264,
    266,
    267,
    269,
    271,
    272,
    274,
    276,
    277,
    280,
    281,
    282,
    284,
    287,
    288,
    289,
    290,
    293,
    294,
    295,
    296,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    307,
    308,
    309,
    310,
    311,
    312,
    313,
    315,
    317,
    318,
    319,
    320,
    322,
    324,
    325,
    327,
    328,
    330,
    331,
    333,
    334,
    335,
    337,
    339,
    341,
    342,
    344,
    347,
    348,
    350,
    351,
    354,
    356,
    357,
    358,
    359,
    360,
    362,
    363,
    364,
    365,
    366,
    367,
    369,
    371,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    382,
    384,
    385,
    387,
    388,
    390,
    391,
    392,
    393,
    394,
    396,
    397,
    398,
    1,
    2,
    4,
    6,
    7,
    8,
    9,
    10,
    11,
    13,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    45,
    46,
    47,
    48,
    49,
    51,
    52,
    53,
    54,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    66,
    68,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    95,
    97,
    99,
    100,
    102,
    104,
    105,
    107,
    108,
    109,
    110,
    111,
    112,
    115,
    116,
    118,
    119,
    120,
    121,
    122,
    123,
    124,
    125,
    127,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    136,
    137,
    138,
    140,
    141,
    142,
    144,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    162,
    164,
    165,
    166,
    167,
    169,
    170,
    172,
    174,
    175,
    176,
    177,
    178,
    179,
    180,
    181,
    183,
    184,
    185,
    186,
    187,
    191,
    192,
    193,
    194,
    196,
    197,
    198,
    200,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    211,
    213,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    224,
    225,
    227,
    230,
    231,
    232,
    233,
    235,
    236,
    237,
    240,
    241,
    242,
    245,
    247,
    249,
    250,
    252,
    253,
    255,
    256,
    257,
    258,
    259,
    261,
    262,
    264,
    265,
    266,
    267,
    269,
    270,
    272,
    275,
    276,
    277,
    278,
    280,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    290,
    292,
    293,
    294,
    295,
    296,
    299,
    300,
    302,
    303,
    305,
    307,
    310,
    311,
    312,
    313,
    314,
    315,
    316,
    317,
    319,
    320,
    321,
    323,
    324,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    340,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    353,
    354,
    355,
    356,
    358,
    360,
    361,
    362,
    363,
    364,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    375,
    376,
    378,
    380,
    381,
    382,
    383,
    385,
    388,
    389,
    391,
    393,
    395,
    396,
    397,
    398,
    1,
    3,
    4,
    5,
    6,
    8,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    19,
    20,
    21,
    22,
    24,
    25,
    26,
    28,
    30,
    31,
    32,
    34,
    35,
    37,
    38,
    39,
    40,
    41,
    42,
    45,
    46,
    48,
    49,
    50,
    52,
    53,
    54,
    56,
    57,
    58,
    59,
    60,
    62,
    63,
    64,
    65,
    66,
    67,
    68,
    70,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    92,
    94,
    96,
    97,
    99,
    100,
    101,
    102,
    104,
    105,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    116,
    117,
    118,
    119,
    120,
    123,
    124,
    125,
    127,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    146,
    148,
    149,
    150,
    152,
    153,
    154,
    155,
    157,
    158,
    160,
    162,
    163,
    166,
    171,
    172,
    173,
    174,
    176,
    178,
    179,
    180,
    181,
    182,
    184,
    185,
    186,
    187,
    188,
    191,
    193,
    194,
    197,
    200,
    201,
    202,
    203,
    204,
    207,
    208,
    209,
    210,
    211,
    214,
    218,
    219,
    220,
    221,
    222,
    223,
    224,
    226,
    227,
    228,
    229,
    230,
    235,
    236,
    237,
    238,
    240,
    244,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    257,
    258,
    259,
    260,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    279,
    280,
    281,
    285,
    288,
    289,
    290,
    291,
    292,
    293,
    295,
    297,
    298,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    308,
    309,
    310,
    311,
    313,
    315,
    316,
    317,
    320,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    334,
    335,
    336,
    337,
    338,
    340,
    341,
    342,
    343,
    344,
    347,
    348,
    352,
    355,
    356,
    357,
    358,
    359,
    360,
    362,
    364,
    365,
    367,
    368,
    369,
    371,
    372,
    373,
    374,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    389,
    390,
    391,
    392,
    393,
    394,
    395,
    397,
    0,
    1,
    2,
    4,
    6,
    8,
    9,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    18,
    19,
    22,
    23,
    24,
    26,
    28,
    29,
    30,
    31,
    32,
    33,
    35,
    36,
    38,
    40,
    41,
    42,
    44,
    46,
    47,
    48,
    49,
    50,
    51,
    52,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    65,
    66,
    70,
    72,
    73,
    74,
    75,
    76,
    79,
    80,
    81,
    82,
    83,
    84,
    86,
    87,
    90,
    92,
    94,
    98,
    100,
    102,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    113,
    114,
    116,
    117,
    118,
    119,
    121,
    124,
    125,
    126,
    127,
    129,
    130,
    133,
    135,
    137,
    138,
    139,
    141,
    142,
    143,
    144,
    145,
    148,
    150,
    151,
    152,
    153,
    154,
    156,
    157,
    158,
    159,
    160,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    173,
    176,
    177,
    178,
    179,
    182,
    183,
    186,
    187,
    188,
    191,
    195,
    196,
    199,
    201,
    202,
    206,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    214,
    215,
    216,
    217,
    218,
    220,
    221,
    223,
    224,
    225,
    226,
    227,
    228,
    230,
    231,
    233,
    234,
    235,
    236,
    237,
    238,
    239,
    240,
    241,
    244,
    245,
    246,
    248,
    249,
    250,
    252,
    255,
    256,
    257,
    259,
    260,
    261,
    262,
    264,
    265,
    266,
    267,
    268,
    269,
    271,
    272,
    273,
    274,
    275,
    276,
    277,
    279,
    281,
    282,
    284,
    285,
    286,
    287,
    289,
    292,
    293,
    294,
    296,
    298,
    300,
    301,
    303,
    304,
    305,
    306,
    307,
    308,
    309,
    310,
    311,
    312,
    314,
    315,
    316,
    317,
    318,
    322,
    323,
    324,
    325,
    327,
    331,
    332,
    333,
    335,
    337,
    338,
    340,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    350,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    364,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    379,
    380,
    381,
    384,
    385,
    387,
    388,
    389,
    391,
    392,
    393,
    395,
    396,
    398,
    0,
    2,
    3,
    4,
    5,
    7,
    8,
    9,
    12,
    13,
    14,
    15,
    16,
    17,
    19,
    21,
    22,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    32,
    34,
    35,
    36,
    37,
    38,
    40,
    41,
    42,
    44,
    45,
    46,
    47,
    48,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    88,
    89,
    90,
    91,
    92,
    94,
    95,
    97,
    98,
    99,
    100,
    101,
    102,
    104,
    105,
    108,
    109,
    111,
    112,
    113,
    115,
    116,
    117,
    118,
    120,
    121,
    122,
    124,
    125,
    128,
    129,
    132,
    133,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    169,
    170,
    171,
    172,
    173,
    174,
    175,
    176,
    177,
    178,
    179,
    180,
    182,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    203,
    205,
    207,
    208,
    210,
    211,
    212,
    215,
    216,
    217,
    218,
    219,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    231,
    232,
    233,
    234,
    235,
    236,
    238,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    249,
    251,
    252,
    253,
    254,
    255,
    256,
    257,
    259,
    261,
    262,
    264,
    265,
    266,
    267,
    268,
    269,
    270,
    273,
    274,
    276,
    280,
    282,
    283,
    287,
    288,
    290,
    291,
    293,
    295,
    296,
    297,
    298,
    299,
    300,
    301,
    303,
    304,
    305,
    307,
    308,
    309,
    310,
    312,
    313,
    314,
    315,
    317,
    318,
    319,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    331,
    332,
    333,
    334,
    336,
    338,
    340,
    341,
    343,
    345,
    347,
    349,
    350,
    351,
    352,
    354,
    355,
    356,
    357,
    358,
    359,
    361,
    362,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    382,
    383,
    384,
    385,
    386,
    388,
    389,
    390,
    391,
    392,
    394,
    395,
    396,
    397,
    398,
    399,
    1,
    2,
    4,
    5,
    8,
    9,
    10,
    12,
    13,
    14,
    15,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    26,
    27,
    28,
    29,
    31,
    32,
    33,
    34,
    35,
    36,
    38,
    40,
    41,
    42,
    44,
    45,
    46,
    47,
    48,
    49,
    50,
    52,
    53,
    54,
    55,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    69,
    70,
    71,
    72,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    95,
    96,
    97,
    98,
    99,
    101,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    121,
    123,
    124,
    126,
    127,
    128,
    129,
    130,
    131,
    132,
    133,
    137,
    138,
    139,
    140,
    142,
    144,
    146,
    147,
    148,
    149,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    161,
    162,
    163,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    174,
    175,
    176,
    177,
    178,
    179,
    180,
    182,
    183,
    184,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    203,
    204,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    214,
    215,
    216,
    217,
    219,
    220,
    221,
    223,
    225,
    226,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    237,
    238,
    239,
    243,
    244,
    246,
    247,
    249,
    250,
    251,
    252,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    265,
    267,
    269,
    271,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    279,
    281,
    282,
    283,
    285,
    286,
    288,
    289,
    290,
    291,
    292,
    294,
    296,
    298,
    299,
    300,
    302,
    303,
    305,
    308,
    309,
    310,
    311,
    312,
    314,
    315,
    316,
    317,
    318,
    319,
    320,
    321,
    323,
    324,
    326,
    327,
    329,
    331,
    332,
    333,
    334,
    336,
    337,
    339,
    340,
    341,
    342,
    346,
    348,
    349,
    350,
    352,
    353,
    356,
    357,
    358,
    359,
    361,
    362,
    363,
    364,
    367,
    368,
    369,
    370,
    371,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    386,
    387,
    388,
    390,
    392,
    393,
    394,
    395,
    396,
    397,
    399,
    0,
    1,
    3,
    4,
    5,
    6,
    7,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    18,
    19,
    22,
    23,
    24,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    37,
    39,
    42,
    43,
    46,
    48,
    49,
    50,
    52,
    53,
    54,
    55,
    56,
    59,
    63,
    64,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    78,
    79,
    81,
    82,
    83,
    84,
    85,
    86,
    88,
    89,
    90,
    91,
    92,
    94,
    96,
    97,
    98,
    99,
    100,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    112,
    114,
    115,
    116,
    119,
    120,
    121,
    122,
    123,
    126,
    127,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    136,
    137,
    140,
    141,
    142,
    143,
    144,
    146,
    147,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    162,
    163,
    164,
    165,
    166,
    168,
    169,
    170,
    174,
    175,
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    184,
    185,
    186,
    189,
    191,
    192,
    193,
    196,
    197,
    198,
    199,
    201,
    202,
    205,
    206,
    207,
    209,
    210,
    211,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    222,
    223,
    224,
    225,
    227,
    230,
    233,
    234,
    235,
    237,
    239,
    242,
    243,
    244,
    245,
    246,
    247,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    257,
    259,
    260,
    261,
    262,
    264,
    265,
    266,
    267,
    268,
    270,
    271,
    272,
    273,
    274,
    277,
    279,
    280,
    281,
    282,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    292,
    295,
    296,
    297,
    299,
    300,
    301,
    303,
    304,
    305,
    307,
    308,
    310,
    311,
    312,
    314,
    315,
    317,
    319,
    320,
    323,
    324,
    325,
    327,
    328,
    331,
    332,
    333,
    334,
    335,
    339,
    341,
    342,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    354,
    355,
    358,
    359,
    360,
    361,
    362,
    363,
    365,
    366,
    367,
    370,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    386,
    387,
    388,
    389,
    390,
    391,
    393,
    394,
    396,
    398,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    8,
    9,
    10,
    11,
    12,
    13,
    15,
    16,
    17,
    18,
    19,
    21,
    22,
    23,
    24,
    26,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    42,
    43,
    44,
    47,
    48,
    49,
    50,
    51,
    54,
    55,
    56,
    57,
    61,
    62,
    63,
    65,
    67,
    68,
    69,
    70,
    71,
    73,
    74,
    76,
    77,
    78,
    80,
    81,
    85,
    86,
    87,
    88,
    89,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    99,
    100,
    101,
    104,
    105,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    121,
    122,
    123,
    125,
    126,
    129,
    132,
    133,
    135,
    136,
    138,
    139,
    140,
    141,
    145,
    146,
    149,
    153,
    154,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    166,
    167,
    169,
    170,
    171,
    172,
    173,
    174,
    175,
    179,
    180,
    181,
    182,
    183,
    184,
    186,
    187,
    188,
    189,
    190,
    191,
    193,
    197,
    198,
    199,
    201,
    203,
    204,
    205,
    207,
    208,
    209,
    212,
    214,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    238,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    256,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    269,
    272,
    274,
    276,
    277,
    278,
    279,
    280,
    281,
    282,
    284,
    286,
    287,
    289,
    290,
    291,
    293,
    294,
    295,
    296,
    298,
    299,
    301,
    302,
    303,
    304,
    305,
    306,
    308,
    309,
    310,
    311,
    312,
    313,
    314,
    315,
    316,
    319,
    320,
    321,
    322,
    323,
    324,
    325,
    328,
    329,
    330,
    332,
    333,
    334,
    335,
    336,
    337,
    339,
    340,
    341,
    343,
    344,
    345,
    348,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    361,
    362,
    363,
    365,
    366,
    367,
    368,
    369,
    370,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    380,
    381,
    382,
    384,
    386,
    387,
    390,
    391,
    393,
    396,
    397,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    8,
    9,
    11,
    12,
    13,
    14,
    15,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    26,
    28,
    29,
    30,
    31,
    35,
    36,
    39,
    40,
    42,
    43,
    45,
    46,
    47,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    57,
    58,
    59,
    60,
    62,
    63,
    64,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    93,
    94,
    96,
    97,
    99,
    100,
    103,
    104,
    105,
    107,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    122,
    123,
    126,
    127,
    129,
    130,
    132,
    133,
    134,
    136,
    137,
    139,
    140,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    172,
    173,
    174,
    175,
    176,
    178,
    180,
    181,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    195,
    196,
    200,
    203,
    206,
    207,
    208,
    209,
    210,
    211,
    215,
    216,
    217,
    218,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    228,
    232,
    233,
    234,
    236,
    239,
    240,
    241,
    242,
    244,
    246,
    247,
    248,
    250,
    251,
    252,
    253,
    254,
    255,
    256,
    258,
    259,
    260,
    262,
    264,
    265,
    266,
    267,
    268,
    270,
    271,
    272,
    273,
    274,
    275,
    278,
    281,
    282,
    284,
    285,
    286,
    287,
    289,
    295,
    296,
    301,
    302,
    304,
    306,
    307,
    308,
    309,
    311,
    312,
    313,
    314,
    315,
    316,
    317,
    318,
    320,
    321,
    323,
    324,
    325,
    326,
    327,
    331,
    332,
    333,
    335,
    338,
    339,
    340,
    342,
    343,
    344,
    345,
    346,
    348,
    349,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    371,
    373,
    374,
    375,
    376,
    377,
    379,
    382,
    383,
    384,
    385,
    387,
    388,
    389,
    390,
    392,
    393,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    5,
    6,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    27,
    28,
    29,
    31,
    32,
    33,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    46,
    50,
    51,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    61,
    62,
    64,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    75,
    76,
    77,
    78,
    79,
    81,
    82,
    83,
    86,
    87,
    88,
    89,
    90,
    91,
    93,
    95,
    98,
    100,
    101,
    102,
    103,
    104,
    105,
    107,
    108,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    121,
    122,
    124,
    125,
    126,
    127,
    128,
    129,
    131,
    132,
    133,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    144,
    145,
    146,
    148,
    149,
    150,
    151,
    152,
    153,
    155,
    156,
    157,
    158,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    168,
    169,
    170,
    171,
    173,
    174,
    175,
    176,
    177,
    178,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    203,
    205,
    206,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    214,
    215,
    217,
    219,
    221,
    222,
    224,
    225,
    226,
    227,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    239,
    240,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    256,
    258,
    260,
    261,
    262,
    263,
    265,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    277,
    279,
    280,
    281,
    282,
    284,
    285,
    287,
    288,
    289,
    290,
    291,
    292,
    293,
    295,
    296,
    297,
    299,
    300,
    302,
    303,
    305,
    306,
    307,
    308,
    309,
    310,
    311,
    312,
    313,
    315,
    320,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    336,
    337,
    338,
    339,
    340,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    351,
    352,
    353,
    355,
    356,
    357,
    359,
    362,
    363,
    364,
    365,
    367,
    369,
    370,
    371,
    372,
    373,
    375,
    376,
    377,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    390,
    391,
    393,
    395,
    396,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    12,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    29,
    30,
    31,
    32,
    33,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    47,
    48,
    49,
    50,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    64,
    65,
    66,
    67,
    68,
    69,
    70,
    71,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    89,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    102,
    103,
    105,
    106,
    107,
    110,
    112,
    113,
    114,
    115,
    116,
    117,
    119,
    120,
    121,
    122,
    123,
    124,
    127,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    135,
    137,
    138,
    139,
    140,
    141,
    142,
    144,
    145,
    146,
    147,
    149,
    150,
    152,
    153,
    154,
    155,
    156,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    167,
    168,
    169,
    170,
    171,
    174,
    175,
    176,
    177,
    179,
    180,
    182,
    184,
    188,
    194,
    195,
    196,
    198,
    200,
    201,
    202,
    204,
    205,
    206,
    207,
    208,
    209,
    211,
    212,
    213,
    214,
    215,
    216,
    218,
    219,
    220,
    221,
    222,
    224,
    226,
    227,
    229,
    230,
    231,
    233,
    236,
    237,
    238,
    241,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    257,
    258,
    259,
    260,
    262,
    265,
    266,
    267,
    268,
    269,
    270,
    272,
    273,
    274,
    275,
    276,
    278,
    280,
    281,
    282,
    286,
    288,
    289,
    290,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    299,
    301,
    303,
    304,
    305,
    307,
    308,
    310,
    311,
    312,
    313,
    314,
    316,
    318,
    319,
    320,
    322,
    324,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    339,
    340,
    341,
    342,
    343,
    344,
    345,
    347,
    349,
    350,
    351,
    352,
    353,
    355,
    356,
    360,
    361,
    362,
    363,
    365,
    366,
    368,
    370,
    371,
    372,
    373,
    374,
    378,
    379,
    381,
    382,
    385,
    386,
    390,
    392,
    393,
    394,
    395,
    396,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    7,
    8,
    9,
    10,
    11,
    13,
    15,
    16,
    17,
    18,
    19,
    20,
    22,
    23,
    24,
    25,
    26,
    28,
    29,
    30,
    31,
    32,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    42,
    44,
    45,
    48,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    59,
    60,
    61,
    62,
    63,
    64,
    66,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    77,
    78,
    80,
    81,
    82,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    93,
    94,
    95,
    96,
    97,
    99,
    101,
    102,
    103,
    104,
    106,
    107,
    108,
    109,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    122,
    123,
    128,
    130,
    131,
    132,
    133,
    134,
    135,
    136,
    137,
    139,
    141,
    142,
    144,
    145,
    146,
    147,
    148,
    150,
    151,
    152,
    154,
    155,
    156,
    159,
    160,
    161,
    162,
    164,
    166,
    170,
    171,
    172,
    174,
    175,
    176,
    177,
    178,
    182,
    184,
    188,
    189,
    190,
    193,
    195,
    196,
    197,
    199,
    200,
    202,
    204,
    205,
    206,
    207,
    208,
    211,
    212,
    213,
    214,
    216,
    218,
    219,
    220,
    221,
    222,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    237,
    238,
    239,
    240,
    242,
    243,
    245,
    246,
    247,
    249,
    250,
    251,
    252,
    253,
    255,
    256,
    257,
    258,
    260,
    261,
    262,
    263,
    264,
    266,
    267,
    268,
    269,
    271,
    272,
    273,
    275,
    276,
    277,
    278,
    281,
    283,
    284,
    285,
    287,
    288,
    289,
    291,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    299,
    303,
    305,
    306,
    307,
    309,
    311,
    313,
    314,
    315,
    317,
    318,
    319,
    320,
    321,
    324,
    328,
    329,
    330,
    331,
    332,
    334,
    335,
    336,
    337,
    338,
    339,
    340,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    350,
    351,
    352,
    356,
    358,
    360,
    361,
    362,
    365,
    366,
    368,
    369,
    370,
    371,
    373,
    374,
    375,
    376,
    377,
    378,
    381,
    382,
    385,
    386,
    387,
    389,
    390,
    392,
    393,
    394,
    396,
    397,
    398,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    20,
    21,
    23,
    24,
    25,
    26,
    28,
    29,
    32,
    33,
    34,
    35,
    36,
    37,
    39,
    41,
    42,
    43,
    44,
    45,
    48,
    49,
    50,
    51,
    52,
    53,
    55,
    56,
    57,
    58,
    59,
    62,
    63,
    64,
    65,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    86,
    89,
    90,
    91,
    92,
    93,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    103,
    104,
    105,
    106,
    108,
    110,
    111,
    112,
    113,
    115,
    116,
    117,
    118,
    119,
    120,
    121,
    123,
    125,
    127,
    131,
    132,
    136,
    137,
    139,
    140,
    141,
    142,
    144,
    146,
    147,
    148,
    149,
    150,
    151,
    154,
    155,
    156,
    158,
    160,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    171,
    172,
    173,
    174,
    175,
    176,
    177,
    179,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    189,
    190,
    191,
    192,
    193,
    195,
    196,
    197,
    198,
    199,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    213,
    214,
    215,
    217,
    218,
    220,
    221,
    222,
    224,
    225,
    226,
    227,
    228,
    230,
    231,
    232,
    233,
    234,
    235,
    237,
    238,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    253,
    254,
    256,
    257,
    260,
    261,
    263,
    264,
    267,
    269,
    271,
    273,
    274,
    276,
    277,
    280,
    281,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    299,
    300,
    301,
    303,
    304,
    305,
    307,
    309,
    310,
    311,
    312,
    313,
    314,
    315,
    318,
    319,
    320,
    322,
    323,
    325,
    326,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    342,
    343,
    345,
    347,
    348,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    363,
    364,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    375,
    377,
    378,
    379,
    383,
    384,
    385,
    386,
    387,
    390,
    391,
    393,
    394,
    395,
    396,
    397,
    0,
    1,
    3,
    4,
    5,
    6,
    7,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    17,
    18,
    19,
    20,
    21,
    23,
    25,
    26,
    27,
    28,
    29,
    30,
    31,
    33,
    34,
    35,
    36,
    37,
    39,
    40,
    41,
    42,
    43,
    44,
    46,
    47,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    59,
    61,
    62,
    65,
    68,
    69,
    71,
    73,
    74,
    75,
    76,
    77,
    78,
    82,
    85,
    86,
    90,
    91,
    92,
    93,
    94,
    95,
    97,
    98,
    99,
    100,
    101,
    102,
    104,
    105,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    116,
    117,
    118,
    119,
    121,
    122,
    124,
    126,
    127,
    129,
    130,
    132,
    133,
    134,
    135,
    138,
    139,
    141,
    143,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    166,
    168,
    169,
    170,
    171,
    174,
    175,
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    184,
    185,
    189,
    190,
    191,
    192,
    193,
    195,
    196,
    197,
    198,
    200,
    202,
    205,
    206,
    207,
    208,
    212,
    213,
    215,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    237,
    238,
    240,
    241,
    242,
    243,
    246,
    247,
    248,
    251,
    252,
    253,
    254,
    255,
    256,
    258,
    259,
    261,
    263,
    265,
    267,
    268,
    269,
    272,
    274,
    275,
    278,
    280,
    281,
    282,
    284,
    285,
    286,
    287,
    289,
    292,
    293,
    294,
    295,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    305,
    306,
    307,
    308,
    311,
    312,
    313,
    314,
    315,
    318,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    332,
    333,
    334,
    336,
    337,
    338,
    341,
    342,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    358,
    359,
    360,
    361,
    363,
    364,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    382,
    384,
    386,
    390,
    391,
    393,
    394,
    395,
    397,
    399,
    0,
    3,
    4,
    5,
    7,
    8,
    9,
    11,
    12,
    13,
    14,
    16,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    32,
    33,
    34,
    35,
    36,
    37,
    38,
    40,
    41,
    42,
    43,
    44,
    45,
    47,
    48,
    50,
    52,
    53,
    54,
    56,
    57,
    58,
    59,
    61,
    62,
    63,
    65,
    66,
    67,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    92,
    93,
    95,
    96,
    97,
    101,
    102,
    106,
    107,
    108,
    109,
    110,
    111,
    113,
    114,
    115,
    117,
    118,
    120,
    121,
    122,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    164,
    166,
    168,
    170,
    171,
    172,
    173,
    174,
    175,
    176,
    180,
    181,
    182,
    184,
    185,
    186,
    187,
    188,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    199,
    200,
    201,
    205,
    206,
    208,
    211,
    213,
    216,
    217,
    218,
    219,
    221,
    222,
    223,
    224,
    225,
    227,
    230,
    231,
    232,
    233,
    234,
    235,
    237,
    238,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    252,
    253,
    254,
    255,
    256,
    257,
    258,
    260,
    261,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    275,
    276,
    277,
    278,
    279,
    280,
    281,
    282,
    283,
    285,
    287,
    289,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    308,
    311,
    312,
    313,
    315,
    316,
    317,
    322,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    339,
    340,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    371,
    374,
    376,
    377,
    378,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    391,
    392,
    393,
    395,
    396,
    397,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    12,
    13,
    15,
    16,
    18,
    19,
    21,
    22,
    24,
    25,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    36,
    37,
    40,
    41,
    42,
    43,
    44,
    46,
    48,
    50,
    51,
    53,
    54,
    55,
    56,
    57,
    58,
    60,
    61,
    62,
    63,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    98,
    99,
    100,
    102,
    103,
    104,
    106,
    107,
    108,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    122,
    124,
    127,
    128,
    129,
    130,
    131,
    132,
    134,
    135,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    149,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    160,
    161,
    162,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    173,
    176,
    177,
    179,
    180,
    181,
    183,
    184,
    185,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    195,
    196,
    197,
    198,
    199,
    202,
    204,
    205,
    206,
    207,
    209,
    210,
    211,
    212,
    213,
    214,
    215,
    216,
    217,
    219,
    220,
    221,
    222,
    223,
    224,
    225,
    227,
    228,
    230,
    231,
    232,
    233,
    234,
    235,
    237,
    238,
    239,
    241,
    242,
    243,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    254,
    255,
    257,
    258,
    259,
    261,
    262,
    263,
    264,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    275,
    276,
    277,
    278,
    279,
    280,
    282,
    283,
    284,
    285,
    286,
    289,
    290,
    291,
    292,
    293,
    294,
    295,
    297,
    298,
    300,
    302,
    305,
    306,
    308,
    309,
    310,
    311,
    312,
    313,
    314,
    316,
    317,
    318,
    319,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    330,
    331,
    332,
    333,
    334,
    335,
    337,
    338,
    339,
    340,
    341,
    342,
    343,
    344,
    345,
    346,
    348,
    349,
    350,
    351,
    352,
    354,
    355,
    356,
    358,
    359,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    370,
    372,
    375,
    377,
    378,
    379,
    381,
    383,
    384,
    386,
    387,
    388,
    389,
    393,
    395,
    397,
    398,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    9,
    10,
    11,
    12,
    15,
    16,
    17,
    22,
    24,
    25,
    26,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    46,
    48,
    49,
    50,
    52,
    53,
    54,
    55,
    56,
    58,
    59,
    60,
    61,
    62,
    63,
    65,
    67,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    77,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    87,
    88,
    93,
    94,
    95,
    96,
    97,
    98,
    100,
    101,
    102,
    103,
    104,
    106,
    108,
    109,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    121,
    122,
    123,
    126,
    127,
    128,
    129,
    130,
    132,
    133,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    143,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    155,
    157,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    170,
    171,
    172,
    173,
    174,
    176,
    177,
    178,
    179,
    180,
    182,
    183,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    194,
    196,
    197,
    198,
    200,
    201,
    202,
    203,
    205,
    206,
    207,
    208,
    209,
    210,
    212,
    213,
    214,
    215,
    217,
    218,
    219,
    221,
    222,
    223,
    224,
    225,
    226,
    228,
    229,
    230,
    231,
    233,
    235,
    237,
    239,
    240,
    241,
    242,
    245,
    246,
    247,
    248,
    249,
    251,
    252,
    254,
    256,
    257,
    258,
    260,
    261,
    262,
    263,
    264,
    266,
    267,
    268,
    269,
    270,
    272,
    273,
    274,
    276,
    279,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    288,
    289,
    293,
    296,
    299,
    300,
    302,
    303,
    304,
    305,
    306,
    308,
    309,
    310,
    311,
    312,
    314,
    315,
    316,
    318,
    319,
    320,
    321,
    323,
    324,
    325,
    326,
    327,
    328,
    330,
    331,
    332,
    334,
    335,
    336,
    337,
    338,
    339,
    340,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    358,
    359,
    360,
    361,
    362,
    363,
    364,
    365,
    367,
    370,
    371,
    372,
    373,
    374,
    375,
    378,
    379,
    380,
    381,
    382,
    384,
    385,
    387,
    388,
    390,
    391,
    392,
    393,
    394,
    395,
    397,
    398,
    1,
    2,
    3,
    4,
    5,
    7,
    8,
    9,
    10,
    11,
    13,
    14,
    20,
    21,
    22,
    23,
    24,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    37,
    40,
    41,
    42,
    43,
    45,
    46,
    47,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    59,
    63,
    64,
    65,
    67,
    70,
    71,
    72,
    73,
    74,
    75,
    77,
    80,
    81,
    82,
    83,
    84,
    86,
    87,
    89,
    90,
    92,
    93,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    104,
    106,
    107,
    108,
    109,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    121,
    122,
    124,
    126,
    127,
    129,
    130,
    131,
    132,
    133,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    148,
    149,
    151,
    152,
    154,
    156,
    157,
    158,
    159,
    160,
    162,
    163,
    164,
    165,
    166,
    168,
    169,
    170,
    172,
    173,
    175,
    176,
    177,
    178,
    179,
    180,
    182,
    183,
    185,
    186,
    188,
    189,
    190,
    191,
    192,
    194,
    195,
    196,
    197,
    198,
    200,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    215,
    216,
    217,
    218,
    219,
    220,
    223,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    236,
    237,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    251,
    252,
    253,
    258,
    259,
    260,
    261,
    263,
    264,
    266,
    267,
    269,
    270,
    271,
    273,
    274,
    275,
    279,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    293,
    295,
    296,
    297,
    298,
    299,
    301,
    302,
    303,
    305,
    306,
    307,
    308,
    309,
    310,
    312,
    313,
    314,
    315,
    316,
    317,
    320,
    321,
    323,
    324,
    325,
    327,
    328,
    329,
    330,
    331,
    332,
    334,
    335,
    336,
    337,
    338,
    340,
    342,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    363,
    364,
    365,
    366,
    367,
    368,
    371,
    372,
    375,
    376,
    378,
    379,
    380,
    381,
    382,
    383,
    386,
    388,
    389,
    390,
    391,
    392,
    393,
    394,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    4,
    5,
    6,
    8,
    10,
    13,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    27,
    28,
    29,
    30,
    31,
    32,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    47,
    48,
    50,
    51,
    52,
    53,
    54,
    55,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    70,
    71,
    73,
    74,
    75,
    76,
    77,
    79,
    80,
    81,
    83,
    84,
    86,
    88,
    89,
    90,
    92,
    94,
    95,
    96,
    98,
    100,
    101,
    102,
    103,
    104,
    105,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    116,
    117,
    119,
    120,
    121,
    122,
    123,
    124,
    125,
    128,
    131,
    132,
    134,
    135,
    136,
    137,
    138,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    149,
    150,
    151,
    153,
    154,
    156,
    157,
    158,
    159,
    160,
    161,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    174,
    175,
    176,
    177,
    179,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    193,
    194,
    195,
    196,
    198,
    199,
    200,
    201,
    202,
    203,
    205,
    206,
    208,
    210,
    211,
    212,
    213,
    217,
    218,
    219,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    238,
    241,
    243,
    245,
    247,
    248,
    249,
    250,
    252,
    253,
    257,
    258,
    259,
    260,
    262,
    263,
    265,
    266,
    267,
    268,
    269,
    271,
    273,
    274,
    275,
    276,
    278,
    279,
    280,
    281,
    282,
    283,
    285,
    286,
    287,
    288,
    289,
    290,
    293,
    294,
    295,
    296,
    297,
    299,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    310,
    314,
    315,
    317,
    318,
    319,
    321,
    322,
    323,
    324,
    326,
    328,
    329,
    330,
    332,
    334,
    337,
    338,
    339,
    341,
    342,
    344,
    346,
    347,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    360,
    362,
    363,
    364,
    366,
    367,
    370,
    372,
    373,
    376,
    377,
    378,
    382,
    383,
    384,
    385,
    386,
    387,
    391,
    392,
    394,
    395,
    396,
    397,
    398,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    32,
    33,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    45,
    46,
    47,
    48,
    50,
    51,
    53,
    56,
    57,
    58,
    60,
    62,
    63,
    64,
    65,
    66,
    67,
    68,
    71,
    72,
    73,
    75,
    76,
    78,
    79,
    80,
    81,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    101,
    102,
    103,
    105,
    106,
    107,
    108,
    109,
    111,
    112,
    113,
    114,
    116,
    117,
    120,
    123,
    124,
    125,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    135,
    136,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    148,
    149,
    150,
    152,
    153,
    154,
    157,
    158,
    159,
    160,
    161,
    162,
    164,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    174,
    176,
    177,
    178,
    181,
    182,
    183,
    184,
    185,
    187,
    188,
    189,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    199,
    200,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    212,
    213,
    214,
    215,
    218,
    220,
    221,
    222,
    223,
    226,
    227,
    228,
    230,
    231,
    232,
    234,
    235,
    236,
    237,
    238,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    251,
    253,
    254,
    255,
    257,
    258,
    259,
    260,
    262,
    263,
    264,
    266,
    267,
    268,
    269,
    271,
    274,
    281,
    282,
    283,
    285,
    286,
    287,
    289,
    290,
    291,
    293,
    294,
    295,
    296,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    307,
    308,
    309,
    310,
    311,
    312,
    314,
    315,
    316,
    317,
    318,
    319,
    320,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    334,
    335,
    336,
    337,
    341,
    342,
    343,
    344,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    355,
    357,
    359,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    369,
    370,
    371,
    372,
    374,
    375,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    387,
    389,
    390,
    391,
    392,
    394,
    395,
    396,
    398,
    399,
    0,
    3,
    4,
    6,
    7,
    8,
    9,
    10,
    12,
    13,
    14,
    15,
    17,
    19,
    20,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    35,
    36,
    37,
    38,
    40,
    41,
    43,
    44,
    45,
    46,
    48,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    67,
    68,
    69,
    70,
    71,
    75,
    76,
    79,
    80,
    81,
    82,
    85,
    86,
    87,
    88,
    89,
    91,
    93,
    94,
    95,
    96,
    98,
    99,
    100,
    103,
    104,
    105,
    106,
    110,
    111,
    112,
    115,
    116,
    117,
    118,
    119,
    121,
    122,
    123,
    124,
    125,
    126,
    128,
    131,
    132,
    133,
    135,
    136,
    138,
    142,
    143,
    144,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    162,
    163,
    167,
    169,
    170,
    171,
    173,
    174,
    175,
    176,
    179,
    180,
    182,
    183,
    184,
    185,
    189,
    191,
    192,
    193,
    194,
    196,
    197,
    199,
    200,
    201,
    202,
    203,
    204,
    205,
    206,
    209,
    210,
    211,
    212,
    213,
    214,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    233,
    234,
    235,
    236,
    238,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    247,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    262,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    270,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    280,
    283,
    284,
    285,
    287,
    288,
    289,
    290,
    291,
    292,
    293,
    294,
    295,
    296,
    298,
    299,
    300,
    301,
    302,
    304,
    305,
    306,
    308,
    309,
    310,
    311,
    312,
    313,
    315,
    317,
    318,
    319,
    321,
    322,
    325,
    326,
    327,
    329,
    331,
    332,
    333,
    335,
    336,
    337,
    338,
    339,
    340,
    342,
    343,
    344,
    347,
    348,
    349,
    350,
    353,
    354,
    355,
    356,
    358,
    359,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    371,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    382,
    383,
    384,
    385,
    386,
    387,
    388,
    391,
    392,
    393,
    395,
    396,
    397,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    9,
    10,
    12,
    15,
    16,
    17,
    18,
    20,
    21,
    24,
    25,
    26,
    27,
    28,
    29,
    31,
    32,
    33,
    35,
    36,
    37,
    38,
    39,
    42,
    43,
    44,
    45,
    48,
    49,
    50,
    51,
    52,
    53,
    54,
    56,
    57,
    58,
    59,
    60,
    64,
    66,
    68,
    69,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    82,
    83,
    84,
    87,
    88,
    90,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    104,
    105,
    106,
    107,
    109,
    110,
    113,
    114,
    115,
    116,
    117,
    120,
    122,
    123,
    124,
    127,
    128,
    130,
    131,
    132,
    133,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    143,
    144,
    148,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    162,
    163,
    165,
    166,
    168,
    169,
    170,
    173,
    174,
    175,
    176,
    177,
    178,
    180,
    181,
    183,
    184,
    185,
    188,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    199,
    200,
    201,
    202,
    203,
    205,
    206,
    207,
    208,
    209,
    210,
    214,
    215,
    216,
    218,
    219,
    220,
    221,
    222,
    223,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    233,
    234,
    235,
    237,
    238,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    249,
    251,
    252,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    265,
    267,
    270,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    279,
    280,
    281,
    282,
    283,
    284,
    285,
    288,
    289,
    290,
    291,
    293,
    294,
    295,
    296,
    298,
    299,
    303,
    305,
    306,
    307,
    308,
    309,
    311,
    314,
    315,
    316,
    318,
    319,
    320,
    323,
    326,
    327,
    328,
    329,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    341,
    342,
    343,
    344,
    346,
    347,
    348,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    363,
    364,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    375,
    377,
    378,
    380,
    381,
    382,
    384,
    386,
    387,
    388,
    390,
    391,
    392,
    396,
    397,
    398,
    399,
    2,
    4,
    5,
    6,
    7,
    8,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    31,
    32,
    34,
    35,
    36,
    37,
    38,
    39,
    41,
    42,
    43,
    44,
    45,
    46,
    47,
    48,
    50,
    52,
    53,
    54,
    55,
    56,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    80,
    81,
    82,
    83,
    84,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    101,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    110,
    111,
    113,
    114,
    115,
    116,
    118,
    119,
    120,
    121,
    122,
    123,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    152,
    155,
    158,
    159,
    160,
    161,
    162,
    164,
    165,
    171,
    172,
    173,
    175,
    176,
    178,
    179,
    180,
    181,
    184,
    185,
    186,
    187,
    189,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    198,
    200,
    202,
    203,
    204,
    206,
    207,
    208,
    209,
    210,
    211,
    212,
    214,
    216,
    217,
    220,
    221,
    222,
    223,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    237,
    238,
    239,
    240,
    243,
    244,
    248,
    250,
    252,
    253,
    255,
    257,
    258,
    262,
    263,
    264,
    265,
    267,
    268,
    269,
    271,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    279,
    280,
    282,
    283,
    284,
    285,
    286,
    289,
    292,
    293,
    294,
    295,
    297,
    299,
    301,
    302,
    303,
    305,
    306,
    307,
    310,
    311,
    312,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    336,
    337,
    339,
    340,
    341,
    342,
    347,
    350,
    351,
    352,
    353,
    354,
    356,
    357,
    358,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    370,
    371,
    372,
    373,
    375,
    376,
    377,
    378,
    380,
    382,
    383,
    384,
    385,
    387,
    388,
    390,
    391,
    392,
    393,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    4,
    5,
    6,
    7,
    8,
    9,
    11,
    12,
    14,
    15,
    17,
    18,
    20,
    21,
    23,
    24,
    25,
    26,
    27,
    29,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    37,
    40,
    43,
    45,
    46,
    47,
    48,
    49,
    50,
    51,
    52,
    54,
    55,
    56,
    57,
    59,
    60,
    61,
    63,
    66,
    67,
    69,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    80,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    93,
    94,
    95,
    96,
    97,
    98,
    100,
    101,
    102,
    104,
    105,
    106,
    107,
    108,
    110,
    111,
    113,
    115,
    116,
    120,
    122,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    132,
    133,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    151,
    152,
    155,
    156,
    157,
    160,
    161,
    162,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    177,
    179,
    182,
    183,
    185,
    187,
    188,
    189,
    190,
    191,
    193,
    194,
    196,
    198,
    199,
    201,
    203,
    205,
    206,
    208,
    211,
    212,
    213,
    217,
    218,
    219,
    220,
    223,
    224,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    234,
    235,
    236,
    237,
    238,
    239,
    240,
    241,
    242,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    256,
    257,
    258,
    262,
    263,
    264,
    266,
    268,
    270,
    271,
    273,
    274,
    276,
    277,
    281,
    283,
    284,
    285,
    287,
    288,
    289,
    290,
    291,
    293,
    294,
    295,
    297,
    298,
    299,
    300,
    302,
    303,
    304,
    306,
    308,
    309,
    312,
    313,
    314,
    316,
    318,
    320,
    321,
    322,
    323,
    325,
    326,
    327,
    329,
    331,
    333,
    335,
    337,
    339,
    340,
    343,
    344,
    345,
    346,
    347,
    348,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    363,
    365,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    375,
    376,
    377,
    378,
    380,
    381,
    382,
    384,
    385,
    386,
    387,
    389,
    390,
    394,
    395,
    396,
    397,
    398,
    1,
    2,
    4,
    5,
    6,
    8,
    9,
    10,
    11,
    12,
    13,
    15,
    17,
    18,
    19,
    20,
    23,
    24,
    25,
    26,
    27,
    28,
    32,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    44,
    45,
    47,
    48,
    49,
    50,
    53,
    54,
    56,
    58,
    59,
    63,
    66,
    67,
    69,
    70,
    72,
    73,
    74,
    75,
    76,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    88,
    90,
    91,
    92,
    93,
    95,
    96,
    97,
    100,
    102,
    105,
    107,
    108,
    109,
    111,
    112,
    114,
    117,
    118,
    119,
    120,
    121,
    122,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    131,
    134,
    135,
    138,
    139,
    140,
    141,
    143,
    145,
    146,
    147,
    148,
    152,
    153,
    154,
    156,
    157,
    158,
    160,
    161,
    162,
    163,
    165,
    167,
    168,
    169,
    170,
    171,
    173,
    174,
    175,
    177,
    178,
    179,
    180,
    181,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    203,
    205,
    206,
    207,
    209,
    212,
    213,
    214,
    215,
    216,
    217,
    220,
    221,
    222,
    224,
    227,
    228,
    229,
    232,
    233,
    234,
    235,
    238,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    250,
    251,
    252,
    253,
    255,
    256,
    257,
    259,
    260,
    262,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    270,
    272,
    274,
    275,
    276,
    277,
    278,
    279,
    281,
    282,
    283,
    285,
    286,
    287,
    288,
    290,
    291,
    292,
    293,
    295,
    296,
    299,
    302,
    303,
    304,
    305,
    306,
    307,
    308,
    309,
    311,
    312,
    315,
    316,
    317,
    318,
    319,
    322,
    323,
    324,
    325,
    326,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    339,
    340,
    342,
    343,
    344,
    345,
    346,
    347,
    350,
    351,
    352,
    353,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    376,
    377,
    378,
    380,
    381,
    382,
    383,
    384,
    386,
    388,
    389,
    390,
    391,
    392,
    393,
    394,
    395,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    7,
    8,
    9,
    10,
    11,
    13,
    14,
    15,
    17,
    18,
    19,
    20,
    21,
    22,
    24,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    48,
    49,
    51,
    54,
    55,
    57,
    58,
    62,
    63,
    64,
    65,
    66,
    68,
    69,
    70,
    71,
    73,
    74,
    75,
    76,
    78,
    80,
    81,
    82,
    84,
    85,
    86,
    87,
    88,
    91,
    92,
    93,
    94,
    95,
    97,
    98,
    99,
    101,
    102,
    105,
    106,
    107,
    108,
    109,
    110,
    113,
    114,
    115,
    117,
    118,
    119,
    120,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    132,
    134,
    136,
    137,
    138,
    140,
    142,
    144,
    145,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    174,
    175,
    177,
    178,
    179,
    180,
    181,
    183,
    184,
    185,
    187,
    190,
    191,
    192,
    193,
    195,
    197,
    199,
    200,
    201,
    202,
    203,
    204,
    206,
    207,
    208,
    210,
    212,
    213,
    214,
    215,
    216,
    217,
    219,
    220,
    221,
    222,
    224,
    225,
    226,
    228,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    238,
    239,
    240,
    241,
    242,
    244,
    245,
    246,
    247,
    248,
    249,
    251,
    255,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    269,
    270,
    273,
    274,
    275,
    276,
    278,
    279,
    281,
    283,
    284,
    286,
    287,
    288,
    289,
    291,
    293,
    294,
    295,
    297,
    298,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    309,
    310,
    311,
    312,
    313,
    315,
    316,
    317,
    319,
    320,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    335,
    336,
    337,
    338,
    339,
    341,
    342,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    355,
    356,
    357,
    358,
    361,
    362,
    364,
    365,
    366,
    367,
    369,
    370,
    371,
    373,
    374,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    391,
    392,
    393,
    394,
    395,
    396,
    397,
    398,
    0,
    1,
    2,
    4,
    5,
    6,
    7,
    9,
    13,
    14,
    15,
    16,
    17,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    38,
    40,
    41,
    42,
    43,
    45,
    46,
    47,
    48,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    59,
    61,
    62,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    84,
    85,
    87,
    88,
    89,
    91,
    92,
    94,
    95,
    97,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    107,
    109,
    110,
    111,
    112,
    114,
    115,
    117,
    118,
    122,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    131,
    132,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    142,
    143,
    144,
    145,
    147,
    148,
    149,
    151,
    152,
    154,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    171,
    172,
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    184,
    185,
    186,
    188,
    190,
    191,
    192,
    193,
    194,
    199,
    200,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    210,
    211,
    212,
    215,
    216,
    217,
    220,
    221,
    222,
    223,
    226,
    228,
    229,
    230,
    231,
    233,
    235,
    236,
    237,
    239,
    240,
    241,
    242,
    244,
    245,
    246,
    247,
    249,
    251,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    275,
    276,
    277,
    278,
    279,
    280,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    291,
    292,
    293,
    295,
    296,
    298,
    299,
    300,
    303,
    304,
    305,
    307,
    309,
    310,
    311,
    312,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    321,
    324,
    326,
    327,
    329,
    330,
    331,
    332,
    333,
    334,
    337,
    338,
    339,
    343,
    344,
    345,
    346,
    347,
    349,
    351,
    352,
    353,
    355,
    359,
    360,
    361,
    362,
    363,
    364,
    366,
    367,
    368,
    369,
    370,
    372,
    373,
    374,
    375,
    377,
    378,
    379,
    381,
    382,
    383,
    384,
    385,
    386,
    389,
    390,
    391,
    392,
    393,
    394,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    11,
    13,
    16,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    30,
    32,
    33,
    34,
    35,
    36,
    37,
    38,
    39,
    41,
    43,
    44,
    45,
    47,
    48,
    49,
    50,
    51,
    53,
    54,
    55,
    56,
    58,
    60,
    63,
    64,
    65,
    66,
    68,
    70,
    71,
    72,
    73,
    75,
    77,
    78,
    79,
    80,
    81,
    83,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    93,
    94,
    95,
    96,
    97,
    98,
    100,
    101,
    102,
    103,
    104,
    105,
    106,
    108,
    109,
    112,
    113,
    114,
    116,
    117,
    118,
    119,
    120,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    132,
    133,
    135,
    137,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    152,
    153,
    154,
    155,
    156,
    157,
    159,
    160,
    161,
    162,
    164,
    165,
    166,
    168,
    169,
    170,
    172,
    173,
    175,
    176,
    177,
    179,
    181,
    182,
    184,
    185,
    189,
    192,
    193,
    195,
    196,
    197,
    198,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    211,
    212,
    215,
    216,
    218,
    219,
    221,
    222,
    224,
    225,
    226,
    227,
    228,
    229,
    231,
    235,
    236,
    238,
    239,
    240,
    241,
    242,
    243,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    255,
    257,
    258,
    259,
    260,
    261,
    263,
    265,
    266,
    268,
    270,
    271,
    273,
    275,
    276,
    278,
    279,
    280,
    281,
    282,
    284,
    286,
    288,
    291,
    292,
    293,
    294,
    295,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    308,
    311,
    314,
    317,
    318,
    319,
    320,
    321,
    323,
    324,
    325,
    326,
    329,
    330,
    332,
    333,
    334,
    335,
    336,
    338,
    340,
    344,
    345,
    346,
    347,
    348,
    353,
    355,
    356,
    358,
    360,
    362,
    363,
    366,
    367,
    370,
    371,
    372,
    373,
    374,
    375,
    377,
    378,
    381,
    384,
    385,
    386,
    387,
    388,
    389,
    390,
    391,
    393,
    394,
    395,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    12,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    23,
    24,
    26,
    27,
    28,
    29,
    31,
    32,
    33,
    34,
    35,
    36,
    37,
    39,
    41,
    42,
    44,
    45,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    61,
    62,
    63,
    64,
    65,
    67,
    68,
    69,
    70,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    95,
    96,
    97,
    99,
    100,
    102,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    120,
    121,
    124,
    125,
    126,
    127,
    129,
    130,
    131,
    132,
    135,
    136,
    137,
    139,
    140,
    141,
    142,
    143,
    145,
    146,
    148,
    149,
    150,
    151,
    152,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    163,
    164,
    166,
    168,
    169,
    170,
    172,
    175,
    176,
    178,
    180,
    182,
    184,
    188,
    189,
    190,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    203,
    208,
    209,
    211,
    212,
    213,
    214,
    217,
    218,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    228,
    230,
    231,
    232,
    233,
    234,
    235,
    237,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    249,
    250,
    251,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    261,
    262,
    263,
    264,
    265,
    267,
    270,
    271,
    273,
    275,
    276,
    278,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    292,
    294,
    295,
    298,
    299,
    300,
    301,
    302,
    304,
    305,
    306,
    307,
    308,
    309,
    311,
    312,
    313,
    314,
    315,
    316,
    317,
    319,
    323,
    324,
    326,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    338,
    339,
    340,
    343,
    346,
    347,
    348,
    349,
    350,
    351,
    354,
    357,
    358,
    359,
    361,
    362,
    364,
    366,
    367,
    368,
    370,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    382,
    385,
    387,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    9,
    10,
    12,
    13,
    14,
    15,
    17,
    18,
    20,
    21,
    23,
    24,
    25,
    26,
    27,
    29,
    30,
    32,
    35,
    36,
    38,
    40,
    44,
    45,
    46,
    47,
    48,
    50,
    51,
    52,
    53,
    55,
    58,
    59,
    61,
    62,
    63,
    66,
    67,
    69,
    70,
    71,
    72,
    73,
    74,
    77,
    79,
    80,
    81,
    82,
    83,
    85,
    86,
    87,
    88,
    90,
    93,
    94,
    95,
    96,
    97,
    98,
    100,
    102,
    103,
    104,
    106,
    107,
    108,
    109,
    111,
    112,
    114,
    115,
    116,
    117,
    118,
    119,
    124,
    125,
    126,
    127,
    129,
    131,
    133,
    134,
    135,
    136,
    138,
    139,
    140,
    142,
    143,
    144,
    146,
    148,
    149,
    150,
    151,
    152,
    153,
    158,
    159,
    161,
    162,
    163,
    164,
    165,
    166,
    168,
    169,
    170,
    171,
    172,
    173,
    175,
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    184,
    185,
    187,
    188,
    190,
    191,
    193,
    194,
    195,
    196,
    198,
    200,
    201,
    202,
    203,
    205,
    207,
    209,
    210,
    211,
    212,
    213,
    214,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    238,
    240,
    241,
    243,
    244,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    256,
    257,
    258,
    259,
    264,
    265,
    266,
    268,
    269,
    271,
    273,
    275,
    276,
    277,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    292,
    293,
    295,
    297,
    302,
    304,
    305,
    307,
    308,
    310,
    311,
    312,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    320,
    322,
    323,
    324,
    325,
    326,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    338,
    339,
    342,
    343,
    344,
    345,
    346,
    347,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    357,
    359,
    360,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    371,
    372,
    373,
    375,
    376,
    377,
    378,
    379,
    380,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    398,
    0,
    1,
    2,
    3,
    4,
    5,
    7,
    9,
    11,
    12,
    13,
    15,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    26,
    27,
    28,
    29,
    32,
    34,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    46,
    47,
    48,
    49,
    50,
    52,
    53,
    54,
    56,
    57,
    59,
    61,
    62,
    64,
    66,
    67,
    68,
    69,
    70,
    72,
    73,
    74,
    76,
    77,
    78,
    79,
    81,
    83,
    84,
    86,
    87,
    89,
    90,
    91,
    92,
    93,
    95,
    96,
    97,
    100,
    101,
    103,
    104,
    105,
    106,
    107,
    111,
    112,
    113,
    115,
    116,
    118,
    119,
    120,
    121,
    122,
    124,
    125,
    126,
    127,
    129,
    132,
    133,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    143,
    144,
    145,
    148,
    149,
    150,
    151,
    152,
    153,
    155,
    156,
    157,
    158,
    159,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    169,
    171,
    173,
    174,
    175,
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    185,
    188,
    189,
    190,
    191,
    192,
    194,
    195,
    196,
    197,
    198,
    199,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    214,
    215,
    216,
    217,
    218,
    220,
    221,
    222,
    224,
    225,
    226,
    228,
    229,
    231,
    235,
    237,
    238,
    239,
    240,
    241,
    242,
    243,
    246,
    247,
    248,
    249,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    262,
    263,
    264,
    266,
    267,
    268,
    270,
    271,
    272,
    274,
    276,
    277,
    278,
    279,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    293,
    295,
    296,
    297,
    299,
    300,
    303,
    304,
    305,
    306,
    307,
    308,
    311,
    313,
    315,
    317,
    319,
    320,
    323,
    325,
    326,
    327,
    328,
    329,
    331,
    333,
    335,
    336,
    337,
    338,
    340,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    353,
    354,
    355,
    358,
    359,
    360,
    361,
    363,
    365,
    366,
    368,
    370,
    371,
    373,
    374,
    375,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    388,
    390,
    392,
    393,
    394,
    395,
    397,
    398,
    399,
    0,
    1,
    2,
    4,
    5,
    6,
    8,
    10,
    11,
    12,
    15,
    18,
    19,
    20,
    22,
    23,
    24,
    25,
    26,
    27,
    30,
    31,
    32,
    33,
    34,
    36,
    38,
    39,
    40,
    42,
    45,
    47,
    49,
    50,
    51,
    53,
    54,
    55,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    68,
    69,
    71,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    81,
    82,
    83,
    84,
    85,
    87,
    88,
    90,
    91,
    92,
    94,
    95,
    97,
    99,
    100,
    102,
    103,
    104,
    105,
    107,
    108,
    110,
    112,
    113,
    114,
    116,
    117,
    121,
    122,
    123,
    125,
    126,
    129,
    130,
    131,
    133,
    135,
    136,
    137,
    138,
    140,
    141,
    143,
    144,
    146,
    148,
    150,
    151,
    152,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    165,
    166,
    168,
    169,
    170,
    171,
    173,
    174,
    175,
    179,
    180,
    181,
    182,
    183,
    185,
    186,
    192,
    193,
    194,
    196,
    200,
    201,
    202,
    203,
    204,
    206,
    208,
    209,
    210,
    211,
    212,
    213,
    214,
    216,
    217,
    218,
    220,
    222,
    224,
    225,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    238,
    239,
    240,
    241,
    244,
    246,
    247,
    248,
    249,
    250,
    252,
    253,
    254,
    256,
    259,
    260,
    263,
    264,
    265,
    267,
    268,
    269,
    270,
    271,
    272,
    274,
    275,
    279,
    280,
    282,
    283,
    285,
    286,
    287,
    288,
    289,
    291,
    293,
    294,
    295,
    296,
    297,
    299,
    300,
    301,
    303,
    305,
    306,
    308,
    309,
    310,
    312,
    313,
    315,
    316,
    317,
    318,
    319,
    320,
    321,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    334,
    335,
    338,
    339,
    340,
    343,
    346,
    347,
    348,
    349,
    350,
    352,
    354,
    356,
    357,
    358,
    359,
    360,
    361,
    364,
    366,
    367,
    368,
    369,
    370,
    371,
    373,
    374,
    376,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    388,
    389,
    390,
    391,
    393,
    394,
    397,
    1,
    2,
    3,
    4,
    6,
    7,
    9,
    10,
    12,
    13,
    14,
    15,
    18,
    19,
    20,
    21,
    22,
    23,
    25,
    26,
    27,
    28,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    46,
    47,
    49,
    50,
    51,
    54,
    55,
    56,
    57,
    58,
    59,
    61,
    62,
    63,
    66,
    68,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    88,
    89,
    90,
    91,
    92,
    93,
    95,
    96,
    97,
    98,
    99,
    100,
    102,
    103,
    104,
    106,
    107,
    109,
    110,
    111,
    113,
    115,
    116,
    117,
    119,
    120,
    121,
    122,
    123,
    125,
    126,
    127,
    128,
    130,
    131,
    133,
    134,
    135,
    136,
    137,
    139,
    140,
    141,
    143,
    144,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    154,
    155,
    156,
    158,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    170,
    171,
    172,
    173,
    174,
    175,
    177,
    179,
    180,
    182,
    183,
    185,
    186,
    187,
    189,
    190,
    191,
    192,
    193,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    204,
    205,
    208,
    211,
    212,
    213,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    239,
    240,
    241,
    242,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    268,
    271,
    272,
    273,
    274,
    276,
    279,
    280,
    286,
    287,
    288,
    289,
    290,
    291,
    293,
    296,
    297,
    299,
    301,
    303,
    304,
    305,
    306,
    307,
    308,
    309,
    310,
    311,
    312,
    315,
    316,
    317,
    319,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    335,
    336,
    337,
    338,
    339,
    342,
    343,
    345,
    347,
    348,
    352,
    353,
    355,
    356,
    358,
    361,
    362,
    365,
    366,
    367,
    368,
    370,
    373,
    374,
    375,
    376,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    386,
    387,
    390,
    391,
    392,
    393,
    394,
    396,
    397,
    398,
    399,
    1,
    2,
    3,
    4,
    5,
    7,
    8,
    9,
    10,
    12,
    13,
    14,
    15,
    16,
    17,
    18,
    21,
    22,
    23,
    24,
    25,
    29,
    30,
    32,
    34,
    35,
    36,
    37,
    38,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    48,
    49,
    52,
    53,
    55,
    56,
    57,
    58,
    59,
    60,
    62,
    64,
    65,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    75,
    76,
    77,
    78,
    80,
    81,
    82,
    83,
    84,
    86,
    87,
    89,
    90,
    93,
    94,
    95,
    96,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    106,
    108,
    110,
    112,
    113,
    114,
    115,
    116,
    117,
    119,
    120,
    121,
    122,
    123,
    124,
    125,
    127,
    130,
    131,
    132,
    133,
    134,
    135,
    136,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    155,
    156,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    170,
    171,
    172,
    173,
    174,
    175,
    177,
    179,
    180,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    195,
    198,
    200,
    201,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    212,
    213,
    215,
    217,
    220,
    223,
    226,
    228,
    229,
    230,
    232,
    234,
    235,
    236,
    238,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    250,
    253,
    254,
    255,
    256,
    257,
    259,
    260,
    261,
    263,
    265,
    266,
    267,
    268,
    269,
    271,
    274,
    275,
    276,
    278,
    279,
    282,
    283,
    286,
    288,
    290,
    293,
    295,
    297,
    298,
    299,
    300,
    303,
    304,
    307,
    308,
    310,
    312,
    313,
    318,
    319,
    320,
    321,
    322,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    333,
    334,
    335,
    336,
    338,
    340,
    342,
    343,
    344,
    345,
    346,
    349,
    350,
    351,
    352,
    353,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    363,
    364,
    366,
    367,
    369,
    370,
    371,
    373,
    374,
    375,
    376,
    377,
    379,
    380,
    381,
    382,
    385,
    386,
    388,
    389,
    390,
    391,
    392,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    4,
    5,
    6,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    18,
    21,
    22,
    24,
    25,
    26,
    27,
    28,
    29,
    31,
    32,
    36,
    37,
    38,
    39,
    41,
    42,
    45,
    46,
    48,
    49,
    50,
    52,
    53,
    55,
    56,
    58,
    59,
    60,
    61,
    62,
    65,
    66,
    67,
    68,
    69,
    70,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    83,
    84,
    85,
    86,
    89,
    90,
    92,
    93,
    96,
    97,
    98,
    99,
    101,
    102,
    106,
    107,
    108,
    109,
    110,
    111,
    112,
    115,
    116,
    117,
    118,
    119,
    121,
    122,
    123,
    124,
    125,
    126,
    127,
    129,
    131,
    133,
    134,
    135,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    145,
    146,
    148,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    160,
    163,
    166,
    167,
    168,
    169,
    170,
    172,
    173,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    184,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    194,
    198,
    199,
    200,
    202,
    204,
    205,
    206,
    208,
    210,
    211,
    212,
    214,
    215,
    216,
    217,
    218,
    221,
    222,
    223,
    224,
    225,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    235,
    236,
    238,
    239,
    240,
    241,
    242,
    244,
    245,
    246,
    248,
    249,
    250,
    251,
    254,
    255,
    256,
    257,
    260,
    262,
    263,
    264,
    265,
    268,
    269,
    271,
    272,
    274,
    276,
    277,
    278,
    279,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    290,
    291,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    300,
    302,
    303,
    304,
    305,
    306,
    307,
    308,
    309,
    311,
    312,
    313,
    315,
    316,
    317,
    319,
    320,
    321,
    322,
    323,
    324,
    325,
    328,
    329,
    331,
    333,
    334,
    335,
    336,
    337,
    340,
    341,
    342,
    343,
    345,
    346,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    363,
    364,
    365,
    366,
    370,
    372,
    376,
    377,
    379,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    390,
    391,
    392,
    393,
    394,
    395,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    11,
    13,
    14,
    15,
    17,
    19,
    20,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    31,
    33,
    35,
    36,
    37,
    38,
    39,
    40,
    42,
    44,
    45,
    46,
    47,
    48,
    49,
    52,
    54,
    56,
    57,
    58,
    59,
    60,
    62,
    63,
    64,
    65,
    66,
    69,
    70,
    73,
    74,
    75,
    76,
    77,
    79,
    80,
    82,
    84,
    87,
    89,
    90,
    91,
    93,
    94,
    95,
    97,
    99,
    101,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    109,
    111,
    112,
    113,
    114,
    115,
    116,
    118,
    119,
    120,
    121,
    122,
    123,
    124,
    125,
    127,
    128,
    129,
    130,
    132,
    133,
    134,
    135,
    136,
    138,
    139,
    141,
    142,
    144,
    145,
    146,
    147,
    149,
    150,
    151,
    153,
    154,
    155,
    156,
    157,
    160,
    161,
    162,
    163,
    165,
    168,
    170,
    171,
    173,
    174,
    176,
    177,
    178,
    179,
    180,
    182,
    183,
    186,
    187,
    188,
    189,
    190,
    193,
    194,
    197,
    200,
    203,
    204,
    205,
    207,
    208,
    209,
    211,
    212,
    213,
    214,
    217,
    218,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    229,
    230,
    231,
    233,
    236,
    238,
    239,
    240,
    241,
    242,
    243,
    246,
    248,
    249,
    251,
    255,
    257,
    258,
    260,
    261,
    262,
    264,
    265,
    267,
    268,
    269,
    270,
    271,
    272,
    274,
    275,
    276,
    277,
    278,
    279,
    280,
    281,
    284,
    285,
    286,
    289,
    291,
    293,
    294,
    295,
    296,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    309,
    310,
    312,
    314,
    315,
    316,
    317,
    318,
    319,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    340,
    342,
    344,
    345,
    348,
    349,
    350,
    352,
    354,
    356,
    357,
    358,
    359,
    360,
    364,
    366,
    367,
    368,
    369,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    384,
    385,
    386,
    387,
    388,
    390,
    392,
    393,
    394,
    395,
    396,
    397,
    399,
    0,
    1,
    3,
    6,
    7,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    17,
    18,
    20,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    48,
    49,
    50,
    52,
    53,
    54,
    56,
    57,
    58,
    59,
    60,
    61,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    81,
    83,
    84,
    85,
    86,
    87,
    88,
    90,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    100,
    101,
    102,
    103,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    112,
    114,
    115,
    118,
    119,
    120,
    121,
    123,
    124,
    125,
    127,
    128,
    129,
    130,
    131,
    132,
    134,
    135,
    136,
    137,
    138,
    139,
    141,
    142,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    156,
    157,
    159,
    160,
    162,
    164,
    165,
    166,
    167,
    168,
    169,
    171,
    172,
    174,
    175,
    177,
    181,
    182,
    184,
    185,
    186,
    187,
    188,
    190,
    191,
    192,
    193,
    194,
    195,
    197,
    198,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    214,
    215,
    216,
    217,
    219,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    233,
    234,
    235,
    238,
    239,
    244,
    247,
    249,
    250,
    251,
    252,
    253,
    255,
    256,
    257,
    259,
    261,
    262,
    263,
    265,
    266,
    267,
    269,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    280,
    282,
    284,
    286,
    287,
    288,
    289,
    290,
    291,
    292,
    294,
    296,
    297,
    298,
    299,
    300,
    302,
    304,
    305,
    306,
    308,
    309,
    310,
    311,
    312,
    313,
    315,
    316,
    317,
    318,
    319,
    322,
    323,
    324,
    325,
    326,
    329,
    330,
    334,
    336,
    337,
    338,
    339,
    341,
    342,
    346,
    347,
    348,
    349,
    350,
    352,
    353,
    355,
    356,
    357,
    358,
    359,
    361,
    363,
    364,
    365,
    368,
    370,
    371,
    373,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    389,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    3,
    5,
    6,
    7,
    9,
    10,
    11,
    12,
    14,
    15,
    16,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    31,
    32,
    33,
    34,
    36,
    37,
    39,
    40,
    42,
    43,
    44,
    45,
    48,
    49,
    51,
    52,
    55,
    56,
    58,
    59,
    61,
    62,
    63,
    64,
    65,
    66,
    67,
    68,
    70,
    71,
    75,
    76,
    77,
    78,
    81,
    82,
    83,
    84,
    86,
    87,
    88,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    100,
    104,
    105,
    107,
    108,
    109,
    110,
    111,
    112,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    122,
    123,
    124,
    125,
    126,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    137,
    138,
    139,
    142,
    144,
    146,
    147,
    148,
    150,
    152,
    153,
    155,
    156,
    157,
    158,
    160,
    161,
    162,
    163,
    164,
    166,
    167,
    168,
    169,
    173,
    176,
    177,
    178,
    179,
    180,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    195,
    197,
    198,
    199,
    200,
    201,
    202,
    203,
    204,
    207,
    208,
    209,
    210,
    211,
    213,
    214,
    215,
    216,
    217,
    219,
    220,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    231,
    232,
    233,
    235,
    236,
    238,
    239,
    240,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    262,
    263,
    265,
    266,
    268,
    269,
    270,
    271,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    279,
    280,
    282,
    283,
    284,
    287,
    288,
    289,
    290,
    291,
    293,
    295,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    307,
    308,
    310,
    311,
    312,
    313,
    314,
    315,
    317,
    318,
    319,
    320,
    321,
    322,
    323,
    324,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    337,
    338,
    339,
    340,
    341,
    343,
    346,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    360,
    361,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    374,
    375,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    386,
    387,
    388,
    390,
    392,
    393,
    396,
    397,
    399,
    2,
    3,
    5,
    6,
    8,
    10,
    11,
    12,
    13,
    15,
    16,
    17,
    18,
    19,
    21,
    22,
    23,
    24,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    35,
    36,
    39,
    40,
    41,
    42,
    44,
    45,
    46,
    47,
    48,
    49,
    50,
    51,
    54,
    55,
    56,
    57,
    58,
    59,
    61,
    62,
    63,
    67,
    68,
    70,
    71,
    73,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    88,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    103,
    104,
    105,
    106,
    109,
    110,
    111,
    113,
    114,
    115,
    117,
    118,
    119,
    122,
    124,
    126,
    127,
    129,
    130,
    132,
    133,
    135,
    136,
    137,
    138,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    156,
    158,
    159,
    160,
    163,
    164,
    165,
    166,
    168,
    169,
    171,
    172,
    173,
    175,
    177,
    178,
    179,
    180,
    181,
    183,
    184,
    185,
    186,
    187,
    188,
    190,
    191,
    193,
    194,
    196,
    199,
    200,
    201,
    202,
    203,
    204,
    206,
    207,
    208,
    209,
    210,
    211,
    212,
    214,
    215,
    217,
    218,
    219,
    220,
    221,
    222,
    223,
    226,
    227,
    228,
    229,
    230,
    233,
    235,
    236,
    237,
    238,
    239,
    240,
    243,
    244,
    245,
    246,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    262,
    263,
    265,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    276,
    279,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    300,
    302,
    303,
    304,
    308,
    312,
    313,
    314,
    315,
    316,
    317,
    319,
    320,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    334,
    335,
    336,
    337,
    339,
    340,
    341,
    342,
    343,
    344,
    346,
    348,
    350,
    351,
    353,
    356,
    358,
    359,
    362,
    363,
    364,
    365,
    368,
    369,
    370,
    371,
    372,
    373,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    385,
    386,
    388,
    389,
    391,
    392,
    393,
    394,
    395,
    397,
    398,
    1,
    3,
    4,
    5,
    6,
    13,
    14,
    16,
    17,
    19,
    20,
    21,
    23,
    24,
    25,
    26,
    27,
    29,
    30,
    31,
    32,
    34,
    36,
    40,
    41,
    42,
    43,
    45,
    46,
    47,
    48,
    50,
    51,
    52,
    54,
    55,
    56,
    60,
    61,
    63,
    64,
    65,
    66,
    67,
    68,
    70,
    74,
    75,
    76,
    78,
    79,
    81,
    82,
    83,
    84,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    106,
    107,
    109,
    110,
    111,
    112,
    113,
    115,
    117,
    120,
    121,
    122,
    123,
    124,
    125,
    126,
    127,
    128,
    129,
    131,
    132,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    159,
    160,
    161,
    162,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    176,
    178,
    179,
    180,
    181,
    182,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    194,
    196,
    197,
    199,
    200,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    211,
    213,
    215,
    217,
    218,
    219,
    220,
    221,
    223,
    225,
    226,
    227,
    228,
    229,
    232,
    234,
    235,
    236,
    237,
    238,
    239,
    240,
    241,
    242,
    244,
    245,
    247,
    248,
    249,
    252,
    253,
    254,
    255,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    265,
    267,
    268,
    269,
    270,
    272,
    273,
    275,
    277,
    278,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    293,
    294,
    295,
    296,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    309,
    310,
    314,
    317,
    319,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    333,
    334,
    336,
    337,
    338,
    339,
    342,
    343,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    357,
    358,
    359,
    360,
    361,
    364,
    365,
    366,
    367,
    371,
    373,
    374,
    375,
    377,
    378,
    379,
    380,
    381,
    382,
    384,
    385,
    386,
    389,
    390,
    391,
    393,
    394,
    395,
    396,
    398,
    399,
    0,
    5,
    6,
    7,
    8,
    9,
    11,
    12,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    26,
    27,
    28,
    29,
    31,
    32,
    33,
    35,
    37,
    39,
    40,
    41,
    42,
    44,
    45,
    46,
    47,
    48,
    49,
    50,
    52,
    53,
    54,
    55,
    57,
    58,
    59,
    61,
    62,
    63,
    64,
    65,
    66,
    67,
    69,
    70,
    71,
    72,
    73,
    75,
    76,
    77,
    78,
    79,
    80,
    82,
    84,
    85,
    86,
    88,
    89,
    90,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    106,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    119,
    121,
    123,
    124,
    125,
    126,
    127,
    129,
    130,
    131,
    132,
    133,
    134,
    135,
    136,
    137,
    139,
    140,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    152,
    153,
    156,
    157,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    170,
    171,
    172,
    175,
    176,
    177,
    178,
    180,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    198,
    199,
    200,
    201,
    202,
    203,
    204,
    205,
    206,
    208,
    209,
    212,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    222,
    223,
    224,
    225,
    226,
    227,
    229,
    230,
    231,
    232,
    233,
    234,
    236,
    238,
    239,
    242,
    243,
    244,
    247,
    248,
    250,
    251,
    252,
    253,
    255,
    256,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    270,
    271,
    272,
    274,
    276,
    278,
    280,
    281,
    282,
    283,
    284,
    285,
    289,
    291,
    294,
    295,
    297,
    298,
    299,
    300,
    304,
    305,
    306,
    307,
    309,
    310,
    311,
    312,
    313,
    314,
    315,
    318,
    319,
    320,
    321,
    322,
    323,
    326,
    328,
    329,
    331,
    332,
    333,
    334,
    337,
    338,
    340,
    342,
    343,
    345,
    346,
    347,
    350,
    351,
    352,
    354,
    355,
    357,
    358,
    359,
    361,
    363,
    364,
    365,
    366,
    367,
    369,
    370,
    371,
    372,
    374,
    375,
    378,
    379,
    380,
    381,
    382,
    384,
    385,
    386,
    387,
    388,
    389,
    391,
    392,
    393,
    394,
    397,
    399,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    13,
    16,
    17,
    18,
    19,
    20,
    21,
    23,
    25,
    26,
    29,
    32,
    33,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    44,
    45,
    46,
    49,
    50,
    51,
    53,
    54,
    56,
    57,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    82,
    83,
    85,
    86,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    97,
    98,
    99,
    102,
    103,
    105,
    106,
    109,
    110,
    112,
    113,
    114,
    115,
    117,
    118,
    119,
    121,
    122,
    125,
    126,
    127,
    129,
    130,
    131,
    133,
    134,
    135,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    153,
    154,
    155,
    156,
    157,
    159,
    160,
    161,
    162,
    163,
    164,
    166,
    167,
    168,
    169,
    170,
    171,
    173,
    174,
    175,
    177,
    179,
    180,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    190,
    192,
    194,
    195,
    197,
    198,
    200,
    201,
    202,
    203,
    205,
    206,
    208,
    210,
    212,
    216,
    217,
    218,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    234,
    237,
    242,
    243,
    244,
    245,
    246,
    247,
    250,
    252,
    253,
    254,
    255,
    256,
    259,
    263,
    264,
    265,
    266,
    267,
    269,
    270,
    272,
    273,
    275,
    276,
    278,
    279,
    280,
    281,
    282,
    283,
    285,
    287,
    294,
    295,
    296,
    297,
    298,
    299,
    300,
    301,
    302,
    304,
    305,
    306,
    309,
    310,
    311,
    312,
    315,
    316,
    317,
    318,
    319,
    320,
    322,
    324,
    326,
    329,
    331,
    332,
    333,
    336,
    338,
    339,
    340,
    342,
    343,
    344,
    345,
    346,
    347,
    349,
    350,
    352,
    354,
    356,
    357,
    358,
    359,
    360,
    362,
    363,
    365,
    368,
    369,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    389,
    390,
    392,
    393,
    394,
    395,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    8,
    10,
    11,
    12,
    13,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    35,
    36,
    37,
    38,
    39,
    40,
    42,
    43,
    45,
    46,
    47,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    61,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    71,
    72,
    75,
    76,
    79,
    80,
    82,
    83,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    94,
    96,
    98,
    99,
    100,
    101,
    102,
    104,
    107,
    109,
    110,
    111,
    112,
    113,
    115,
    116,
    117,
    118,
    119,
    120,
    121,
    122,
    124,
    125,
    126,
    127,
    128,
    130,
    131,
    132,
    133,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    146,
    147,
    148,
    149,
    150,
    152,
    153,
    154,
    155,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    171,
    174,
    176,
    177,
    178,
    179,
    181,
    182,
    183,
    184,
    185,
    187,
    190,
    191,
    192,
    193,
    194,
    196,
    197,
    198,
    199,
    200,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    211,
    212,
    213,
    214,
    215,
    216,
    218,
    219,
    221,
    223,
    225,
    226,
    227,
    228,
    229,
    232,
    234,
    235,
    236,
    237,
    238,
    239,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    267,
    270,
    272,
    273,
    275,
    277,
    279,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    290,
    292,
    293,
    294,
    296,
    297,
    301,
    302,
    303,
    304,
    306,
    307,
    309,
    311,
    312,
    313,
    315,
    316,
    317,
    318,
    319,
    320,
    321,
    322,
    323,
    324,
    325,
    328,
    330,
    331,
    334,
    335,
    336,
    338,
    341,
    342,
    344,
    345,
    347,
    349,
    350,
    352,
    353,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    363,
    364,
    365,
    366,
    367,
    368,
    371,
    372,
    373,
    374,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    388,
    389,
    390,
    393,
    394,
    395,
    397,
    398,
    399,
    0,
    2,
    4,
    5,
    7,
    8,
    9,
    12,
    13,
    16,
    17,
    18,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    47,
    48,
    50,
    51,
    52,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    77,
    78,
    80,
    81,
    82,
    83,
    84,
    85,
    88,
    89,
    91,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    105,
    106,
    110,
    112,
    113,
    114,
    115,
    116,
    117,
    121,
    122,
    125,
    126,
    127,
    128,
    129,
    130,
    131,
    134,
    135,
    136,
    137,
    138,
    141,
    142,
    143,
    144,
    145,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    165,
    168,
    170,
    172,
    173,
    174,
    175,
    176,
    177,
    178,
    180,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    191,
    192,
    194,
    195,
    196,
    198,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    212,
    214,
    215,
    216,
    217,
    218,
    219,
    222,
    223,
    224,
    225,
    226,
    229,
    231,
    233,
    234,
    235,
    236,
    237,
    238,
    239,
    241,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    253,
    257,
    259,
    260,
    261,
    264,
    268,
    269,
    270,
    273,
    276,
    279,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    290,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    300,
    303,
    304,
    305,
    306,
    307,
    308,
    309,
    310,
    311,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    320,
    321,
    322,
    323,
    325,
    326,
    327,
    328,
    333,
    334,
    335,
    336,
    337,
    339,
    340,
    341,
    343,
    344,
    348,
    350,
    351,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    362,
    364,
    365,
    366,
    367,
    368,
    371,
    372,
    373,
    374,
    376,
    378,
    379,
    381,
    382,
    384,
    385,
    386,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    6,
    7,
    9,
    10,
    11,
    12,
    13,
    14,
    18,
    19,
    20,
    22,
    23,
    24,
    25,
    26,
    27,
    29,
    31,
    32,
    34,
    35,
    36,
    37,
    38,
    39,
    41,
    42,
    43,
    44,
    45,
    46,
    47,
    48,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    58,
    60,
    61,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    80,
    81,
    82,
    86,
    88,
    89,
    90,
    91,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    102,
    103,
    104,
    105,
    106,
    108,
    109,
    112,
    113,
    115,
    116,
    118,
    119,
    120,
    121,
    122,
    123,
    124,
    125,
    126,
    128,
    130,
    131,
    132,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    148,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    170,
    171,
    173,
    174,
    175,
    176,
    177,
    178,
    179,
    181,
    183,
    184,
    185,
    186,
    188,
    189,
    190,
    192,
    193,
    195,
    196,
    197,
    198,
    200,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    211,
    212,
    213,
    214,
    216,
    217,
    218,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    238,
    239,
    240,
    241,
    242,
    243,
    245,
    246,
    248,
    253,
    254,
    255,
    257,
    258,
    259,
    261,
    262,
    264,
    265,
    266,
    267,
    272,
    273,
    274,
    275,
    278,
    281,
    282,
    283,
    285,
    286,
    288,
    289,
    290,
    291,
    292,
    294,
    295,
    296,
    297,
    298,
    299,
    300,
    302,
    303,
    304,
    305,
    306,
    307,
    308,
    309,
    314,
    316,
    318,
    319,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    333,
    334,
    335,
    336,
    337,
    338,
    339,
    341,
    343,
    344,
    346,
    347,
    348,
    349,
    350,
    352,
    353,
    355,
    356,
    360,
    362,
    363,
    364,
    365,
    369,
    370,
    372,
    374,
    375,
    377,
    378,
    380,
    381,
    382,
    386,
    387,
    388,
    389,
    390,
    391,
    392,
    393,
    394,
    396,
    398,
    0,
    1,
    2,
    4,
    5,
    6,
    7,
    8,
    10,
    11,
    12,
    13,
    15,
    16,
    17,
    18,
    21,
    22,
    24,
    26,
    28,
    29,
    32,
    33,
    34,
    35,
    36,
    37,
    38,
    40,
    41,
    42,
    43,
    47,
    48,
    49,
    50,
    51,
    53,
    54,
    55,
    56,
    60,
    61,
    63,
    64,
    65,
    67,
    69,
    70,
    71,
    72,
    74,
    75,
    77,
    78,
    79,
    80,
    81,
    83,
    84,
    85,
    86,
    87,
    88,
    90,
    92,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    108,
    109,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    122,
    123,
    124,
    125,
    126,
    128,
    129,
    130,
    131,
    134,
    135,
    137,
    138,
    140,
    141,
    142,
    144,
    148,
    149,
    150,
    151,
    152,
    155,
    156,
    157,
    158,
    160,
    161,
    162,
    163,
    164,
    166,
    167,
    168,
    169,
    170,
    172,
    173,
    175,
    176,
    177,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    190,
    192,
    193,
    194,
    195,
    198,
    199,
    200,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    209,
    210,
    211,
    212,
    214,
    215,
    219,
    220,
    221,
    222,
    223,
    224,
    226,
    227,
    231,
    232,
    233,
    234,
    235,
    236,
    239,
    241,
    242,
    244,
    245,
    246,
    248,
    249,
    251,
    252,
    254,
    255,
    258,
    259,
    260,
    262,
    263,
    266,
    267,
    268,
    270,
    271,
    272,
    275,
    277,
    278,
    281,
    285,
    286,
    288,
    290,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    300,
    301,
    302,
    303,
    305,
    306,
    307,
    308,
    309,
    311,
    312,
    313,
    316,
    317,
    318,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    333,
    334,
    338,
    340,
    341,
    343,
    344,
    345,
    346,
    347,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    358,
    359,
    360,
    361,
    363,
    364,
    365,
    367,
    368,
    369,
    370,
    371,
    374,
    376,
    377,
    378,
    379,
    381,
    383,
    385,
    386,
    387,
    388,
    389,
    391,
    392,
    393,
    395,
    396,
    398,
    0,
    1,
    3,
    4,
    5,
    7,
    8,
    10,
    13,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    27,
    28,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    46,
    47,
    48,
    50,
    51,
    52,
    54,
    55,
    56,
    57,
    59,
    60,
    62,
    63,
    65,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    76,
    77,
    78,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    90,
    91,
    92,
    94,
    95,
    96,
    97,
    99,
    100,
    101,
    103,
    105,
    107,
    108,
    109,
    110,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    121,
    122,
    124,
    127,
    128,
    129,
    130,
    132,
    133,
    136,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    147,
    148,
    149,
    151,
    152,
    154,
    156,
    158,
    160,
    163,
    164,
    166,
    167,
    168,
    170,
    171,
    172,
    173,
    174,
    175,
    178,
    179,
    181,
    182,
    183,
    184,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    194,
    195,
    198,
    199,
    200,
    201,
    203,
    205,
    207,
    208,
    210,
    211,
    212,
    213,
    214,
    215,
    216,
    217,
    218,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    228,
    229,
    230,
    232,
    234,
    235,
    236,
    237,
    239,
    240,
    242,
    243,
    244,
    245,
    248,
    250,
    252,
    253,
    255,
    256,
    257,
    258,
    260,
    261,
    262,
    263,
    264,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    275,
    276,
    278,
    279,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    288,
    289,
    290,
    291,
    292,
    293,
    294,
    295,
    297,
    299,
    300,
    301,
    302,
    303,
    304,
    306,
    307,
    308,
    309,
    310,
    312,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    321,
    322,
    323,
    325,
    327,
    328,
    329,
    331,
    333,
    334,
    335,
    336,
    337,
    338,
    340,
    343,
    344,
    345,
    346,
    348,
    350,
    351,
    352,
    353,
    355,
    357,
    358,
    359,
    360,
    361,
    362,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    376,
    377,
    378,
    379,
    380,
    381,
    383,
    384,
    386,
    387,
    388,
    389,
    390,
    392,
    393,
    395,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    7,
    9,
    11,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    24,
    26,
    27,
    29,
    30,
    31,
    32,
    33,
    36,
    38,
    41,
    43,
    44,
    45,
    46,
    47,
    48,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    64,
    66,
    67,
    69,
    70,
    71,
    77,
    78,
    80,
    81,
    82,
    84,
    85,
    86,
    87,
    89,
    91,
    92,
    95,
    97,
    99,
    100,
    101,
    103,
    105,
    106,
    107,
    108,
    112,
    113,
    114,
    116,
    117,
    118,
    120,
    121,
    122,
    123,
    124,
    125,
    126,
    127,
    128,
    129,
    131,
    132,
    134,
    136,
    137,
    138,
    139,
    140,
    144,
    145,
    146,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    159,
    161,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    171,
    172,
    173,
    174,
    175,
    176,
    177,
    180,
    181,
    182,
    184,
    185,
    186,
    188,
    189,
    190,
    191,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    203,
    205,
    206,
    207,
    209,
    210,
    212,
    213,
    214,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    224,
    225,
    226,
    227,
    228,
    230,
    231,
    233,
    234,
    235,
    236,
    237,
    238,
    239,
    240,
    241,
    245,
    246,
    247,
    249,
    250,
    252,
    253,
    256,
    257,
    259,
    260,
    261,
    262,
    264,
    265,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    275,
    276,
    277,
    278,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    291,
    295,
    296,
    297,
    299,
    300,
    301,
    302,
    304,
    306,
    308,
    309,
    310,
    311,
    312,
    313,
    314,
    316,
    317,
    318,
    319,
    321,
    323,
    324,
    325,
    327,
    330,
    331,
    332,
    333,
    334,
    336,
    337,
    338,
    340,
    341,
    342,
    345,
    346,
    347,
    350,
    351,
    353,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    372,
    373,
    375,
    377,
    378,
    379,
    380,
    381,
    383,
    386,
    388,
    389,
    390,
    391,
    393,
    394,
    395,
    396,
    399,
    3,
    5,
    6,
    8,
    9,
    11,
    12,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    25,
    26,
    27,
    28,
    30,
    31,
    32,
    33,
    34,
    35,
    37,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    48,
    49,
    50,
    52,
    53,
    54,
    55,
    56,
    59,
    60,
    61,
    62,
    64,
    66,
    67,
    69,
    70,
    71,
    72,
    74,
    75,
    76,
    77,
    78,
    80,
    82,
    83,
    84,
    85,
    86,
    87,
    91,
    92,
    93,
    94,
    96,
    100,
    101,
    103,
    104,
    105,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    118,
    120,
    121,
    122,
    123,
    124,
    125,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    135,
    136,
    138,
    139,
    141,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    151,
    152,
    155,
    156,
    157,
    160,
    162,
    163,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    175,
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    194,
    197,
    198,
    201,
    203,
    204,
    205,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    215,
    216,
    218,
    219,
    220,
    221,
    222,
    223,
    224,
    225,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    235,
    236,
    237,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    247,
    249,
    250,
    251,
    252,
    255,
    256,
    257,
    259,
    261,
    262,
    264,
    265,
    266,
    267,
    268,
    269,
    270,
    271,
    273,
    274,
    275,
    276,
    277,
    278,
    279,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    288,
    289,
    290,
    291,
    292,
    293,
    294,
    295,
    296,
    298,
    299,
    300,
    302,
    303,
    304,
    307,
    308,
    309,
    310,
    311,
    313,
    317,
    318,
    319,
    321,
    323,
    324,
    325,
    327,
    328,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    339,
    340,
    341,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    358,
    362,
    364,
    365,
    366,
    367,
    368,
    369,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    383,
    385,
    386,
    387,
    388,
    389,
    390,
    392,
    393,
    394,
    395,
    396,
    397,
    398,
    399,
    1,
    6,
    7,
    8,
    9,
    12,
    13,
    14,
    16,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    47,
    48,
    49,
    50,
    53,
    54,
    55,
    56,
    57,
    58,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    80,
    81,
    82,
    84,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    94,
    95,
    97,
    98,
    100,
    102,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    116,
    117,
    118,
    119,
    121,
    123,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    132,
    133,
    134,
    139,
    140,
    141,
    142,
    143,
    144,
    146,
    147,
    148,
    150,
    151,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    175,
    179,
    180,
    181,
    182,
    183,
    184,
    185,
    186,
    189,
    190,
    191,
    192,
    193,
    195,
    196,
    198,
    199,
    200,
    201,
    208,
    209,
    210,
    212,
    213,
    214,
    215,
    216,
    217,
    219,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    249,
    250,
    253,
    256,
    257,
    258,
    259,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    268,
    270,
    271,
    272,
    274,
    275,
    277,
    278,
    279,
    280,
    281,
    283,
    285,
    286,
    288,
    290,
    291,
    292,
    293,
    296,
    297,
    299,
    301,
    302,
    303,
    305,
    306,
    307,
    308,
    309,
    310,
    311,
    312,
    313,
    314,
    316,
    317,
    319,
    320,
    322,
    323,
    324,
    325,
    327,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    339,
    340,
    341,
    342,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    357,
    358,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    371,
    373,
    374,
    375,
    376,
    377,
    379,
    380,
    381,
    383,
    385,
    386,
    387,
    388,
    390,
    392,
    394,
    395,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    6,
    7,
    8,
    9,
    10,
    14,
    16,
    17,
    18,
    20,
    21,
    22,
    24,
    26,
    28,
    30,
    31,
    33,
    34,
    35,
    36,
    37,
    38,
    40,
    41,
    44,
    45,
    46,
    48,
    51,
    52,
    53,
    54,
    56,
    57,
    58,
    59,
    62,
    65,
    66,
    67,
    68,
    69,
    70,
    71,
    74,
    75,
    76,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    89,
    90,
    91,
    92,
    94,
    95,
    97,
    98,
    100,
    101,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    112,
    113,
    114,
    115,
    117,
    118,
    120,
    121,
    122,
    123,
    126,
    127,
    128,
    129,
    130,
    131,
    132,
    135,
    136,
    137,
    138,
    139,
    141,
    143,
    144,
    146,
    148,
    149,
    150,
    153,
    156,
    157,
    158,
    159,
    161,
    163,
    164,
    165,
    168,
    169,
    171,
    172,
    173,
    174,
    176,
    177,
    178,
    179,
    182,
    183,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    194,
    195,
    197,
    198,
    199,
    200,
    202,
    203,
    204,
    205,
    207,
    208,
    209,
    210,
    212,
    213,
    214,
    215,
    216,
    218,
    221,
    222,
    223,
    224,
    226,
    227,
    228,
    229,
    230,
    236,
    238,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    251,
    252,
    253,
    255,
    256,
    257,
    258,
    262,
    263,
    264,
    265,
    266,
    267,
    269,
    270,
    272,
    273,
    275,
    276,
    278,
    279,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    293,
    294,
    295,
    296,
    297,
    298,
    300,
    302,
    303,
    305,
    306,
    307,
    309,
    311,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    320,
    321,
    322,
    324,
    325,
    326,
    327,
    330,
    331,
    333,
    334,
    335,
    336,
    337,
    338,
    340,
    341,
    343,
    344,
    345,
    350,
    351,
    352,
    353,
    354,
    355,
    357,
    358,
    361,
    362,
    363,
    364,
    365,
    367,
    368,
    369,
    370,
    371,
    372,
    374,
    377,
    378,
    379,
    380,
    381,
    382,
    384,
    386,
    387,
    388,
    389,
    390,
    391,
    392,
    393,
    394,
    396,
    397,
    399,
    0,
    1,
    2,
    5,
    6,
    7,
    8,
    9,
    10,
    12,
    13,
    14,
    15,
    17,
    18,
    19,
    21,
    22,
    25,
    26,
    28,
    29,
    30,
    31,
    35,
    36,
    37,
    38,
    39,
    41,
    42,
    44,
    45,
    46,
    47,
    49,
    50,
    51,
    52,
    53,
    54,
    58,
    59,
    61,
    62,
    65,
    66,
    67,
    69,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    80,
    81,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    101,
    102,
    104,
    105,
    106,
    107,
    108,
    110,
    111,
    112,
    113,
    114,
    116,
    117,
    119,
    120,
    123,
    124,
    125,
    126,
    127,
    128,
    130,
    132,
    133,
    134,
    135,
    136,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    148,
    149,
    150,
    151,
    152,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    163,
    165,
    167,
    168,
    169,
    173,
    174,
    175,
    176,
    177,
    178,
    179,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    203,
    206,
    207,
    209,
    212,
    213,
    216,
    217,
    220,
    221,
    222,
    223,
    225,
    226,
    227,
    229,
    232,
    233,
    234,
    235,
    236,
    239,
    240,
    241,
    242,
    243,
    245,
    246,
    247,
    248,
    249,
    251,
    252,
    253,
    254,
    255,
    257,
    258,
    259,
    261,
    262,
    265,
    267,
    270,
    271,
    273,
    275,
    276,
    277,
    278,
    281,
    282,
    283,
    284,
    285,
    286,
    288,
    290,
    291,
    292,
    293,
    295,
    296,
    297,
    299,
    300,
    301,
    302,
    303,
    305,
    306,
    307,
    308,
    309,
    310,
    311,
    313,
    315,
    316,
    318,
    319,
    320,
    321,
    323,
    324,
    326,
    329,
    330,
    331,
    333,
    334,
    335,
    336,
    337,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    363,
    365,
    367,
    368,
    371,
    372,
    373,
    374,
    375,
    378,
    379,
    381,
    382,
    383,
    386,
    387,
    388,
    389,
    390,
    391,
    392,
    394,
    395,
    396,
    399,
    0,
    2,
    4,
    5,
    11,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    26,
    28,
    29,
    30,
    31,
    33,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    47,
    48,
    49,
    51,
    52,
    55,
    57,
    58,
    59,
    63,
    64,
    67,
    68,
    69,
    70,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    84,
    85,
    86,
    87,
    89,
    91,
    93,
    94,
    95,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    105,
    106,
    107,
    110,
    113,
    114,
    116,
    119,
    120,
    121,
    122,
    124,
    126,
    127,
    128,
    131,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    154,
    155,
    156,
    157,
    159,
    160,
    161,
    162,
    163,
    164,
    166,
    167,
    169,
    170,
    172,
    173,
    174,
    175,
    177,
    178,
    179,
    180,
    181,
    182,
    185,
    186,
    188,
    189,
    192,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    204,
    206,
    207,
    210,
    211,
    212,
    213,
    214,
    215,
    216,
    217,
    218,
    219,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    239,
    240,
    241,
    242,
    243,
    244,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    255,
    256,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    270,
    271,
    274,
    276,
    278,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    289,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    299,
    301,
    303,
    305,
    306,
    307,
    308,
    309,
    311,
    312,
    313,
    316,
    317,
    318,
    319,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    340,
    341,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    352,
    353,
    354,
    355,
    358,
    359,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    369,
    370,
    371,
    372,
    375,
    378,
    379,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    397,
    399,
    0,
    1,
    2,
    4,
    6,
    7,
    8,
    9,
    10,
    11,
    12,
    13,
    15,
    16,
    17,
    18,
    20,
    21,
    22,
    23,
    24,
    27,
    28,
    29,
    30,
    31,
    32,
    34,
    35,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    48,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    61,
    62,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    81,
    82,
    84,
    85,
    86,
    87,
    88,
    90,
    91,
    93,
    94,
    95,
    97,
    98,
    99,
    100,
    101,
    102,
    104,
    105,
    106,
    107,
    108,
    110,
    111,
    112,
    113,
    114,
    115,
    117,
    118,
    119,
    120,
    121,
    122,
    124,
    125,
    126,
    127,
    129,
    130,
    132,
    133,
    134,
    135,
    136,
    137,
    140,
    141,
    142,
    144,
    146,
    148,
    149,
    151,
    152,
    153,
    154,
    155,
    158,
    159,
    160,
    161,
    162,
    165,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    175,
    176,
    177,
    178,
    179,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    192,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    203,
    204,
    206,
    207,
    208,
    209,
    210,
    211,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    233,
    234,
    235,
    236,
    239,
    241,
    242,
    244,
    245,
    246,
    247,
    249,
    250,
    254,
    256,
    257,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    268,
    269,
    270,
    272,
    273,
    274,
    275,
    276,
    277,
    279,
    283,
    284,
    286,
    287,
    288,
    289,
    295,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    309,
    310,
    311,
    312,
    316,
    317,
    318,
    319,
    320,
    321,
    322,
    323,
    325,
    327,
    328,
    331,
    332,
    334,
    335,
    336,
    337,
    339,
    340,
    341,
    342,
    344,
    345,
    346,
    347,
    348,
    351,
    352,
    353,
    355,
    356,
    358,
    361,
    362,
    363,
    365,
    366,
    367,
    368,
    370,
    373,
    374,
    375,
    376,
    377,
    378,
    380,
    383,
    387,
    388,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    398,
    399,
    0,
    1,
    2,
    4,
    5,
    6,
    7,
    9,
    10,
    11,
    13,
    15,
    16,
    19,
    21,
    22,
    25,
    26,
    29,
    30,
    32,
    34,
    35,
    36,
    37,
    38,
    39,
    41,
    42,
    43,
    44,
    46,
    47,
    48,
    49,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    67,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    80,
    83,
    84,
    87,
    88,
    89,
    90,
    91,
    93,
    95,
    97,
    99,
    100,
    101,
    102,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    118,
    119,
    120,
    121,
    122,
    123,
    127,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    135,
    137,
    138,
    140,
    142,
    143,
    145,
    146,
    148,
    149,
    150,
    151,
    152,
    154,
    157,
    159,
    160,
    161,
    164,
    165,
    166,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    175,
    176,
    178,
    179,
    180,
    181,
    183,
    184,
    185,
    189,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    210,
    211,
    212,
    213,
    214,
    216,
    217,
    219,
    220,
    221,
    222,
    223,
    224,
    225,
    228,
    229,
    231,
    232,
    233,
    234,
    236,
    237,
    238,
    239,
    240,
    241,
    242,
    243,
    246,
    247,
    248,
    249,
    250,
    252,
    253,
    254,
    256,
    257,
    258,
    260,
    261,
    262,
    263,
    265,
    266,
    267,
    271,
    272,
    274,
    275,
    276,
    278,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    288,
    290,
    291,
    292,
    293,
    294,
    295,
    297,
    299,
    300,
    301,
    302,
    303,
    304,
    306,
    307,
    309,
    310,
    311,
    312,
    313,
    314,
    315,
    316,
    318,
    320,
    321,
    322,
    323,
    324,
    325,
    327,
    328,
    329,
    330,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    339,
    340,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    350,
    351,
    352,
    353,
    354,
    357,
    358,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    376,
    378,
    379,
    380,
    381,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    390,
    391,
    392,
    394,
    396,
    397,
    399,
    2,
    3,
    4,
    6,
    8,
    9,
    10,
    12,
    13,
    14,
    15,
    16,
    17,
    18,
    19,
    21,
    22,
    23,
    25,
    26,
    27,
    28,
    29,
    31,
    32,
    33,
    34,
    35,
    36,
    39,
    40,
    41,
    42,
    44,
    45,
    46,
    47,
    50,
    51,
    52,
    53,
    55,
    56,
    58,
    59,
    60,
    61,
    62,
    65,
    66,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    87,
    90,
    91,
    92,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    103,
    105,
    106,
    107,
    109,
    111,
    112,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    121,
    123,
    124,
    125,
    127,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    136,
    137,
    138,
    139,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    152,
    153,
    154,
    155,
    157,
    158,
    159,
    160,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    175,
    176,
    177,
    178,
    180,
    183,
    185,
    186,
    188,
    189,
    190,
    191,
    192,
    194,
    195,
    196,
    198,
    199,
    200,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    212,
    213,
    215,
    216,
    218,
    220,
    221,
    223,
    224,
    226,
    227,
    228,
    230,
    231,
    232,
    235,
    236,
    237,
    238,
    239,
    240,
    242,
    243,
    244,
    246,
    249,
    251,
    252,
    253,
    254,
    255,
    256,
    257,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    268,
    270,
    272,
    273,
    274,
    275,
    277,
    279,
    281,
    283,
    284,
    285,
    286,
    287,
    289,
    290,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    308,
    310,
    312,
    314,
    315,
    316,
    317,
    318,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    339,
    340,
    341,
    342,
    344,
    347,
    348,
    350,
    352,
    354,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    363,
    364,
    365,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    389,
    390,
    391,
    392,
    393,
    394,
    396,
    398,
    399,
    0,
    1,
    4,
    5,
    7,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    27,
    29,
    30,
    31,
    32,
    33,
    34,
    35,
    38,
    39,
    40,
    42,
    43,
    45,
    46,
    47,
    49,
    51,
    52,
    53,
    54,
    55,
    56,
    58,
    59,
    61,
    62,
    63,
    64,
    67,
    68,
    70,
    71,
    73,
    74,
    75,
    76,
    78,
    79,
    80,
    81,
    83,
    84,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    96,
    97,
    98,
    99,
    100,
    102,
    103,
    105,
    106,
    107,
    109,
    110,
    111,
    112,
    113,
    116,
    118,
    119,
    120,
    123,
    124,
    125,
    127,
    129,
    133,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    145,
    146,
    147,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    157,
    158,
    159,
    160,
    161,
    162,
    164,
    165,
    168,
    169,
    170,
    171,
    173,
    174,
    175,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    195,
    196,
    197,
    198,
    200,
    202,
    203,
    205,
    206,
    207,
    208,
    209,
    210,
    211,
    212,
    215,
    216,
    217,
    218,
    220,
    221,
    222,
    223,
    225,
    226,
    227,
    228,
    230,
    231,
    236,
    237,
    238,
    239,
    241,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    271,
    272,
    273,
    274,
    275,
    278,
    279,
    280,
    283,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    292,
    294,
    295,
    296,
    297,
    299,
    300,
    301,
    302,
    304,
    305,
    306,
    308,
    309,
    310,
    312,
    314,
    315,
    317,
    318,
    320,
    322,
    323,
    326,
    327,
    328,
    330,
    331,
    332,
    335,
    336,
    337,
    339,
    342,
    343,
    346,
    347,
    349,
    350,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    362,
    363,
    364,
    367,
    368,
    369,
    370,
    373,
    375,
    376,
    377,
    378,
    380,
    381,
    382,
    384,
    385,
    386,
    387,
    389,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    397,
    399,
    0,
    1,
    2,
    5,
    7,
    8,
    10,
    12,
    14,
    16,
    17,
    18,
    19,
    20,
    22,
    24,
    25,
    26,
    27,
    28,
    29,
    32,
    33,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    47,
    49,
    50,
    51,
    52,
    55,
    56,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    68,
    70,
    72,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    103,
    104,
    107,
    108,
    109,
    110,
    111,
    113,
    114,
    116,
    117,
    118,
    119,
    120,
    122,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    131,
    132,
    135,
    136,
    137,
    138,
    142,
    143,
    144,
    145,
    146,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    156,
    158,
    159,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    169,
    170,
    171,
    172,
    174,
    175,
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    184,
    186,
    187,
    189,
    190,
    192,
    193,
    194,
    196,
    197,
    198,
    200,
    202,
    203,
    204,
    205,
    207,
    208,
    209,
    210,
    212,
    213,
    214,
    216,
    217,
    218,
    219,
    221,
    223,
    226,
    227,
    228,
    230,
    233,
    234,
    236,
    237,
    238,
    239,
    240,
    242,
    243,
    245,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    255,
    258,
    261,
    263,
    264,
    265,
    267,
    269,
    270,
    273,
    276,
    277,
    278,
    279,
    281,
    282,
    283,
    285,
    286,
    287,
    288,
    290,
    291,
    292,
    293,
    294,
    297,
    298,
    300,
    301,
    302,
    303,
    305,
    306,
    308,
    309,
    310,
    311,
    312,
    313,
    314,
    317,
    320,
    321,
    323,
    324,
    327,
    328,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    340,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    354,
    355,
    356,
    358,
    359,
    360,
    361,
    362,
    366,
    367,
    369,
    370,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    380,
    382,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    391,
    392,
    393,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    4,
    6,
    7,
    9,
    10,
    11,
    12,
    14,
    15,
    19,
    20,
    21,
    22,
    23,
    24,
    26,
    28,
    29,
    30,
    32,
    35,
    36,
    37,
    38,
    39,
    40,
    42,
    43,
    44,
    45,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    70,
    72,
    73,
    74,
    76,
    77,
    78,
    80,
    81,
    84,
    86,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    102,
    103,
    106,
    107,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    117,
    118,
    119,
    121,
    122,
    123,
    124,
    127,
    128,
    129,
    131,
    133,
    134,
    135,
    136,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    148,
    149,
    150,
    151,
    156,
    157,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    172,
    173,
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    185,
    186,
    187,
    188,
    189,
    190,
    192,
    193,
    195,
    197,
    198,
    199,
    200,
    201,
    202,
    204,
    206,
    207,
    208,
    210,
    213,
    215,
    216,
    217,
    219,
    220,
    221,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    232,
    233,
    234,
    235,
    236,
    237,
    238,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    249,
    250,
    252,
    254,
    255,
    257,
    258,
    259,
    260,
    262,
    263,
    264,
    266,
    267,
    269,
    270,
    271,
    272,
    273,
    274,
    276,
    277,
    278,
    280,
    281,
    282,
    284,
    285,
    286,
    287,
    290,
    291,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    300,
    301,
    304,
    305,
    306,
    307,
    309,
    310,
    313,
    314,
    316,
    318,
    319,
    320,
    323,
    324,
    327,
    328,
    329,
    330,
    331,
    332,
    334,
    335,
    336,
    337,
    338,
    340,
    342,
    344,
    345,
    347,
    348,
    349,
    350,
    351,
    353,
    354,
    355,
    358,
    359,
    360,
    361,
    362,
    364,
    365,
    366,
    367,
    369,
    370,
    371,
    373,
    375,
    376,
    377,
    378,
    379,
    380,
    383,
    385,
    387,
    388,
    389,
    390,
    391,
    392,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    7,
    8,
    9,
    11,
    12,
    13,
    16,
    17,
    20,
    21,
    22,
    23,
    24,
    26,
    27,
    28,
    30,
    34,
    35,
    37,
    40,
    41,
    42,
    45,
    46,
    48,
    49,
    50,
    51,
    52,
    54,
    55,
    57,
    58,
    60,
    61,
    63,
    64,
    65,
    66,
    68,
    69,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    83,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    106,
    108,
    109,
    110,
    111,
    112,
    114,
    115,
    117,
    118,
    119,
    122,
    123,
    124,
    125,
    127,
    128,
    129,
    130,
    131,
    133,
    134,
    136,
    137,
    139,
    140,
    142,
    143,
    144,
    146,
    147,
    148,
    149,
    151,
    153,
    155,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    175,
    176,
    178,
    179,
    180,
    181,
    183,
    184,
    185,
    186,
    187,
    189,
    190,
    191,
    192,
    193,
    194,
    195,
    198,
    199,
    201,
    202,
    203,
    204,
    207,
    208,
    209,
    210,
    216,
    217,
    218,
    219,
    222,
    223,
    225,
    226,
    227,
    229,
    230,
    231,
    234,
    237,
    238,
    240,
    241,
    242,
    249,
    250,
    251,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    265,
    266,
    268,
    270,
    271,
    272,
    273,
    274,
    275,
    276,
    278,
    279,
    280,
    281,
    282,
    285,
    286,
    287,
    288,
    289,
    291,
    293,
    294,
    295,
    296,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    309,
    310,
    311,
    313,
    314,
    315,
    316,
    318,
    319,
    320,
    321,
    323,
    324,
    325,
    327,
    329,
    331,
    332,
    333,
    334,
    335,
    337,
    341,
    342,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    355,
    356,
    357,
    360,
    361,
    362,
    365,
    366,
    367,
    368,
    370,
    372,
    374,
    375,
    376,
    378,
    380,
    382,
    384,
    385,
    386,
    387,
    388,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    4,
    5,
    6,
    7,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    28,
    29,
    30,
    32,
    34,
    35,
    36,
    37,
    39,
    41,
    43,
    44,
    46,
    47,
    48,
    49,
    52,
    53,
    56,
    58,
    59,
    60,
    62,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    71,
    72,
    73,
    74,
    76,
    77,
    78,
    79,
    80,
    83,
    85,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    95,
    97,
    100,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    121,
    122,
    124,
    125,
    126,
    129,
    131,
    132,
    133,
    134,
    136,
    137,
    138,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    170,
    172,
    173,
    175,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    184,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    194,
    196,
    197,
    200,
    201,
    202,
    203,
    205,
    207,
    208,
    210,
    211,
    213,
    217,
    218,
    221,
    222,
    225,
    226,
    229,
    230,
    232,
    233,
    235,
    236,
    237,
    239,
    241,
    242,
    243,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    255,
    256,
    257,
    258,
    260,
    261,
    264,
    265,
    266,
    267,
    268,
    269,
    272,
    273,
    274,
    275,
    276,
    277,
    279,
    280,
    281,
    282,
    284,
    286,
    287,
    288,
    289,
    290,
    291,
    293,
    294,
    297,
    299,
    300,
    301,
    303,
    304,
    306,
    307,
    309,
    312,
    313,
    314,
    315,
    317,
    318,
    319,
    322,
    323,
    324,
    325,
    326,
    328,
    329,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    339,
    340,
    342,
    343,
    345,
    346,
    347,
    348,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    358,
    359,
    360,
    361,
    362,
    363,
    365,
    366,
    367,
    368,
    369,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    379,
    380,
    383,
    384,
    386,
    387,
    388,
    389,
    390,
    391,
    392,
    393,
    394,
    399,
    0,
    1,
    3,
    4,
    5,
    6,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    18,
    19,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    32,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    45,
    49,
    50,
    51,
    52,
    53,
    56,
    58,
    59,
    60,
    61,
    62,
    64,
    66,
    67,
    68,
    70,
    71,
    72,
    73,
    75,
    76,
    78,
    79,
    80,
    83,
    84,
    85,
    87,
    88,
    91,
    92,
    93,
    94,
    95,
    97,
    98,
    99,
    101,
    102,
    106,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    118,
    120,
    121,
    122,
    123,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    131,
    134,
    135,
    136,
    137,
    138,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    151,
    152,
    153,
    155,
    156,
    158,
    159,
    160,
    162,
    164,
    165,
    166,
    167,
    169,
    170,
    172,
    173,
    174,
    175,
    176,
    178,
    179,
    180,
    181,
    182,
    185,
    187,
    188,
    189,
    191,
    192,
    193,
    194,
    196,
    197,
    199,
    202,
    204,
    205,
    206,
    207,
    208,
    210,
    211,
    212,
    213,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    223,
    224,
    226,
    227,
    228,
    230,
    231,
    232,
    233,
    234,
    237,
    238,
    239,
    242,
    243,
    244,
    245,
    246,
    248,
    250,
    251,
    252,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    261,
    262,
    264,
    265,
    266,
    267,
    269,
    271,
    272,
    273,
    274,
    275,
    278,
    280,
    281,
    282,
    283,
    284,
    286,
    288,
    290,
    291,
    292,
    293,
    294,
    296,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    305,
    306,
    309,
    310,
    311,
    312,
    313,
    316,
    317,
    318,
    319,
    320,
    322,
    323,
    324,
    325,
    327,
    329,
    330,
    332,
    333,
    334,
    336,
    337,
    338,
    343,
    344,
    345,
    346,
    347,
    349,
    350,
    351,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    370,
    372,
    373,
    374,
    376,
    378,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    390,
    391,
    392,
    393,
    394,
    396,
    397,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    18,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    35,
    36,
    37,
    38,
    40,
    42,
    43,
    44,
    45,
    46,
    49,
    50,
    51,
    55,
    56,
    57,
    58,
    59,
    60,
    62,
    63,
    64,
    66,
    67,
    68,
    69,
    70,
    71,
    73,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    87,
    88,
    89,
    90,
    91,
    93,
    95,
    96,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    106,
    112,
    113,
    114,
    115,
    117,
    118,
    119,
    121,
    123,
    126,
    128,
    129,
    130,
    131,
    132,
    133,
    135,
    137,
    139,
    141,
    144,
    145,
    146,
    148,
    149,
    150,
    151,
    153,
    154,
    156,
    162,
    163,
    164,
    165,
    166,
    168,
    169,
    171,
    172,
    173,
    174,
    175,
    176,
    177,
    178,
    179,
    182,
    183,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    199,
    200,
    201,
    202,
    203,
    205,
    207,
    208,
    209,
    211,
    212,
    214,
    216,
    217,
    218,
    219,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    232,
    233,
    234,
    235,
    236,
    239,
    240,
    243,
    244,
    245,
    246,
    247,
    248,
    251,
    252,
    254,
    256,
    257,
    258,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    274,
    275,
    276,
    278,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    289,
    290,
    291,
    292,
    297,
    298,
    299,
    301,
    303,
    304,
    306,
    307,
    308,
    309,
    310,
    311,
    313,
    316,
    317,
    318,
    321,
    323,
    324,
    325,
    326,
    328,
    329,
    331,
    333,
    335,
    336,
    338,
    339,
    340,
    341,
    342,
    343,
    344,
    346,
    347,
    348,
    351,
    353,
    354,
    356,
    359,
    360,
    361,
    362,
    363,
    365,
    369,
    370,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    392,
    396,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    7,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    16,
    17,
    18,
    19,
    21,
    23,
    25,
    26,
    27,
    28,
    29,
    30,
    32,
    33,
    35,
    36,
    37,
    38,
    41,
    42,
    43,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    58,
    60,
    61,
    63,
    64,
    66,
    67,
    68,
    69,
    70,
    72,
    73,
    74,
    75,
    76,
    77,
    79,
    81,
    82,
    85,
    86,
    87,
    88,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    100,
    102,
    105,
    106,
    107,
    108,
    110,
    111,
    116,
    117,
    118,
    119,
    121,
    123,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    131,
    132,
    134,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    156,
    157,
    158,
    159,
    160,
    161,
    165,
    166,
    167,
    168,
    169,
    170,
    173,
    174,
    177,
    178,
    179,
    180,
    181,
    182,
    184,
    185,
    186,
    187,
    189,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    199,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    212,
    213,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    222,
    223,
    224,
    225,
    227,
    228,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    238,
    239,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    251,
    252,
    254,
    255,
    256,
    257,
    259,
    260,
    261,
    265,
    268,
    269,
    270,
    272,
    274,
    275,
    277,
    279,
    280,
    281,
    282,
    283,
    285,
    286,
    287,
    292,
    293,
    295,
    296,
    299,
    300,
    301,
    304,
    305,
    306,
    308,
    310,
    311,
    312,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    321,
    322,
    323,
    324,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    339,
    341,
    342,
    343,
    345,
    346,
    347,
    349,
    350,
    351,
    352,
    353,
    355,
    356,
    359,
    361,
    362,
    363,
    364,
    365,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    388,
    389,
    390,
    391,
    393,
    394,
    395,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    6,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    18,
    19,
    21,
    22,
    23,
    24,
    25,
    26,
    28,
    32,
    33,
    34,
    36,
    37,
    38,
    39,
    40,
    42,
    43,
    44,
    45,
    46,
    47,
    48,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    60,
    61,
    62,
    64,
    65,
    66,
    67,
    68,
    70,
    71,
    73,
    74,
    76,
    77,
    78,
    79,
    80,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    108,
    109,
    110,
    111,
    112,
    114,
    117,
    118,
    121,
    122,
    123,
    124,
    125,
    126,
    127,
    128,
    130,
    131,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    156,
    158,
    159,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    170,
    172,
    173,
    174,
    178,
    179,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    198,
    200,
    201,
    203,
    204,
    205,
    206,
    213,
    214,
    215,
    217,
    219,
    220,
    221,
    223,
    224,
    227,
    229,
    230,
    231,
    232,
    233,
    236,
    237,
    238,
    239,
    240,
    241,
    242,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    256,
    257,
    260,
    261,
    262,
    263,
    264,
    266,
    267,
    268,
    269,
    271,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    279,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    288,
    289,
    290,
    291,
    292,
    293,
    295,
    296,
    297,
    298,
    299,
    300,
    301,
    303,
    306,
    307,
    308,
    312,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    320,
    321,
    322,
    325,
    326,
    327,
    329,
    330,
    331,
    332,
    335,
    338,
    339,
    341,
    342,
    343,
    345,
    346,
    347,
    349,
    350,
    351,
    353,
    356,
    358,
    360,
    361,
    363,
    364,
    366,
    368,
    369,
    371,
    372,
    377,
    378,
    379,
    381,
    383,
    384,
    385,
    386,
    387,
    389,
    391,
    392,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    6,
    7,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    16,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    37,
    38,
    39,
    43,
    44,
    45,
    48,
    49,
    50,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    62,
    63,
    65,
    66,
    67,
    68,
    69,
    70,
    71,
    73,
    75,
    76,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    93,
    94,
    95,
    97,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    108,
    109,
    110,
    112,
    114,
    116,
    117,
    118,
    120,
    121,
    122,
    123,
    124,
    127,
    128,
    130,
    132,
    133,
    134,
    136,
    137,
    138,
    140,
    141,
    142,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    156,
    158,
    160,
    161,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    172,
    173,
    174,
    175,
    176,
    177,
    179,
    180,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    198,
    199,
    200,
    203,
    204,
    205,
    206,
    209,
    210,
    211,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    223,
    224,
    227,
    229,
    230,
    231,
    232,
    233,
    234,
    236,
    237,
    238,
    239,
    241,
    242,
    243,
    244,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    266,
    267,
    268,
    269,
    271,
    272,
    273,
    274,
    276,
    277,
    278,
    279,
    280,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    291,
    292,
    294,
    296,
    297,
    298,
    299,
    302,
    303,
    304,
    305,
    307,
    308,
    310,
    312,
    313,
    314,
    315,
    317,
    318,
    320,
    321,
    323,
    325,
    327,
    328,
    329,
    330,
    331,
    332,
    334,
    335,
    337,
    340,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    350,
    351,
    352,
    354,
    356,
    357,
    358,
    359,
    360,
    362,
    363,
    364,
    365,
    366,
    369,
    370,
    371,
    372,
    373,
    374,
    376,
    377,
    380,
    383,
    384,
    386,
    387,
    389,
    391,
    392,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    2,
    3,
    4,
    6,
    7,
    8,
    9,
    10,
    11,
    12,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    25,
    26,
    27,
    29,
    30,
    31,
    32,
    33,
    34,
    36,
    38,
    39,
    40,
    43,
    44,
    45,
    46,
    48,
    49,
    50,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    65,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    95,
    96,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    110,
    111,
    114,
    115,
    116,
    117,
    119,
    121,
    123,
    124,
    125,
    126,
    127,
    128,
    129,
    131,
    132,
    133,
    134,
    135,
    136,
    137,
    138,
    139,
    141,
    142,
    143,
    145,
    146,
    147,
    148,
    149,
    150,
    152,
    153,
    154,
    157,
    158,
    159,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    175,
    178,
    179,
    180,
    181,
    183,
    185,
    186,
    187,
    188,
    189,
    190,
    192,
    193,
    194,
    196,
    197,
    198,
    199,
    201,
    204,
    205,
    206,
    208,
    209,
    213,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    225,
    226,
    228,
    229,
    230,
    231,
    233,
    235,
    239,
    241,
    242,
    244,
    245,
    246,
    247,
    248,
    250,
    251,
    254,
    255,
    257,
    258,
    259,
    260,
    261,
    262,
    265,
    266,
    267,
    268,
    269,
    270,
    272,
    273,
    274,
    275,
    277,
    279,
    280,
    282,
    283,
    284,
    286,
    287,
    288,
    289,
    290,
    291,
    292,
    293,
    296,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    307,
    309,
    310,
    311,
    312,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    320,
    322,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    337,
    338,
    339,
    340,
    341,
    342,
    343,
    344,
    348,
    349,
    350,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    362,
    363,
    365,
    367,
    368,
    369,
    371,
    372,
    373,
    374,
    375,
    376,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    388,
    390,
    391,
    393,
    394,
    395,
    396,
    397,
    399,
    0,
    2,
    4,
    6,
    8,
    9,
    11,
    12,
    13,
    15,
    16,
    17,
    19,
    20,
    21,
    22,
    23,
    24,
    28,
    29,
    30,
    31,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    45,
    46,
    47,
    48,
    49,
    52,
    53,
    54,
    55,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    66,
    67,
    69,
    70,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    98,
    102,
    103,
    104,
    105,
    106,
    108,
    109,
    110,
    111,
    113,
    116,
    117,
    119,
    120,
    121,
    125,
    127,
    128,
    129,
    131,
    132,
    133,
    134,
    135,
    136,
    139,
    141,
    143,
    144,
    145,
    147,
    148,
    149,
    150,
    152,
    154,
    156,
    157,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    170,
    171,
    172,
    173,
    178,
    180,
    181,
    183,
    184,
    185,
    187,
    188,
    189,
    191,
    193,
    194,
    195,
    196,
    198,
    199,
    200,
    201,
    202,
    203,
    204,
    205,
    206,
    209,
    211,
    212,
    213,
    214,
    216,
    217,
    218,
    219,
    220,
    221,
    224,
    225,
    226,
    227,
    228,
    233,
    234,
    236,
    237,
    238,
    239,
    240,
    241,
    242,
    243,
    245,
    248,
    249,
    251,
    252,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    261,
    262,
    264,
    265,
    266,
    268,
    270,
    274,
    275,
    276,
    278,
    279,
    280,
    282,
    283,
    284,
    286,
    287,
    288,
    289,
    290,
    292,
    294,
    295,
    296,
    297,
    298,
    299,
    300,
    302,
    303,
    305,
    307,
    308,
    309,
    310,
    312,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    329,
    330,
    331,
    333,
    334,
    335,
    336,
    337,
    338,
    340,
    341,
    343,
    344,
    345,
    346,
    347,
    348,
    351,
    352,
    354,
    355,
    356,
    357,
    358,
    359,
    361,
    364,
    367,
    368,
    369,
    372,
    373,
    374,
    375,
    377,
    378,
    381,
    382,
    383,
    386,
    387,
    388,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    16,
    17,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    28,
    29,
    30,
    31,
    32,
    33,
    35,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    46,
    48,
    49,
    50,
    51,
    54,
    55,
    56,
    59,
    60,
    61,
    62,
    63,
    65,
    66,
    67,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    101,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    109,
    112,
    113,
    114,
    115,
    116,
    118,
    119,
    120,
    122,
    123,
    124,
    125,
    126,
    127,
    128,
    130,
    132,
    133,
    134,
    136,
    140,
    142,
    143,
    144,
    145,
    147,
    149,
    150,
    152,
    153,
    154,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    166,
    167,
    168,
    169,
    171,
    172,
    173,
    174,
    175,
    176,
    178,
    182,
    183,
    186,
    187,
    188,
    189,
    191,
    192,
    194,
    195,
    197,
    198,
    200,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    210,
    211,
    213,
    214,
    216,
    217,
    219,
    220,
    221,
    223,
    225,
    226,
    227,
    228,
    230,
    232,
    233,
    235,
    236,
    237,
    238,
    239,
    240,
    241,
    244,
    246,
    247,
    248,
    249,
    250,
    252,
    253,
    254,
    255,
    257,
    258,
    260,
    261,
    262,
    263,
    264,
    265,
    267,
    270,
    271,
    272,
    274,
    275,
    276,
    277,
    278,
    280,
    281,
    282,
    283,
    284,
    285,
    287,
    288,
    289,
    290,
    292,
    293,
    295,
    298,
    300,
    301,
    303,
    305,
    307,
    308,
    309,
    310,
    312,
    314,
    317,
    319,
    320,
    321,
    323,
    325,
    326,
    327,
    330,
    331,
    332,
    335,
    337,
    338,
    339,
    340,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    360,
    361,
    362,
    363,
    364,
    366,
    367,
    371,
    373,
    374,
    375,
    376,
    377,
    378,
    380,
    381,
    382,
    384,
    385,
    387,
    388,
    390,
    393,
    394,
    395,
    398,
    399,
    1,
    2,
    3,
    4,
    7,
    8,
    10,
    11,
    12,
    13,
    14,
    16,
    17,
    19,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    29,
    30,
    31,
    32,
    33,
    35,
    36,
    37,
    39,
    41,
    42,
    43,
    44,
    45,
    46,
    47,
    49,
    51,
    52,
    53,
    54,
    56,
    57,
    58,
    59,
    61,
    62,
    63,
    65,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    74,
    75,
    76,
    78,
    79,
    81,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    111,
    112,
    114,
    115,
    116,
    117,
    120,
    121,
    123,
    124,
    125,
    126,
    128,
    129,
    131,
    132,
    133,
    134,
    135,
    136,
    138,
    139,
    140,
    141,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    160,
    161,
    162,
    163,
    165,
    167,
    168,
    169,
    170,
    171,
    173,
    174,
    176,
    177,
    178,
    180,
    181,
    182,
    185,
    186,
    187,
    188,
    189,
    190,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    203,
    206,
    207,
    208,
    209,
    210,
    212,
    213,
    214,
    215,
    216,
    217,
    218,
    220,
    221,
    222,
    223,
    224,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    239,
    240,
    241,
    242,
    244,
    247,
    249,
    251,
    252,
    253,
    255,
    257,
    258,
    260,
    261,
    262,
    264,
    265,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    274,
    276,
    277,
    278,
    281,
    282,
    284,
    285,
    286,
    288,
    289,
    290,
    291,
    292,
    293,
    294,
    297,
    298,
    299,
    300,
    301,
    305,
    307,
    308,
    309,
    310,
    312,
    314,
    315,
    316,
    317,
    319,
    322,
    323,
    325,
    326,
    328,
    329,
    332,
    333,
    334,
    335,
    336,
    337,
    340,
    341,
    342,
    345,
    346,
    348,
    349,
    350,
    351,
    352,
    354,
    355,
    356,
    357,
    359,
    362,
    364,
    368,
    370,
    371,
    372,
    374,
    375,
    377,
    378,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    390,
    392,
    393,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    11,
    13,
    14,
    15,
    16,
    17,
    18,
    21,
    23,
    25,
    27,
    28,
    29,
    31,
    32,
    33,
    34,
    35,
    36,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    47,
    49,
    50,
    51,
    52,
    54,
    55,
    56,
    58,
    59,
    60,
    63,
    65,
    66,
    70,
    71,
    72,
    73,
    74,
    75,
    79,
    80,
    81,
    82,
    83,
    85,
    86,
    88,
    89,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    99,
    101,
    102,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    112,
    113,
    115,
    117,
    118,
    119,
    120,
    121,
    122,
    123,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    136,
    137,
    138,
    139,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    153,
    154,
    155,
    158,
    159,
    160,
    161,
    163,
    164,
    165,
    167,
    169,
    170,
    172,
    173,
    174,
    177,
    178,
    179,
    180,
    182,
    183,
    184,
    185,
    188,
    190,
    191,
    193,
    194,
    195,
    196,
    197,
    198,
    200,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    211,
    212,
    215,
    216,
    217,
    218,
    219,
    220,
    222,
    223,
    224,
    226,
    227,
    231,
    232,
    234,
    237,
    239,
    240,
    242,
    244,
    245,
    247,
    248,
    249,
    250,
    252,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    267,
    268,
    269,
    271,
    273,
    275,
    276,
    278,
    279,
    280,
    282,
    283,
    284,
    285,
    288,
    289,
    290,
    291,
    292,
    294,
    295,
    296,
    297,
    298,
    301,
    302,
    303,
    305,
    307,
    308,
    311,
    312,
    314,
    315,
    316,
    317,
    320,
    324,
    325,
    326,
    327,
    328,
    330,
    333,
    334,
    335,
    336,
    337,
    338,
    339,
    340,
    341,
    343,
    344,
    345,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    356,
    357,
    358,
    359,
    360,
    362,
    363,
    364,
    366,
    367,
    368,
    369,
    370,
    371,
    373,
    375,
    376,
    377,
    378,
    379,
    382,
    384,
    386,
    387,
    388,
    389,
    390,
    393,
    394,
    396,
    397,
    399,
    0,
    1,
    2,
    3,
    5,
    6,
    7,
    8,
    9,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    19,
    21,
    22,
    23,
    24,
    25,
    28,
    30,
    31,
    33,
    34,
    35,
    36,
    37,
    38,
    40,
    42,
    44,
    45,
    46,
    47,
    48,
    49,
    51,
    52,
    53,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    66,
    67,
    68,
    69,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    80,
    81,
    82,
    83,
    85,
    86,
    89,
    92,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    119,
    121,
    122,
    125,
    127,
    128,
    129,
    130,
    132,
    136,
    137,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    149,
    150,
    151,
    152,
    154,
    155,
    156,
    158,
    159,
    160,
    161,
    163,
    164,
    165,
    166,
    167,
    169,
    170,
    171,
    172,
    173,
    174,
    176,
    178,
    179,
    180,
    181,
    182,
    183,
    185,
    186,
    187,
    188,
    189,
    190,
    192,
    193,
    196,
    198,
    199,
    200,
    203,
    205,
    206,
    209,
    211,
    212,
    213,
    214,
    215,
    216,
    218,
    219,
    220,
    224,
    225,
    227,
    228,
    230,
    231,
    232,
    233,
    235,
    236,
    237,
    238,
    240,
    241,
    242,
    243,
    245,
    246,
    250,
    253,
    254,
    255,
    256,
    258,
    259,
    260,
    261,
    262,
    263,
    265,
    266,
    268,
    269,
    271,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    281,
    282,
    283,
    285,
    286,
    287,
    288,
    290,
    291,
    292,
    293,
    294,
    296,
    297,
    298,
    300,
    301,
    304,
    308,
    309,
    310,
    311,
    312,
    313,
    314,
    315,
    317,
    318,
    319,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    328,
    329,
    330,
    331,
    333,
    334,
    336,
    337,
    338,
    340,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    353,
    354,
    358,
    359,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    385,
    386,
    387,
    389,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    3,
    4,
    6,
    7,
    9,
    10,
    11,
    12,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    22,
    24,
    25,
    26,
    27,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    38,
    39,
    40,
    42,
    43,
    45,
    46,
    47,
    48,
    49,
    51,
    53,
    56,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    75,
    76,
    79,
    80,
    81,
    82,
    83,
    84,
    86,
    87,
    88,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    103,
    104,
    105,
    107,
    108,
    110,
    111,
    112,
    114,
    115,
    116,
    117,
    118,
    120,
    121,
    122,
    123,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    131,
    133,
    136,
    137,
    139,
    140,
    141,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    156,
    159,
    160,
    161,
    163,
    164,
    165,
    166,
    167,
    168,
    170,
    171,
    172,
    173,
    175,
    176,
    177,
    179,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    193,
    194,
    198,
    199,
    200,
    201,
    202,
    203,
    204,
    205,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    214,
    215,
    216,
    218,
    219,
    220,
    221,
    223,
    224,
    225,
    226,
    227,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    257,
    258,
    259,
    260,
    261,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    271,
    272,
    273,
    274,
    276,
    277,
    278,
    279,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    289,
    290,
    291,
    292,
    294,
    296,
    297,
    298,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    308,
    310,
    311,
    312,
    314,
    316,
    317,
    319,
    320,
    321,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    334,
    335,
    336,
    337,
    339,
    341,
    342,
    343,
    344,
    345,
    346,
    348,
    349,
    351,
    352,
    353,
    354,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    390,
    392,
    393,
    394,
    395,
    396,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    10,
    12,
    13,
    14,
    16,
    17,
    19,
    20,
    22,
    23,
    25,
    26,
    28,
    29,
    30,
    31,
    32,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    48,
    49,
    50,
    52,
    53,
    54,
    55,
    56,
    58,
    59,
    60,
    62,
    63,
    64,
    65,
    67,
    69,
    70,
    71,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    81,
    85,
    86,
    87,
    90,
    91,
    92,
    93,
    94,
    96,
    97,
    98,
    99,
    100,
    101,
    103,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    112,
    114,
    118,
    119,
    120,
    121,
    122,
    123,
    124,
    125,
    126,
    127,
    129,
    130,
    131,
    132,
    136,
    139,
    141,
    142,
    143,
    144,
    146,
    147,
    148,
    149,
    150,
    151,
    154,
    155,
    156,
    158,
    160,
    165,
    166,
    168,
    170,
    171,
    172,
    173,
    175,
    176,
    178,
    179,
    180,
    181,
    183,
    184,
    185,
    186,
    188,
    189,
    190,
    191,
    192,
    193,
    195,
    196,
    197,
    198,
    203,
    204,
    205,
    206,
    208,
    210,
    211,
    212,
    214,
    216,
    217,
    219,
    221,
    222,
    223,
    226,
    228,
    230,
    231,
    232,
    233,
    236,
    237,
    238,
    239,
    240,
    242,
    243,
    244,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    256,
    258,
    261,
    262,
    263,
    264,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    275,
    276,
    277,
    278,
    279,
    280,
    281,
    282,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    299,
    300,
    301,
    302,
    304,
    305,
    306,
    308,
    311,
    312,
    314,
    315,
    318,
    319,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    329,
    331,
    333,
    335,
    336,
    337,
    338,
    339,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    369,
    371,
    372,
    373,
    374,
    375,
    376,
    378,
    380,
    382,
    383,
    384,
    385,
    386,
    389,
    390,
    391,
    392,
    393,
    395,
    396,
    397,
    399,
    0,
    3,
    4,
    5,
    7,
    8,
    9,
    10,
    11,
    13,
    14,
    15,
    16,
    18,
    19,
    20,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    32,
    35,
    36,
    39,
    41,
    42,
    45,
    47,
    48,
    50,
    51,
    54,
    55,
    56,
    60,
    61,
    62,
    63,
    65,
    66,
    67,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    80,
    81,
    82,
    83,
    85,
    87,
    88,
    89,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    103,
    105,
    106,
    107,
    108,
    110,
    111,
    112,
    113,
    114,
    115,
    120,
    122,
    123,
    124,
    125,
    126,
    128,
    130,
    133,
    134,
    135,
    139,
    140,
    141,
    143,
    146,
    147,
    148,
    149,
    151,
    152,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    167,
    168,
    169,
    170,
    171,
    172,
    174,
    175,
    176,
    182,
    184,
    186,
    188,
    192,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    204,
    206,
    207,
    208,
    209,
    210,
    213,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    230,
    232,
    235,
    236,
    238,
    240,
    242,
    245,
    246,
    248,
    250,
    253,
    254,
    255,
    256,
    257,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    267,
    268,
    269,
    270,
    271,
    272,
    275,
    276,
    277,
    278,
    279,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    292,
    293,
    296,
    297,
    298,
    299,
    300,
    302,
    303,
    304,
    305,
    307,
    309,
    311,
    312,
    313,
    314,
    316,
    317,
    318,
    320,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    332,
    334,
    335,
    336,
    337,
    339,
    340,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    354,
    355,
    356,
    357,
    358,
    361,
    362,
    364,
    365,
    366,
    367,
    369,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    381,
    382,
    384,
    385,
    386,
    387,
    388,
    389,
    390,
    392,
    394,
    395,
    396,
    397,
    398,
    399,
    1,
    2,
    3,
    6,
    7,
    8,
    9,
    10,
    12,
    13,
    17,
    20,
    22,
    23,
    24,
    25,
    26,
    27,
    29,
    31,
    32,
    33,
    37,
    38,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    48,
    49,
    51,
    52,
    54,
    55,
    56,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    66,
    67,
    69,
    70,
    71,
    72,
    74,
    75,
    76,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    101,
    103,
    104,
    106,
    107,
    108,
    109,
    110,
    113,
    114,
    115,
    117,
    118,
    119,
    121,
    122,
    123,
    125,
    126,
    127,
    128,
    129,
    130,
    131,
    133,
    134,
    135,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    160,
    161,
    162,
    163,
    164,
    165,
    167,
    168,
    172,
    173,
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    185,
    186,
    187,
    189,
    190,
    191,
    192,
    193,
    194,
    196,
    198,
    199,
    200,
    201,
    206,
    207,
    208,
    209,
    210,
    213,
    214,
    217,
    218,
    220,
    221,
    222,
    223,
    226,
    228,
    229,
    230,
    233,
    234,
    237,
    239,
    240,
    241,
    242,
    244,
    245,
    246,
    249,
    250,
    251,
    252,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    262,
    263,
    266,
    267,
    268,
    269,
    271,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    292,
    293,
    294,
    296,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    308,
    309,
    310,
    312,
    313,
    315,
    316,
    317,
    318,
    319,
    320,
    321,
    323,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    339,
    340,
    341,
    342,
    343,
    345,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    357,
    358,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    375,
    377,
    379,
    380,
    382,
    383,
    385,
    388,
    389,
    391,
    392,
    393,
    394,
    396,
    397,
    399,
    0,
    1,
    3,
    4,
    5,
    6,
    8,
    9,
    11,
    12,
    13,
    14,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    24,
    25,
    26,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    47,
    48,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    58,
    59,
    60,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    70,
    72,
    73,
    74,
    75,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    87,
    88,
    91,
    93,
    94,
    96,
    98,
    99,
    100,
    102,
    103,
    104,
    105,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    115,
    116,
    117,
    118,
    119,
    120,
    123,
    124,
    125,
    126,
    128,
    130,
    131,
    132,
    133,
    134,
    135,
    136,
    138,
    139,
    140,
    141,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    165,
    166,
    167,
    168,
    170,
    173,
    174,
    176,
    177,
    179,
    180,
    181,
    183,
    185,
    186,
    187,
    189,
    190,
    194,
    196,
    198,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    212,
    213,
    214,
    215,
    216,
    217,
    218,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    238,
    239,
    240,
    241,
    242,
    243,
    245,
    246,
    247,
    248,
    249,
    250,
    252,
    254,
    255,
    256,
    258,
    259,
    260,
    262,
    263,
    264,
    266,
    267,
    268,
    269,
    270,
    273,
    274,
    275,
    276,
    277,
    279,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    294,
    295,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    308,
    310,
    311,
    312,
    313,
    314,
    316,
    317,
    318,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    328,
    330,
    333,
    334,
    335,
    337,
    338,
    339,
    340,
    342,
    344,
    345,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    357,
    358,
    359,
    360,
    361,
    364,
    366,
    367,
    368,
    369,
    370,
    371,
    373,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    392,
    393,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    6,
    7,
    8,
    9,
    10,
    12,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    32,
    33,
    34,
    35,
    36,
    38,
    39,
    40,
    41,
    43,
    44,
    45,
    46,
    47,
    48,
    49,
    50,
    51,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    65,
    68,
    69,
    70,
    71,
    72,
    74,
    75,
    78,
    79,
    80,
    81,
    83,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    120,
    123,
    127,
    128,
    129,
    131,
    132,
    133,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    142,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    160,
    161,
    162,
    163,
    164,
    166,
    168,
    169,
    170,
    171,
    173,
    174,
    175,
    176,
    177,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    202,
    203,
    205,
    206,
    208,
    209,
    210,
    211,
    212,
    213,
    214,
    216,
    217,
    218,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    238,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    254,
    255,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    270,
    273,
    274,
    275,
    277,
    279,
    280,
    281,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    308,
    309,
    311,
    312,
    313,
    315,
    318,
    319,
    321,
    322,
    323,
    324,
    326,
    327,
    328,
    330,
    332,
    333,
    335,
    337,
    338,
    339,
    341,
    342,
    343,
    345,
    346,
    347,
    348,
    349,
    351,
    352,
    353,
    354,
    356,
    357,
    358,
    361,
    363,
    364,
    365,
    366,
    368,
    369,
    370,
    371,
    373,
    374,
    376,
    377,
    378,
    379,
    380,
    383,
    386,
    387,
    388,
    389,
    391,
    393,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    20,
    21,
    22,
    24,
    26,
    27,
    28,
    29,
    31,
    32,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    48,
    49,
    50,
    51,
    52,
    54,
    55,
    56,
    57,
    58,
    59,
    61,
    63,
    64,
    65,
    66,
    67,
    69,
    70,
    72,
    74,
    75,
    77,
    79,
    80,
    81,
    83,
    85,
    86,
    87,
    89,
    90,
    92,
    94,
    96,
    97,
    100,
    101,
    102,
    103,
    104,
    106,
    107,
    108,
    109,
    110,
    112,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    122,
    123,
    124,
    125,
    126,
    128,
    129,
    130,
    131,
    134,
    136,
    137,
    138,
    139,
    140,
    143,
    144,
    145,
    146,
    147,
    149,
    150,
    151,
    153,
    154,
    158,
    159,
    160,
    161,
    162,
    164,
    165,
    166,
    167,
    168,
    170,
    171,
    172,
    173,
    174,
    177,
    178,
    180,
    181,
    182,
    183,
    184,
    185,
    187,
    190,
    191,
    192,
    193,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    203,
    204,
    206,
    207,
    208,
    210,
    211,
    213,
    214,
    215,
    216,
    217,
    218,
    220,
    222,
    223,
    225,
    226,
    228,
    229,
    230,
    232,
    233,
    234,
    235,
    236,
    237,
    238,
    239,
    241,
    242,
    244,
    246,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    266,
    267,
    269,
    270,
    271,
    273,
    274,
    276,
    277,
    278,
    279,
    280,
    281,
    282,
    283,
    284,
    285,
    286,
    288,
    290,
    292,
    293,
    295,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    309,
    310,
    317,
    318,
    319,
    320,
    321,
    323,
    324,
    325,
    326,
    328,
    329,
    330,
    331,
    334,
    335,
    337,
    338,
    340,
    341,
    342,
    345,
    346,
    347,
    348,
    349,
    350,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    360,
    361,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    371,
    372,
    374,
    375,
    376,
    378,
    379,
    380,
    381,
    384,
    386,
    388,
    389,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    10,
    11,
    12,
    13,
    17,
    18,
    20,
    21,
    22,
    23,
    24,
    25,
    27,
    28,
    30,
    31,
    32,
    33,
    34,
    36,
    38,
    39,
    40,
    41,
    42,
    45,
    46,
    47,
    48,
    49,
    50,
    51,
    52,
    53,
    55,
    56,
    57,
    59,
    60,
    61,
    62,
    63,
    65,
    66,
    67,
    68,
    69,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    88,
    89,
    90,
    91,
    93,
    94,
    98,
    99,
    100,
    102,
    105,
    106,
    107,
    108,
    109,
    110,
    112,
    114,
    116,
    117,
    118,
    120,
    123,
    125,
    126,
    127,
    129,
    130,
    131,
    132,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    144,
    145,
    146,
    147,
    148,
    150,
    151,
    152,
    153,
    155,
    157,
    158,
    159,
    160,
    161,
    163,
    165,
    167,
    168,
    169,
    172,
    174,
    176,
    179,
    182,
    183,
    184,
    185,
    187,
    188,
    190,
    191,
    192,
    193,
    196,
    198,
    199,
    200,
    201,
    202,
    205,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    216,
    217,
    218,
    219,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    230,
    231,
    233,
    236,
    238,
    240,
    241,
    242,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    257,
    259,
    261,
    264,
    265,
    266,
    267,
    268,
    269,
    271,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    280,
    281,
    282,
    284,
    286,
    288,
    289,
    292,
    293,
    295,
    296,
    297,
    298,
    301,
    302,
    304,
    306,
    307,
    308,
    310,
    311,
    312,
    314,
    316,
    317,
    319,
    320,
    321,
    323,
    324,
    327,
    328,
    331,
    333,
    334,
    335,
    336,
    337,
    339,
    340,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    349,
    353,
    354,
    356,
    358,
    359,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    369,
    370,
    371,
    372,
    375,
    376,
    377,
    378,
    380,
    381,
    382,
    383,
    386,
    387,
    389,
    390,
    391,
    392,
    393,
    396,
    398,
    399,
    0,
    2,
    3,
    4,
    5,
    7,
    9,
    12,
    15,
    17,
    18,
    19,
    21,
    22,
    24,
    25,
    26,
    27,
    28,
    30,
    31,
    32,
    35,
    36,
    38,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    47,
    48,
    50,
    51,
    52,
    53,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    65,
    67,
    68,
    70,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    81,
    82,
    83,
    84,
    86,
    87,
    88,
    89,
    91,
    93,
    94,
    96,
    97,
    98,
    100,
    101,
    102,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    113,
    114,
    116,
    117,
    123,
    124,
    125,
    126,
    127,
    128,
    130,
    132,
    133,
    134,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    148,
    149,
    151,
    152,
    153,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    175,
    176,
    178,
    180,
    181,
    182,
    183,
    185,
    186,
    187,
    188,
    191,
    192,
    193,
    194,
    196,
    198,
    199,
    200,
    201,
    203,
    204,
    205,
    206,
    207,
    208,
    210,
    211,
    212,
    213,
    214,
    215,
    217,
    221,
    222,
    223,
    224,
    228,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    239,
    240,
    241,
    242,
    243,
    244,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    256,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    280,
    281,
    282,
    283,
    284,
    286,
    287,
    289,
    290,
    292,
    293,
    294,
    295,
    297,
    299,
    301,
    303,
    305,
    307,
    308,
    310,
    311,
    313,
    314,
    317,
    318,
    319,
    320,
    322,
    324,
    325,
    327,
    329,
    330,
    331,
    332,
    333,
    336,
    341,
    342,
    344,
    345,
    346,
    347,
    348,
    349,
    351,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    371,
    372,
    373,
    374,
    377,
    378,
    379,
    385,
    386,
    387,
    388,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    399,
    0,
    2,
    3,
    4,
    6,
    11,
    13,
    14,
    15,
    18,
    19,
    20,
    22,
    24,
    25,
    26,
    28,
    29,
    30,
    31,
    33,
    35,
    36,
    37,
    38,
    41,
    42,
    44,
    45,
    46,
    47,
    48,
    49,
    50,
    51,
    52,
    53,
    54,
    57,
    58,
    59,
    60,
    61,
    63,
    64,
    65,
    66,
    69,
    70,
    71,
    73,
    76,
    78,
    80,
    81,
    82,
    83,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    95,
    97,
    99,
    102,
    103,
    104,
    105,
    107,
    108,
    109,
    110,
    112,
    113,
    114,
    116,
    117,
    120,
    121,
    122,
    123,
    124,
    125,
    126,
    127,
    130,
    133,
    134,
    135,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    145,
    147,
    148,
    149,
    150,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    184,
    185,
    189,
    190,
    194,
    195,
    196,
    197,
    198,
    199,
    201,
    202,
    204,
    206,
    209,
    210,
    212,
    214,
    216,
    217,
    219,
    221,
    222,
    223,
    225,
    226,
    227,
    228,
    230,
    231,
    232,
    233,
    235,
    236,
    239,
    240,
    241,
    244,
    245,
    246,
    247,
    251,
    253,
    254,
    256,
    257,
    258,
    259,
    260,
    261,
    262,
    265,
    266,
    267,
    268,
    269,
    271,
    272,
    273,
    275,
    276,
    278,
    279,
    281,
    283,
    284,
    287,
    290,
    291,
    292,
    293,
    294,
    298,
    299,
    301,
    302,
    304,
    305,
    306,
    307,
    308,
    309,
    310,
    313,
    314,
    317,
    318,
    320,
    321,
    322,
    323,
    324,
    327,
    329,
    330,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    340,
    341,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    370,
    372,
    373,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    386,
    388,
    389,
    391,
    393,
    394,
    396,
    397,
    398,
    399,
    0,
    2,
    5,
    6,
    7,
    8,
    11,
    14,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    26,
    27,
    28,
    29,
    30,
    32,
    33,
    34,
    35,
    38,
    39,
    40,
    41,
    42,
    44,
    45,
    46,
    47,
    49,
    50,
    51,
    52,
    53,
    54,
    55,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    69,
    70,
    71,
    72,
    74,
    75,
    76,
    79,
    80,
    81,
    83,
    86,
    87,
    88,
    90,
    92,
    94,
    95,
    96,
    97,
    98,
    99,
    101,
    105,
    107,
    108,
    109,
    112,
    113,
    114,
    115,
    116,
    117,
    120,
    121,
    122,
    123,
    124,
    125,
    127,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    135,
    138,
    140,
    142,
    144,
    146,
    147,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    160,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    171,
    173,
    174,
    175,
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    191,
    192,
    193,
    194,
    195,
    198,
    199,
    200,
    201,
    203,
    204,
    206,
    207,
    208,
    209,
    210,
    211,
    212,
    214,
    215,
    216,
    217,
    218,
    219,
    221,
    222,
    225,
    226,
    227,
    228,
    229,
    230,
    232,
    235,
    236,
    238,
    239,
    240,
    241,
    242,
    243,
    244,
    245,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    262,
    264,
    265,
    268,
    269,
    270,
    271,
    272,
    273,
    275,
    276,
    277,
    278,
    279,
    280,
    282,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    292,
    294,
    295,
    296,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    309,
    310,
    311,
    312,
    314,
    315,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    329,
    330,
    331,
    333,
    334,
    335,
    336,
    337,
    338,
    339,
    340,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    361,
    363,
    364,
    366,
    367,
    368,
    369,
    370,
    372,
    373,
    374,
    375,
    376,
    378,
    379,
    380,
    381,
    384,
    385,
    386,
    387,
    388,
    390,
    391,
    392,
    393,
    394,
    396,
    397,
    398,
    0,
    1,
    2,
    5,
    6,
    7,
    9,
    10,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    24,
    25,
    26,
    27,
    29,
    30,
    32,
    33,
    35,
    36,
    37,
    42,
    44,
    45,
    47,
    48,
    49,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    68,
    69,
    72,
    73,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    87,
    88,
    89,
    90,
    91,
    92,
    94,
    95,
    97,
    98,
    99,
    100,
    102,
    103,
    104,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    116,
    117,
    118,
    119,
    121,
    122,
    123,
    124,
    125,
    126,
    127,
    130,
    131,
    132,
    133,
    135,
    136,
    137,
    138,
    139,
    140,
    142,
    143,
    144,
    147,
    149,
    150,
    151,
    152,
    155,
    156,
    157,
    160,
    162,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    175,
    176,
    178,
    179,
    180,
    182,
    183,
    185,
    186,
    187,
    189,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    201,
    203,
    204,
    207,
    208,
    210,
    211,
    212,
    213,
    214,
    215,
    216,
    218,
    219,
    220,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    231,
    232,
    233,
    234,
    235,
    236,
    239,
    241,
    243,
    245,
    246,
    248,
    250,
    251,
    253,
    254,
    255,
    256,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    266,
    268,
    269,
    270,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    279,
    281,
    282,
    283,
    284,
    285,
    286,
    288,
    289,
    290,
    291,
    292,
    293,
    296,
    297,
    299,
    300,
    301,
    304,
    306,
    307,
    309,
    310,
    313,
    314,
    315,
    317,
    318,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    330,
    332,
    333,
    335,
    336,
    337,
    338,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    360,
    362,
    363,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    375,
    376,
    378,
    379,
    382,
    384,
    385,
    386,
    390,
    391,
    393,
    394,
    395,
    396,
    397,
    398,
    399,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    24,
    25,
    26,
    27,
    28,
    30,
    32,
    33,
    34,
    37,
    38,
    40,
    42,
    45,
    46,
    47,
    48,
    49,
    53,
    54,
    56,
    57,
    59,
    60,
    61,
    62,
    63,
    64,
    66,
    67,
    68,
    69,
    71,
    72,
    74,
    76,
    78,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    102,
    103,
    104,
    106,
    107,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    118,
    119,
    120,
    121,
    123,
    124,
    125,
    127,
    129,
    130,
    133,
    134,
    135,
    136,
    137,
    139,
    140,
    143,
    144,
    145,
    146,
    147,
    148,
    150,
    155,
    156,
    157,
    158,
    159,
    161,
    162,
    163,
    165,
    166,
    167,
    169,
    171,
    172,
    173,
    174,
    175,
    176,
    178,
    179,
    180,
    181,
    182,
    184,
    185,
    187,
    188,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    204,
    206,
    207,
    210,
    211,
    212,
    216,
    219,
    220,
    221,
    222,
    223,
    224,
    227,
    228,
    229,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    239,
    240,
    241,
    242,
    244,
    246,
    248,
    249,
    250,
    252,
    253,
    254,
    255,
    256,
    258,
    260,
    261,
    262,
    263,
    265,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    274,
    276,
    277,
    278,
    279,
    280,
    281,
    282,
    283,
    284,
    286,
    288,
    289,
    290,
    291,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    309,
    310,
    311,
    312,
    314,
    315,
    316,
    317,
    319,
    320,
    321,
    322,
    323,
    324,
    326,
    329,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    339,
    341,
    342,
    343,
    344,
    345,
    347,
    349,
    350,
    351,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    364,
    368,
    369,
    370,
    371,
    373,
    374,
    375,
    377,
    378,
    379,
    380,
    382,
    384,
    385,
    386,
    387,
    388,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    397,
    399,
    1,
    3,
    4,
    5,
    6,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    19,
    20,
    21,
    24,
    25,
    26,
    27,
    28,
    29,
    32,
    33,
    35,
    36,
    37,
    38,
    39,
    41,
    42,
    43,
    44,
    45,
    46,
    47,
    50,
    53,
    54,
    55,
    56,
    57,
    58,
    60,
    62,
    65,
    66,
    67,
    68,
    69,
    71,
    72,
    73,
    74,
    75,
    76,
    79,
    80,
    81,
    82,
    83,
    85,
    89,
    90,
    93,
    94,
    95,
    96,
    97,
    99,
    101,
    103,
    104,
    105,
    109,
    110,
    112,
    113,
    114,
    115,
    116,
    117,
    120,
    122,
    123,
    124,
    125,
    126,
    127,
    128,
    132,
    135,
    136,
    137,
    138,
    139,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    149,
    151,
    152,
    153,
    156,
    160,
    162,
    163,
    164,
    165,
    167,
    168,
    169,
    171,
    172,
    173,
    174,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    192,
    193,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    203,
    204,
    205,
    206,
    207,
    208,
    210,
    211,
    213,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    223,
    225,
    227,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    237,
    238,
    240,
    241,
    242,
    243,
    244,
    246,
    249,
    250,
    251,
    252,
    254,
    255,
    256,
    257,
    259,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    270,
    271,
    273,
    274,
    275,
    276,
    278,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    293,
    294,
    295,
    296,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    308,
    309,
    310,
    311,
    313,
    314,
    316,
    317,
    319,
    321,
    322,
    326,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    337,
    338,
    340,
    342,
    343,
    344,
    345,
    347,
    348,
    350,
    351,
    352,
    353,
    354,
    355,
    357,
    358,
    359,
    360,
    361,
    364,
    366,
    367,
    368,
    369,
    371,
    373,
    375,
    376,
    377,
    379,
    380,
    381,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    390,
    391,
    393,
    395,
    397,
    399,
    0,
    1,
    2,
    3,
    4,
    5,
    6,
    7,
    8,
    11,
    13,
    14,
    15,
    16,
    18,
    19,
    21,
    22,
    23,
    24,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    34,
    35,
    36,
    38,
    39,
    40,
    41,
    44,
    45,
    46,
    47,
    48,
    49,
    50,
    51,
    52,
    53,
    59,
    63,
    64,
    65,
    66,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    84,
    85,
    88,
    89,
    90,
    92,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    105,
    106,
    107,
    108,
    110,
    111,
    112,
    116,
    117,
    120,
    122,
    123,
    124,
    126,
    127,
    128,
    129,
    130,
    134,
    136,
    137,
    140,
    141,
    142,
    143,
    144,
    146,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    157,
    158,
    159,
    160,
    161,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    172,
    173,
    174,
    178,
    179,
    180,
    181,
    182,
    183,
    185,
    186,
    188,
    189,
    190,
    191,
    192,
    193,
    194,
    195,
    198,
    201,
    202,
    203,
    204,
    205,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    214,
    215,
    217,
    218,
    219,
    221,
    222,
    223,
    224,
    225,
    226,
    228,
    229,
    232,
    238,
    239,
    240,
    241,
    242,
    243,
    245,
    247,
    248,
    249,
    253,
    254,
    255,
    257,
    258,
    259,
    262,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    270,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    279,
    280,
    281,
    283,
    284,
    285,
    286,
    289,
    290,
    292,
    293,
    295,
    296,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    307,
    308,
    310,
    311,
    312,
    313,
    314,
    315,
    319,
    321,
    322,
    327,
    328,
    331,
    332,
    333,
    335,
    336,
    337,
    338,
    340,
    341,
    342,
    343,
    344,
    346,
    347,
    349,
    350,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    361,
    362,
    363,
    364,
    365,
    366,
    368,
    370,
    371,
    372,
    373,
    374,
    376,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    390,
    391,
    392,
    393,
    394,
    398,
    399,
    0,
    1,
    2,
    3,
    5,
    6,
    8,
    9,
    10,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    24,
    26,
    27,
    28,
    29,
    30,
    33,
    34,
    35,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    48,
    49,
    50,
    51,
    54,
    57,
    59,
    63,
    64,
    65,
    66,
    67,
    69,
    70,
    71,
    74,
    75,
    76,
    77,
    79,
    81,
    82,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    105,
    106,
    107,
    108,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    122,
    123,
    125,
    126,
    127,
    128,
    129,
    130,
    131,
    132,
    133,
    134,
    136,
    138,
    139,
    140,
    143,
    144,
    145,
    147,
    148,
    149,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    173,
    174,
    175,
    179,
    180,
    181,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    194,
    197,
    198,
    199,
    200,
    201,
    202,
    203,
    205,
    206,
    208,
    209,
    210,
    211,
    212,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    230,
    233,
    234,
    235,
    236,
    238,
    239,
    241,
    242,
    247,
    248,
    250,
    252,
    253,
    255,
    256,
    257,
    259,
    260,
    261,
    262,
    263,
    265,
    266,
    267,
    268,
    269,
    270,
    271,
    273,
    274,
    279,
    280,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    291,
    292,
    293,
    294,
    295,
    296,
    299,
    300,
    302,
    303,
    304,
    305,
    306,
    308,
    309,
    310,
    312,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    320,
    322,
    324,
    326,
    327,
    328,
    330,
    331,
    333,
    334,
    335,
    336,
    337,
    339,
    340,
    341,
    342,
    343,
    344,
    345,
    346,
    347,
    348,
    352,
    354,
    355,
    356,
    358,
    359,
    360,
    361,
    363,
    364,
    366,
    367,
    368,
    370,
    374,
    376,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    390,
    392,
    393,
    394,
    395,
    396,
    397,
    399,
    2,
    3,
    5,
    6,
    7,
    8,
    11,
    13,
    14,
    15,
    16,
    17,
    18,
    19,
    20,
    21,
    23,
    24,
    25,
    27,
    29,
    30,
    31,
    32,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    47,
    49,
    51,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    66,
    67,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    92,
    93,
    95,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    122,
    123,
    124,
    125,
    126,
    127,
    129,
    132,
    133,
    134,
    136,
    137,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    150,
    151,
    152,
    153,
    155,
    157,
    158,
    160,
    162,
    163,
    164,
    165,
    166,
    167,
    168,
    169,
    170,
    171,
    172,
    174,
    175,
    176,
    177,
    179,
    182,
    184,
    185,
    188,
    191,
    192,
    194,
    196,
    197,
    198,
    199,
    200,
    201,
    203,
    204,
    205,
    206,
    207,
    208,
    210,
    211,
    213,
    215,
    216,
    218,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    229,
    230,
    235,
    236,
    238,
    239,
    240,
    241,
    243,
    245,
    246,
    247,
    248,
    249,
    250,
    253,
    254,
    255,
    256,
    257,
    258,
    262,
    263,
    264,
    265,
    266,
    267,
    269,
    271,
    273,
    274,
    275,
    276,
    277,
    278,
    279,
    281,
    282,
    283,
    284,
    285,
    286,
    287,
    289,
    290,
    291,
    294,
    296,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    306,
    308,
    309,
    311,
    314,
    315,
    317,
    318,
    319,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    329,
    330,
    331,
    334,
    335,
    336,
    337,
    338,
    339,
    340,
    341,
    342,
    344,
    346,
    347,
    348,
    349,
    351,
    352,
    354,
    355,
    357,
    358,
    359,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    383,
    384,
    387,
    388,
    389,
    390,
    391,
    392,
    393,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    4,
    5,
    7,
    8,
    10,
    11,
    12,
    13,
    14,
    16,
    18,
    20,
    21,
    22,
    25,
    26,
    29,
    31,
    32,
    33,
    34,
    36,
    37,
    38,
    41,
    43,
    44,
    45,
    46,
    47,
    48,
    50,
    53,
    54,
    55,
    57,
    59,
    61,
    62,
    63,
    64,
    66,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    76,
    77,
    79,
    80,
    81,
    82,
    83,
    84,
    86,
    87,
    89,
    90,
    91,
    92,
    95,
    96,
    97,
    99,
    101,
    103,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    112,
    115,
    116,
    117,
    118,
    120,
    122,
    123,
    124,
    125,
    126,
    127,
    129,
    130,
    131,
    132,
    133,
    134,
    136,
    137,
    139,
    140,
    142,
    143,
    144,
    146,
    147,
    148,
    150,
    151,
    152,
    153,
    154,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    166,
    169,
    172,
    173,
    175,
    176,
    178,
    179,
    180,
    181,
    183,
    184,
    186,
    187,
    189,
    190,
    191,
    192,
    193,
    195,
    196,
    197,
    198,
    200,
    201,
    202,
    203,
    204,
    206,
    208,
    211,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    224,
    226,
    227,
    228,
    231,
    234,
    235,
    236,
    237,
    238,
    239,
    242,
    243,
    244,
    245,
    247,
    248,
    249,
    251,
    252,
    253,
    254,
    255,
    256,
    258,
    259,
    261,
    262,
    263,
    265,
    266,
    268,
    269,
    270,
    273,
    275,
    276,
    277,
    278,
    279,
    281,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    290,
    291,
    293,
    294,
    295,
    296,
    297,
    298,
    300,
    301,
    302,
    303,
    305,
    307,
    309,
    311,
    312,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    320,
    321,
    323,
    324,
    325,
    326,
    327,
    328,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    340,
    341,
    343,
    344,
    345,
    346,
    347,
    348,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    368,
    370,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    383,
    384,
    386,
    387,
    388,
    390,
    392,
    393,
    394,
    395,
    396,
    397,
    399,
    0,
    1,
    2,
    3,
    4,
    6,
    8,
    9,
    11,
    12,
    13,
    14,
    15,
    16,
    17,
    19,
    20,
    21,
    22,
    23,
    24,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    34,
    35,
    36,
    38,
    39,
    40,
    41,
    42,
    44,
    47,
    49,
    50,
    51,
    54,
    55,
    56,
    57,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    67,
    68,
    70,
    71,
    74,
    75,
    76,
    77,
    78,
    79,
    83,
    84,
    86,
    87,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    117,
    118,
    119,
    120,
    121,
    122,
    123,
    124,
    125,
    126,
    128,
    129,
    131,
    132,
    133,
    136,
    137,
    138,
    139,
    141,
    142,
    143,
    146,
    147,
    148,
    149,
    150,
    151,
    153,
    154,
    155,
    158,
    159,
    163,
    164,
    165,
    167,
    168,
    172,
    173,
    174,
    177,
    179,
    180,
    181,
    182,
    183,
    184,
    185,
    187,
    188,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    198,
    200,
    201,
    204,
    205,
    206,
    207,
    211,
    212,
    213,
    214,
    216,
    217,
    219,
    220,
    223,
    225,
    226,
    227,
    228,
    232,
    234,
    235,
    236,
    237,
    239,
    242,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    257,
    258,
    260,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    274,
    276,
    277,
    278,
    280,
    282,
    283,
    284,
    285,
    286,
    287,
    288,
    289,
    292,
    293,
    295,
    297,
    298,
    299,
    300,
    301,
    302,
    303,
    304,
    305,
    307,
    309,
    314,
    315,
    316,
    318,
    319,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    340,
    342,
    343,
    344,
    346,
    347,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    363,
    364,
    366,
    369,
    370,
    371,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    384,
    385,
    386,
    387,
    388,
    390,
    392,
    393,
    394,
    395,
    396,
    397,
    399,
    0,
    1,
    2,
    4,
    5,
    6,
    7,
    8,
    10,
    11,
    12,
    14,
    16,
    17,
    18,
    19,
    20,
    21,
    22,
    24,
    25,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    46,
    48,
    49,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    64,
    65,
    66,
    67,
    68,
    70,
    71,
    72,
    73,
    75,
    76,
    77,
    78,
    79,
    82,
    83,
    85,
    87,
    90,
    93,
    94,
    96,
    98,
    99,
    100,
    104,
    105,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    118,
    120,
    121,
    124,
    126,
    129,
    130,
    131,
    133,
    134,
    136,
    137,
    138,
    139,
    140,
    141,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    152,
    154,
    155,
    156,
    158,
    159,
    160,
    161,
    162,
    164,
    166,
    167,
    168,
    169,
    170,
    171,
    173,
    174,
    176,
    177,
    178,
    179,
    180,
    181,
    182,
    183,
    185,
    186,
    187,
    189,
    191,
    193,
    194,
    195,
    196,
    197,
    199,
    201,
    202,
    203,
    204,
    205,
    208,
    209,
    210,
    211,
    212,
    214,
    215,
    216,
    218,
    219,
    220,
    221,
    222,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    236,
    239,
    240,
    241,
    242,
    244,
    245,
    247,
    248,
    249,
    251,
    253,
    254,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    271,
    272,
    273,
    275,
    276,
    277,
    278,
    280,
    281,
    282,
    283,
    284,
    285,
    288,
    290,
    291,
    292,
    293,
    294,
    295,
    297,
    300,
    301,
    302,
    303,
    304,
    306,
    307,
    308,
    310,
    311,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    320,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    334,
    335,
    337,
    338,
    339,
    341,
    342,
    344,
    345,
    347,
    348,
    349,
    350,
    351,
    352,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    369,
    370,
    371,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    385,
    386,
    387,
    388,
    390,
    391,
    392,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    4,
    5,
    7,
    11,
    12,
    13,
    14,
    15,
    16,
    18,
    19,
    21,
    22,
    23,
    25,
    26,
    27,
    28,
    29,
    30,
    31,
    32,
    33,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    42,
    43,
    44,
    45,
    46,
    47,
    48,
    50,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    70,
    72,
    73,
    74,
    75,
    76,
    77,
    79,
    80,
    81,
    82,
    84,
    85,
    86,
    87,
    88,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    106,
    107,
    108,
    109,
    113,
    115,
    116,
    118,
    119,
    121,
    122,
    123,
    124,
    126,
    127,
    128,
    129,
    131,
    132,
    133,
    134,
    135,
    136,
    137,
    138,
    141,
    142,
    146,
    147,
    148,
    149,
    150,
    151,
    153,
    154,
    155,
    156,
    158,
    159,
    160,
    161,
    163,
    164,
    165,
    166,
    168,
    169,
    171,
    172,
    176,
    177,
    180,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    191,
    192,
    193,
    196,
    198,
    199,
    202,
    203,
    204,
    205,
    206,
    207,
    209,
    211,
    212,
    213,
    214,
    215,
    216,
    217,
    219,
    220,
    222,
    223,
    225,
    226,
    228,
    229,
    230,
    231,
    232,
    233,
    234,
    235,
    237,
    238,
    240,
    241,
    242,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    254,
    255,
    256,
    257,
    258,
    259,
    261,
    263,
    264,
    265,
    266,
    268,
    269,
    270,
    275,
    276,
    277,
    278,
    279,
    280,
    281,
    282,
    283,
    284,
    286,
    287,
    289,
    290,
    292,
    293,
    294,
    295,
    296,
    297,
    298,
    300,
    301,
    304,
    305,
    306,
    307,
    308,
    309,
    311,
    314,
    315,
    317,
    318,
    320,
    322,
    323,
    324,
    327,
    329,
    330,
    331,
    332,
    335,
    336,
    340,
    341,
    342,
    344,
    345,
    346,
    347,
    348,
    349,
    350,
    351,
    353,
    354,
    355,
    358,
    359,
    361,
    362,
    364,
    368,
    369,
    370,
    371,
    372,
    373,
    374,
    375,
    376,
    377,
    378,
    379,
    381,
    383,
    385,
    387,
    388,
    390,
    391,
    392,
    395,
    396,
    398,
    399,
    0,
    1,
    2,
    5,
    6,
    7,
    9,
    10,
    13,
    15,
    16,
    18,
    19,
    20,
    21,
    22,
    23,
    25,
    26,
    27,
    28,
    29,
    30,
    33,
    34,
    35,
    36,
    37,
    38,
    39,
    40,
    41,
    43,
    45,
    47,
    49,
    50,
    51,
    52,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    67,
    69,
    70,
    71,
    72,
    73,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    98,
    99,
    100,
    101,
    102,
    106,
    107,
    109,
    110,
    111,
    113,
    115,
    117,
    119,
    120,
    121,
    122,
    123,
    124,
    125,
    126,
    127,
    128,
    129,
    130,
    132,
    133,
    134,
    136,
    137,
    139,
    140,
    141,
    142,
    143,
    144,
    145,
    146,
    147,
    148,
    149,
    150,
    151,
    155,
    156,
    157,
    158,
    159,
    162,
    163,
    164,
    166,
    167,
    169,
    170,
    171,
    172,
    175,
    177,
    178,
    180,
    181,
    182,
    183,
    184,
    185,
    186,
    187,
    189,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    201,
    203,
    204,
    205,
    206,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    215,
    216,
    217,
    218,
    219,
    220,
    224,
    225,
    226,
    227,
    228,
    229,
    230,
    231,
    232,
    235,
    236,
    237,
    238,
    239,
    240,
    241,
    242,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    252,
    253,
    254,
    255,
    257,
    258,
    259,
    260,
    261,
    262,
    263,
    264,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    274,
    275,
    276,
    277,
    278,
    279,
    280,
    281,
    284,
    285,
    286,
    287,
    288,
    292,
    294,
    296,
    297,
    298,
    299,
    301,
    303,
    304,
    306,
    307,
    308,
    309,
    311,
    312,
    313,
    314,
    317,
    318,
    319,
    321,
    322,
    323,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    333,
    335,
    337,
    338,
    339,
    341,
    342,
    344,
    345,
    347,
    348,
    349,
    350,
    351,
    353,
    354,
    355,
    356,
    357,
    359,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    368,
    369,
    370,
    371,
    372,
    374,
    377,
    378,
    379,
    380,
    382,
    383,
    384,
    385,
    387,
    388,
    389,
    390,
    392,
    394,
    395,
    396,
    397,
    398,
    399,
    0,
    2,
    4,
    5,
    6,
    7,
    8,
    9,
    10,
    11,
    12,
    13,
    15,
    16,
    17,
    18,
    19,
    20,
    22,
    24,
    25,
    26,
    27,
    28,
    29,
    32,
    34,
    35,
    36,
    39,
    40,
    41,
    42,
    44,
    46,
    47,
    49,
    50,
    51,
    52,
    53,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    64,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    77,
    78,
    79,
    80,
    81,
    82,
    84,
    85,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    102,
    103,
    105,
    106,
    107,
    108,
    109,
    110,
    111,
    112,
    113,
    114,
    115,
    116,
    117,
    118,
    119,
    120,
    122,
    123,
    124,
    125,
    126,
    127,
    128,
    130,
    131,
    132,
    133,
    136,
    137,
    139,
    140,
    141,
    143,
    144,
    145,
    146,
    147,
    148,
    152,
    153,
    155,
    156,
    157,
    158,
    160,
    161,
    162,
    163,
    164,
    165,
    167,
    168,
    169,
    170,
    172,
    173,
    174,
    175,
    178,
    181,
    183,
    184,
    185,
    187,
    189,
    191,
    192,
    193,
    194,
    195,
    198,
    199,
    200,
    203,
    204,
    207,
    209,
    210,
    211,
    212,
    213,
    214,
    216,
    218,
    219,
    220,
    221,
    222,
    223,
    224,
    225,
    226,
    227,
    228,
    229,
    232,
    233,
    234,
    235,
    238,
    239,
    240,
    241,
    242,
    243,
    244,
    246,
    247,
    249,
    250,
    253,
    256,
    259,
    260,
    261,
    264,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    274,
    276,
    277,
    278,
    280,
    281,
    282,
    284,
    285,
    286,
    288,
    289,
    291,
    292,
    293,
    294,
    295,
    296,
    298,
    300,
    301,
    302,
    304,
    306,
    307,
    308,
    309,
    310,
    312,
    313,
    316,
    317,
    318,
    319,
    320,
    321,
    324,
    325,
    326,
    327,
    328,
    329,
    331,
    332,
    333,
    334,
    335,
    336,
    337,
    338,
    341,
    342,
    343,
    345,
    346,
    348,
    349,
    350,
    351,
    353,
    354,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    368,
    369,
    370,
    372,
    374,
    375,
    376,
    377,
    378,
    379,
    380,
    381,
    382,
    383,
    384,
    385,
    386,
    387,
    388,
    389,
    390,
    391,
    392,
    393,
    394,
    395,
    398,
    0,
    1,
    3,
    5,
    6,
    7,
    8,
    10,
    11,
    12,
    13,
    14,
    15,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    24,
    25,
    29,
    30,
    32,
    33,
    34,
    36,
    37,
    38,
    40,
    41,
    42,
    43,
    45,
    47,
    48,
    49,
    51,
    52,
    53,
    54,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    64,
    65,
    66,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    85,
    86,
    87,
    88,
    89,
    90,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    99,
    100,
    101,
    104,
    105,
    106,
    107,
    108,
    109,
    110,
    112,
    113,
    114,
    115,
    116,
    118,
    119,
    120,
    121,
    122,
    123,
    125,
    126,
    127,
    129,
    130,
    131,
    132,
    133,
    135,
    136,
    137,
    138,
    140,
    142,
    143,
    145,
    146,
    148,
    149,
    151,
    152,
    154,
    155,
    156,
    157,
    160,
    161,
    162,
    163,
    164,
    165,
    166,
    167,
    169,
    170,
    171,
    173,
    174,
    175,
    176,
    177,
    178,
    179,
    181,
    182,
    184,
    185,
    186,
    187,
    188,
    190,
    191,
    192,
    193,
    194,
    196,
    197,
    199,
    202,
    203,
    204,
    205,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    215,
    216,
    217,
    218,
    219,
    221,
    222,
    223,
    224,
    225,
    227,
    228,
    230,
    231,
    233,
    234,
    236,
    239,
    241,
    242,
    245,
    246,
    247,
    249,
    250,
    252,
    254,
    259,
    260,
    261,
    262,
    263,
    264,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    274,
    275,
    276,
    277,
    279,
    280,
    281,
    282,
    283,
    285,
    286,
    288,
    289,
    291,
    292,
    293,
    294,
    295,
    297,
    298,
    300,
    302,
    303,
    309,
    310,
    311,
    313,
    314,
    315,
    316,
    317,
    318,
    319,
    320,
    324,
    326,
    328,
    329,
    330,
    332,
    333,
    335,
    336,
    337,
    339,
    340,
    342,
    343,
    344,
    345,
    346,
    348,
    349,
    350,
    351,
    353,
    354,
    355,
    356,
    357,
    358,
    359,
    360,
    361,
    362,
    364,
    365,
    368,
    369,
    370,
    371,
    372,
    375,
    376,
    377,
    378,
    379,
    380,
    382,
    386,
    387,
    388,
    389,
    390,
    391,
    392,
    393,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    6,
    7,
    8,
    9,
    10,
    11,
    13,
    14,
    15,
    16,
    18,
    19,
    22,
    23,
    24,
    25,
    26,
    27,
    31,
    32,
    33,
    35,
    36,
    37,
    38,
    39,
    40,
    42,
    43,
    44,
    46,
    47,
    48,
    49,
    51,
    52,
    53,
    54,
    55,
    56,
    57,
    58,
    59,
    61,
    62,
    64,
    65,
    66,
    68,
    69,
    70,
    71,
    72,
    74,
    75,
    76,
    77,
    78,
    79,
    80,
    81,
    82,
    83,
    84,
    88,
    89,
    91,
    92,
    93,
    95,
    96,
    97,
    98,
    99,
    100,
    101,
    102,
    103,
    104,
    105,
    106,
    108,
    109,
    110,
    111,
    112,
    114,
    116,
    117,
    118,
    120,
    121,
    122,
    123,
    124,
    125,
    128,
    131,
    132,
    133,
    135,
    136,
    139,
    140,
    141,
    142,
    145,
    146,
    147,
    151,
    153,
    155,
    156,
    157,
    158,
    159,
    160,
    161,
    162,
    166,
    167,
    168,
    170,
    172,
    173,
    174,
    175,
    176,
    177,
    178,
    180,
    181,
    182,
    183,
    184,
    186,
    187,
    188,
    190,
    191,
    192,
    193,
    194,
    196,
    197,
    198,
    199,
    201,
    202,
    203,
    208,
    209,
    210,
    211,
    212,
    213,
    214,
    216,
    217,
    219,
    221,
    224,
    226,
    227,
    228,
    229,
    232,
    233,
    234,
    235,
    236,
    237,
    239,
    241,
    242,
    243,
    244,
    246,
    247,
    248,
    249,
    250,
    251,
    252,
    253,
    254,
    256,
    257,
    258,
    259,
    261,
    262,
    263,
    264,
    265,
    266,
    267,
    268,
    269,
    270,
    271,
    272,
    273,
    274,
    276,
    277,
    278,
    279,
    280,
    281,
    283,
    284,
    285,
    286,
    289,
    291,
    294,
    297,
    298,
    299,
    300,
    302,
    303,
    304,
    307,
    308,
    310,
    311,
    312,
    313,
    314,
    316,
    318,
    319,
    320,
    321,
    322,
    323,
    324,
    326,
    329,
    332,
    334,
    335,
    336,
    338,
    339,
    340,
    341,
    343,
    344,
    345,
    346,
    347,
    348,
    352,
    354,
    356,
    358,
    359,
    361,
    362,
    363,
    366,
    368,
    369,
    370,
    371,
    375,
    376,
    378,
    379,
    381,
    382,
    383,
    384,
    386,
    388,
    390,
    391,
    392,
    393,
    395,
    396,
    397,
    398,
    399,
    0,
    1,
    2,
    3,
    4,
    6,
    7,
    8,
    10,
    11,
    12,
    13,
    15,
    16,
    17,
    18,
    21,
    22,
    23,
    24,
    25,
    27,
    28,
    30,
    32,
    33,
    34,
    35,
    37,
    38,
    39,
    41,
    43,
    45,
    46,
    48,
    49,
    50,
    52,
    54,
    55,
    56,
    57,
    58,
    59,
    60,
    61,
    62,
    63,
    64,
    65,
    66,
    67,
    68,
    69,
    70,
    71,
    72,
    73,
    74,
    75,
    77,
    78,
    80,
    82,
    84,
    86,
    87,
    88,
    89,
    90,
    92,
    93,
    94,
    95,
    98,
    100,
    101,
    102,
    103,
    105,
    106,
    107,
    108,
    109,
    110,
    112,
    113,
    114,
    116,
    117,
    118,
    119,
    120,
    121,
    122,
    123,
    124,
    126,
    127,
    129,
    131,
    134,
    136,
    137,
    139,
    141,
    143,
    144,
    145,
    146,
    147,
    148,
    150,
    151,
    152,
    154,
    155,
    157,
    158,
    159,
    160,
    161,
    162,
    163,
    164,
    165,
    167,
    169,
    170,
    171,
    173,
    175,
    176,
    177,
    179,
    180,
    181,
    182,
    184,
    187,
    189,
    190,
    191,
    192,
    193,
    194,
    195,
    196,
    197,
    198,
    199,
    200,
    201,
    202,
    203,
    204,
    207,
    208,
    209,
    210,
    211,
    212,
    213,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    225,
    226,
    228,
    229,
    230,
    231,
    234,
    235,
    237,
    238,
    239,
    240,
    241,
    243,
    244,
    245,
    246,
    247,
    248,
    249,
    250,
    251,
    253,
    254,
    255,
    256,
    257,
    259,
    260,
    261,
    262,
    266,
    267,
    268,
    270,
    271,
    272,
    273,
    274,
    275,
    277,
    281,
    282,
    283,
    285,
    287,
    289,
    290,
    291,
    294,
    295,
    296,
    297,
    298,
    299,
    300,
    302,
    304,
    305,
    306,
    307,
    308,
    310,
    311,
    313,
    314,
    316,
    317,
    319,
    321,
    322,
    324,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    336,
    339,
    340,
    341,
    342,
    344,
    345,
    347,
    348,
    349,
    350,
    352,
    353,
    354,
    356,
    357,
    359,
    360,
    361,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    373,
    375,
    376,
    377,
    378,
    383,
    385,
    386,
    388,
    390,
    391,
    392,
    393,
    394,
    395,
    397,
    398,
    399,
    1,
    2,
    3,
    4,
    7,
    8,
    9,
    10,
    11,
    13,
    14,
    15,
    17,
    18,
    19,
    20,
    21,
    22,
    23,
    25,
    26,
    27,
    30,
    31,
    32,
    33,
    34,
    35,
    37,
    38,
    39,
    40,
    41,
    42,
    44,
    45,
    46,
    47,
    49,
    52,
    54,
    55,
    56,
    57,
    58,
    60,
    62,
    64,
    65,
    66,
    68,
    69,
    71,
    72,
    75,
    76,
    77,
    78,
    80,
    81,
    82,
    84,
    85,
    86,
    87,
    89,
    91,
    92,
    93,
    94,
    95,
    96,
    97,
    98,
    101,
    102,
    103,
    104,
    106,
    108,
    109,
    111,
    114,
    115,
    117,
    118,
    119,
    120,
    121,
    123,
    124,
    126,
    127,
    128,
    129,
    132,
    133,
    134,
    136,
    137,
    138,
    139,
    140,
    141,
    142,
    144,
    145,
    147,
    148,
    149,
    151,
    152,
    155,
    157,
    159,
    160,
    161,
    162,
    163,
    165,
    167,
    169,
    171,
    172,
    174,
    175,
    177,
    178,
    179,
    180,
    181,
    183,
    184,
    185,
    186,
    187,
    188,
    189,
    190,
    192,
    194,
    196,
    197,
    198,
    199,
    202,
    203,
    204,
    205,
    206,
    208,
    209,
    212,
    214,
    215,
    216,
    217,
    218,
    219,
    220,
    221,
    222,
    224,
    226,
    227,
    228,
    229,
    230,
    231,
    233,
    234,
    235,
    237,
    238,
    239,
    240,
    242,
    244,
    245,
    246,
    248,
    250,
    251,
    252,
    253,
    254,
    255,
    256,
    257,
    259,
    260,
    261,
    262,
    263,
    264,
    265,
    266,
    269,
    270,
    271,
    272,
    273,
    275,
    276,
    279,
    281,
    282,
    284,
    286,
    287,
    288,
    289,
    290,
    291,
    292,
    294,
    295,
    298,
    304,
    306,
    308,
    309,
    310,
    311,
    312,
    313,
    314,
    316,
    317,
    318,
    319,
    323,
    325,
    326,
    327,
    328,
    329,
    330,
    331,
    332,
    333,
    334,
    335,
    337,
    338,
    340,
    341,
    343,
    344,
    345,
    348,
    349,
    350,
    351,
    352,
    353,
    354,
    356,
    360,
    361,
    362,
    363,
    364,
    365,
    366,
    367,
    368,
    369,
    370,
    371,
    372,
    374,
    375,
    376,
    378,
    379,
    380,
    381,
    383,
    385,
    386,
    387,
    388,
    389,
    390,
    392,
    393,
    394,
    395,
    396,
    397,
    398,
    399,
]).reshape((30012,))


QUESTION_IDS = np.array([
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    2,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    3,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    4,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    5,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    6,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    7,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    8,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    9,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    10,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    11,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    12,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    13,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    14,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    15,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    16,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    17,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    18,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    19,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    20,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    21,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    22,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    23,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    24,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    25,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    26,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    27,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    28,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    29,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    30,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    31,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    32,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    33,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    34,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    35,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    36,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    37,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    38,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    39,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    40,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    41,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    42,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    43,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    44,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    45,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    46,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    47,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    48,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    49,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    50,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    51,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    52,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    53,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    54,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    55,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    56,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    57,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    58,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    59,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    60,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    61,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    62,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    63,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    64,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    65,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    66,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    67,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    68,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    69,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    70,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    71,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    72,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    73,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    74,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    75,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    76,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    77,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    78,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    79,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    80,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    81,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    82,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    83,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    84,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    85,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    86,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    87,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    88,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    89,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    90,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    91,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    92,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    93,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    94,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    95,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    96,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    97,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    98,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
    99,
]).reshape((30012,))


CORRECT = np.array([
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    1,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    1,
    1,
    0,
    1,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    1,
    1,
    0,
    1,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    1,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    1,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    1,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
    0,
]).reshape((30012,))
