# crawl_domain

References:

*   [Code](https://github.com/huggingface/datasets/blob/master/datasets/crawl_domain)
*   [Huggingface](https://huggingface.co/datasets/crawl_domain)



Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:crawl_domain')
```

*   **Description**:

```
Corpus of domain names scraped from Common Crawl and manually annotated to add word boundaries (e.g. "commoncrawl" to "common crawl"). Breaking domain names such as "openresearch" into component words "open" and "research" is important for applications such as Text-to-Speech synthesis and web search. Common Crawl is an open repository of web crawl data that can be accessed and analyzed by anyone. Specifically, we scraped the plaintext (WET) extracts for domain names from URLs that contained diverse letter casing (e.g. "OpenBSD"). Although in the previous example, segmentation is trivial using letter casing, this was not always the case (e.g. "NASA"), so we had to manually annotate the data. The dataset is stored as plaintext file where each line is an example of space separated segments of a domain name. The examples are stored in their original letter casing, but harder and more interesting examples can be generated by lowercasing the input first.
```

*   **License**: MIT License
*   **Version**: 1.0.0
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 2170
`'train'` | 17572
`'validation'` | 1953

*   **Features**:

```json
{
    "example": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    }
}
```


