# cfq

References:

*   [Code](https://github.com/huggingface/datasets/blob/master/datasets/cfq)
*   [Huggingface](https://huggingface.co/datasets/cfq)


## mcd1


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:cfq/mcd1')
```

*   **Description**:

```
The CFQ dataset (and it's splits) for measuring compositional generalization.

See https://arxiv.org/abs/1912.09713.pdf for background.

Example usage:
data = datasets.load_dataset('cfq/mcd1')
```

*   **License**: No known license
*   **Version**: 1.0.1
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 11968
`'train'` | 95743

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "query": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    }
}
```



## mcd2


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:cfq/mcd2')
```

*   **Description**:

```
The CFQ dataset (and it's splits) for measuring compositional generalization.

See https://arxiv.org/abs/1912.09713.pdf for background.

Example usage:
data = datasets.load_dataset('cfq/mcd1')
```

*   **License**: No known license
*   **Version**: 1.0.1
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 11968
`'train'` | 95743

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "query": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    }
}
```



## mcd3


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:cfq/mcd3')
```

*   **Description**:

```
The CFQ dataset (and it's splits) for measuring compositional generalization.

See https://arxiv.org/abs/1912.09713.pdf for background.

Example usage:
data = datasets.load_dataset('cfq/mcd1')
```

*   **License**: No known license
*   **Version**: 1.0.1
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 11968
`'train'` | 95743

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "query": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    }
}
```



## question_complexity_split


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:cfq/question_complexity_split')
```

*   **Description**:

```
The CFQ dataset (and it's splits) for measuring compositional generalization.

See https://arxiv.org/abs/1912.09713.pdf for background.

Example usage:
data = datasets.load_dataset('cfq/mcd1')
```

*   **License**: No known license
*   **Version**: 1.0.1
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 10340
`'train'` | 98999

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "query": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    }
}
```



## question_pattern_split


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:cfq/question_pattern_split')
```

*   **Description**:

```
The CFQ dataset (and it's splits) for measuring compositional generalization.

See https://arxiv.org/abs/1912.09713.pdf for background.

Example usage:
data = datasets.load_dataset('cfq/mcd1')
```

*   **License**: No known license
*   **Version**: 1.0.1
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 11909
`'train'` | 95654

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "query": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    }
}
```



## query_complexity_split


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:cfq/query_complexity_split')
```

*   **Description**:

```
The CFQ dataset (and it's splits) for measuring compositional generalization.

See https://arxiv.org/abs/1912.09713.pdf for background.

Example usage:
data = datasets.load_dataset('cfq/mcd1')
```

*   **License**: No known license
*   **Version**: 1.0.1
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 9512
`'train'` | 100654

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "query": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    }
}
```



## query_pattern_split


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:cfq/query_pattern_split')
```

*   **Description**:

```
The CFQ dataset (and it's splits) for measuring compositional generalization.

See https://arxiv.org/abs/1912.09713.pdf for background.

Example usage:
data = datasets.load_dataset('cfq/mcd1')
```

*   **License**: No known license
*   **Version**: 1.0.1
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 12589
`'train'` | 94600

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "query": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    }
}
```



## random_split


Use the following command to load this dataset in TFDS:

```python
ds = tfds.load('huggingface:cfq/random_split')
```

*   **Description**:

```
The CFQ dataset (and it's splits) for measuring compositional generalization.

See https://arxiv.org/abs/1912.09713.pdf for background.

Example usage:
data = datasets.load_dataset('cfq/mcd1')
```

*   **License**: No known license
*   **Version**: 1.0.1
*   **Splits**:

Split  | Examples
:----- | -------:
`'test'` | 11967
`'train'` | 95744

*   **Features**:

```json
{
    "question": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    },
    "query": {
        "dtype": "string",
        "id": null,
        "_type": "Value"
    }
}
```


