<div itemscope itemtype="http://schema.org/Dataset">
  <div itemscope itemprop="includedInDataCatalog" itemtype="http://schema.org/DataCatalog">
    <meta itemprop="name" content="TensorFlow Datasets" />
  </div>
  <meta itemprop="name" content="i_naturalist2021" />
  <meta itemprop="description" content="The iNaturalist dataset 2021 contains a total of 10,000 species. &#10;The full training dataset contains nearly 2.7M images. &#10;To make the dataset more accessible we have also created a &quot;mini&quot; training &#10;dataset with 50 examples per species for a total of 500K images. The full &#10;training `train` split overlaps with the `mini` split. The val set contains for&#10;each species 10 validation images (100K in total). There are a total of 500,000 &#10;test images in the `public_test` split (without ground-truth labels).&#10;&#10;To use this dataset:&#10;&#10;```python&#10;import tensorflow_datasets as tfds&#10;&#10;ds = tfds.load(&#x27;i_naturalist2021&#x27;, split=&#x27;train&#x27;)&#10;for ex in ds.take(4):&#10;  print(ex)&#10;```&#10;&#10;See [the guide](https://www.tensorflow.org/datasets/overview) for more&#10;informations on [tensorflow_datasets](https://www.tensorflow.org/datasets).&#10;&#10;" />
  <meta itemprop="url" content="https://www.tensorflow.org/datasets/catalog/i_naturalist2021" />
  <meta itemprop="sameAs" content="https://github.com/visipedia/inat_comp/tree/master/2021" />
  <meta itemprop="citation" content="\&#10;@misc{inaturalist21,&#10;    Howpublished = {~\url{https://github.com/visipedia/inat_comp/tree/master/2021}},&#10;    Title = {{iNaturalist} 2021 competition dataset.},&#10;    Year = {2021},&#10;    key = {{iNaturalist} 2021 competition dataset},&#10;    }" />
</div>

# `i_naturalist2021`


*   **Description**:

The iNaturalist dataset 2021 contains a total of 10,000 species. The full
training dataset contains nearly 2.7M images. To make the dataset more
accessible we have also created a "mini" training dataset with 50 examples per
species for a total of 500K images. The full training `train` split overlaps
with the `mini` split. The val set contains for each species 10 validation
images (100K in total). There are a total of 500,000 test images in the
`public_test` split (without ground-truth labels).

*   **Homepage**:
    [https://github.com/visipedia/inat_comp/tree/master/2021](https://github.com/visipedia/inat_comp/tree/master/2021)

*   **Source code**:
    [`tfds.image_classification.i_naturalist2021.INaturalist2021`](https://github.com/tensorflow/datasets/tree/master/tensorflow_datasets/image_classification/i_naturalist2021/i_naturalist2021.py)

*   **Versions**:

    *   `1.0.0`: Initial release.
    *   **`2.0.0`** (default): Update: Class indices follow the order in the
        JSON train file.

*   **Download size**: `316.54 GiB`

*   **Dataset size**: `318.38 GiB`

*   **Auto-cached**
    ([documentation](https://www.tensorflow.org/datasets/performances#auto-caching)):
    No

*   **Splits**:

Split     | Examples
:-------- | --------:
`'mini'`  | 500,000
`'test'`  | 500,000
`'train'` | 2,686,843
`'val'`   | 100,000

*   **Feature structure**:

```python
FeaturesDict({
    'id': Text(shape=(), dtype=string),
    'image': Image(shape=(None, None, 3), dtype=uint8),
    'label': ClassLabel(shape=(), dtype=int64, num_classes=10000),
    'supercategory': ClassLabel(shape=(), dtype=int64, num_classes=11),
})
```

*   **Feature documentation**:

Feature       | Class        | Shape           | Dtype  | Description
:------------ | :----------- | :-------------- | :----- | :----------
              | FeaturesDict |                 |        |
id            | Text         |                 | string |
image         | Image        | (None, None, 3) | uint8  |
label         | ClassLabel   |                 | int64  |
supercategory | ClassLabel   |                 | int64  |

*   **Supervised keys** (See
    [`as_supervised` doc](https://www.tensorflow.org/datasets/api_docs/python/tfds/load#args)):
    `('image', 'label')`

*   **Figure**
    ([tfds.show_examples](https://www.tensorflow.org/datasets/api_docs/python/tfds/visualization/show_examples)):
    Not supported.

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):
    Missing.

*   **Citation**:

```
\
@misc{inaturalist21,
    Howpublished = {~\url{https://github.com/visipedia/inat_comp/tree/master/2021}},
    Title = {{iNaturalist} 2021 competition dataset.},
    Year = {2021},
    key = {{iNaturalist} 2021 competition dataset},
    }
```

