<div itemscope itemtype="http://schema.org/Dataset">
  <div itemscope itemprop="includedInDataCatalog" itemtype="http://schema.org/DataCatalog">
    <meta itemprop="name" content="TensorFlow Datasets" />
  </div>
  <meta itemprop="name" content="ucf101" />
  <meta itemprop="description" content="A 101-label video classification dataset.&#10;&#10;To use this dataset:&#10;&#10;```python&#10;import tensorflow_datasets as tfds&#10;&#10;ds = tfds.load(&#x27;ucf101&#x27;, split=&#x27;train&#x27;)&#10;for ex in ds.take(4):&#10;  print(ex)&#10;```&#10;&#10;See [the guide](https://www.tensorflow.org/datasets/overview) for more&#10;informations on [tensorflow_datasets](https://www.tensorflow.org/datasets).&#10;&#10;" />
  <meta itemprop="url" content="https://www.tensorflow.org/datasets/catalog/ucf101" />
  <meta itemprop="sameAs" content="https://www.crcv.ucf.edu/data-sets/ucf101/" />
  <meta itemprop="citation" content="@article{DBLP:journals/corr/abs-1212-0402,&#10;  author    = {Khurram Soomro and&#10;               Amir Roshan Zamir and&#10;               Mubarak Shah},&#10;  title     = {{UCF101:} {A} Dataset of 101 Human Actions Classes From Videos in&#10;               The Wild},&#10;  journal   = {CoRR},&#10;  volume    = {abs/1212.0402},&#10;  year      = {2012},&#10;  url       = {http://arxiv.org/abs/1212.0402},&#10;  archivePrefix = {arXiv},&#10;  eprint    = {1212.0402},&#10;  timestamp = {Mon, 13 Aug 2018 16:47:45 +0200},&#10;  biburl    = {https://dblp.org/rec/bib/journals/corr/abs-1212-0402},&#10;  bibsource = {dblp computer science bibliography, https://dblp.org}&#10;}" />
</div>

# `ucf101`


*   **Description**:

A 101-label video classification dataset.

*   **Homepage**:
    [https://www.crcv.ucf.edu/data-sets/ucf101/](https://www.crcv.ucf.edu/data-sets/ucf101/)

*   **Source code**:
    [`tfds.video.Ucf101`](https://github.com/tensorflow/datasets/tree/master/tensorflow_datasets/video/ucf101.py)

*   **Versions**:

    *   **`2.0.0`** (default): New split API
        (https://tensorflow.org/datasets/splits)

*   **Download size**: `6.48 GiB`

*   **Dataset size**: `Unknown size`

*   **Auto-cached**
    ([documentation](https://www.tensorflow.org/datasets/performances#auto-caching)):
    Unknown

*   **Supervised keys** (See
    [`as_supervised` doc](https://www.tensorflow.org/datasets/api_docs/python/tfds/load#args)):
    `None`

*   **Figure**
    ([tfds.show_examples](https://www.tensorflow.org/datasets/api_docs/python/tfds/visualization/show_examples)):
    Not supported.

*   **Citation**:

```
@article{DBLP:journals/corr/abs-1212-0402,
  author    = {Khurram Soomro and
               Amir Roshan Zamir and
               Mubarak Shah},
  title     = {{UCF101:} {A} Dataset of 101 Human Actions Classes From Videos in
               The Wild},
  journal   = {CoRR},
  volume    = {abs/1212.0402},
  year      = {2012},
  url       = {http://arxiv.org/abs/1212.0402},
  archivePrefix = {arXiv},
  eprint    = {1212.0402},
  timestamp = {Mon, 13 Aug 2018 16:47:45 +0200},
  biburl    = {https://dblp.org/rec/bib/journals/corr/abs-1212-0402},
  bibsource = {dblp computer science bibliography, https://dblp.org}
}
```


## ucf101/ucf101_1_256 (default config)

*   **Config description**: 256x256 UCF with the first action recognition split.

*   **Splits**:

Split     | Examples
:-------- | -------:
`'test'`  | 3,783
`'train'` | 9,537

*   **Feature structure**:

```python
FeaturesDict({
    'label': ClassLabel(shape=(), dtype=tf.int64, num_classes=101),
    'video': Video(Image(shape=(256, 256, 3), dtype=tf.uint8)),
})
```

*   **Feature documentation**:

Feature | Class        | Shape               | Dtype    | Description
:------ | :----------- | :------------------ | :------- | :----------
        | FeaturesDict |                     |          |
label   | ClassLabel   |                     | tf.int64 |
video   | Video(Image) | (None, 256, 256, 3) | tf.uint8 |

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/ucf101-ucf101_1_256-2.0.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## ucf101/ucf101_1

*   **Config description**: UCF with the action recognition split #1.

*   **Splits**:

Split     | Examples
:-------- | -------:
`'test'`  | 3,783
`'train'` | 9,537

*   **Feature structure**:

```python
FeaturesDict({
    'label': ClassLabel(shape=(), dtype=tf.int64, num_classes=101),
    'video': Video(Image(shape=(None, None, 3), dtype=tf.uint8)),
})
```

*   **Feature documentation**:

Feature | Class        | Shape                 | Dtype    | Description
:------ | :----------- | :-------------------- | :------- | :----------
        | FeaturesDict |                       |          |
label   | ClassLabel   |                       | tf.int64 |
video   | Video(Image) | (None, None, None, 3) | tf.uint8 |

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/ucf101-ucf101_1-2.0.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## ucf101/ucf101_2

*   **Config description**: UCF with the action recognition split #2.

*   **Splits**:

Split     | Examples
:-------- | -------:
`'test'`  | 3,734
`'train'` | 9,586

*   **Feature structure**:

```python
FeaturesDict({
    'label': ClassLabel(shape=(), dtype=tf.int64, num_classes=101),
    'video': Video(Image(shape=(None, None, 3), dtype=tf.uint8)),
})
```

*   **Feature documentation**:

Feature | Class        | Shape                 | Dtype    | Description
:------ | :----------- | :-------------------- | :------- | :----------
        | FeaturesDict |                       |          |
label   | ClassLabel   |                       | tf.int64 |
video   | Video(Image) | (None, None, None, 3) | tf.uint8 |

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/ucf101-ucf101_2-2.0.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

## ucf101/ucf101_3

*   **Config description**: UCF with the action recognition split #3.

*   **Splits**:

Split     | Examples
:-------- | -------:
`'test'`  | 3,696
`'train'` | 9,624

*   **Feature structure**:

```python
FeaturesDict({
    'label': ClassLabel(shape=(), dtype=tf.int64, num_classes=101),
    'video': Video(Image(shape=(None, None, 3), dtype=tf.uint8)),
})
```

*   **Feature documentation**:

Feature | Class        | Shape                 | Dtype    | Description
:------ | :----------- | :-------------------- | :------- | :----------
        | FeaturesDict |                       |          |
label   | ClassLabel   |                       | tf.int64 |
video   | Video(Image) | (None, None, None, 3) | tf.uint8 |

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/ucf101-ucf101_3-2.0.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->