<div itemscope itemtype="http://schema.org/Dataset">
  <div itemscope itemprop="includedInDataCatalog" itemtype="http://schema.org/DataCatalog">
    <meta itemprop="name" content="TensorFlow Datasets" />
  </div>
  <meta itemprop="name" content="pet_finder" />
  <meta itemprop="description" content="Dataset with images from 5 classes (see config name for information on the specific class)&#10;&#10;To use this dataset:&#10;&#10;```python&#10;import tensorflow_datasets as tfds&#10;&#10;ds = tfds.load(&#x27;pet_finder&#x27;, split=&#x27;train&#x27;)&#10;for ex in ds.take(4):&#10;  print(ex)&#10;```&#10;&#10;See [the guide](https://www.tensorflow.org/datasets/overview) for more&#10;informations on [tensorflow_datasets](https://www.tensorflow.org/datasets).&#10;&#10;&lt;img src=&quot;https://storage.googleapis.com/tfds-data/visualization/fig/pet_finder-1.0.0.png&quot; alt=&quot;Visualization&quot; width=&quot;500px&quot;&gt;&#10;&#10;" />
  <meta itemprop="url" content="https://www.tensorflow.org/datasets/catalog/pet_finder" />
  <meta itemprop="sameAs" content="https://www.kaggle.com/c/petfinder-adoption-prediction/data" />
  <meta itemprop="citation" content="@ONLINE {kaggle-petfinder-adoption-prediction,&#10;    author = &quot;Kaggle and PetFinder.my&quot;,&#10;    title  = &quot;PetFinder.my Adoption Prediction&quot;,&#10;    month  = &quot;april&quot;,&#10;    year   = &quot;2019&quot;,&#10;    url    = &quot;https://www.kaggle.com/c/petfinder-adoption-prediction/data/&quot;&#10;}" />
</div>

# `pet_finder`


*   **Visualization**:
    <a class="button button-with-icon" href="https://knowyourdata-tfds.withgoogle.com/#tab=STATS&dataset=pet_finder">
    Explore in Know Your Data
    <span class="material-icons icon-after" aria-hidden="true"> north_east
    </span> </a>

*   **Description**:

Dataset with images from 5 classes (see config name for information on the
specific class)

*   **Homepage**:
    [https://www.kaggle.com/c/petfinder-adoption-prediction/data](https://www.kaggle.com/c/petfinder-adoption-prediction/data)

*   **Source code**:
    [`tfds.image_classification.PetFinder`](https://github.com/tensorflow/datasets/tree/master/tensorflow_datasets/image_classification/pet_finder.py)

*   **Versions**:

    *   **`1.0.0`** (default): No release notes.

*   **Download size**: `1.94 GiB`

*   **Dataset size**: `Unknown size`

*   **Auto-cached**
    ([documentation](https://www.tensorflow.org/datasets/performances#auto-caching)):
    Unknown

*   **Splits**:

Split     | Examples
:-------- | -------:
`'test'`  | 14,465
`'train'` | 58,311

*   **Feature structure**:

```python
FeaturesDict({
    'PetID': Text(shape=(), dtype=tf.string),
    'attributes': FeaturesDict({
        'Age': tf.int64,
        'Breed1': tf.int64,
        'Breed2': tf.int64,
        'Color1': tf.int64,
        'Color2': tf.int64,
        'Color3': tf.int64,
        'Dewormed': tf.int64,
        'Fee': tf.int64,
        'FurLength': tf.int64,
        'Gender': tf.int64,
        'Health': tf.int64,
        'MaturitySize': tf.int64,
        'Quantity': tf.int64,
        'State': tf.int64,
        'Sterilized': tf.int64,
        'Type': tf.int64,
        'Vaccinated': tf.int64,
        'VideoAmt': tf.int64,
    }),
    'image': Image(shape=(None, None, 3), dtype=tf.uint8),
    'image/filename': Text(shape=(), dtype=tf.string),
    'label': ClassLabel(shape=(), dtype=tf.int64, num_classes=5),
})
```

*   **Feature documentation**:

| Feature                 | Class        | Shape    | Dtype     | Description |
| :---------------------- | :----------- | :------- | :-------- | :---------- |
|                         | FeaturesDict |          |           |             |
| PetID                   | Text         |          | tf.string |             |
| attributes              | FeaturesDict |          |           |             |
| attributes/Age          | Tensor       |          | tf.int64  |             |
| attributes/Breed1       | Tensor       |          | tf.int64  |             |
| attributes/Breed2       | Tensor       |          | tf.int64  |             |
| attributes/Color1       | Tensor       |          | tf.int64  |             |
| attributes/Color2       | Tensor       |          | tf.int64  |             |
| attributes/Color3       | Tensor       |          | tf.int64  |             |
| attributes/Dewormed     | Tensor       |          | tf.int64  |             |
| attributes/Fee          | Tensor       |          | tf.int64  |             |
| attributes/FurLength    | Tensor       |          | tf.int64  |             |
| attributes/Gender       | Tensor       |          | tf.int64  |             |
| attributes/Health       | Tensor       |          | tf.int64  |             |
| attributes/MaturitySize | Tensor       |          | tf.int64  |             |
| attributes/Quantity     | Tensor       |          | tf.int64  |             |
| attributes/State        | Tensor       |          | tf.int64  |             |
| attributes/Sterilized   | Tensor       |          | tf.int64  |             |
| attributes/Type         | Tensor       |          | tf.int64  |             |
| attributes/Vaccinated   | Tensor       |          | tf.int64  |             |
| attributes/VideoAmt     | Tensor       |          | tf.int64  |             |
| image                   | Image        | (None,   | tf.uint8  |             |
:                         :              : None, 3) :           :             :
| image/filename          | Text         |          | tf.string |             |
| label                   | ClassLabel   |          | tf.int64  |             |

*   **Supervised keys** (See
    [`as_supervised` doc](https://www.tensorflow.org/datasets/api_docs/python/tfds/load#args)):
    `('attributes', 'label')`

*   **Figure**
    ([tfds.show_examples](https://www.tensorflow.org/datasets/api_docs/python/tfds/visualization/show_examples)):

<img src="https://storage.googleapis.com/tfds-data/visualization/fig/pet_finder-1.0.0.png" alt="Visualization" width="500px">

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/pet_finder-1.0.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

*   **Citation**:

```
@ONLINE {kaggle-petfinder-adoption-prediction,
    author = "Kaggle and PetFinder.my",
    title  = "PetFinder.my Adoption Prediction",
    month  = "april",
    year   = "2019",
    url    = "https://www.kaggle.com/c/petfinder-adoption-prediction/data/"
}
```

