<div itemscope itemtype="http://schema.org/Dataset">
  <div itemscope itemprop="includedInDataCatalog" itemtype="http://schema.org/DataCatalog">
    <meta itemprop="name" content="TensorFlow Datasets" />
  </div>
  <meta itemprop="name" content="imagenet2012_multilabel" />
  <meta itemprop="description" content="This dataset contains ILSVRC-2012 (ImageNet) validation images annotated with&#10;multi-class labels from&#10;[&quot;Evaluating Machine Accuracy on ImageNet&quot;](http://proceedings.mlr.press/v119/shankar20c/shankar20c.pdf),&#10;ICML, 2020.  The multi-class labels were reviewed by a panel of experts&#10;extensively trained in the intricacies of fine-grained class distinctions in the&#10;ImageNet class hierarchy (see paper for more details).&#10;Compared to the original labels, these expert-reviewed multi-class labels enable&#10;a more semantically coherent evaluation of accuracy.&#10;&#10;Version 3.0.0 of this dataset contains more corrected labels from&#10;[&quot;When does dough become a bagel? Analyzing the remaining mistakes on ImageNet](https://arxiv.org/abs/2205.04596)&#10;as well as the ImageNet-Major (ImageNet-M) 68-example split under &#x27;imagenet-m&#x27;.&#10;&#10;Only 20,000 of the 50,000 ImageNet validation images have multi-label&#10;annotations.  The set of multi-labels was first generated by a testbed of 67&#10;trained ImageNet models, and then each individual model prediction was manually&#10;annotated by the experts as either `correct` (the label is correct for the&#10;image),`wrong` (the label is incorrect for the image), or `unclear` (no&#10;consensus was reached among the experts).&#10;&#10;Additionally, during annotation, the expert panel identified a set of&#10;*problematic images*. An image was problematic if it met any of the below&#10;criteria:&#10;&#10;  * The original ImageNet label (top-1 label) was incorrect or unclear&#10;  * Image was a drawing, painting, sketch, cartoon, or computer-rendered&#10;  * Image was excessively edited&#10;  * Image had inappropriate content&#10;&#10;The problematic images are included in this dataset but should be ignored when&#10;computing multi-label accuracy. Additionally, since the initial set of 20,000&#10;annotations is class-balanced, but the set of problematic images is not, we&#10;recommend computing the per-class accuracies and then averaging them. We also&#10;recommend counting a prediction as correct if it is marked as correct or unclear&#10;(i.e., being lenient with the unclear labels).&#10;&#10;One possible way of doing this is with the following NumPy code:&#10;&#10;```python&#10;import tensorflow_datasets as tfds&#10;&#10;ds = tfds.load(&#x27;imagenet2012_multilabel&#x27;, split=&#x27;validation&#x27;)&#10;&#10;# We assume that predictions is a dictionary from file_name to a class index between 0 and 999&#10;&#10;num_correct_per_class = {}&#10;num_images_per_class = {}&#10;&#10;for example in ds:&#10;    # We ignore all problematic images&#10;    if example[‘is_problematic’].numpy():&#10;        continue&#10;&#10;    # The label of the image in ImageNet&#10;    cur_class = example[&#x27;original_label&#x27;].numpy()&#10;&#10;    # If we haven&#x27;t processed this class yet, set the counters to 0&#10;    if cur_class not in num_correct_per_class:&#10;        num_correct_per_class[cur_class] = 0&#10;        assert cur_class not in num_images_per_class&#10;        num_images_per_class[cur_class] = 0&#10;&#10;    num_images_per_class[cur_class] += 1&#10;&#10;    # Get the predictions for this image&#10;    cur_pred = predictions[example[&#x27;file_name&#x27;].numpy()]&#10;&#10;    # We count a prediction as correct if it is marked as correct or unclear&#10;    # (i.e., we are lenient with the unclear labels)&#10;    if cur_pred is in example[&#x27;correct_multi_labels&#x27;].numpy() or cur_pred is in example[&#x27;unclear_multi_labels&#x27;].numpy():&#10;        num_correct_per_class[cur_class] += 1&#10;&#10;# Check that we have collected accuracy data for each of the 1,000 classes&#10;num_classes = 1000&#10;assert len(num_correct_per_class) == num_classes&#10;assert len(num_images_per_class) == num_classes&#10;&#10;# Compute the per-class accuracies and then average them&#10;final_avg = 0&#10;for cid in range(num_classes):&#10;  assert cid in num_correct_per_class&#10;  assert cid in num_images_per_class&#10;  final_avg += num_correct_per_class[cid] / num_images_per_class[cid]&#10;final_avg /= num_classes&#10;&#10;```&#10;&#10;To use this dataset:&#10;&#10;```python&#10;import tensorflow_datasets as tfds&#10;&#10;ds = tfds.load(&#x27;imagenet2012_multilabel&#x27;, split=&#x27;train&#x27;)&#10;for ex in ds.take(4):&#10;  print(ex)&#10;```&#10;&#10;See [the guide](https://www.tensorflow.org/datasets/overview) for more&#10;informations on [tensorflow_datasets](https://www.tensorflow.org/datasets).&#10;&#10;&lt;img src=&quot;https://storage.googleapis.com/tfds-data/visualization/fig/imagenet2012_multilabel-3.0.0.png&quot; alt=&quot;Visualization&quot; width=&quot;500px&quot;&gt;&#10;&#10;" />
  <meta itemprop="url" content="https://www.tensorflow.org/datasets/catalog/imagenet2012_multilabel" />
  <meta itemprop="sameAs" content="https://github.com/modestyachts/evaluating_machine_accuracy_on_imagenet" />
  <meta itemprop="citation" content="@article{shankar2019evaluating,&#10;  title={Evaluating Machine Accuracy on ImageNet},&#10;  author={Vaishaal Shankar* and Rebecca Roelofs* and Horia Mania and Alex Fang and Benjamin Recht and Ludwig Schmidt},&#10;  journal={ICML},&#10;  year={2020},&#10;  note={\url{http://proceedings.mlr.press/v119/shankar20c.html}}&#10;}&#10;@article{ImageNetChallenge,&#10;  title={{ImageNet} large scale visual recognition challenge},&#10;  author={Olga Russakovsky and Jia Deng and Hao Su and Jonathan Krause&#10;   and Sanjeev Satheesh and Sean Ma and Zhiheng Huang and Andrej Karpathy and Aditya Khosla and Michael Bernstein and&#10;   Alexander C. Berg and Fei-Fei Li},&#10;  journal={International Journal of Computer Vision},&#10;  year={2015},&#10;  note={\url{https://arxiv.org/abs/1409.0575}}&#10;}&#10;@inproceedings{ImageNet,&#10;   author={Jia Deng and Wei Dong and Richard Socher and Li-Jia Li and Kai Li and Li Fei-Fei},&#10;   booktitle={Conference on Computer Vision and Pattern Recognition (CVPR)},&#10;   title={{ImageNet}: A large-scale hierarchical image database},&#10;   year={2009},&#10;   note={\url{http://www.image-net.org/papers/imagenet_cvpr09.pdf}}&#10;}&#10;@article{vasudevan2022does,&#10;  title={When does dough become a bagel? Analyzing the remaining mistakes on ImageNet},&#10;  author={Vasudevan, Vijay and Caine, Benjamin and Gontijo-Lopes, Raphael and Fridovich-Keil, Sara and Roelofs, Rebecca},&#10;  journal={arXiv preprint arXiv:2205.04596},&#10;  year={2022}&#10;}" />
</div>

# `imagenet2012_multilabel`


Note: This dataset has been updated since the last stable release. The new
versions and config marked with
<span class="material-icons" title="Available only in the tfds-nightly package">nights_stay</span>
are only available in the `tfds-nightly` package.

Warning: Manual download required. See instructions below.

*   **Description**:

This dataset contains ILSVRC-2012 (ImageNet) validation images annotated with
multi-class labels from
["Evaluating Machine Accuracy on ImageNet"](http://proceedings.mlr.press/v119/shankar20c/shankar20c.pdf),
ICML, 2020. The multi-class labels were reviewed by a panel of experts
extensively trained in the intricacies of fine-grained class distinctions in the
ImageNet class hierarchy (see paper for more details). Compared to the original
labels, these expert-reviewed multi-class labels enable a more semantically
coherent evaluation of accuracy.

Version 3.0.0 of this dataset contains more corrected labels from
["When does dough become a bagel? Analyzing the remaining mistakes on ImageNet](https://arxiv.org/abs/2205.04596)
as well as the ImageNet-Major (ImageNet-M) 68-example split under 'imagenet-m'.

Only 20,000 of the 50,000 ImageNet validation images have multi-label
annotations. The set of multi-labels was first generated by a testbed of 67
trained ImageNet models, and then each individual model prediction was manually
annotated by the experts as either `correct` (the label is correct for the
image),`wrong` (the label is incorrect for the image), or `unclear` (no
consensus was reached among the experts).

Additionally, during annotation, the expert panel identified a set of
*problematic images*. An image was problematic if it met any of the below
criteria:

*   The original ImageNet label (top-1 label) was incorrect or unclear
*   Image was a drawing, painting, sketch, cartoon, or computer-rendered
*   Image was excessively edited
*   Image had inappropriate content

The problematic images are included in this dataset but should be ignored when
computing multi-label accuracy. Additionally, since the initial set of 20,000
annotations is class-balanced, but the set of problematic images is not, we
recommend computing the per-class accuracies and then averaging them. We also
recommend counting a prediction as correct if it is marked as correct or unclear
(i.e., being lenient with the unclear labels).

One possible way of doing this is with the following NumPy code:

```python
import tensorflow_datasets as tfds

ds = tfds.load('imagenet2012_multilabel', split='validation')

# We assume that predictions is a dictionary from file_name to a class index between 0 and 999

num_correct_per_class = {}
num_images_per_class = {}

for example in ds:
    # We ignore all problematic images
    if example[‘is_problematic’].numpy():
        continue

    # The label of the image in ImageNet
    cur_class = example['original_label'].numpy()

    # If we haven't processed this class yet, set the counters to 0
    if cur_class not in num_correct_per_class:
        num_correct_per_class[cur_class] = 0
        assert cur_class not in num_images_per_class
        num_images_per_class[cur_class] = 0

    num_images_per_class[cur_class] += 1

    # Get the predictions for this image
    cur_pred = predictions[example['file_name'].numpy()]

    # We count a prediction as correct if it is marked as correct or unclear
    # (i.e., we are lenient with the unclear labels)
    if cur_pred is in example['correct_multi_labels'].numpy() or cur_pred is in example['unclear_multi_labels'].numpy():
        num_correct_per_class[cur_class] += 1

# Check that we have collected accuracy data for each of the 1,000 classes
num_classes = 1000
assert len(num_correct_per_class) == num_classes
assert len(num_images_per_class) == num_classes

# Compute the per-class accuracies and then average them
final_avg = 0
for cid in range(num_classes):
  assert cid in num_correct_per_class
  assert cid in num_images_per_class
  final_avg += num_correct_per_class[cid] / num_images_per_class[cid]
final_avg /= num_classes

```

*   **Homepage**:
    [https://github.com/modestyachts/evaluating_machine_accuracy_on_imagenet](https://github.com/modestyachts/evaluating_machine_accuracy_on_imagenet)

*   **Source code**:
    [`tfds.image_classification.imagenet2012_multilabel.Imagenet2012Multilabel`](https://github.com/tensorflow/datasets/tree/master/tensorflow_datasets/image_classification/imagenet2012_multilabel/imagenet2012_multilabel.py)

*   **Versions**:

    *   `1.0.0`: Initial release.
    *   `2.0.0`: Fixed ILSVRC2012_img_val.tar file.
    *   **`3.0.0`** (default)
        <span class="material-icons" title="Available only in the tfds-nightly package">nights_stay</span>:
        Corrected labels and ImageNet-M split.

*   **Download size**: `191.13 MiB`

*   **Dataset size**: `2.50 GiB`

*   **Manual download instructions**: This dataset requires you to
    download the source data manually into `download_config.manual_dir`
    (defaults to `~/tensorflow_datasets/downloads/manual/`):<br/>
    manual_dir should contain `ILSVRC2012_img_val.tar` file.
    You need to register on http://www.image-net.org/download-images in order
    to get the link to download the dataset.

*   **Auto-cached**
    ([documentation](https://www.tensorflow.org/datasets/performances#auto-caching)):
    No

*   **Splits**:

Split          | Examples
:------------- | -------:
`'imagenet_m'` | 68
`'validation'` | 20,000

*   **Feature structure**:

```python
FeaturesDict({
    'correct_multi_labels': Sequence(ClassLabel(shape=(), dtype=tf.int64, num_classes=1000)),
    'file_name': Text(shape=(), dtype=tf.string),
    'image': Image(shape=(None, None, 3), dtype=tf.uint8),
    'is_problematic': tf.bool,
    'original_label': ClassLabel(shape=(), dtype=tf.int64, num_classes=1000),
    'unclear_multi_labels': Sequence(ClassLabel(shape=(), dtype=tf.int64, num_classes=1000)),
    'wrong_multi_labels': Sequence(ClassLabel(shape=(), dtype=tf.int64, num_classes=1000)),
})
```

*   **Feature documentation**:

Feature              | Class                | Shape           | Dtype     | Description
:------------------- | :------------------- | :-------------- | :-------- | :----------
                     | FeaturesDict         |                 |           |
correct_multi_labels | Sequence(ClassLabel) | (None,)         | tf.int64  |
file_name            | Text                 |                 | tf.string |
image                | Image                | (None, None, 3) | tf.uint8  |
is_problematic       | Tensor               |                 | tf.bool   |
original_label       | ClassLabel           |                 | tf.int64  |
unclear_multi_labels | Sequence(ClassLabel) | (None,)         | tf.int64  |
wrong_multi_labels   | Sequence(ClassLabel) | (None,)         | tf.int64  |

*   **Supervised keys** (See
    [`as_supervised` doc](https://www.tensorflow.org/datasets/api_docs/python/tfds/load#args)):
    `('image', 'correct_multi_labels')`

*   **Figure**
    ([tfds.show_examples](https://www.tensorflow.org/datasets/api_docs/python/tfds/visualization/show_examples)):

<img src="https://storage.googleapis.com/tfds-data/visualization/fig/imagenet2012_multilabel-3.0.0.png" alt="Visualization" width="500px">

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:auto"></div>
<script>
const url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/imagenet2012_multilabel-3.0.0.html";
const dataButton = document.getElementById('displaydataframe');
dataButton.addEventListener('click', async () => {
  // Disable the button after clicking (dataframe loaded only once).
  dataButton.disabled = true;

  const contentPane = document.getElementById('dataframecontent');
  try {
    const response = await fetch(url);
    // Error response codes don't throw an error, so force an error to show
    // the error message.
    if (!response.ok) throw Error(response.statusText);

    const data = await response.text();
    contentPane.innerHTML = data;
  } catch (e) {
    contentPane.innerHTML =
        'Error loading examples. If the error persist, please open '
        + 'a new issue.';
  }
});
</script>

{% endframebox %}

<!-- mdformat on -->

*   **Citation**:

```
@article{shankar2019evaluating,
  title={Evaluating Machine Accuracy on ImageNet},
  author={Vaishaal Shankar* and Rebecca Roelofs* and Horia Mania and Alex Fang and Benjamin Recht and Ludwig Schmidt},
  journal={ICML},
  year={2020},
  note={\url{http://proceedings.mlr.press/v119/shankar20c.html}}
}
@article{ImageNetChallenge,
  title={{ImageNet} large scale visual recognition challenge},
  author={Olga Russakovsky and Jia Deng and Hao Su and Jonathan Krause
   and Sanjeev Satheesh and Sean Ma and Zhiheng Huang and Andrej Karpathy and Aditya Khosla and Michael Bernstein and
   Alexander C. Berg and Fei-Fei Li},
  journal={International Journal of Computer Vision},
  year={2015},
  note={\url{https://arxiv.org/abs/1409.0575}}
}
@inproceedings{ImageNet,
   author={Jia Deng and Wei Dong and Richard Socher and Li-Jia Li and Kai Li and Li Fei-Fei},
   booktitle={Conference on Computer Vision and Pattern Recognition (CVPR)},
   title={{ImageNet}: A large-scale hierarchical image database},
   year={2009},
   note={\url{http://www.image-net.org/papers/imagenet_cvpr09.pdf}}
}
@article{vasudevan2022does,
  title={When does dough become a bagel? Analyzing the remaining mistakes on ImageNet},
  author={Vasudevan, Vijay and Caine, Benjamin and Gontijo-Lopes, Raphael and Fridovich-Keil, Sara and Roelofs, Rebecca},
  journal={arXiv preprint arXiv:2205.04596},
  year={2022}
}
```

