#!/bin/bash

set -vx  # print command from file as well as evaluated command
set -e   # fail and exit on any command erroring

: "${TF_VERSION:?}"

source ./oss_scripts/utils.sh

# Install ffmpeg for Audio FeatureConnector tests
if command -v ffmpeg 2>/dev/null
then
  echo "Using installed ffmpeg"
else
  echo "Installing ffmpeg"
  sudo add-apt-repository -y ppa:jonathonf/ffmpeg-4
  sudo apt-get update -qq
  sudo apt-get install -qq -y ffmpeg
fi

# Required for opencv2
sudo apt-get install -qq -y libsm6

install_tf "$TF_VERSION"

# Make sure we have the latest version of numpy - avoid problems we were
# seeing with Python 3
pip install -q -U numpy

# First ensure that the base dependencies are sufficient for a full import and
# data load
pip install -e .

python -c "import tensorflow_datasets as tfds"
python -c "import tensorflow_datasets as tfds; tfds.load('mnist', split='train')"

# Then install the test dependencies
pip install -e .[tests-all]

if [[ "$TF_VERSION" == "tf-nightly" ]]
then
  # `tensorflow` is automatically installed with `tensorflow-data-validation`
  # so uninstall `tensorflow` to avoid conflicts with `tf-nightly`
  pip uninstall -y tensorflow
  # Use --no-deps, otherwise protobuf and other package are reverted to
  # previous version
  pip install tf-nightly --upgrade --force-reinstall --no-deps
  python -c "import tensorflow as tf ; assert 'dev' in tf.__version__"
fi

pip freeze
