<div itemscope itemtype="http://schema.org/Dataset">
  <div itemscope itemprop="includedInDataCatalog" itemtype="http://schema.org/DataCatalog">
    <meta itemprop="name" content="TensorFlow Datasets" />
  </div>
  <meta itemprop="name" content="pg19" />
  <meta itemprop="description" content="This dataset contains the PG-19 language modeling benchmark. It includes a set&#10;of books extracted from the Project Gutenberg books project&#10;(https://www.gutenberg.org), that were published before 1919. It also contains&#10;metadata of book titles and publication dates.&#10;PG-19 is over double the size of the Billion Word benchmark and contains&#10;documents that are 20X longer, on average, than the WikiText long-range&#10;language modelling benchmark.&#10;&#10;Books are partitioned into a train, validation, and test set. Books metadata is&#10;stored in metadata.csv which contains&#10;(book_id, short_book_title, publication_date, book_link).&#10;&#10;To use this dataset:&#10;&#10;```python&#10;import tensorflow_datasets as tfds&#10;&#10;ds = tfds.load(&#x27;pg19&#x27;, split=&#x27;train&#x27;)&#10;for ex in ds.take(4):&#10;  print(ex)&#10;```&#10;&#10;See [the guide](https://www.tensorflow.org/datasets/overview) for more&#10;informations on [tensorflow_datasets](https://www.tensorflow.org/datasets).&#10;&#10;" />
  <meta itemprop="url" content="https://www.tensorflow.org/datasets/catalog/pg19" />
  <meta itemprop="sameAs" content="https://github.com/deepmind/pg19" />
  <meta itemprop="citation" content="@article{raecompressive2019,&#10;author = {Rae, Jack W and Potapenko, Anna and Jayakumar, Siddhant M and&#10;          Hillier, Chloe and Lillicrap, Timothy P},&#10;title = {Compressive Transformers for Long-Range Sequence Modelling},&#10;journal = {arXiv preprint},&#10;url = {https://arxiv.org/abs/1911.05507},&#10;year = {2019},&#10;}" />
</div>

# `pg19`

*   **Description**:

This dataset contains the PG-19 language modeling benchmark. It includes a set
of books extracted from the Project Gutenberg books project
(https://www.gutenberg.org), that were published before 1919. It also contains
metadata of book titles and publication dates. PG-19 is over double the size of
the Billion Word benchmark and contains documents that are 20X longer, on
average, than the WikiText long-range language modelling benchmark.

Books are partitioned into a train, validation, and test set. Books metadata is
stored in metadata.csv which contains (book_id, short_book_title,
publication_date, book_link).

*   **Homepage**:
    [https://github.com/deepmind/pg19](https://github.com/deepmind/pg19)

*   **Source code**:
    [`tfds.text.Pg19`](https://github.com/tensorflow/datasets/tree/master/tensorflow_datasets/text/pg19.py)

*   **Versions**:

    *   **`0.1.1`** (default): No release notes.

*   **Download size**: `Unknown size`

*   **Dataset size**: `10.94 GiB`

*   **Auto-cached**
    ([documentation](https://www.tensorflow.org/datasets/performances#auto-caching)):
    No

*   **Splits**:

Split          | Examples
:------------- | -------:
`'test'`       | 100
`'train'`      | 28,602
`'validation'` | 50

*   **Features**:

```python
FeaturesDict({
    'book_id': tf.int32,
    'book_link': tf.string,
    'book_text': Text(shape=(), dtype=tf.string),
    'book_title': tf.string,
    'publication_date': tf.string,
})
```

*   **Supervised keys** (See
    [`as_supervised` doc](https://www.tensorflow.org/datasets/api_docs/python/tfds/load#args)):
    `None`

*   **Citation**:

```
@article{raecompressive2019,
author = {Rae, Jack W and Potapenko, Anna and Jayakumar, Siddhant M and
          Hillier, Chloe and Lillicrap, Timothy P},
title = {Compressive Transformers for Long-Range Sequence Modelling},
journal = {arXiv preprint},
url = {https://arxiv.org/abs/1911.05507},
year = {2019},
}
```

*   **Figure**
    ([tfds.show_examples](https://www.tensorflow.org/datasets/api_docs/python/tfds/visualization/show_examples)):
    Not supported.

*   **Examples**
    ([tfds.as_dataframe](https://www.tensorflow.org/datasets/api_docs/python/tfds/as_dataframe)):

<!-- mdformat off(HTML should not be auto-formatted) -->

{% framebox %}

<button id="displaydataframe">Display examples...</button>
<div id="dataframecontent" style="overflow-x:scroll"></div>
<script src="https://www.gstatic.com/external_hosted/jquery2.min.js"></script>
<script>
var url = "https://storage.googleapis.com/tfds-data/visualization/dataframe/pg19-0.1.1.html";
$(document).ready(() => {
  $("#displaydataframe").click((event) => {
    // Disable the button after clicking (dataframe loaded only once).
    $("#displaydataframe").prop("disabled", true);

    // Pre-fetch and display the content
    $.get(url, (data) => {
      $("#dataframecontent").html(data);
    }).fail(() => {
      $("#dataframecontent").html(
        'Error loading examples. If the error persist, please open '
        + 'a new issue.'
      );
    });
  });
});
</script>

{% endframebox %}

<!-- mdformat on -->